#ifdef CONFIG_TOP
#include "v3_config.h"
#define NUM_BLADES 1
#define NUM_BUTTONS 1
#define VOLUME 1800
const unsigned int maxLedsPerStrip = 144;
#define CLASH_THRESHOLD_G 2.0
#define ENABLE_AUDIO
#define ENABLE_MOTION
#define ENABLE_WS2811
#define ENABLE_SD
#endif

#ifdef CONFIG_PRESETS
Preset presets[] = {
  { "font07", "tracks/duel.wav",
    StylePtr<InOutSparkTip<(GREEN, WHITE), 300, 800> >(), "green spark"},
  { "font03", "tracks/duel.wav",
    StylePtr<InOutHelper<EASYBLADE(OnSpark<RED>, WHITE), 300, 800> >(), "red spark"},
  { "font05", "tracks/duel.wav",
    StylePtr<InOutSparkTip<(Rgb<0,20,255>, WHITE), 300, 800> >(), "light blue spark"},
  { "font08", "tracks/duel.wav",
    StylePtr<InOutHelper<EASYBLADE(OnSpark<BLUE>, WHITE), 300, 800> >(), "blue spark"},
  { "font02", "tracks/duel.wav",
    StylePtr<InOutSparkTip<(Rgb<255,200,0>, WHITE), 300, 800> >(), "gold spark"},
  { "font07", "tracks/duel.wav",
    StylePtr<InOutHelper<EASYBLADE(OnSpark<YELLOW>, BLUE>, 300, 800> >(), "yellow spark"},
    { "font03", "tracks/duel.wav",
      StylePtr<InOutHelper<EASYBLADE(OnSpark<Rgb<200,0,255>>, WHITE), 300, 800> >(), "purple spark"},
    { "font05", "tracks/duel.wav",
      StyleNormalPtr<WHITE, RED, 300, 800, RED>(), "white"},
    { "font08", "tracks/duel.wav",
      StyleFirePtr<RED, YELLOW>(), "fire"},
    { "font02", "tracks/duel.wav",
      StyleFirePtr<BLUE, CYAN>(), "blue fire"},
    { "font07", "tracks/duel.wav",
      &style_pov, "POV"},
    { "font03", "tracks/duel.wav",
      StyleRainbowPtr<300, 800>(), "rainbow"},
    { "font05", "tracks/duel.wav",
      StyleNormalPtr<Gradient<RED, BLUE>, Gradient<CYAN, YELLOW>, 300, 800>(), "gradient"},
    { "font08", "tracks/duel.wav",
      StyleStrobePtr<WHITE, Rainbow, 15, 300, 800>(), "strobe"},
    { "font02", "tracks/duel.wav",
      &style_charging, "Battery\nLevel"}
  };
  BladeConfig blades[] = {
    { 0, WS2811BladePtr<125, WS2811_ACTUALLY_800kHz | WS2811_GRB>(), CONFIGARRAY(presets) },
  };
  #endif

  #ifdef CONFIG_BUTTONS
  Button PowerButton(BUTTON_POWER, powerButtonPin, "pow");
  #endif
  
