// Talkie library
// Copyright 2011 Peter Knight
// This code is released under GPLv2 license.
//
// The following phrases are derived from VM61003/4/5 ROMs
//
// A male voice with a US accent.
//
// These phrases have a very military bias
// with lots of very useful engineering words.
// They also have good expression.
// 

// ROM VM61003
const uint8_t spZERO[] PROGMEM = {0x69,0xFB,0x59,0xDD,0x51,0xD5,0xD7,0xB5,0x6F,0x0A,0x78,0xC0,0x52,0x01,0x0F,0x50,0xAC,0xF6,0xA8,0x16,0x15,0xF2,0x7B,0xEA,0x19,0x47,0xD0,0x64,0xEB,0xAD,0x76,0xB5,0xEB,0xD1,0x96,0x24,0x6E,0x62,0x6D,0x5B,0x1F,0x0A,0xA7,0xB9,0xC5,0xAB,0xFD,0x1A,0x62,0xF0,0xF0,0xE2,0x6C,0x73,0x1C,0x73,0x52,0x1D,0x19,0x94,0x6F,0xCE,0x7D,0xED,0x6B,0xD9,0x82,0xDC,0x48,0xC7,0x2E,0x71,0x8B,0xBB,0xDF,0xFF,0x1F};
const uint8_t spONE[] PROGMEM = {0x66,0x4E,0xA8,0x7A,0x8D,0xED,0xC4,0xB5,0xCD,0x89,0xD4,0xBC,0xA2,0xDB,0xD1,0x27,0xBE,0x33,0x4C,0xD9,0x4F,0x9B,0x4D,0x57,0x8A,0x76,0xBE,0xF5,0xA9,0xAA,0x2E,0x4F,0xD5,0xCD,0xB7,0xD9,0x43,0x5B,0x87,0x13,0x4C,0x0D,0xA7,0x75,0xAB,0x7B,0x3E,0xE3,0x19,0x6F,0x7F,0xA7,0xA7,0xF9,0xD0,0x30,0x5B,0x1D,0x9E,0x9A,0x34,0x44,0xBC,0xB6,0x7D,0xFE,0x1F};
const uint8_t spTWO[]  PROGMEM = {0x06,0xB8,0x59,0x34,0x00,0x27,0xD6,0x38,0x60,0x58,0xD3,0x91,0x55,0x2D,0xAA,0x65,0x9D,0x4F,0xD1,0xB8,0x39,0x17,0x67,0xBF,0xC5,0xAE,0x5A,0x1D,0xB5,0x7A,0x06,0xF6,0xA9,0x7D,0x9D,0xD2,0x6C,0x55,0xA5,0x26,0x75,0xC9,0x9B,0xDF,0xFC,0x6E,0x0E,0x63,0x3A,0x34,0x70,0xAF,0x3E,0xFF,0x1F};
const uint8_t spTHREE[] PROGMEM = {0x0C,0xE8,0x2E,0x94,0x01,0x4D,0xBA,0x4A,0x40,0x03,0x16,0x68,0x69,0x36,0x1C,0xE9,0xBA,0xB8,0xE5,0x39,0x70,0x72,0x84,0xDB,0x51,0xA4,0xA8,0x4E,0xA3,0xC9,0x77,0xB1,0xCA,0xD6,0x52,0xA8,0x71,0xED,0x2A,0x7B,0x4B,0xA6,0xE0,0x37,0xB7,0x5A,0xDD,0x48,0x8E,0x94,0xF1,0x64,0xCE,0x6D,0x19,0x55,0x91,0xBC,0x6E,0xD7,0xAD,0x1E,0xF5,0xAA,0x77,0x7A,0xC6,0x70,0x22,0xCD,0xC7,0xF9,0x89,0xCF,0xFF,0x03};
const uint8_t spFOUR[] PROGMEM = {0x08,0x68,0x21,0x0D,0x03,0x1C,0x90,0xC0,0x88,0x92,0xB2,0x29,0x87,0x76,0x2B,0x2D,0x5C,0x7B,0x06,0xD9,0xED,0x74,0x64,0x51,0x54,0x4D,0xA2,0xBA,0x99,0xB7,0x3A,0xF8,0xEA,0x74,0xCA,0xD3,0x87,0xBE,0x94,0x3D,0xA4,0xD4,0x4E,0xC9,0x5F,0xF7,0x72,0xA7,0x9C,0x1C,0x63,0xDE,0xF2,0x9B,0xBE,0x34,0x84,0x27,0x2D,0x4B,0xF8,0x53,0x09,0x9C,0x0E,0xB7,0xEE,0xCB,0x5B,0x70,0xDD,0xB2,0xFC,0x3F};
const uint8_t spFIVE[] PROGMEM = {0x08,0x68,0x4E,0x9D,0x02,0x1C,0x60,0xC0,0x8C,0x69,0x12,0xB0,0xC0,0x28,0xAB,0x8C,0x9C,0xC0,0x2D,0xBB,0x38,0x79,0x31,0x15,0xA3,0xB6,0xE4,0x16,0xB7,0xDC,0xF5,0x6E,0x57,0xDF,0x54,0x5B,0x85,0xBE,0xD9,0xE3,0x5C,0xC6,0xD6,0x6D,0xB1,0xA5,0xBF,0x99,0x5B,0x3B,0x5A,0x30,0x09,0xAF,0x2F,0xED,0xEC,0x31,0xC4,0x5C,0xBE,0xD6,0x33,0xDD,0xAD,0x88,0x87,0xE2,0xD2,0xF2,0xF4,0xE0,0x16,0x2A,0xB2,0xE3,0x63,0x1F,0xF9,0xF0,0xE7,0xFF,0x01};
const uint8_t spSIX[] PROGMEM = {0x04,0xF8,0xB9,0x55,0x01,0xBF,0xA5,0x1B,0xE0,0x37,0x0F,0x03,0xFC,0x96,0x61,0x80,0xDF,0x3C,0x0C,0xF0,0x93,0xDA,0x4A,0x87,0x49,0x53,0x91,0x37,0x2B,0x6D,0xD2,0x55,0x23,0xDE,0xAC,0xAA,0xB9,0x16,0x09,0xFF,0xB2,0xFA,0x66,0x93,0x3C,0x63,0xF3,0x9C,0x10,0x38,0x45,0xA9,0x0A,0xD5,0x00,0x00,0x02,0x14,0x97,0xAA,0x80,0xAB,0x6B,0x0D,0xF0,0x63,0xA5,0x01,0x7E,0xCB,0x30,0xC0,0x6F,0xE9,0x0A,0xF8,0x25,0x93,0x01,0x3F,0x57,0xFC,0x3F};
const uint8_t spSEVEN[] PROGMEM = {0x0C,0x78,0xC6,0x95,0x01,0x3F,0xA5,0x28,0xE0,0xB7,0x52,0x0B,0x04,0xE0,0xB7,0x54,0x07,0xFC,0x52,0x66,0x80,0x9F,0xCB,0x56,0x59,0x6C,0x98,0x47,0x3E,0x59,0x4D,0x89,0x69,0x66,0xB9,0x7A,0x34,0x39,0x86,0x9B,0xD9,0xA6,0xD4,0xE7,0x10,0xAE,0xCA,0xAD,0x47,0x97,0x5D,0x9A,0xA9,0xAE,0x1A,0x75,0xB1,0xA5,0x66,0xF9,0xB2,0xD4,0x4D,0x63,0xB6,0x84,0x9A,0x52,0x76,0x45,0x11,0x1A,0xAA,0x4B,0x31,0x0C,0x79,0x4A,0xB0,0x49,0xC5,0x50,0xA2,0x41,0xA1,0xC9,0x65,0xD9,0xAB,0x89,0x56,0x84,0xFF,0x07};
const uint8_t spEIGHT[] PROGMEM = {0xAD,0x1B,0xDE,0x58,0x23,0x17,0xAF,0x6E,0xE8,0x20,0xEB,0x5C,0xBC,0xEA,0x61,0x03,0xAD,0x73,0xF6,0xAA,0x66,0x4A,0xD0,0xCC,0xD9,0xAB,0x1E,0x45,0xC1,0xA3,0x66,0xAF,0x61,0x36,0x03,0x8B,0x5A,0x9C,0xA6,0x51,0x04,0xA2,0x66,0x96,0xBB,0xBA,0x47,0xEC,0xED,0x8A,0x08,0x9C,0xA2,0x54,0x85,0x6A,0x00,0x80,0x02,0x86,0x74,0x63,0xC0,0xE6,0x6A,0xFF,0x0F};
const uint8_t spNINE[] PROGMEM = {0x62,0x75,0xDC,0x33,0xB5,0x62,0xB9,0x25,0x0B,0x8E,0x34,0x8F,0xD3,0xA6,0xAE,0x59,0xD2,0x34,0xE9,0x18,0x87,0x27,0xC9,0xD0,0x78,0xAB,0x6F,0xCE,0xC2,0x45,0x1B,0xAF,0xB6,0xF8,0x51,0x73,0x9D,0xB3,0x9A,0x12,0xC7,0x2C,0x6D,0xC9,0xAA,0x73,0x4B,0xF3,0x88,0x26,0xAB,0xCE,0x2D,0xCC,0x23,0xEA,0xAC,0x26,0xB7,0xD0,0x88,0x98,0xB3,0xBA,0x5C,0x43,0x32,0x7D,0xCE,0x1A,0x4A,0x0A,0xCD,0xF4,0x39,0x6B,0xAA,0x3E,0x24,0xCB,0x67,0xAF,0xB5,0xD9,0xE4,0x18,0x5F,0xB4,0xF6,0x6E,0x92,0x62,0x7D,0xD1,0x38,0xBA,0x09,0xF2,0x8D,0x59,0xED,0xE8,0x3A,0xD8,0x27,0x16,0xA6,0xBB,0x7B,0xF2,0x74,0x4F,0x92,0x9E,0x1E,0xC8,0x4A,0xC3,0x49,0x7A,0x9A,0x25,0x2B,0xF5,0x24,0xE9,0xEE,0xD1,0x24,0x25,0x27,0xBA,0xBB,0x25,0x51,0xD3,0xAA,0x24,0xAE,0x5E,0x54,0x55,0x3A,0xD4,0xFF,0x03};
const uint8_t spTEN[] PROGMEM = {0x0A,0xD8,0x5C,0x4D,0x03,0x2B,0xAB,0x5E,0xC4,0x33,0x2B,0xAF,0x62,0x84,0x12,0x0D,0x7B,0xB3,0xCA,0x66,0x43,0xA2,0xE3,0xF6,0xAA,0xAA,0x4E,0xC9,0x89,0xDB,0xAB,0x6E,0xBA,0xC5,0xDB,0x66,0xAF,0xB9,0xE8,0xE6,0x4C,0xBF,0x3D,0xE6,0x6A,0xC4,0x4B,0xCA,0x49,0xD9,0xBA,0x61,0x2B,0x09,0x25,0xED,0xE8,0x5A,0xB4,0xC4,0xED,0xA6,0x6B,0x18,0xE1,0x56,0xB7,0x9A,0xAE,0xA6,0x44,0x47,0xDC,0x6E,0xBE,0xC2,0xDD,0xA5,0xF0,0xB8,0xD9,0xFD,0x7F};
const uint8_t spELEVEN[] PROGMEM = {0x29,0x6F,0x52,0xA8,0xBB,0x6A,0x8F,0xBA,0x2B,0xC5,0xE8,0x9C,0xBD,0xAA,0x61,0x1D,0xB5,0xE3,0xF1,0xAA,0x9A,0x35,0xB6,0xB0,0xC5,0xAB,0x5E,0x44,0x53,0x4D,0xBA,0xAD,0x7A,0x42,0x1B,0xE1,0x5C,0xB3,0x9A,0x09,0x6D,0x94,0x62,0xE9,0x6A,0x8A,0x6A,0x37,0x8D,0xC7,0xAB,0x69,0xBC,0xDD,0xCC,0x5F,0xAF,0xB6,0xC9,0x76,0x37,0x7F,0xBD,0xDA,0x62,0xCA,0xDD,0x62,0xD1,0xEA,0xB2,0xCB,0x70,0xA3,0x45,0x69,0xCA,0x36,0xDD,0x14,0x1B,0xAE,0xBE,0x98,0x74,0x33,0x5E,0x39,0xFA,0x6C,0xC3,0x42,0xFC,0xF1,0xE8,0x8B,0x2E,0x71,0x8D,0xDB,0x63,0xA8,0x1A,0xAB,0x39,0x9C,0x8C,0xBE,0x69,0xCA,0xD2,0x50,0x32,0xFA,0xA6,0xD8,0x4B,0x52,0x71,0xEB,0xAA,0xE4,0x28,0x4E,0xD5,0xAD,0xCB,0xC2,0x3C,0x35,0x1D,0xB5,0x36,0xDB,0x14,0xAB,0x8C,0xF4,0xFF};
const uint8_t spTWELVE[] PROGMEM = {0x09,0x98,0xDA,0x22,0x01,0x37,0x78,0x1A,0x20,0x85,0xD1,0x50,0x3A,0x33,0x11,0x81,0x5D,0x5B,0x95,0xD4,0x44,0x04,0x76,0x9D,0xD5,0xA9,0x3A,0xAB,0xF0,0xA1,0x3E,0xB7,0xBA,0xD5,0xA9,0x2B,0xEB,0xCC,0xA0,0x3E,0xB7,0xBD,0xC3,0x5A,0x3B,0xC8,0x69,0x67,0xBD,0xFB,0xE8,0x67,0xBF,0xCA,0x9D,0xE9,0x74,0x08,0xE7,0xCE,0x77,0x78,0x06,0x89,0x32,0x57,0xD6,0xF1,0xF1,0x8F,0x7D,0xFE,0x1F};
const uint8_t spTHIRTEEN[] PROGMEM = {0x08,0x18,0xA2,0x12,0x03,0x18,0x40,0xC0,0x50,0x13,0x25,0x1D,0x3A,0x55,0x9D,0x5B,0xAF,0xAA,0xAB,0x74,0x4A,0xE9,0xB6,0xAA,0x6A,0xC7,0xA0,0xDD,0xDD,0xA8,0xAA,0x1F,0x82,0x75,0xED,0xA5,0x2A,0x8D,0x31,0xC6,0xB3,0x21,0x70,0x8A,0x52,0x15,0xAA,0x01,0x00,0x10,0x80,0xED,0x2C,0x12,0x70,0x53,0x55,0x00,0x66,0x2E,0x1D,0xD9,0x8C,0x46,0x14,0xB9,0x64,0xD5,0xD3,0x1B,0xD2,0xD4,0xAC,0xD1,0x2E,0x6B,0x44,0x9B,0xA5,0x46,0xBF,0xAC,0x91,0x6E,0x04,0x19,0xE3,0xD2,0x4A,0x76,0x6E,0xA4,0x2D,0xCB,0x2A,0xC9,0x65,0xE8,0xB6,0x0D,0x29,0x6C,0xEB,0xA1,0xC3,0xD1,0x1D,0x54,0xB9,0x28,0x75,0x67,0xB7,0x90,0xE5,0x6A,0x27,0xDC,0xDD,0xA1,0xB7,0xB9,0x92,0xF2,0x77,0x1B,0x1C,0x92,0x0D,0xDD,0xDF,0x92,0x9A,0x59,0x55,0xFC,0x7F};
const uint8_t spFOURTEEN[] PROGMEM = {0x08,0xE8,0x2A,0x94,0x00,0xC3,0x56,0x10,0x60,0xFA,0x0A,0x01,0x4C,0x97,0xAE,0x80,0x66,0xCB,0x4A,0x6F,0xF3,0x84,0xB1,0xB4,0x6E,0x9D,0x73,0x57,0x1A,0xD0,0x6E,0x74,0xC1,0x7D,0x71,0x61,0xD6,0x51,0x07,0xF7,0x26,0x25,0xDE,0x46,0x15,0xED,0x52,0x37,0xFB,0x29,0x65,0x1E,0x18,0x61,0xD6,0x1A,0x81,0x53,0x94,0xAA,0x50,0x0D,0x00,0x80,0x02,0x2C,0xE3,0x5E,0x80,0x13,0xBA,0x13,0x30,0x43,0xDB,0x2A,0x46,0x34,0xA2,0x8E,0xC5,0xAB,0x9A,0xDE,0x88,0x2E,0x4A,0xAD,0x7A,0x7A,0x25,0x7E,0x0F,0xB2,0xDA,0x69,0x84,0xED,0xC4,0xEC,0xEA,0xA6,0x15,0xF6,0x53,0xB1,0x6B,0x18,0x56,0x38,0x4F,0xCC,0x8D,0x71,0x5A,0x61,0x7F,0x35,0x3A,0xC6,0xA1,0x44,0xFC,0xCD,0x74,0x9B,0xBA,0xC1,0xCA,0x54,0xAB,0x6D,0x6C,0x06,0x3B,0x5D,0xED,0xB4,0xA1,0x29,0x6A,0x37,0x57,0xDD,0x86,0x2A,0xA9,0x52,0x43,0x51,0xEB,0xAA,0x0E,0x8E,0xA8,0x48,0xFF,0x0F};
const uint8_t spFIFTEEN[] PROGMEM = {0x02,0x68,0xD6,0xCC,0x00,0x43,0x9A,0x39,0x60,0x3A,0xF7,0x51,0x34,0x5B,0x6A,0x2C,0x6D,0x4E,0xD5,0x92,0x99,0x89,0x2C,0x39,0x55,0xF3,0xAE,0xA6,0x32,0x67,0x54,0xC5,0x99,0xB9,0xC8,0x1C,0x07,0x0C,0xA5,0x94,0x01,0x04,0x4E,0x51,0xAA,0x42,0x35,0x00,0x02,0xB0,0x84,0x4A,0x6B,0x4F,0x6C,0x23,0x15,0x2F,0x6D,0x18,0xC1,0x44,0xC2,0x17,0x8F,0x69,0xBA,0x54,0xA8,0x58,0x3D,0xE6,0x6D,0x53,0xA1,0x73,0xF5,0x5A,0xA6,0x31,0xA2,0x8D,0x89,0x63,0x9D,0xCE,0x88,0xD6,0x47,0xB6,0x75,0x5B,0x13,0x6C,0xAF,0x54,0x96,0x61,0x84,0x22,0x64,0x74,0x59,0x9A,0x61,0x4B,0x0D,0xA7,0x65,0x6A,0x86,0xD2,0x23,0x5C,0xA7,0xB1,0x08,0xCA,0xB0,0x70,0x9D,0x86,0xA2,0x38,0xC9,0xA2,0x55,0xE8,0x32,0x11,0x8F,0x94,0xD6,0xFF,0x0F};
const uint8_t spSIXTEEN[] PROGMEM = {0x0C,0x78,0xC6,0x95,0x01,0x3F,0xA5,0x28,0xE0,0xB7,0x52,0x0B,0x04,0xE0,0xB7,0x54,0x07,0xFC,0x52,0x66,0x80,0x9F,0xCB,0x96,0xB7,0xA5,0x1B,0x9B,0x66,0x5A,0x59,0xB3,0x26,0x1A,0xF6,0xA6,0x15,0xCD,0x2B,0x59,0xFA,0x6A,0x04,0x4E,0x51,0xAA,0x42,0x35,0x40,0x01,0x25,0xA7,0x24,0xE0,0x98,0x1E,0x07,0xFC,0x9D,0x2E,0x80,0x57,0x9D,0x18,0xB0,0x05,0x6A,0x02,0xAE,0x54,0x1D,0x6D,0x77,0xCA,0xEA,0xF9,0x78,0xF5,0xD3,0x1A,0x51,0xE7,0xE2,0x35,0x4F,0x6F,0xC4,0x53,0x93,0xC6,0x3A,0x9D,0x91,0x6C,0x86,0x6A,0xC7,0x34,0x2A,0x7A,0x66,0x36,0x9D,0xD3,0xA9,0xC8,0x99,0xD5,0x72,0x75,0xC7,0x92,0xA3,0x96,0xC3,0xD3,0x3D,0x46,0xA4,0x3A,0x09,0x4F,0x73,0x98,0xE1,0xEA,0x24,0x3C,0xDD,0x92,0x87,0xBB,0x93,0xF4,0x0D,0x63,0x94,0x2E,0x75,0xFF,0x1F};
const uint8_t spSEVENTEEN[] PROGMEM = {0x0C,0xF8,0x29,0x45,0x01,0xBF,0x95,0x5A,0x20,0x00,0xBF,0xA5,0x3A,0xE0,0x97,0x32,0x03,0xFC,0x5C,0xB6,0xAA,0x26,0x53,0xD5,0x7D,0xF5,0x6A,0x8A,0x4E,0xB5,0xCC,0x47,0xAB,0xAB,0xAA,0xD4,0xC2,0x36,0xA7,0x31,0xF9,0x30,0x33,0x49,0x9D,0x86,0x6C,0xD5,0x5D,0xA4,0xF5,0xE8,0xAB,0x32,0x37,0x97,0x95,0x69,0xA8,0x0A,0x7B,0x50,0xD5,0xA5,0xA1,0x69,0xA8,0x56,0x63,0x1B,0xC6,0xA6,0xB1,0x43,0xD4,0x35,0x24,0xE0,0x18,0xB3,0x96,0xAF,0xBC,0x99,0x86,0x9A,0x5A,0xD5,0x2C,0x71,0xD6,0xC4,0x5C,0xF5,0x2C,0x4E,0x94,0x31,0x6B,0x35,0x33,0x1A,0xF2,0x64,0xE9,0xD5,0x4F,0xAF,0xA8,0x1B,0x81,0xC7,0xBC,0xAC,0x91,0x9E,0x1B,0x29,0xDB,0x32,0x8A,0x7A,0x19,0xA8,0xEC,0x43,0x08,0xC5,0xB9,0xE9,0xF4,0x34,0x0D,0x35,0xAE,0x76,0xD3,0x5B,0x14,0x76,0xA9,0x3B,0x4A,0x7F,0x77,0x58,0xA1,0xE6,0x38,0xFD,0xDD,0x51,0x9A,0xBB,0xAB,0xF4,0x57,0x67,0x16,0xDA,0xB3,0xFE,0x1F};
const uint8_t spEIGHTEEN[] PROGMEM = {0x6B,0x18,0x36,0x88,0x3B,0x1B,0xEF,0x61,0x0D,0xD3,0x27,0x52,0xE5,0x9A,0x51,0x8F,0x1E,0xC8,0x96,0x4B,0x5A,0xD5,0x03,0x61,0xD5,0xCC,0x72,0x75,0x35,0x10,0xD3,0x13,0x11,0x81,0x53,0x94,0xAA,0x50,0x0D,0x80,0x02,0x2C,0x95,0x5A,0x80,0x17,0xC7,0x57,0x3E,0xBD,0x33,0x6B,0x36,0x59,0xD5,0xC8,0x4E,0xE4,0xB9,0x64,0xD5,0x33,0x24,0x61,0xE7,0xA4,0x35,0x2C,0xEF,0x28,0x9B,0xA5,0xC6,0x38,0x9D,0xA2,0x5F,0x84,0x6E,0xCB,0x74,0x8A,0x7E,0x6E,0xA6,0xEC,0xCD,0xB0,0x76,0x4B,0xD4,0x72,0x74,0x87,0x1E,0xA9,0x76,0xD2,0x3D,0x3C,0x59,0x84,0x26,0x4D,0x4F,0xD3,0x68,0x15,0xEE,0xE4,0xFF,0x01};
const uint8_t spNINETEEN[] PROGMEM = {0x6E,0x2F,0x44,0xB4,0x5B,0x93,0xA6,0xAD,0x32,0x96,0x2E,0x69,0xBA,0x96,0x26,0xD3,0xCC,0x65,0xF1,0x1A,0x9B,0x9C,0xE0,0xD4,0x2D,0x6B,0x68,0xA6,0xCD,0xCA,0x56,0xAF,0xAE,0xB9,0x64,0x6F,0x5F,0xB4,0xEA,0xE6,0x84,0xA7,0xA3,0x52,0xAB,0x5B,0x40,0xAB,0x28,0xD3,0xAE,0xCD,0x0A,0xC7,0x5D,0x35,0x23,0x70,0x8A,0x52,0x15,0xAA,0x01,0x50,0x80,0xAB,0x4C,0x0A,0xB0,0x7C,0x4B,0xCB,0x57,0xDE,0x4C,0x43,0x4D,0xAD,0x6A,0x96,0x38,0x6B,0x62,0xAE,0x7A,0x16,0x27,0xCA,0x98,0xB5,0x9A,0x19,0x0D,0x79,0xB2,0xF4,0xEA,0xA7,0x57,0xD4,0x8D,0xC0,0x63,0x5E,0xD6,0x48,0xCF,0x8D,0x94,0x6D,0x19,0x45,0xBD,0x0C,0x54,0xF6,0x21,0x84,0xE2,0xDC,0x74,0x79,0x9A,0x86,0x1A,0x57,0xBB,0xE5,0x2D,0x0A,0xBB,0xD4,0x1D,0x95,0xBF,0x3B,0xAC,0x50,0x73,0x5C,0xFE,0xEE,0x28,0xCD,0xDD,0x55,0xF8,0xAB,0x33,0x0B,0xED,0x59,0xFF,0x0F};
const uint8_t spTWENTY[] PROGMEM = {0x0A,0xE8,0x4A,0xCD,0x01,0xDB,0xB9,0x33,0xC0,0xA6,0x54,0x0C,0xA4,0x34,0xD9,0xF2,0x0A,0x6C,0xBB,0xB3,0x53,0x0E,0x5D,0xA6,0x25,0x9B,0x6F,0x75,0xCA,0x61,0x52,0xDC,0x74,0x49,0xA9,0x8A,0xC4,0x76,0x4D,0xD7,0xB1,0x76,0xC0,0x55,0xA6,0x65,0xD8,0x26,0x99,0x5C,0x56,0xAD,0xB9,0x25,0x23,0xD5,0x7C,0x32,0x96,0xE9,0x9B,0x20,0x7D,0xCB,0x3C,0xFA,0x55,0xAE,0x99,0x1A,0x30,0xFC,0x4B,0x3C,0xFF,0x1F};
const uint8_t spTHIRTY[] PROGMEM = {0x02,0x18,0xA2,0x52,0x02,0x16,0x60,0xC0,0x50,0x13,0x25,0x6B,0x2C,0xC4,0xDC,0x52,0xAF,0xB2,0x8B,0x70,0x2A,0xCD,0xBA,0xAA,0xAA,0xC7,0x60,0xCC,0xFD,0xAA,0x8B,0x5D,0x85,0x35,0xED,0xA3,0x2B,0xD3,0x31,0x52,0xF2,0x2A,0xA0,0x7A,0xA5,0x00,0x2C,0xED,0xD2,0xFA,0x9E,0x8C,0x45,0x7D,0xF5,0xD8,0xBA,0x55,0xB2,0xAC,0xD5,0xED,0xE8,0xDE,0x51,0x2A,0x57,0x97,0xA7,0x07,0x41,0xAF,0x5A,0xEC,0xB6,0xEE,0x19,0x7D,0x7A,0xB1,0x9B,0xBA,0x23,0xCC,0xE9,0x5A,0xFF,0x0F};
uint8_t spFOURTY[] PROGMEM = {0x04,0xC8,0xCE,0x8C,0x01,0xCB,0x94,0x33,0x60,0xDA,0x0C,0x01,0x0C,0x13,0xAE,0x80,0xEA,0xD3,0x4A,0x1D,0xC4,0xB4,0x26,0x39,0x1E,0x75,0xA2,0xB3,0x9C,0xAC,0x7E,0x54,0x51,0xEC,0x52,0xAA,0xFA,0x51,0x05,0x73,0xC1,0xE5,0xDC,0x47,0x9D,0xC2,0x8A,0xB5,0x6A,0x57,0x40,0xF5,0x4A,0x01,0x58,0xDA,0xA5,0x8D,0xC3,0x24,0x89,0x5B,0xAF,0xB1,0xB4,0x20,0xE4,0x5E,0x8B,0xC7,0xDA,0x9D,0xA3,0x54,0xBE,0x4E,0xF7,0x8C,0x41,0x98,0xF1,0xC6,0x3D,0x3D,0x0A,0xEA,0xF4,0x23,0xF7,0x34,0x47,0x9C,0x53,0x93,0xDC,0xD3,0x15,0x63,0x6D,0x4D,0x32,0xCF,0x98,0x41,0xA4,0xB9,0xF8,0xFF,0x01};
const uint8_t spFIFTY[] PROGMEM = {0x08,0x68,0x3A,0x05,0x01,0x5D,0xA4,0x12,0x60,0xD8,0x0A,0x02,0x4C,0x5F,0x21,0x80,0xE9,0xD2,0x15,0xD0,0x6C,0xD9,0x4A,0x9B,0x09,0x91,0x94,0x2D,0x2B,0xEF,0x2A,0x95,0x52,0x37,0xAF,0xA2,0xD9,0x52,0x09,0xFD,0x4C,0x80,0x61,0x2B,0x08,0x30,0x7D,0x85,0x00,0xA6,0x4B,0x47,0xE0,0x14,0xA5,0x2A,0x54,0x03,0x0A,0x30,0x74,0xD9,0xE8,0xBB,0x34,0xF2,0x8C,0xD5,0x63,0xE9,0x56,0x49,0x2B,0x1F,0xAF,0x6D,0x04,0x27,0xAA,0x58,0x53,0xEE,0x19,0x93,0x30,0xFD,0x4B,0xB9,0x67,0x70,0xE4,0xAA,0xD5,0xEE,0x6D,0x96,0xB1,0xA6,0x66,0x87,0xB7,0x67,0x22,0x8F,0xA9,0xFD,0xFF};
const uint8_t spSIXTY[] PROGMEM = {0x06,0x78,0x90,0xC4,0x00,0x3F,0x66,0x18,0xE0,0xA7,0x8C,0x04,0x7C,0x9F,0x11,0x80,0xDF,0xDA,0x57,0xD1,0x5D,0xBB,0x2B,0x2D,0x59,0x45,0x6B,0xA9,0xC6,0xB2,0xA6,0x14,0xAD,0x9B,0x18,0x59,0x17,0x04,0x4E,0x51,0xAA,0x42,0x35,0x40,0x01,0x35,0x8D,0x17,0xE0,0xC4,0x9A,0x02,0xBC,0x54,0x85,0xC0,0x29,0x4A,0x55,0xA8,0x06,0x04,0x60,0x48,0x37,0x07,0x6C,0xAE,0xB6,0xAA,0xA9,0x53,0x54,0xA5,0xCB,0xAA,0xBB,0x4B,0x12,0xB7,0x37,0x6B,0x18,0x31,0x51,0xDC,0x5F,0xAF,0x79,0x34,0x47,0xD1,0x58,0x3D,0xD6,0xD1,0x14,0xD5,0x72,0x71,0xDB,0x47,0x51,0xD4,0xC8,0xD7,0xFF,0x0F};
const uint8_t spSEVENTY[] PROGMEM = {0x0C,0xF8,0x29,0x45,0x01,0xBF,0x95,0x5A,0x20,0x00,0xBF,0xA5,0x3A,0xE0,0x97,0x32,0x03,0xFC,0x5C,0xB6,0x8A,0x2E,0x42,0xDD,0x6C,0xD3,0x2A,0x3B,0x2F,0xD3,0xB4,0xCD,0xAB,0xCA,0xA6,0xD4,0x2B,0x37,0xB5,0x3A,0x3A,0x8F,0x10,0x5B,0x99,0xFA,0x6C,0xC3,0xCC,0x78,0xD5,0x6A,0x8A,0x0D,0x0B,0xF5,0x47,0x63,0xAC,0x9A,0x33,0xC5,0x63,0xA7,0xB1,0x2A,0xEC,0x50,0xD7,0x9C,0x96,0x66,0xB0,0x92,0xC2,0x95,0x01,0x9E,0x32,0x2D,0xDB,0x0B,0xE3,0xE2,0xAC,0xAD,0xED,0x4D,0x39,0xB9,0xD5,0xC6,0xB5,0x0F,0x13,0xCC,0xE1,0x9B,0xC7,0xD1,0x9D,0x93,0x66,0x7C,0x2E,0xE7,0x70,0x49,0x94,0xBE,0xA5,0x5C,0xC3,0x25,0x72,0xC5,0xA6,0x72,0x0F,0xEF,0x28,0x59,0xAB,0xDD,0x3D,0xAA,0x91,0x58,0xAD,0xFA,0x7F};
const uint8_t spEIGHTY[] PROGMEM = {0x63,0xEA,0xD2,0x28,0x37,0x67,0xAD,0x7E,0xF9,0x26,0xAC,0x58,0xB3,0x9A,0x91,0x1C,0x34,0xB3,0xC9,0x68,0x46,0x13,0x54,0xEF,0x25,0xA3,0x1E,0x85,0xD1,0x7C,0x96,0x88,0x21,0x52,0xB3,0x71,0x4F,0xA4,0x80,0x25,0x42,0x4B,0x37,0x82,0x82,0xD9,0x2C,0x1E,0xD3,0x4C,0x06,0xEA,0xB5,0x64,0xAC,0xCB,0x3B,0x50,0xE5,0xE2,0xB2,0x2F,0xEB,0x40,0x53,0x8F,0xCB,0x39,0xBD,0x21,0x75,0x2D,0xCE,0x6F,0x7A,0x67,0x12,0x90,0xEC,0xD9,0xFF,0x0F};
const uint8_t spNINETY[] PROGMEM = {0x6E,0x28,0x1C,0xE3,0x38,0xB4,0xB8,0x3E,0x33,0xAA,0xE5,0xF0,0xB2,0xBA,0x26,0xD2,0x5D,0x6C,0xF5,0xA9,0x9A,0x9C,0xB0,0x90,0x35,0xA7,0xAA,0x76,0xDC,0x52,0xD6,0x9C,0xA2,0x56,0xB7,0x70,0x9D,0xB3,0xB2,0x56,0x4C,0xC2,0x7D,0xCA,0xCA,0x7A,0x11,0xF1,0x88,0x31,0xAD,0xE8,0x91,0x34,0xA2,0xCA,0x88,0xD6,0x08,0xAD,0xF4,0x4C,0x5C,0x80,0xA9,0x52,0x5A,0xB7,0xD2,0xB8,0x30,0xB6,0x19,0xC3,0x48,0x4A,0xE2,0xB1,0x64,0xCD,0x33,0x97,0xA0,0xE9,0x96,0xB1,0xCC,0xD8,0x02,0x6E,0x5F,0xDA,0x3A,0xD3,0x30,0xB8,0x7F,0x29,0xEB,0x4C,0x8D,0x10,0xB1,0xE5,0xFF,0x01};
const uint8_t spHUNDRED[] PROGMEM = {0x04,0xC8,0x7E,0x5C,0x02,0x0A,0xA8,0x62,0x43,0x03,0xA7,0xA8,0x62,0x43,0x4B,0x97,0xDC,0xF2,0x14,0xC5,0xA7,0x9B,0x7A,0xD3,0x95,0x37,0xC3,0x1E,0x16,0x4A,0x66,0x36,0xF3,0x5A,0x89,0x6E,0xD4,0x30,0x55,0xB5,0x32,0xB7,0x31,0xB5,0xC1,0x69,0x2C,0xE9,0xF7,0xBC,0x96,0x12,0x39,0xD4,0xB5,0xFD,0xDA,0x9B,0x0F,0xD1,0x90,0xEE,0xF5,0xE4,0x17,0x02,0x45,0x28,0x77,0x11,0xD9,0x40,0x9E,0x45,0xDD,0x2B,0x33,0x71,0x7A,0xBA,0x0B,0x13,0x95,0x2D,0xF9,0xF9,0x7F};
const uint8_t spTHOUSAND[] PROGMEM = {0x08,0x48,0xCC,0x0C,0x01,0x5D,0xA9,0x21,0x60,0x2A,0x33,0x04,0x4C,0x65,0x4A,0x80,0xE9,0x52,0x57,0xDD,0x84,0x7B,0x98,0x36,0x3E,0x75,0x13,0x19,0xE1,0xB4,0xE5,0x54,0x55,0x76,0x86,0xCB,0x9A,0x53,0x15,0xDB,0x99,0xAA,0x6B,0x4E,0x51,0x42,0x67,0x8A,0x2E,0x39,0x59,0x0A,0x9D,0xA1,0xB6,0x64,0x64,0x31,0x4F,0xBA,0xDA,0x93,0x55,0x44,0xB7,0xE9,0x2A,0x9B,0x57,0x95,0xF9,0xBA,0xAB,0x74,0x69,0x75,0x62,0x13,0x2A,0xB2,0xB9,0xF5,0x87,0x8B,0x87,0x8B,0x36,0x07,0x3C,0x82,0x1E,0x81,0x32,0xFD,0xEE,0x1A,0xC6,0x52,0xD7,0x3A,0x49,0xBA,0x99,0x6C,0x39,0x7B,0xA7,0xE9,0x1A,0xB2,0xA5,0xED,0x43,0x55,0x88,0xE1,0x97,0xF2,0x74,0x59,0x21,0xC6,0xAF,0xCB,0x33,0x1C,0x99,0xBB,0xC5,0x2D,0xD7,0xB0,0x24,0xE1,0x1A,0x2F,0x9C,0xCD,0xA0,0x85,0xBB,0x5D,0x77,0x16,0x89,0xD1,0x26,0xC9,0xCC,0x95,0x04,0x65,0xBB,0x25,0x25,0xB7,0x11,0x96,0x25,0xBD,0x3A,0x7D,0x53,0xAB,0xB9,0x69,0x1B,0xF3,0x35,0x67,0xA6,0x2A,0x5B,0xFE,0x1F};
const uint8_t spMILLION[] PROGMEM = {0x69,0xCE,0x5C,0x74,0xD4,0x9A,0xF6,0xF1,0xF4,0x83,0x9B,0x98,0xF9,0xE2,0x53,0xB4,0x60,0xA6,0x6A,0x6B,0x4E,0xD6,0x43,0x9A,0x8A,0xAC,0x39,0x69,0x37,0xE5,0xA6,0xB2,0xE6,0xA4,0x4D,0xB9,0x25,0xCB,0x9A,0x93,0x4E,0x2D,0x62,0x65,0xE9,0x4E,0x36,0x55,0x3A,0x69,0xA4,0x5D,0x55,0xCF,0x8E,0x6A,0xBA,0x66,0xD5,0xCD,0x2B,0x99,0xE7,0x9A,0xD3,0x37,0xAF,0xEC,0x9E,0x6B,0xCE,0xD4,0x4C,0x8A,0x79,0xAC,0x1A,0x7B,0x93,0xA9,0xE1,0xF1,0x69,0x5C,0x95,0x95,0x7A,0xD8,0xC2,0x76,0x35,0x83,0xE1,0xEE,0x6E,0xD2,0xD5,0x2D,0xBA,0x79,0x64,0x09,0xD7,0x48,0xE8,0x1C,0x9A,0x26,0x5D,0xCD,0xA0,0x47,0x84,0x9B,0xF4,0x34,0x8D,0xAE,0x1E,0x59,0xFE,0x1F};
const uint8_t spPATH[] PROGMEM = {0x08,0x48,0xCC,0x0C,0x03,0xA9,0xAE,0x51,0x2D,0xAD,0x22,0xAF,0xA6,0x24,0xD3,0x8A,0x9C,0xB2,0xBA,0xEA,0x52,0xA2,0x6D,0xF6,0xEA,0xAA,0x4F,0x89,0xB2,0xDB,0x6B,0x68,0xAE,0xC5,0x4B,0x1F,0xAF,0xA5,0xFA,0x96,0x48,0x9B,0x3D,0xB6,0x12,0x52,0xCB,0x63,0xF6,0x38,0x4B,0x28,0x2D,0xF7,0xD9,0xED,0x29,0x29,0xAC,0xA4,0x96,0xA4,0x37,0x07,0x8F,0xE6,0xAE,0x6C,0xFE,0xDC,0x2C,0x42,0xA2,0x2E,0x02,0x92,0x72,0x65,0x40,0x33,0x69,0x0C,0x18,0x2E,0x8D,0x00,0xC3,0x56,0x50,0x80,0x00,0xD3,0xA5,0x23,0xA0,0xD9,0xB2,0xFF,0x07};
const uint8_t spNEGATIVE[] PROGMEM = {0x66,0x88,0x82,0x3A,0xDD,0xE3,0x84,0x31,0x4B,0x6C,0x0F,0x4F,0x9C,0x86,0xAA,0xA0,0x3D,0xB5,0xF1,0xEA,0xBA,0x33,0x71,0xB5,0x59,0xAB,0x1A,0x36,0x55,0x43,0x57,0xAF,0x72,0xF8,0x52,0x4D,0xDD,0xB2,0xF2,0x91,0x92,0x34,0x64,0x75,0xA9,0x9B,0x31,0x8A,0x94,0x4A,0xA3,0x1E,0x3E,0x41,0x4A,0x56,0xAF,0xB6,0x59,0xC3,0x08,0x5F,0xBD,0xBA,0x6A,0x9C,0xD3,0x7C,0x95,0x9A,0x9D,0xF2,0x28,0x8F,0x06,0x68,0x19,0x4C,0xD8,0xCC,0x6C,0x39,0x60,0x28,0x93,0x00,0x5C,0x19,0xD6,0xCA,0x6A,0x9D,0x5C,0x6B,0xD1,0x18,0x8A,0x31,0xC9,0xA8,0x45,0x63,0xCB,0x3A,0x38,0x2B,0x17,0x95,0xA7,0x04,0x95,0xD0,0x99,0x5D,0x9E,0xE2,0x55,0x43,0xE7,0x75,0x79,0xB3,0x35,0x0D,0xCF,0x55,0xEE,0xCB,0x5E,0x2D,0x38,0x36,0x89,0x3F,0x07,0x33,0x63,0xE9,0x82,0x80,0x60,0x35,0x08,0x50,0x5D,0x2A,0x02,0xAA,0x4D,0xFB,0x7F};
const uint8_t spPOINT[] PROGMEM = {0x0A,0xC8,0x2E,0x8C,0x01,0xD1,0x85,0x95,0x34,0x8B,0xAA,0x74,0x56,0xBD,0xCA,0xE8,0xA6,0xCA,0x29,0xCB,0x2A,0x92,0xEE,0xCA,0xA4,0x36,0x2B,0x2F,0xAA,0x3C,0x43,0x9A,0xAC,0xBC,0x78,0xF3,0xD0,0x68,0xD4,0xB2,0x6A,0x45,0x4A,0x2A,0xA6,0xC9,0x93,0xC4,0x29,0x09,0xC7,0x24,0x8D,0xB1,0xD3,0xCD,0x08,0x21,0x70,0x8A,0x52,0x15,0xAA,0x01,0xE0,0x80,0x63,0xC2,0x14,0x70,0x94,0x19,0x01,0xA6,0x32,0xFB,0x7F};
const uint8_t spAFFIRMATIVE[] PROGMEM = {0xA5,0x4F,0x7A,0xD3,0x3C,0x5A,0x8F,0xAE,0xC8,0xA9,0x70,0xED,0xBD,0xBA,0x2A,0x3B,0xC3,0xD9,0x8F,0x00,0x6C,0x4A,0x21,0x40,0xD3,0xCA,0x08,0x18,0xC2,0x04,0x01,0xC3,0x86,0x11,0x60,0xDA,0x4C,0x05,0x54,0x53,0xDA,0x9C,0x58,0x16,0xED,0xC8,0xEB,0x88,0xE2,0x4C,0xEC,0xC1,0x36,0x23,0xC8,0x65,0xD1,0x17,0xBA,0xB4,0x20,0xE5,0xE4,0x6A,0x8A,0x53,0xA2,0xAC,0x0B,0x73,0x38,0xC9,0xC8,0xB2,0x68,0xCE,0x92,0x24,0x33,0x5B,0x45,0xB1,0xA9,0x11,0xB6,0x6A,0x75,0x4D,0x96,0x98,0xC7,0xAA,0xD6,0x37,0x91,0xEC,0x12,0xAF,0xC8,0xD1,0xB1,0x88,0x97,0x25,0x76,0xC0,0x96,0x22,0x01,0xF8,0x2E,0x2C,0x01,0x53,0x99,0xAD,0xA1,0x7A,0x13,0xF5,0x7A,0xBD,0xE6,0xAE,0x43,0xD4,0x7D,0xCF,0xBA,0xBA,0x0E,0x51,0xF7,0xDD,0xED,0x6A,0xB6,0x94,0xDC,0xF7,0xB4,0xB7,0x5A,0x57,0x09,0xDF,0x9D,0xBE,0x62,0xDC,0xD4,0x75,0xB7,0xFB,0xAA,0x55,0x33,0xE7,0x3E,0xE2,0x2B,0xDC,0x5D,0x35,0xFC,0x98,0xAF,0x79,0x0F,0x0F,0x56,0x6D,0xBE,0xE1,0xA6,0xAA,0x42,0xCE,0xFF,0x03};
const uint8_t spTIMES[] PROGMEM = {0x06,0x18,0xD2,0xCD,0x01,0x9B,0xAB,0x69,0x60,0x15,0xD5,0x74,0x44,0xF2,0x9A,0x55,0x15,0x3B,0xEE,0x29,0x4B,0x76,0xB5,0xEA,0xE2,0xC7,0xBD,0x64,0xC9,0xAA,0x4B,0x18,0xF3,0x94,0x25,0xAB,0x2B,0x61,0xCC,0x53,0x96,0xAE,0xA9,0xC6,0x56,0x4F,0x59,0x32,0xA6,0x9A,0x5D,0x23,0x7C,0xCE,0x58,0x6B,0x54,0x0B,0xCF,0xC9,0x6D,0xAF,0xDE,0x24,0x2A,0x26,0x95,0xBD,0x49,0x61,0x0F,0x8D,0x97,0x8F,0x74,0x56,0x29,0xEC,0x6E,0x55,0xF3,0x69,0x8E,0x26,0x44,0xCC,0xAD,0xAA,0x39,0x9A,0x14,0x71,0x93,0x6A,0xE6,0xAC,0x86,0xCD,0xD5,0xE2,0xA6,0xEB,0x92,0x10,0x71,0xC9,0x9B,0xAE,0x8B,0xD8,0xCD,0xC3,0x4D,0xBE,0xD3,0xFD,0x7D,0x84,0x09,0x33,0x53,0xC0,0xF7,0x48,0x0A,0xD8,0x90,0xF3,0xFF,0x01};
const uint8_t spDIVIDED[] PROGMEM = {0x0A,0x28,0x30,0x6C,0x2C,0x43,0xAA,0x8B,0x64,0xA4,0xD3,0x0F,0xE5,0x22,0x26,0x5B,0x4E,0xD7,0x8C,0xAB,0x98,0x6D,0x39,0x7D,0xD3,0x66,0x1A,0xDC,0xA5,0x4D,0x85,0x99,0xA9,0x71,0x96,0x36,0x57,0xA5,0x6A,0x62,0x71,0x4E,0x5B,0x64,0xA5,0x07,0xA5,0x59,0x55,0x72,0x95,0x61,0xBC,0xF9,0xA4,0xD9,0x95,0xA7,0xC9,0xE6,0x11,0x95,0x90,0x56,0x62,0xAB,0x5B,0x5A,0xA2,0x6B,0x4A,0xCE,0x2E,0x59,0x73,0x2E,0xC1,0xB9,0xBA,0xB5,0x09,0x9B,0x45,0x54,0xEB,0x36,0x54,0xAD,0x14,0xBC,0x73,0xDA,0xD4,0x8C,0x51,0x48,0x2F,0x6E,0x4B,0x53,0x4E,0xAE,0xB9,0x9A,0x1D,0x8E,0x64,0xA6,0x45,0xA3,0xFF,0x07};
const uint8_t spBY[] PROGMEM = {0xEC,0x10,0x32,0x23,0xC5,0x3B,0xAF,0xBD,0x69,0x8D,0x72,0xEA,0x72,0xFA,0x2A,0xAB,0xC3,0x68,0xCB,0xE9,0xB3,0x99,0x0C,0x95,0xCD,0xA7,0x4B,0xB1,0x33,0xD4,0x96,0x9C,0x2E,0xFB,0x8D,0x50,0x5B,0x73,0xBA,0x1C,0xD6,0xC2,0x62,0xC9,0xE9,0x53,0x69,0x4B,0x8B,0x39,0x67,0xCA,0xB9,0x2C,0x35,0xE7,0xAC,0x39,0x97,0xF4,0xD4,0x9C,0xB3,0xF6,0x92,0x3C,0x4B,0x72,0xCE,0xD8,0x4B,0xB4,0x28,0xCD,0x29,0xEB,0xA8,0xD9,0xAD,0x34,0x96,0xB4,0xAB,0x56,0xF5,0xD0,0x9E,0x33,0xAE,0x56,0xD4,0xC2,0x7B,0x4D,0xBB,0x5B,0x34,0x89,0xE8,0x35,0xE5,0xE9,0xDD,0x4D,0xD5,0xD7,0xD4,0xEF,0xFF,0x01};
const uint8_t spHOURS[] PROGMEM = {0x63,0xC9,0x66,0xA2,0xCC,0x57,0x9F,0xB1,0xF1,0xCE,0x6E,0xEE,0x72,0xBB,0xD3,0x24,0x3B,0x99,0x49,0x79,0x6E,0x35,0x2A,0x1F,0x27,0xBD,0xC8,0x4B,0x69,0x4D,0xDA,0xB0,0x54,0x2E,0x65,0xB0,0x65,0x34,0x43,0xF8,0x96,0x31,0x75,0xA5,0x6E,0xEA,0x53,0xD7,0x7C,0xA4,0x27,0xD7,0x00,0x6F,0xD7,0x1B,0x1F,0xFF,0xB8,0xB7,0x26,0x16,0x49,0xEB,0xE6,0x5F,0xF7,0x56,0x2B,0x62,0xEA,0xEB,0xDC,0xDB,0x83,0xB2,0x9A,0x74,0x73,0xEF,0x76,0x9E,0xC4,0xAA,0xDE,0x7D,0xBF,0x87,0xA6,0xA0,0x52,0x06,0x7C,0x4B,0x24,0x01,0x09,0x70,0xE0,0xFF,0x01};
const uint8_t spPLUS[] PROGMEM = {0x0A,0xC8,0x2A,0x54,0x01,0xCD,0xA1,0xA6,0x22,0x09,0x1B,0x57,0x57,0x35,0xF2,0x2C,0x7C,0x93,0x35,0xF3,0x2A,0x2B,0xD9,0x51,0xD3,0x2D,0xAB,0xCC,0xFC,0x4B,0xC3,0x37,0xAF,0x32,0xC9,0xB7,0x72,0x5F,0x39,0xCA,0xE8,0xD3,0x9B,0x7B,0x72,0xA9,0xBE,0xE4,0x48,0x32,0x27,0x06,0x78,0xC6,0x55,0x01,0x3F,0xA5,0x28,0xE0,0xB7,0x52,0x0E,0x30,0xE0,0xB7,0xD4,0xFF,0x07};
const uint8_t spMINUS[] PROGMEM = {0x6A,0xCE,0x8C,0xF4,0xD4,0x93,0x86,0xA5,0x49,0xE2,0x31,0x73,0x1B,0x96,0x26,0x48,0xC6,0x25,0x59,0x9A,0x1B,0x67,0xEC,0xD4,0x34,0x69,0xEA,0x16,0x31,0x33,0x92,0x9C,0xA1,0x88,0xEC,0x08,0xEA,0x72,0xBA,0x2A,0xA6,0x2D,0xB4,0xCB,0xC9,0xBA,0x19,0xB5,0xD4,0x35,0x27,0xEB,0xA9,0x29,0xCC,0x67,0x9F,0xAC,0x65,0xE7,0xE0,0x9E,0x32,0xAA,0x11,0xD1,0xCD,0xC3,0x4D,0x6B,0x7B,0xA0,0x54,0xF5,0x4C,0x67,0x68,0xA1,0xC4,0xC4,0x17,0x8F,0xA5,0x46,0x37,0x97,0x5E,0xD2,0xAE,0x12,0xDD,0x5D,0x7A,0x89,0xBB,0x72,0x72,0xF5,0xD8,0xD9,0x02,0xA8,0xB2,0x58,0x01,0xDF,0x9B,0x09,0xE0,0xB7,0x74,0x01,0xFC,0xE6,0xA9,0x80,0x9F,0x52,0x05,0xF0,0x67,0xFB,0xFF,0x03};
const uint8_t spEQUALS[] PROGMEM = {0x6D,0x18,0x49,0x91,0xBC,0x17,0xEF,0x6E,0x15,0xA3,0x15,0xA2,0xE5,0x93,0x9D,0xB5,0x7C,0x6C,0x07,0xB6,0x7C,0x1C,0xF2,0x11,0x19,0xAC,0xB2,0x0E,0x02,0x45,0x28,0x77,0x11,0xD9,0x00,0x04,0xF0,0xA3,0x88,0x01,0xBE,0x65,0xB4,0x36,0xC8,0x8D,0x08,0xF4,0x33,0xBB,0x39,0xB4,0xB5,0xE2,0xAE,0x0E,0xF2,0xDB,0xD7,0xBA,0xA7,0x23,0xD3,0xEA,0x0E,0xF0,0x9B,0x8E,0xC8,0xAE,0x92,0x24,0x77,0x38,0x33,0xF8,0x68,0xE6,0xD6,0xF1,0x4C,0xD7,0x25,0x21,0xE2,0x92,0x37,0x5D,0x17,0xB1,0x9B,0x87,0x9B,0x7C,0xB7,0xFB,0xFB,0x08,0x13,0x66,0xA6,0x80,0xEF,0x91,0x14,0xB0,0x21,0xE7,0xFF,0x03};
const uint8_t spRED[] PROGMEM = {0x64,0x94,0x76,0xD2,0x24,0xD2,0xA8,0x45,0x97,0x94,0x72,0x95,0xAB,0x26,0x51,0x9B,0x32,0xCC,0x89,0x9A,0x64,0x0B,0xCE,0x34,0x67,0x61,0xF4,0x4D,0xA4,0x43,0x9C,0x8F,0x3E,0x0F,0xB6,0xB0,0x70,0xBF,0xBA,0x12,0x53,0xC2,0xAD,0xFB,0xEA,0x9A,0x19,0xD1,0xB4,0x2E,0xAB,0xEF,0x76,0x59,0xC2,0x76,0xAF,0xA1,0xAB,0x61,0x29,0xDF,0xB5,0x86,0xA1,0x86,0x35,0xFC,0xD3,0xEA,0x27,0x1F,0x96,0xB0,0x4F,0xA2,0x33,0xAC,0x7D,0x4C,0x43,0x89,0x5E,0xCA,0x8C,0x11,0x0F,0x5D,0xBA,0xC9,0x44,0x25,0x2C,0x49,0x69,0x9A,0x48,0x16,0xCF,0x47,0xAD,0xAD,0xD6,0x45,0xB5,0x66,0x99,0xA6,0x26,0x67,0x86,0x9C,0xAC,0xDA,0x96,0x92,0x99,0x2C,0xF2,0xFF,0x03};
const uint8_t spYELLOW[] PROGMEM = {0x69,0xBD,0x56,0x15,0xAC,0x67,0xE5,0xA5,0xCC,0x2B,0x8E,0x82,0xD8,0xD6,0x39,0x9E,0xAE,0x85,0x50,0x37,0x5F,0x7D,0xEB,0x53,0x55,0x1B,0xDE,0xA6,0x6B,0x56,0x5D,0x74,0x47,0x2B,0x77,0x6E,0x75,0x87,0x59,0x95,0xA4,0x76,0x76,0x6B,0xCE,0xA2,0xB3,0x4C,0xF2,0xCF,0xBD,0xED,0xC9,0x54,0xB6,0x52,0x9F,0x7E,0xA5,0xDB,0xC7,0xCA,0x46,0x5D,0x13,0xEF,0xF8,0x84,0x37,0xA8,0xA9,0x0C,0xF2,0xE3,0xBE,0x24,0xC6,0x2B,0x48,0xDF,0xFF,0x03};
const uint8_t spGREEN[] PROGMEM = {0x64,0xD5,0xA2,0x22,0x23,0xAC,0xB0,0x4D,0xF1,0xCA,0x2C,0x55,0x1A,0xF6,0x6C,0x3F,0x24,0xC4,0x72,0x19,0xB2,0xCA,0xA0,0x62,0x67,0xAD,0x8B,0x49,0xCD,0x53,0xDC,0x8D,0x3A,0x55,0x0E,0x4D,0xB5,0x3F,0xAA,0xD2,0x38,0x5C,0xBD,0xFD,0xAA,0x5A,0x51,0x76,0xB7,0x2D,0xA3,0xEE,0xC5,0xD1,0xD2,0x6F,0xAD,0x66,0x78,0x43,0xDB,0x28,0x35,0xDA,0x61,0x15,0xED,0x22,0x4C,0x6B,0x87,0x15,0x8A,0x73,0xB3,0xAD,0xEB,0x52,0xB9,0x4E,0xAD,0xB6,0xAE,0x29,0xB2,0x09,0x0B,0x5B,0xDA,0xA6,0xB1,0xCA,0xDC,0x69,0x69,0xAB,0xC2,0x0A,0x73,0xD5,0xA5,0x6D,0x9A,0xD5,0x3D,0x12,0x95,0xB6,0x7A,0x15,0xB7,0x8A,0x58,0xDA,0xE2,0x54,0x32,0x42,0x62,0x69,0x8A,0x13,0x35,0xCD,0x48,0xFF,0x0F};
const uint8_t spWHITE[] PROGMEM = {0xAE,0x32,0xFE,0x93,0xC3,0x94,0xF9,0xBA,0x34,0xDE,0x5F,0x71,0xB3,0xB6,0xD5,0x46,0x77,0xA1,0x4D,0x5D,0xD6,0x50,0xD4,0xBA,0x8C,0x6C,0x5E,0x63,0xD3,0xAD,0x32,0xBA,0xBA,0xCC,0x3D,0x38,0x71,0xF9,0xE2,0xBA,0x84,0x75,0x24,0x65,0xAA,0x5C,0x82,0xC0,0x29,0x4A,0x55,0xA8,0x06,0x00,0x28,0x60,0x48,0x37,0x06,0x6C,0xAE,0x86,0xC0,0x29,0x4A,0x55,0xA8,0xC6,0xFF,0x03};
const uint8_t spTHEE[] PROGMEM = {0x08,0x20,0xBA,0x0D,0x03,0x6D,0x3E,0x2C,0x55,0x45,0xB3,0x8C,0xBE,0x05,0x65,0xD5,0x78,0x32,0xDA,0xEE,0x85,0x34,0xF2,0xF6,0xE8,0x86,0x33,0xE0,0xCA,0xC7,0xAD,0x9B,0xCE,0x81,0xBB,0x66,0xB7,0x61,0x06,0x07,0xEE,0x9C,0xD5,0xC6,0xA9,0x1D,0x65,0x72,0xD1,0xFF,0x03};
const uint8_t spTHE[] PROGMEM = {0x08,0x20,0xBA,0x0D,0x03,0x69,0xDF,0xA8,0xCD,0x85,0x3B,0xD7,0x79,0xF4,0x59,0xB7,0xA9,0xFA,0xA2,0xD5,0x27,0xD9,0x6E,0x11,0x8B,0xC6,0x90,0xB4,0x47,0xA8,0x6D,0xFA,0x7F};
const uint8_t spANSWER[] PROGMEM = {0x63,0x6E,0x3E,0xC5,0xC7,0x17,0xEF,0x79,0x8D,0x3D,0xB4,0x68,0xD9,0x9B,0x35,0x0C,0x3F,0x62,0x69,0xAB,0x57,0xD7,0x7C,0x71,0xB8,0x2F,0x59,0x75,0x0D,0xE6,0x4E,0x5D,0xA7,0x55,0xCD,0x60,0x6A,0xB8,0xEB,0x52,0x55,0x89,0x15,0xE1,0x6E,0x6A,0x95,0xAA,0x09,0xC9,0x22,0x2C,0x8B,0x03,0x7E,0x1D,0x75,0xC0,0x6F,0xA5,0x0E,0xF8,0xAB,0xC5,0x01,0x2F,0xBA,0xAF,0xB1,0x89,0x54,0x4E,0xEF,0xBA,0xC6,0x26,0x5B,0x69,0x3C,0xDB,0x58,0xAB,0x1F,0xA6,0x95,0x6C,0x63,0x2F,0x79,0x88,0x97,0xB3,0x96,0xA3,0xD4,0x46,0x5E,0xEA,0x56,0xCE,0xD2,0x0A,0xAD,0xB9,0xCB,0xFF,0x03};
const uint8_t spIS[] PROGMEM = {0xA3,0xED,0xC6,0x30,0x3D,0x57,0xAD,0x7E,0xA8,0x42,0xA9,0x5C,0xB5,0xFA,0xA9,0x8A,0xB8,0x62,0xF3,0xEA,0x86,0x48,0xE6,0x8A,0x57,0xAB,0xEB,0x22,0x58,0x23,0x5E,0xAF,0xAE,0xCA,0x64,0xF5,0x7C,0x3C,0xBA,0xCA,0x93,0xD5,0xE3,0x76,0xEB,0x3B,0x4E,0x55,0xB3,0x4D,0x65,0xB8,0x58,0x5D,0xDD,0x72,0x97,0xE9,0x1B,0x55,0x27,0x4D,0xD3,0xE6,0x85,0xD5,0x4D,0x3D,0x6B,0xF9,0x5F,0x50,0x1B,0x26,0x27,0x0A,0xF8,0xAD,0x54,0x01,0xBF,0xBA,0x0B,0xE0,0xA7,0xF4,0xFF,0x07};
const uint8_t spSTART[] PROGMEM = {0x02,0xF8,0x49,0xCC,0x00,0xBF,0x87,0x3B,0xE0,0xB7,0x60,0x03,0xFC,0x9A,0xAA,0x80,0x3F,0x92,0x11,0x30,0x29,0x9A,0x02,0x86,0x34,0x5F,0x65,0x13,0x69,0xE2,0xDA,0x65,0x35,0x59,0x8F,0x49,0x59,0x97,0xD5,0x65,0x7D,0x29,0xA5,0xDE,0x56,0x97,0xF5,0x85,0x8E,0xE4,0x5D,0x6D,0x0E,0x23,0x39,0xDC,0x79,0xD4,0xA5,0x35,0x75,0x72,0xEF,0x51,0x95,0xE9,0x38,0xE6,0xB9,0x4B,0x5D,0x1A,0x26,0x6B,0x3B,0x46,0xE0,0x14,0xA5,0x2A,0x54,0x03,0x40,0x01,0x43,0xBA,0x31,0x60,0x73,0x35,0x04,0x4E,0x51,0xAA,0x42,0x35,0xFE,0x1F};
const uint8_t spSTOP[] PROGMEM = {0x08,0xF8,0x91,0x55,0x00,0x3F,0x09,0x1B,0xE0,0x9B,0x48,0x03,0xFC,0xE0,0x6E,0x80,0xEF,0xDC,0x1D,0xF0,0x83,0x1B,0x02,0xA7,0x28,0x55,0xA1,0x1A,0x60,0x80,0xA7,0x4C,0x47,0x5C,0x4D,0xA9,0xA6,0xAE,0xD9,0xE9,0x4A,0xAB,0xAA,0xF0,0xE4,0x2D,0x23,0xCB,0x76,0x2B,0x83,0x37,0xCF,0x6C,0xA4,0xC9,0x5F,0xB8,0xEB,0xEA,0x91,0xC4,0x3C,0x91,0x6A,0x8B,0x53,0x1C,0x4A,0xA4,0xA9,0xD7,0x42,0xE0,0x14,0xA5,0x2A,0x54,0x03,0x80,0x00,0xCE,0x85,0x08,0x20,0x27,0xF7,0xFF,0x07};
const uint8_t spREADY[] PROGMEM = {0x6A,0xB4,0xD9,0x25,0x4A,0xE5,0xDB,0xD9,0x8D,0xB1,0xB2,0x45,0x9A,0xF6,0xD8,0x9F,0xAE,0x26,0xD7,0x30,0xED,0x72,0xDA,0x9E,0xCD,0x9C,0x6D,0xC9,0x6D,0x76,0xED,0xFA,0xE1,0x93,0x8D,0xAD,0x51,0x1F,0xC7,0xD8,0x13,0x8B,0x5A,0x3F,0x99,0x4B,0x39,0x7A,0x13,0xE2,0xE8,0x3B,0xF5,0xCA,0x77,0x7E,0xC2,0xDB,0x2B,0x8A,0xC7,0xD6,0xFA,0x7F,};
const uint8_t spTEMPERATURE[] PROGMEM = {0x0A,0x38,0xDE,0x32,0x00,0x2F,0xBB,0x37,0xBF,0x59,0x57,0x76,0x6F,0xB8,0xB2,0x16,0xCA,0xC4,0x75,0xCB,0x4A,0xAB,0x4A,0xF3,0xF6,0xCD,0x2B,0x2D,0x66,0x94,0xD7,0xBA,0xB4,0x34,0x79,0x93,0x52,0x97,0x16,0xB2,0x28,0x5B,0x4D,0x43,0x36,0x10,0x20,0xAB,0xB2,0x52,0xC4,0x26,0x9A,0x26,0x49,0x47,0x9B,0x1B,0xA5,0xA6,0x74,0x5D,0x43,0xF1,0x65,0x14,0x91,0xAD,0xED,0xB5,0x99,0xB1,0x69,0x1A,0x20,0xC0,0x0A,0x84,0x0E,0xD8,0xD3,0x23,0x01,0xA3,0x4C,0x1A,0xA0,0xF5,0xC9,0xD6,0x95,0xE0,0x24,0x1D,0xD9,0x5A,0x9B,0x9C,0x8B,0xAE,0x79,0x2B,0x43,0xAC,0xA6,0xDE,0x9C,0x35,0x9D,0xB1,0xB3,0x47,0x52,0xD7,0x74,0xC6,0x2E,0x52,0xA1,0x5E,0xC2,0x1D,0x3B,0xEB,0xB8,0x65,0x0D,0x5F,0xAA,0x26,0xB6,0xE2,0x35,0x7C,0xA9,0x2A,0xFB,0x6A,0x16,0xF7,0xE7,0x9E,0x4C,0xEB,0xD9,0xFE,0x1F};
const uint8_t spTIME[] PROGMEM = {0x0E,0x18,0xA2,0x34,0x00,0x4B,0x0E,0x2B,0x20,0x5B,0xB7,0x51,0xA4,0x94,0x5A,0xAE,0xA5,0x56,0x99,0x4B,0x6B,0xBA,0xCC,0x5D,0x75,0x8E,0x63,0xD6,0x32,0x67,0x35,0x39,0x8F,0x5A,0xEB,0x9C,0x35,0x16,0xBF,0x26,0x2D,0x4B,0xD6,0x58,0xED,0x39,0x8D,0xAE,0x59,0x47,0xD3,0x1B,0xDC,0xD2,0x66,0x9C,0x5D,0xB6,0xC9,0xE8,0xEA,0x76,0x37,0x9F,0x62,0x6D,0x8B,0xCB,0xD3,0x42,0x88,0x8C,0x2D,0x2A,0x6F,0x8B,0x6A,0x1E,0x36,0xA5,0x7C,0xD5,0xB1,0xBB,0x78,0xE2,0xF2,0x56,0x4B,0x6E,0xEA,0x4E,0xCA,0x5B,0x3D,0x87,0xA8,0x39,0x09,0x6F,0x75,0xE2,0xA6,0x6A,0xF7,0xFF,0x01};
const uint8_t spA_M[] PROGMEM = {0x6B,0xE8,0xC9,0x44,0x22,0xD7,0xEC,0xE1,0xB4,0x23,0x3B,0xA9,0xE5,0x9A,0x53,0xF5,0x64,0x64,0x59,0x6B,0x4F,0x35,0xB2,0x91,0x45,0x3D,0x39,0xF5,0xC8,0x86,0x1A,0xF9,0xE4,0xF4,0xA3,0x19,0xA9,0xE7,0x92,0xD3,0x8D,0x22,0x64,0xD9,0x4B,0xC6,0x3A,0x8A,0xA1,0x74,0x3D,0x69,0xFB,0xAC,0x89,0xE4,0xF9,0xA4,0x0C,0x3D,0x89,0x6A,0xE5,0xE2,0x33,0xF6,0x2A,0xE2,0xD1,0xAB,0x4F,0xD7,0xAB,0xB3,0x46,0xAE,0x3E,0x75,0x6F,0x66,0x6A,0xB9,0xE6,0xD4,0xAD,0x9A,0xBA,0xE6,0x92,0xD3,0xB6,0xA2,0xEE,0x5A,0x73,0x4E,0x57,0x93,0xBB,0x9B,0x2D,0x39,0x43,0x89,0xE9,0x6E,0xB6,0x64,0x4D,0xC5,0x5B,0x04,0xB9,0xDC,0xB1,0x34,0x2D,0x16,0x64,0x76,0xDB,0x5E,0x95,0x78,0xA0,0xC9,0x2D,0x7B,0xD3,0xE2,0x41,0x26,0xB7,0x9C,0xCD,0x70,0x1A,0x85,0x92,0x74,0x56,0xA5,0x91,0x68,0x4A,0xD2,0xD5,0x0C,0xA5,0x89,0x29,0x49,0x57,0x33,0x1C,0xC9,0x2A,0x27,0xDD,0xCD,0x71,0xAA,0xAA,0xE2,0xF4,0x34,0xCB,0x19,0x6C,0x72,0xD2,0x57,0x95,0x44,0x90,0xC9,0xFD,0x7F};
const uint8_t spP_M[] PROGMEM = {0x0A,0xC8,0xDC,0x95,0x01,0xC6,0x90,0xB5,0xB4,0x19,0x41,0xCD,0x58,0xD2,0xD2,0xE6,0x51,0xA3,0x7B,0xF6,0xCA,0x46,0x25,0x92,0xAC,0x25,0xAB,0x98,0xCD,0x91,0x2C,0x57,0xAF,0x6A,0x56,0x43,0x8A,0xDA,0x3C,0xBA,0x59,0x0D,0x29,0x6B,0x55,0x9B,0x66,0x35,0xA4,0xAC,0x47,0x6D,0x99,0xD5,0x90,0xAA,0x1E,0xB7,0x75,0x66,0x43,0xEA,0xBA,0x35,0x86,0x9E,0x44,0xB5,0x72,0xF1,0x19,0x7B,0x15,0xF1,0xE8,0xD5,0xA7,0xEB,0xD5,0x59,0x23,0x57,0x9F,0xBA,0x37,0x33,0xB5,0x5C,0x73,0xEA,0x56,0x4D,0x5D,0x73,0xC9,0x69,0x5B,0x51,0x77,0xAD,0x39,0xA7,0xAB,0xC9,0xDD,0xCD,0x96,0x9C,0xA1,0xC4,0x74,0x37,0x5B,0xB2,0xA6,0xE2,0x2D,0x82,0x5C,0xEE,0x58,0x9A,0x16,0x0B,0x32,0xBB,0x6D,0xAF,0x4A,0x3C,0xD0,0xE4,0x96,0xBD,0x69,0xF1,0x20,0x93,0x5B,0xCE,0x66,0x38,0x8D,0x42,0x49,0x3A,0xAB,0xD2,0x48,0x34,0x25,0xE9,0x6A,0x86,0xD2,0xC4,0x94,0xA4,0xAB,0x19,0x8E,0x64,0x95,0x93,0xEE,0xE6,0x38,0x55,0x55,0x71,0xBA,0x9B,0xE5,0x0C,0x36,0x39,0xFF,0x0F};
const uint8_t spOCLOCK[] PROGMEM = {0xAD,0x8C,0xBE,0x22,0xC5,0x56,0x8D,0xBE,0xC8,0xB1,0x74,0xE9,0x33,0xEA,0xCA,0xD7,0x38,0xB9,0x8F,0xA8,0x63,0x4A,0x14,0xEB,0xCE,0xA0,0x80,0xEC,0xA6,0x14,0xD0,0x94,0x87,0x00,0x06,0x8B,0x6A,0x59,0xE2,0x97,0x6E,0xEC,0x79,0x65,0x49,0x5F,0xA9,0xC9,0xEA,0x55,0x15,0x79,0xAD,0xCE,0x5B,0x56,0x9F,0xD5,0x15,0x87,0xAF,0x59,0x73,0x91,0x57,0x9C,0xBE,0x65,0xAC,0xD9,0x5C,0x4A,0xD8,0xE6,0x71,0xE4,0xB0,0xEE,0x61,0xAB,0xCA,0x93,0x4A,0x7A,0x5A,0x2E,0x42,0xE0,0x14,0xA5,0x2A,0x54,0x03,0x40,0x00,0x75,0x0E,0x71,0x00,0x01,0xD1,0x11,0xFF,0x3F};
const uint8_t spDEGREES[] PROGMEM = {0x0A,0x28,0x30,0x6C,0x74,0x53,0x25,0xB3,0x67,0xAC,0x95,0x0D,0x63,0x24,0x11,0x8B,0x57,0x31,0xBC,0xA1,0x54,0xAC,0x19,0xF5,0x70,0x06,0x3C,0xB6,0xC6,0x0D,0x91,0xA9,0xCE,0x52,0x28,0x36,0x32,0xDD,0x95,0x69,0xB2,0xF8,0xD8,0xBA,0x6C,0xDA,0x31,0x34,0x69,0xA9,0x53,0x30,0xE3,0x92,0x74,0xA9,0x2A,0x55,0x4D,0x92,0xD3,0x97,0xAA,0x46,0x13,0x2A,0x4D,0xBF,0xEA,0x1E,0x82,0xB1,0x74,0xEB,0xEA,0x86,0x09,0x82,0xF6,0x35,0x6B,0x18,0xCE,0x11,0x27,0x66,0x8D,0x69,0x38,0x47,0x9C,0x5C,0x3C,0x96,0xE9,0x1C,0xA1,0x73,0xF5,0xD8,0xA7,0x33,0xA4,0xCE,0xC5,0xE5,0x18,0x41,0x91,0x3B,0x1F,0xB7,0x73,0x04,0x25,0xAA,0x5C,0x53,0xDE,0x19,0x83,0x30,0x6C,0x6B,0x7A,0x87,0x77,0xE4,0x8C,0x3D,0xE5,0x1D,0xD1,0x50,0xCC,0xB7,0xA6,0x6F,0x38,0x27,0x76,0xDD,0x12,0xBE,0xA1,0x83,0x38,0x78,0xAF,0xF9,0x9A,0x0A,0x14,0xB7,0xCF,0xE9,0xBF,0x24,0x44,0x5C,0xF2,0xA6,0xFF,0x22,0x76,0xF3,0x70,0x93,0x7F,0x05,0x7C,0x8F,0xA4,0x01,0x01,0x6C,0xC8,0xC9,0x80,0x1F,0x3C,0xFE,0x1F};
const uint8_t spCELCIUS[] PROGMEM = {0x08,0x68,0x48,0x94,0x00,0x37,0x30,0x0A,0xE0,0x0F,0x17,0x05,0xFC,0xEE,0x64,0x80,0xDF,0x8B,0x0D,0xF0,0x6F,0x89,0x01,0xDE,0x54,0x4D,0xCD,0xB7,0x5E,0xCA,0xE2,0x65,0x65,0x4D,0x87,0x99,0xD9,0x9A,0x95,0x57,0xD9,0x6E,0x61,0x6B,0x56,0x96,0xD5,0x84,0xA7,0xAC,0x5E,0x69,0x08,0x1B,0x6E,0xB6,0x79,0xC4,0xC1,0x6F,0x96,0x48,0xA7,0x96,0x44,0x7D,0x9E,0xC2,0x9D,0x5A,0xD6,0x51,0x45,0x18,0x7B,0x31,0xC0,0x63,0xC4,0x0E,0xF8,0xD5,0x24,0x00,0x7F,0xB8,0x07,0xE0,0x77,0xD5,0xD6,0x2D,0x11,0x4E,0x6A,0x59,0x5B,0x57,0xAD,0x70,0x44,0x3C,0x1E,0x43,0xD7,0x46,0xD6,0xF6,0x68,0x2C,0x55,0x2A,0xC7,0xC4,0xAA,0xB6,0x36,0x65,0x1C,0xE3,0x8F,0xC6,0xD6,0x55,0x88,0x96,0x2F,0x6E,0x47,0xB1,0x21,0x9E,0xF9,0x78,0x3C,0x55,0x96,0x46,0xF8,0xAA,0xF2,0x57,0x35,0xAC,0x91,0x8B,0xD2,0x5F,0x79,0x4B,0x4A,0xAE,0x66,0xC0,0x67,0xA4,0x0A,0xF8,0xC9,0xC4,0x00,0xAF,0x38,0x2B,0xE0,0x35,0x55,0x0E,0x30,0xE0,0xB5,0x92,0xFF,0x07};
const uint8_t spFARENHEIT[] PROGMEM = {0x04,0xE8,0xDE,0x1D,0x01,0x4B,0xBB,0x12,0x60,0x7A,0x77,0x01,0x0C,0xED,0x36,0x8A,0xEA,0xDD,0xDC,0x64,0xCD,0x2A,0x6A,0x34,0x4F,0xAD,0x25,0xBB,0x5C,0x55,0xCB,0xE6,0x29,0xBD,0x64,0xD7,0xAB,0xA9,0xC5,0x3C,0xA4,0xEB,0x88,0x56,0x35,0xB6,0x74,0x57,0x97,0xBA,0xD8,0xD8,0xDC,0xDD,0x59,0xE9,0x73,0xE3,0x94,0x30,0x6F,0x6B,0x2C,0xC1,0x42,0xC3,0xBA,0xAE,0xBA,0x85,0x14,0xB7,0x9C,0x5D,0xCE,0x6E,0x49,0x53,0x3D,0x6E,0x3A,0x9B,0x46,0x29,0xF3,0x78,0x0C,0x28,0xAE,0x53,0x03,0x1A,0x58,0x5D,0xD5,0x93,0x19,0xB2,0x66,0xF5,0xC5,0x4C,0x64,0xC8,0x9A,0xB1,0xB6,0x58,0x96,0x66,0x4F,0xC6,0xD5,0x5C,0x8B,0xA7,0xBE,0x2E,0x57,0xB3,0xC9,0x59,0xF1,0x66,0xDC,0x3D,0xB7,0xB8,0xD9,0x9A,0x72,0xB7,0x22,0xA6,0xDE,0xB5,0xD3,0xD7,0x1A,0xB9,0xF4,0xCE,0x46,0xE0,0x14,0xA5,0x2A,0x54,0x03,0x00,0x14,0x30,0x85,0xBA,0x00,0x9E,0xAF,0xF8,0x7F};
const uint8_t spERROR[] PROGMEM = {0x6D,0x6C,0x6E,0x89,0x5B,0x36,0x8F,0xA9,0x9B,0x11,0x5A,0xE9,0x33,0xA7,0x31,0x17,0xB7,0x4A,0x47,0xFD,0xC6,0x92,0x9A,0x8B,0x2F,0x65,0x4B,0x6B,0x1C,0xE4,0xD5,0xD8,0x2D,0xAF,0x65,0x8D,0x83,0xAD,0x9A,0xB2,0x95,0x23,0x76,0x93,0x58,0xCA,0xD7,0xCE,0xEC,0x57,0xF8,0xD8,0x5B,0x3A,0x8B,0x3D,0xC5,0xE7,0x7C,0xE9,0xCD,0xBD,0x30,0x86,0xDA,0x86,0x2F,0x97,0x82,0x38,0xEC,0x13,0xFE,0xE4,0x07,0xED,0x35,0x4B,0xF8,0x73,0x4E,0xEC,0xD2,0x3C,0xEE,0x2F,0xCB,0xB9,0x9D,0x3B,0xFF,0x3F};
uint8_t spMILES[] PROGMEM = {0xA5,0xA8,0x86,0xDA,0xD9,0xDC,0x8E,0xB2,0x1A,0xCD,0x22,0x53,0x32,0xEA,0x64,0xB3,0x92,0x43,0xC9,0xAA,0x63,0x69,0x77,0xD3,0xB9,0xA3,0x49,0xEE,0x42,0x5A,0x67,0xAF,0x36,0x9B,0x73,0x19,0x5D,0xBC,0xBA,0xA2,0xD7,0x65,0x64,0xF1,0xEA,0x8B,0x59,0xD3,0x96,0xC7,0x6B,0x28,0xA1,0xC5,0x4B,0x1F,0xB7,0xB1,0xEA,0x55,0x19,0x79,0xD5,0x96,0xE2,0x46,0xAC,0x65,0x51,0x59,0xB3,0x1F,0xB6,0xB1,0x47,0x6D,0x4D,0x6E,0x3C,0x5D,0x16,0xA5,0x2D,0xBA,0x89,0x52,0xD9,0xE8,0xB6,0xE0,0x36,0x4A,0x74,0x57,0xD8,0x83,0xE9,0x2A,0xE3,0xCE,0xE6,0x88,0x26,0x2B,0x59,0x5A,0x89,0x33,0x98,0xAC,0x44,0x4B,0x1D,0xAE,0x4B,0x42,0xC4,0x25,0x6F,0xB8,0x2F,0x62,0x37,0x0F,0x37,0xF1,0x56,0xC0,0xF7,0x48,0x02,0xD8,0x90,0xF3,0xFF,0x01};
uint8_t spPER[] PROGMEM = {0x0A,0x28,0xC2,0x44,0x01,0xD1,0x88,0x2A,0x20,0x67,0xB7,0xD2,0x85,0xAA,0xDC,0x4D,0x6B,0x4E,0x9B,0xC3,0x30,0x1D,0x65,0x5B,0x6D,0xF1,0xC3,0x74,0x9C,0x6D,0x8C,0x25,0x0C,0xF1,0x71,0xB6,0xB1,0xE6,0x5A,0xA8,0x2B,0x59,0xCA,0x99,0xAA,0x63,0x9C,0x64,0x49,0x57,0x69,0x8D,0xB2,0xE2,0x25,0xDD,0xA5,0x25,0xEA,0x8A,0x97,0xF0,0xE4,0x21,0x54,0xA3,0x59,0xFE,0x1F};
uint8_t spHOUR[] PROGMEM = {0xA5,0x8E,0x2D,0x23,0xA2,0xEA,0x9C,0xA3,0x98,0xC9,0x70,0x5B,0x72,0xC6,0xA2,0x36,0x23,0x74,0xCD,0x19,0x8A,0xDA,0x0C,0xD7,0x2D,0xA7,0xCB,0x7A,0x33,0x5D,0xB6,0x9C,0x36,0xDA,0xAD,0x72,0xEE,0x32,0x5A,0x9F,0xBA,0xD2,0xA9,0xF3,0xE8,0x5C,0x9C,0x8C,0x60,0x2F,0x63,0x70,0x79,0x3C,0x82,0xBD,0xCC,0x61,0x2C,0x31,0xA7,0x54,0x73,0x96,0xB1,0xA6,0xE6,0x1C,0x43,0x59,0xDA,0x9E,0x9A,0x53,0x2C,0x77,0x29,0x47,0xEE,0x46,0x31,0xDC,0x25,0x9D,0xB9,0x3A,0xFA,0x4A,0x96,0x74,0x15,0xDF,0x82,0x17,0xDA,0xC2,0x95,0xA7,0x60,0xAE,0x66,0xF9,0x7F};
const uint8_t spMINUTES[] PROGMEM = {0x66,0x55,0xD2,0xA2,0xD3,0xEB,0xBA,0xD5,0x0B,0xB5,0x2A,0x4B,0x66,0x16,0xA7,0x38,0x2A,0x22,0x4D,0x9B,0xB2,0x32,0x35,0xF3,0x36,0xAB,0xAE,0x8E,0x42,0xB3,0xA6,0x9C,0xAA,0x58,0x76,0xCF,0x2E,0x7D,0x8A,0xEA,0xC5,0x2C,0x7A,0xCA,0xCA,0x9A,0xE3,0x54,0x8E,0x26,0xA3,0xE8,0x16,0xD3,0x4B,0x93,0xAC,0xBA,0x5B,0x36,0x17,0x5D,0x73,0xFA,0xE6,0x52,0xD4,0x62,0xF1,0x59,0xBA,0x49,0x31,0x8B,0xD5,0x63,0xAF,0xDE,0xC5,0xAC,0xDF,0x20,0x70,0x8A,0x52,0x15,0xAA,0x01,0x00,0xC0,0x80,0xE9,0x24,0x04,0xB0,0xDC,0xAE,0x01,0x9E,0x71,0x55,0xC0,0x4F,0x29,0x0A,0xF8,0xAD,0x54,0x03,0x0C,0xF8,0x2D,0x95,0x01,0xBF,0x94,0xFD,0x3F};
uint8_t spGUSTING_TO[] PROGMEM = {0x0A,0x28,0xB9,0x65,0xEC,0x5D,0x8F,0xAA,0xB8,0xEB,0x55,0x16,0x1B,0x62,0x69,0x6B,0x56,0x55,0xD4,0x98,0xA7,0xAF,0x5E,0x75,0xB1,0x27,0xEE,0xB1,0xB9,0x34,0x9D,0x87,0x64,0x52,0x42,0x07,0xFC,0xC0,0xA2,0x80,0x7F,0x53,0x05,0xF0,0x47,0x09,0x02,0x6E,0x10,0x71,0xC0,0x61,0x6E,0xA3,0xAD,0xDA,0xC5,0xB5,0x56,0x8F,0xB6,0x1B,0x23,0xCD,0x58,0xDD,0xFA,0xEE,0x15,0x63,0xAD,0x52,0xEA,0x9B,0x45,0x6F,0x53,0xF9,0xA9,0x6F,0x9A,0xAC,0xDD,0xEC,0xA5,0xBE,0x6A,0x8C,0x49,0x97,0x67,0x86,0xA2,0xA0,0xCA,0x59,0x0B,0x59,0x0A,0x51,0x73,0xAF,0x34,0x01,0xD8,0x22,0x2C,0x00,0xC7,0x45,0x95,0xA1,0x1A,0x63,0xF1,0x58,0xD5,0xC6,0x6A,0x44,0x35,0x74,0x4D,0x9B,0x8A,0x30,0xB3,0x94,0x2D,0x65,0xCA,0xD4,0x3D,0x8B,0xD6,0xA4,0x29,0xE3,0x48,0x2B,0xDC,0x9C,0xA6,0x8C,0x22,0xA2,0x61,0x73,0x98,0x12,0xAA,0x92,0xA4,0xCD,0x69,0x4E,0xA4,0x43,0x9D,0xB6,0xA4,0x39,0xF2,0x36,0x57,0x5E,0x1D,0x96,0xC8,0x47,0x43,0x75,0x73,0x58,0x32,0x2D,0x2D,0xD5,0x5E,0xFF,0x0F};
const uint8_t spGUST[] PROGMEM = {0x0A,0x28,0x30,0x6C,0x74,0xDD,0x8C,0x93,0x71,0x9B,0x55,0x55,0x5B,0x26,0x6A,0x6B,0x56,0x95,0x63,0xBA,0x59,0x2D,0x5E,0x55,0x0E,0xED,0x6E,0xB9,0x7A,0x54,0x29,0x8E,0x85,0xD6,0xA2,0xD1,0xA4,0xD8,0x16,0x56,0x8B,0x19,0x90,0x8D,0xB8,0x02,0x9E,0x32,0xD3,0x80,0x02,0xBE,0xB3,0xD0,0x80,0x01,0xBE,0x37,0x55,0xC0,0xCF,0x6E,0x04,0xF8,0x33,0x15,0x81,0x53,0x94,0xAA,0x50,0x0D,0x30,0xC0,0x90,0x6E,0x02,0xD8,0x5C,0x0D,0x81,0x53,0x94,0xAA,0x50,0x8D,0xFF,0x07};
const uint8_t spEAST[] PROGMEM = {0xAD,0x9A,0xD1,0x10,0xAB,0xE7,0x8C,0x62,0x25,0x43,0x8C,0x5E,0x32,0xF2,0x99,0x04,0xA9,0x66,0xC9,0xC8,0x67,0x62,0xE4,0xEE,0x25,0xA3,0x98,0x59,0x90,0xB2,0xE7,0x8C,0x72,0x46,0x01,0xA9,0x9E,0x3D,0xFA,0x99,0x18,0xB5,0x7A,0x76,0x9B,0x87,0x25,0xF4,0xE9,0x59,0x65,0xED,0x8A,0xB0,0xAB,0x56,0x0A,0xE0,0x0F,0x13,0x03,0xFC,0xE8,0x66,0x80,0x9F,0xD3,0x0C,0xF0,0x67,0x99,0x05,0x0C,0xF0,0x93,0xBB,0x02,0x7E,0xA9,0x44,0xE0,0x14,0xA5,0x2A,0x54,0x03,0x0C,0x30,0xA4,0x9B,0x02,0x36,0x57,0x43,0xE0,0x14,0xA5,0x2A,0x54,0xE3,0xFF,0x01};
const uint8_t spWEST[] PROGMEM = {0x6C,0x65,0x7E,0xD3,0xCD,0x1C,0x8B,0x83,0xBA,0x4B,0x37,0xB3,0xC3,0x0E,0x56,0x36,0xD9,0xDD,0x61,0xD8,0x75,0x9C,0x34,0xA1,0xAE,0x6B,0x49,0x72,0xDC,0x83,0xD6,0xAE,0xAE,0xDA,0xD6,0x70,0x7E,0xB3,0xBA,0xEA,0x5C,0xCB,0xE3,0xCE,0x1A,0x9A,0x6B,0xF1,0xB0,0xC7,0x6B,0x6E,0xBA,0x39,0xD2,0x5E,0xB5,0xB3,0xDA,0xE4,0xF4,0x9C,0xED,0xDE,0x96,0xC3,0x83,0x22,0xB1,0x01,0x9E,0x71,0x55,0xC0,0x4F,0x29,0x06,0xF8,0xAD,0xD4,0x02,0x01,0xF8,0x2D,0xD5,0x01,0xBF,0x94,0x19,0xE0,0xE7,0x32,0x04,0x4E,0x51,0xAA,0x42,0x35,0x00,0x14,0x30,0xA4,0x1B,0x03,0x36,0x57,0xFB,0x7F};
const uint8_t spSOUTH[] PROGMEM = {0x0C,0x78,0xC6,0x95,0x01,0x3F,0xA5,0x28,0xE0,0xB7,0x52,0x0B,0x04,0xE0,0xB7,0x54,0x07,0xFC,0x52,0x66,0x80,0x9F,0xCB,0x4E,0x56,0xE5,0x24,0xA7,0xB6,0x3D,0x45,0x15,0x53,0x5A,0xBA,0xF5,0x54,0xD9,0x6D,0x58,0xEA,0xEA,0x55,0xA7,0xB8,0x6E,0xE5,0xAB,0xC7,0x98,0xEC,0x85,0x94,0xAD,0x6E,0x4B,0xB4,0x97,0x52,0xB6,0x2A,0x6C,0x31,0x6C,0x98,0xDB,0x46,0xF3,0xF8,0xB2,0x69,0xE6,0x1B,0xCD,0xE3,0x6A,0xBB,0xA9,0x2F,0x12,0xAF,0x4B,0xE3,0xC1,0xDE,0x89,0x01,0x43,0x54,0x72,0x80,0x03,0x14,0xA0,0xC0,0xFF,0x03};
const uint8_t spNORTH[] PROGMEM = {0x6E,0x4A,0x9C,0x62,0x4A,0xEB,0x84,0xA5,0x08,0xD2,0x2E,0x69,0x92,0x96,0xAA,0x48,0x33,0xA5,0x69,0x9A,0x8B,0x24,0x8F,0x90,0xA6,0x63,0xAA,0xD6,0x42,0x9C,0xD7,0xAC,0x3E,0x1B,0xCB,0x52,0x5A,0xB2,0xDA,0xE8,0x3A,0xC3,0x68,0xCD,0xAA,0x42,0xDE,0xF0,0xE0,0x2C,0xAB,0x08,0x6D,0x35,0x83,0xB3,0x8C,0x32,0xD4,0xE1,0x2A,0xEA,0x33,0x86,0xD8,0x9B,0x3A,0x69,0xCF,0x58,0x73,0x6E,0xEA,0xA2,0xDC,0xE3,0xCC,0xD5,0x78,0x52,0x73,0xB5,0x33,0x37,0x93,0x48,0xD9,0x14,0xAE,0x52,0x5C,0x35,0x74,0x12,0x03,0x86,0xA8,0xE4,0x00,0x07,0x08,0x30,0xD4,0x04,0x01,0x1A,0x1F,0xFB,0x7F};
uint8_t spNORTHEAST[] PROGMEM = {0x66,0x4E,0x92,0xBD,0x43,0x67,0xBB,0x35,0x4A,0xAA,0xF4,0x68,0x1C,0xD6,0xAC,0xB0,0x32,0x2C,0x71,0x59,0xB2,0x62,0x0B,0xB7,0xA6,0x63,0x4C,0x3A,0x2C,0x43,0x96,0xAE,0x21,0xE9,0x8A,0x0A,0x4E,0xBA,0x9A,0xE8,0xD6,0x33,0x25,0xDE,0xA8,0x62,0x6C,0xED,0xE2,0x78,0x2B,0x4D,0x61,0xB8,0x06,0xBB,0x8C,0x38,0x35,0x95,0x31,0x59,0xD9,0x92,0x32,0x85,0x8B,0xB5,0x75,0x2A,0xB6,0x5C,0x51,0x65,0x25,0x0C,0x18,0x6A,0x82,0x01,0xDD,0xAC,0xA6,0x78,0xEB,0x35,0x53,0x4C,0xBD,0xE2,0x61,0x1C,0xCD,0x6C,0xC9,0x48,0x86,0x31,0xE4,0x8E,0x27,0x2D,0x9D,0xCE,0x81,0x3A,0x1F,0xB7,0x6C,0xA6,0x00,0xAC,0x5A,0xDC,0xFA,0xE9,0x1D,0xA8,0x6B,0x76,0x99,0x67,0x51,0xE0,0xA8,0xD9,0x61,0x9D,0xD9,0x80,0xAA,0x1E,0x9B,0x6D,0x54,0x26,0xF6,0x5A,0xA2,0xF6,0xA1,0x8D,0xD4,0xBC,0xB5,0x01,0x9E,0x71,0x55,0xC0,0x4F,0x29,0x06,0xF8,0xAD,0xD4,0x02,0x01,0xF8,0x2D,0xD5,0x01,0xBF,0x94,0x19,0xE0,0xE7,0x32,0x04,0x4E,0x51,0xAA,0x42,0x35,0x00,0x40,0x01,0x4F,0xA9,0x31,0x60,0x73,0xB5,0xFF,0x07};
const uint8_t spNORTHWEST[] PROGMEM = {0x2A,0x4D,0x9C,0x7D,0x4A,0xE2,0x84,0x35,0x49,0xCA,0x34,0xAB,0xDD,0xD6,0x6A,0xC5,0xD4,0xA5,0xC9,0x18,0x8B,0x4E,0x57,0xD7,0xAE,0x6B,0x48,0x7A,0xD2,0x92,0xBB,0xAE,0x2E,0x9A,0x4D,0x2B,0xF1,0xB6,0xEA,0x64,0xCE,0xB5,0xC5,0xEF,0x2A,0x53,0x5C,0xAE,0xD4,0x5C,0xAB,0xCA,0x35,0xA9,0x42,0x5B,0x29,0x60,0x88,0x4A,0x05,0x0C,0x35,0x21,0x80,0x6E,0x56,0x5D,0xEB,0xD4,0xB9,0x26,0xA7,0x76,0x9D,0x51,0x5F,0x1C,0x9C,0xA7,0x75,0x51,0x5E,0x71,0x52,0xDF,0x55,0x67,0x75,0x2E,0x45,0x9B,0x57,0x5D,0xEC,0x88,0x95,0xBE,0x5E,0x5D,0xB1,0xA1,0x6D,0x71,0x7B,0xAD,0xD5,0x87,0x96,0xE6,0xED,0x75,0x54,0x1B,0x5A,0x16,0xAB,0xDB,0x53,0x43,0x58,0x68,0x2C,0x16,0x7F,0xF2,0x61,0xD1,0xBB,0x49,0x01,0x99,0x37,0x3A,0xE0,0xBB,0x0E,0x07,0x7C,0xB7,0xE5,0x80,0xD7,0x3B,0x1D,0xF0,0xCA,0x24,0x02,0xA7,0x28,0x55,0xA1,0x1A,0x00,0x0A,0x18,0xD2,0x8D,0x01,0x9B,0xAB,0x21,0x70,0x8A,0x52,0x15,0xAA,0xF1,0xFF};
const uint8_t spSOUTHEAST[] PROGMEM = {0x0C,0x78,0xC6,0x95,0x01,0x3F,0xA5,0x28,0xE0,0xB7,0x52,0x0B,0x04,0xE0,0xB7,0x54,0x07,0xFC,0x52,0x66,0x80,0x9F,0xCB,0x56,0x5D,0xF5,0x84,0xA5,0xAE,0x59,0x75,0x36,0x13,0x11,0xB6,0x7A,0x95,0xC9,0x6E,0x78,0xFA,0xEA,0x95,0xC5,0xDC,0x1E,0x16,0x93,0x5B,0x1A,0x6A,0xBB,0x73,0xCC,0x4E,0x59,0x74,0x15,0x4D,0x3C,0x3B,0x54,0x5B,0x96,0x99,0x8A,0x2D,0x03,0x0C,0x51,0xE9,0x80,0x6E,0x56,0x2D,0xD0,0xA2,0xEA,0x98,0xCD,0x73,0x4E,0xCB,0x87,0x17,0x94,0xCC,0xC7,0xA5,0x18,0x4E,0x81,0xA7,0x6E,0x97,0x6A,0x5A,0x01,0xD9,0x9E,0x5D,0xDA,0xE5,0x0D,0xA8,0x7B,0x56,0x19,0x67,0x12,0xA4,0xAA,0xD9,0x65,0x1B,0x89,0x50,0xBA,0x67,0xA7,0x63,0x38,0x22,0x9D,0x5A,0x9C,0x8E,0x21,0x8D,0xD9,0xBB,0xB3,0x01,0x9E,0x71,0x55,0xC0,0x4F,0x29,0x06,0xF8,0xAD,0xD4,0x02,0x01,0xF8,0x2D,0xD5,0x01,0xBF,0x94,0x19,0xE0,0xE7,0x32,0x04,0x4E,0x51,0xAA,0x42,0x35,0x00,0xC0,0x01,0x53,0xA8,0x0B,0xE0,0xF9,0x8A,0xFF,0x07};
const uint8_t spSOUTHWEST[] PROGMEM = {0x0C,0xB8,0x5E,0x92,0x01,0xCF,0xB8,0x32,0xE0,0xA7,0x14,0x05,0xFC,0x56,0x6A,0x81,0x00,0xFC,0x96,0xEA,0x80,0x5F,0xCA,0x0C,0xF0,0x73,0xD9,0x6A,0x8B,0x19,0xF7,0xD4,0xCF,0xAB,0xCD,0x66,0x23,0x42,0x37,0xAF,0x3A,0xAB,0x4B,0x4B,0xEB,0xBC,0xAA,0x18,0x37,0xDC,0x6C,0x55,0x2B,0x42,0xDA,0x08,0x91,0x59,0xA9,0x88,0x7A,0xAC,0x89,0x5A,0xAA,0x61,0x50,0x37,0x53,0x95,0xA2,0x80,0x21,0x2A,0x05,0xD0,0xCD,0x6A,0x68,0xAB,0x0E,0x53,0x33,0xC7,0xAE,0x0B,0x6A,0x8A,0x9D,0x52,0x97,0x2E,0xE8,0x6B,0x32,0xEE,0xBA,0xAA,0xC2,0xBA,0xB4,0xA8,0xEB,0xAA,0xAB,0x1C,0x97,0xE6,0x2F,0xAB,0x69,0xAA,0x34,0x5A,0x5E,0xAF,0xA9,0x9A,0x92,0x4C,0x7F,0xB4,0xF6,0x6A,0x4B,0x2A,0xF2,0x56,0x3B,0x4B,0x48,0x49,0xAF,0xD9,0xE9,0x29,0x3E,0xA4,0xF8,0x16,0x1B,0xE0,0x19,0x57,0x05,0xFC,0x94,0x62,0x80,0xDF,0x4A,0x2D,0x10,0x80,0xDF,0x52,0x1D,0xF0,0x4B,0x99,0x01,0x7E,0x2E,0x43,0xE0,0x14,0xA5,0x2A,0x54,0x03,0x00,0x1C,0x30,0x85,0xBA,0x00,0x9E,0xAF,0xF8,0x7F};
const uint8_t spHAIL[] PROGMEM = {0x08,0x28,0x5A,0x1C,0x01,0x45,0x7B,0x94,0x62,0x04,0x21,0xB3,0x8C,0xB3,0xF2,0xAA,0x59,0x3B,0xDB,0xF2,0x4A,0x9B,0x27,0x89,0x9A,0x3A,0x2B,0xED,0x41,0xD8,0xBA,0x97,0xAC,0x74,0x44,0x25,0xCD,0x5E,0xBD,0xB2,0x11,0x95,0xB4,0x6A,0xCD,0xCA,0x47,0x74,0x92,0x8C,0x3B,0x3B,0x5F,0xD5,0x30,0x4E,0x3A,0xF1,0x78,0xF5,0x5D,0x05,0x6B,0xDB,0xEB,0xB1,0x36,0x5E,0xE6,0x25,0x9F,0xC7,0x9E,0x74,0x47,0xBA,0x6C,0x2E,0x47,0xF0,0x1B,0xEA,0xB6,0xB9,0x9C,0x41,0x6F,0x96,0x72,0x9F,0x72,0x25,0x3E,0x55,0x46,0xDE,0xD2,0x1D,0xE5,0x55,0x08,0x67,0xCB,0xF7,0xFF,0x03};
const uint8_t spTORNADO[] PROGMEM = {0x01,0xD8,0x5C,0xCD,0x03,0x25,0xCF,0x6E,0x54,0xC5,0x9D,0xB4,0x22,0x4C,0x17,0x2B,0x69,0xB5,0xAA,0x94,0x5B,0x6D,0x28,0xEB,0x6A,0x72,0x6C,0x93,0xE1,0x6C,0xAB,0xAD,0xC5,0xDC,0xD4,0x93,0xAD,0xBE,0x59,0x91,0x32,0x89,0xB7,0xBA,0x1E,0x59,0x4B,0xD5,0xDE,0xEA,0x86,0x2B,0xE1,0xD0,0xD5,0xAB,0x9D,0xAE,0x95,0x52,0x37,0xAF,0x76,0xF9,0x51,0x4C,0x5D,0xB3,0x9A,0xE5,0x8A,0xB1,0x6C,0xF5,0x6A,0xA6,0x2F,0x41,0x97,0x2E,0xA1,0xCD,0x5C,0x24,0xD3,0xDA,0xAC,0x69,0xC8,0x60,0x4D,0xFD,0xBC,0xE6,0x22,0x4A,0xAC,0x7C,0xF3,0x58,0x63,0x0C,0xCE,0x88,0xD6,0x6D,0x8E,0x29,0x25,0xD2,0x37,0x96,0x2D,0x74,0xB3,0xB0,0x58,0x55,0xF6,0x58,0x4B,0x2C,0x6C,0x57,0x39,0x42,0x2B,0xF6,0x88,0x3D,0xE9,0xF4,0x65,0x38,0x25,0xF7,0x86,0xCB,0xB5,0x21,0xCB,0xEA,0xAB,0xEE,0xE0,0xAB,0x93,0xCC,0xE9,0xFF,0x03};
uint8_t spWIND[] PROGMEM = {0x22,0xA7,0x75,0xCD,0xC5,0x6D,0x9B,0x85,0xF5,0x74,0x4D,0xB7,0xEC,0x66,0x5E,0x2A,0x34,0x3C,0x56,0x99,0x4D,0xED,0x60,0x95,0x46,0x6B,0x48,0xAA,0xDD,0x0C,0x57,0xAF,0xBA,0x59,0x17,0x0B,0x5A,0xB3,0xCA,0x9E,0x9C,0x4D,0xF5,0xC9,0x2A,0x9A,0x77,0x71,0x8F,0xD9,0xAB,0x68,0x21,0xC4,0xDC,0x67,0xAF,0xB6,0x1A,0xB7,0x70,0x9F,0x3C,0xFA,0xA6,0xD9,0x52,0xCC,0x69,0x5B,0x9A,0x60,0x69,0x35,0x7B,0x65,0x6D,0x92,0x65,0x54,0xEC,0xA7,0xBD,0x69,0xD4,0x31,0xB3,0x17,0xCE,0xAA,0x30,0x92,0x32,0x89,0xB9,0xB2,0xC4,0x09,0x8B,0x54,0xEC,0x16,0x22,0x73,0x3D,0x13,0x93,0xDB,0x91,0xF4,0xC9,0x48,0x45,0x6F,0x06,0x14,0x18,0xD6,0xCE,0x1E,0x53,0x44,0x6C,0xCB,0xFF,0x03};
const uint8_t spWEATHER[] PROGMEM = {0x6A,0xA5,0xFE,0xB2,0x48,0x95,0xE8,0x55,0xAF,0x7C,0x65,0x1B,0x73,0x37,0xE1,0xAA,0x58,0x6C,0xBC,0xAC,0xAB,0xBA,0x1D,0xB3,0xAA,0x7C,0x4E,0x26,0xAB,0xDB,0x10,0xD4,0xB8,0x07,0x6D,0x5D,0x4D,0x71,0x29,0xE1,0xFC,0x78,0xD5,0x35,0xBA,0xA6,0xF8,0x92,0x55,0x94,0x10,0x12,0x52,0x4B,0x5A,0x9E,0x83,0xBA,0xF2,0xC6,0x71,0x45,0xB6,0x2E,0x8E,0xDD,0x28,0xF4,0x59,0x87,0x24,0x55,0xC3,0x34,0xC4,0x60,0x92,0x36,0x95,0xDB,0x50,0x9C,0x9A,0x4B,0x3E,0x6E,0x73,0x31,0xC5,0x5A,0xB6,0xB9,0xAD,0xD5,0x35,0xC9,0x48,0x9F,0x72,0xD5,0xB0,0xC8,0xCB,0x79,0xD2,0x55,0x6A,0x41,0x2C,0xED,0x4D,0x7F,0x99,0x06,0x9D,0xBA,0x35,0xFD,0x65,0x27,0x8C,0x59,0xD6,0xFF,0x07};
const uint8_t spSHOWERS[] PROGMEM = {0x0C,0x38,0x71,0x54,0x01,0xBB,0x6D,0x69,0xC0,0x02,0x1E,0xF0,0x40,0x04,0x34,0xB0,0x8A,0x1A,0x4A,0x2D,0x75,0xCB,0x2A,0x72,0x68,0xF3,0xD6,0xCD,0x2B,0x4F,0x61,0xDD,0x5B,0x57,0x8F,0x2C,0xD6,0x71,0x4F,0x59,0x5D,0x72,0x3F,0x3B,0x32,0xB8,0x69,0x2A,0xED,0x89,0x28,0x93,0xB4,0xA1,0xF7,0x6D,0xA4,0x0A,0x7A,0xA7,0x31,0x9A,0x57,0x3E,0xF4,0x93,0xD6,0xEC,0x8E,0xE4,0x30,0x4F,0x3A,0x73,0x1E,0xF0,0xC5,0x3E,0xE1,0x28,0xAD,0xC1,0x86,0xF3,0xB8,0xA3,0x4C,0x83,0x4A,0xE9,0xEB,0xCE,0x1C,0x02,0x6D,0x22,0xAB,0x39,0x4B,0x08,0xD4,0xCE,0xFC,0xE6,0xCA,0xDE,0x30,0xAA,0xFA,0xB9,0xEB,0x92,0x10,0x71,0xC9,0x1B,0xEE,0x8B,0xD8,0xCD,0xC3,0x4D,0xBC,0xDD,0xF3,0x7D,0x84,0x09,0x33,0x53,0xC0,0xF7,0x48,0x02,0xD8,0x90,0xF3,0xFF,0x01};
const uint8_t spSLEET[] PROGMEM = {0x06,0x78,0xC6,0x55,0x01,0x3F,0xA5,0x18,0xE0,0xB7,0x52,0x0B,0x04,0xE0,0xB7,0x54,0x07,0xFC,0x52,0x66,0x80,0x9F,0xCB,0xC6,0xD0,0x70,0x44,0xA8,0x78,0x5D,0x45,0xC7,0xDE,0x2E,0x94,0x77,0x15,0x93,0x68,0x99,0x72,0xD6,0x95,0x35,0x6D,0xAA,0x66,0x8F,0x57,0x3A,0xA2,0xB0,0x98,0x3F,0x59,0xC5,0x08,0x4C,0x56,0xBD,0xB8,0x35,0xD3,0x29,0x70,0xF7,0xE3,0x34,0xCE,0xA8,0xC0,0x5D,0x8F,0xDD,0x32,0x3C,0xA1,0x6D,0x5F,0x42,0xE0,0x14,0xA5,0x2A,0x54,0x03,0x00,0x14,0x30,0xA4,0x1B,0x03,0x36,0x57,0x43,0xE0,0x14,0xA5,0x2A,0x54,0xE3,0xFF,0x01};
const uint8_t spSMOKE[] PROGMEM = {0x08,0xE8,0x58,0x94,0x01,0xDF,0x30,0x33,0xE0,0x7B,0x65,0x03,0xFC,0x12,0xEA,0x80,0x5F,0x8B,0x1D,0xF0,0x7B,0xA8,0x03,0x5E,0x53,0x56,0x40,0xA1,0x1C,0xAE,0xF1,0x2C,0xA2,0x52,0xDD,0xA4,0x3A,0x2B,0xCC,0x71,0x89,0x37,0xEA,0x2C,0x33,0x5D,0xA1,0xCD,0x2A,0x92,0xEC,0x56,0xE7,0x36,0x23,0x0F,0x7E,0x4B,0x4C,0xD6,0x8C,0x3C,0xDA,0x69,0x35,0x5E,0xDD,0xEA,0x68,0xB7,0x55,0xA9,0x6F,0x19,0x82,0xBD,0x14,0x95,0xBE,0x61,0xF1,0x76,0xC3,0x85,0xFB,0x88,0x25,0xE8,0x29,0x63,0x73,0x87,0xC0,0x29,0x4A,0x55,0xA8,0x06,0x00,0x08,0xA0,0x94,0x62,0x0C,0x20,0xA0,0xA4,0x20,0x04,0x94,0xE2,0xF6,0xFF};
const uint8_t spSTORM[] PROGMEM = {0x0C,0xF8,0x59,0x51,0x01,0x3F,0x07,0x19,0xE0,0xB7,0x91,0x00,0xFC,0x3E,0x9C,0x80,0x5F,0xC3,0x0C,0xF0,0x57,0x0B,0x02,0xA7,0x28,0x55,0xA1,0x1A,0xC0,0x80,0xCD,0xD5,0x5A,0x5C,0x79,0x16,0x07,0x67,0x1B,0x45,0x92,0x5D,0x96,0xD8,0x77,0xE4,0x3E,0x6E,0x99,0x63,0x97,0x96,0xF9,0xB8,0x69,0xC6,0x4D,0x5A,0x16,0xDA,0x64,0x88,0x26,0x69,0x65,0x28,0x13,0xE6,0xA1,0xB6,0xB5,0xB1,0xB4,0x5B,0xA4,0xBA,0xD6,0xA5,0x9C,0x1A,0x2D,0x79,0xDA,0x90,0x63,0x8B,0x0D,0xE7,0x29,0x53,0x4E,0x2D,0x36,0x94,0xB7,0xCC,0xD9,0x15,0x75,0xB1,0xDD,0xB2,0x16,0xDD,0x98,0x45,0xE6,0xCA,0x56,0x45,0x8B,0xB9,0x4A,0x2D,0xFB,0x20,0xED,0xEA,0x64,0xB5,0x9C,0x4D,0x96,0xA4,0x70,0xD4,0x72,0x75,0x15,0x92,0x2A,0x56,0xCB,0xDD,0x94,0x6B,0x89,0x45,0xFD,0x7F};
const uint8_t spSNOW[] PROGMEM = {0x04,0x78,0xC6,0x95,0x01,0x3F,0xA5,0x28,0xE0,0xB7,0x52,0x0D,0x18,0xE0,0xB7,0x54,0x05,0xFC,0x52,0x56,0xAA,0xAA,0x30,0x2B,0xC5,0x6E,0xAD,0x56,0xD1,0x95,0xB9,0x26,0xAD,0x59,0x79,0x95,0x91,0x52,0xB2,0x76,0x65,0x55,0x54,0x73,0xC9,0xD6,0x95,0x15,0x51,0x2D,0xC9,0x6B,0x56,0x99,0xD4,0xB4,0xA4,0x6C,0x19,0x43,0xB4,0x5B,0x12,0xB2,0xA5,0x0C,0x3E,0x6D,0xAA,0xDB,0x9E,0xB2,0xFA,0xB0,0x11,0x26,0x5B,0xD2,0xEE,0xD2,0x44,0x88,0xAE,0x4E,0xB7,0x2B,0x1D,0xC9,0xBA,0xC5,0xFD,0xAE,0x4C,0xAA,0x58,0x37,0xF7,0xBB,0x3A,0x6E,0xA2,0x59,0xDC,0xA3,0xD3,0x86,0x8B,0xF4,0x75,0x8F,0x8F,0x95,0x41,0xDA,0xC7,0xDD,0xD1,0x55,0x05,0x86,0xEB,0xFF,0x07};
const uint8_t spSAND[] PROGMEM = {0x0C,0xF8,0x55,0x45,0x01,0xBF,0x1A,0x1B,0xE0,0x47,0x23,0x07,0xFC,0x64,0xE2,0x80,0x5F,0x5C,0x02,0xF0,0x63,0xBA,0x01,0x7E,0x4A,0x5C,0x49,0x53,0xA9,0x6A,0xFE,0x78,0xD5,0xCD,0x96,0x68,0xC6,0xE3,0x55,0x15,0xE7,0x9A,0x55,0x93,0x57,0x55,0xBD,0x69,0x67,0xD5,0x5A,0x65,0xCB,0x62,0xE5,0x53,0x7B,0x95,0x35,0xA8,0x75,0x56,0xA5,0x55,0x55,0x67,0xDA,0x99,0x95,0x56,0x5F,0xAD,0x4B,0x67,0x4C,0x5A,0x43,0xD3,0xC5,0x99,0x31,0x71,0xAD,0x8D,0xB5,0x64,0xF9,0xCC,0xB6,0x35,0x3A,0x1A,0x61,0x8B,0xD2,0xD1,0x34,0x6B,0xAB,0xDB,0x09,0x67,0x93,0x22,0xAB,0x66,0x2F,0x9C,0x55,0x61,0x24,0x65,0x12,0x73,0x65,0x89,0x13,0x16,0xA9,0xD8,0x2D,0x44,0xE6,0x7A,0x26,0x26,0xB7,0x23,0xE9,0x93,0x91,0x4A,0x00,0x05,0x86,0xA5,0xBD,0x3B,0x23,0x17,0xDB,0xF2,0xFF};
const uint8_t spPELLETS[] PROGMEM = {0x06,0xA8,0xDC,0x55,0x01,0xC5,0x2A,0xB7,0xAC,0x58,0x53,0xB3,0x48,0x31,0xF2,0x12,0xCD,0xCD,0xAB,0xF6,0xCA,0x8B,0x2B,0x37,0xB7,0xC7,0xAB,0xC8,0x72,0xD3,0x52,0x17,0x8F,0xA2,0xE0,0x1D,0x0E,0x6D,0x3D,0xAA,0x82,0x77,0x28,0x3C,0xC9,0xA8,0xB3,0xB8,0xB0,0xB0,0x55,0x63,0x6A,0x7C,0x5D,0xC3,0x37,0x8D,0xB5,0xC8,0x91,0x88,0x7A,0x55,0x8E,0x62,0x8B,0x32,0x66,0x16,0x02,0xA7,0x28,0x55,0xA1,0x1A,0x00,0x04,0x18,0x54,0x8C,0x01,0x3F,0x28,0x1A,0xE0,0x1B,0x57,0x05,0xFC,0x94,0xC2,0x80,0xDF,0x4A,0x39,0xF0,0xFF};
const uint8_t spRAIN[] PROGMEM = {0x62,0xE1,0x7E,0x5D,0x2D,0xEC,0x88,0x49,0xB4,0x64,0x4F,0x77,0x6A,0x26,0xDB,0xD8,0xA3,0x54,0x6B,0xEB,0x72,0x97,0xD4,0xE2,0xAC,0xAB,0x29,0x49,0xDD,0xD2,0xD6,0xAC,0xBA,0x3A,0xE7,0x6C,0x7F,0xB4,0xAA,0x16,0x8C,0x62,0x63,0xD2,0xA8,0x86,0x0D,0xD2,0x8B,0x4A,0xA3,0x19,0x3E,0x48,0x2F,0x2B,0xCD,0xA6,0xF5,0xC3,0x39,0xD9,0x45,0xA8,0x32,0x0D,0x6B,0xE4,0x67,0x81,0xEB,0x54,0xD6,0xAA,0x45,0x6B,0x2D,0x70,0x59,0x9B,0xC6,0x2A,0x57,0x25,0x69,0x2F,0x8A,0x32,0x2D,0x14,0xA5,0xAB,0x69,0xF6,0x52,0xB7,0x93,0xAF,0xF4,0x34,0xAD,0x96,0xE6,0x89,0xC2,0xD3,0x44,0xAA,0xB5,0x37,0xFC,0x7F};
const uint8_t spICE[] PROGMEM = {0xA9,0x89,0xE1,0x3C,0x3C,0x66,0x8F,0x31,0xEB,0x0B,0x2B,0x5F,0xBD,0xA6,0x62,0xC6,0xA2,0xEC,0xF1,0x6A,0xAB,0x6B,0xAE,0xF6,0x47,0xAB,0x6A,0x31,0xB0,0x3C,0x17,0x8F,0xAE,0x67,0x43,0x8B,0x5A,0x5C,0xC6,0x9E,0x18,0x2D,0x6B,0x76,0x58,0x5A,0x40,0xF1,0x98,0xC6,0x6A,0x6F,0xD2,0x20,0xBD,0x1B,0x1B,0xE0,0x49,0x13,0x03,0x7C,0x13,0x66,0x80,0x1F,0x3D,0x0C,0xF0,0x53,0x84,0x02,0x7E,0x77,0x57,0xC0,0x0F,0x66,0x0A,0xF8,0x29,0x44,0x01,0xBF,0x16,0x0B,0xE0,0x8F,0x34,0x01,0x7C,0x6B,0xF9,0xFF};
const uint8_t spHEAT[] PROGMEM = {0x04,0x18,0xB6,0x82,0x00,0xD3,0x57,0x50,0x40,0x00,0xD3,0xA5,0x8F,0x62,0xC6,0x20,0x48,0x7F,0x3A,0xCA,0x19,0x83,0x20,0xF3,0x49,0x6F,0x46,0x3F,0x83,0x02,0x57,0xCF,0x6E,0xEB,0x74,0x06,0xDC,0x7D,0x2B,0x5D,0xD3,0x28,0xC8,0xF4,0x6C,0x75,0x75,0x29,0x64,0x1D,0x2B,0x11,0x38,0x45,0xA9,0x0A,0xD5,0x00,0x00,0x03,0x4C,0xA1,0xEE,0x80,0xE7,0x2B,0x04,0x70,0x63,0xE6,0xFF,0x03};
const uint8_t spFOG[] PROGMEM = {0x08,0xE8,0x26,0x15,0x01,0x5D,0xBB,0x22,0x60,0xEA,0x34,0x06,0x0C,0x9B,0xCE,0x80,0x2C,0xD3,0x46,0x96,0x64,0xAF,0x06,0x65,0x1B,0x45,0xB4,0x33,0x1A,0xD4,0x6D,0x94,0xD1,0xEC,0x68,0x70,0xD7,0x51,0x45,0xB3,0xAD,0xC1,0x7D,0x47,0x13,0xED,0xB6,0x86,0xF4,0x19,0x43,0xB4,0xDB,0x1E,0xDC,0x67,0x8C,0xD1,0x6E,0xA9,0x6B,0x9F,0xB6,0x45,0xBF,0xA9,0x61,0x7D,0xDA,0x99,0xF4,0x96,0x86,0xE7,0x6D,0x4F,0x32,0xA7,0x16,0xE2,0xC7,0x9D,0x71,0x26,0x99,0xB3,0x67,0x77,0x0A,0x35,0x1E,0x91,0xB1,0xC2,0x19,0x48,0x7A,0x45,0x26,0x12,0x40,0xC9,0x2D,0x69,0xEF,0x7A,0x54,0xC5,0x5D,0xFF,0x3F};
const uint8_t spHEAVY[] PROGMEM = {0x08,0xC8,0x46,0x13,0x03,0xAB,0xAE,0x5E,0xCC,0xB3,0x6B,0xAF,0xB6,0x99,0x10,0xAB,0xBC,0xB3,0xEA,0xE6,0x52,0x34,0xE2,0xF6,0xAA,0x8A,0x73,0x55,0xD7,0x35,0xA6,0xF1,0xDA,0x55,0xC3,0x56,0x85,0x76,0xC8,0x10,0x63,0xB3,0x33,0xB2,0x16,0x54,0xC4,0x6D,0xF1,0xCA,0x7A,0x50,0x96,0xC8,0x25,0xA3,0xE8,0x41,0xD1,0x32,0x1F,0xCF,0xA2,0x56,0xFF,0x0F};
const uint8_t spLAND[] PROGMEM = {0x6E,0x5A,0x88,0xA6,0x58,0xD6,0xA6,0x6D,0x00,0x5B,0x23,0x6F,0x56,0xD6,0x0E,0x6C,0x83,0xAD,0x5D,0x59,0x06,0xB0,0x75,0xB2,0xF6,0x6B,0xC8,0x7A,0xCA,0x54,0x56,0xAF,0xA1,0xB3,0x2E,0x4B,0xDD,0xBC,0x86,0x21,0x3B,0x34,0x6D,0xCD,0xEA,0x86,0x6A,0xD5,0xB2,0xD5,0xAB,0x19,0xA6,0xC5,0xD2,0x56,0xAF,0xB2,0x9B,0xE2,0xAC,0x58,0xB4,0x8A,0xE6,0x5C,0xDA,0x6B,0xF6,0xCA,0x4B,0x34,0x4F,0x9B,0xDA,0x2B,0xCD,0x3E,0xAC,0x65,0xA3,0xB4,0xA4,0x19,0x2A,0x37,0x57,0xD5,0xE2,0xAE,0x29,0x52,0x53,0x73,0x49,0x9A,0xC2,0x6A,0x73,0xB5,0x08,0x28,0x30,0xAC,0xE5,0x55,0x84,0x84,0xE6,0xA2,0xFF,0x07};
const uint8_t spTHIN[] PROGMEM = {0x08,0x48,0xCC,0x0C,0x01,0x5D,0xA9,0x21,0x60,0x2A,0x33,0x04,0x4C,0x65,0x4A,0x80,0xE9,0x52,0x57,0xDD,0x43,0x88,0xA8,0x3D,0x5E,0x55,0x0F,0xC1,0xEA,0xFE,0x68,0x95,0xCD,0x99,0x78,0xE4,0xA4,0x55,0x14,0x6B,0x1A,0x56,0x93,0x57,0xD1,0x2D,0x79,0xB8,0x29,0x5D,0x45,0x37,0x14,0x1E,0xEE,0x64,0x55,0x4D,0x85,0x86,0xFA,0xEC,0xFF,0x07};
const uint8_t spOF[] PROGMEM = {0x65,0x4A,0xEA,0x3A,0x5C,0xB2,0xCE,0x6E,0x57,0xA7,0x48,0xE6,0xD2,0x5D,0xBB,0xEC,0x62,0x17,0xBB,0xDE,0x7D,0x9F,0xDA,0x5C,0x5C,0x7A,0xAA,0xB5,0x6E,0xCB,0xD0,0x0E,0xAD,0x6E,0xAF,0xEE,0xF9,0x88,0x67,0xBC,0xDC,0x3D,0xAC,0x60,0xB8,0x45,0xF3,0xB7,0xBF,0xC3,0xDD,0xA2,0xBB,0xAB,0xCD,0x89,0x8F,0x7F,0xFE,0x1F};
const uint8_t spAERIAL[] PROGMEM = {0xE2,0x8A,0xCC,0xD5,0xDC,0xDD,0x9A,0xAB,0x09,0x13,0x55,0x53,0xE2,0x8E,0xA6,0x4C,0xC4,0xC4,0xC9,0xDA,0x6A,0x72,0x13,0x97,0x36,0xAB,0xAF,0x3E,0x8C,0x4B,0xB7,0xAC,0x36,0x87,0x90,0x48,0xDF,0xB2,0xEA,0x94,0x4D,0xAB,0x6C,0xD3,0xAA,0x63,0x13,0x6F,0xCB,0xDC,0xAD,0x4A,0x9D,0x3A,0x3C,0x7C,0xB7,0x2A,0x0F,0x6A,0x2E,0xF7,0x3D,0xDA,0xD2,0xD9,0x43,0x23,0xF7,0x1A,0x6A,0x08,0xF4,0xB6,0xDD,0x63,0x6C,0x21,0xC1,0xCA,0x37,0xAF,0xB9,0x9B,0x22,0x49,0xDD,0xB2,0xB6,0x6E,0x46,0x29,0x74,0xF3,0x38,0x9A,0x2A,0x97,0x90,0x2E,0xEE,0x08,0xBA,0x4C,0xCC,0xD2,0x20,0x00,0xBC,0x32,0x02,0x58,0x9D,0x9A,0xCE,0x60,0xA6,0x4D,0xA4,0x5B,0xBA,0x83,0x9D,0x56,0x93,0xAC,0xE1,0xF6,0x71,0x8B,0xD5,0xBB,0xA6,0xD7,0xA7,0x29,0x63,0xC9,0x12,0x7E,0x1F,0x36,0x4D,0xB8,0xAD,0xFB,0xBD,0xB9,0x66,0xD1,0x74,0xEE,0x0F,0x7A,0x5A,0x9C,0x3B,0xFF,0x3F};
const uint8_t spOBSCURED[] PROGMEM = {0xA3,0xAF,0xDA,0xB4,0x42,0x57,0x8F,0x21,0xB9,0x34,0x35,0x6B,0x2D,0x06,0xEE,0x46,0x2D,0x32,0x16,0x1B,0x99,0x6B,0xB7,0xA8,0x98,0x69,0x1E,0xDA,0xD4,0x45,0xD4,0x3A,0xE0,0xA6,0x08,0x07,0xDC,0x30,0x15,0x80,0x57,0xBC,0x10,0xB0,0xB8,0x38,0x02,0xBA,0x37,0x51,0x40,0x14,0xA2,0xA3,0xE9,0xA9,0x18,0x4A,0xBA,0x8D,0xB6,0xD9,0x60,0x5C,0xE9,0xDA,0xBA,0xAC,0x4A,0x68,0x25,0x5F,0x19,0xA3,0x2F,0x96,0xE3,0x3C,0x69,0x0A,0xD5,0x38,0x9B,0xF3,0x84,0x3D,0x34,0x95,0x09,0xE9,0x13,0xF6,0x58,0x85,0xD7,0xB4,0x4F,0xBA,0x72,0x0F,0xCA,0xE4,0xDC,0xE1,0xCD,0x31,0x49,0x87,0xFB,0x86,0x3F,0x67,0xA1,0x2C,0xE9,0x13,0xFE,0xDA,0x95,0x35,0x25,0x8B,0xFA,0x4B,0x66,0x51,0xF7,0x76,0xEC,0xCF,0x5C,0x38,0xBA,0xD4,0xB8,0x7F,0x04,0x51,0x31,0xB7,0x1D,0xFE,0x26,0x93,0x35,0x7D,0x4B,0x78,0x6B,0x32,0xD6,0x8C,0x4D,0x08,0xC8,0x1E,0xED,0xFF,0x01};
const uint8_t spBROKEN[] PROGMEM = {0x0C,0x08,0x51,0xBC,0x74,0xB1,0x49,0x72,0x8A,0xF7,0xD5,0xC5,0xAC,0xA9,0xAE,0xE9,0x56,0x9B,0xCC,0x06,0x85,0xF5,0x5D,0x6D,0x52,0x97,0x1C,0xB2,0xBB,0x75,0x51,0x4E,0x58,0xE0,0x66,0x60,0x40,0x99,0x4E,0x04,0xE0,0x3E,0x7C,0xED,0xC5,0x9B,0x7A,0xF8,0xE2,0xB5,0x77,0x19,0x26,0xA5,0x5B,0xCA,0xD5,0xA4,0x9B,0xA5,0xAC,0x4E,0x7F,0x37,0x6C,0xED,0x62,0x3D,0xFD,0xCD,0xB0,0x85,0x99,0xDD,0xF4,0x0D,0xCF,0x12,0xE6,0x51,0xCB,0x57,0x8D,0x84,0x69,0xC4,0x71,0x5F,0xAD,0x66,0x4C,0x99,0xE8,0xFF,0x01};
const uint8_t spALOFT[] PROGMEM = {0xAD,0xCE,0xE2,0xC2,0x5C,0x57,0xF7,0xB6,0xB5,0xDE,0x74,0x05,0x6B,0x93,0xD2,0x7A,0xD3,0x1D,0xE0,0x4D,0x6A,0xBB,0xDA,0xCC,0xA6,0x4B,0x25,0xC9,0x68,0xA2,0xBE,0x72,0xD1,0x35,0xA3,0x09,0xEE,0xD2,0x45,0xBB,0xAC,0x36,0xC4,0x0F,0x89,0x6C,0xBD,0xFA,0x90,0x2E,0xCC,0xBC,0xF3,0x9A,0x83,0xBF,0x30,0xF3,0xCE,0xE3,0x88,0xF1,0x5C,0x2D,0x36,0xB7,0x3B,0xDA,0x2B,0x33,0xED,0x9C,0x9E,0x50,0xC7,0x4D,0xF3,0x75,0x7A,0x52,0xEC,0x74,0xD1,0x49,0x02,0xA8,0x26,0x55,0x00,0x5D,0x87,0x32,0xA0,0x9B,0x52,0x0E,0x20,0x70,0x8A,0x52,0x15,0xAA,0x01,0xA0,0x80,0x21,0xDD,0x18,0xB0,0xB9,0x1A,0x02,0xA7,0x28,0x55,0xA1,0x1A,0xFF,0x0F};
const uint8_t spCEILING[] PROGMEM = {0x0C,0xF8,0x29,0x45,0x01,0xBF,0x95,0x5A,0x20,0x00,0xBF,0xA5,0x3A,0xE0,0x97,0xB2,0x95,0x0E,0xED,0x8A,0x61,0x6B,0x46,0x39,0x7C,0x30,0x86,0x7E,0x19,0xC5,0x88,0x4E,0x94,0xFA,0x65,0x15,0xDD,0x29,0x6B,0xEB,0xEA,0x56,0x54,0xA6,0x16,0xC5,0xAB,0x47,0x31,0xB0,0xA6,0x85,0xB6,0x59,0x79,0x53,0xCE,0x91,0x3E,0x6B,0x14,0x4D,0xA9,0x54,0x79,0xA9,0x52,0x54,0x8D,0x39,0x21,0x56,0x4B,0xD1,0x34,0x76,0xB9,0xDA,0x2D,0x79,0xD3,0x58,0xED,0x6A,0x37,0xE5,0x59,0x51,0x55,0xB0,0x13,0x91,0x31,0x57,0x61,0x6A,0x69,0x48,0xA6,0x59,0x55,0x85,0xCB,0xF9,0x7F};
const uint8_t spPARTIALLY[] PROGMEM = {0x0A,0x68,0xD2,0x88,0x01,0xD1,0x9A,0x8F,0x3C,0x94,0x76,0x77,0xEE,0xB4,0xEA,0xE8,0xCE,0xB5,0x69,0xCB,0xAA,0xB3,0x3E,0xE7,0x91,0x3E,0xAB,0x8A,0xA1,0x65,0x4A,0x36,0x97,0x2A,0x15,0x93,0xF5,0xEC,0x24,0x80,0xA0,0x84,0x13,0x30,0xC3,0x78,0x00,0x56,0x9A,0x4A,0xC0,0x8C,0x53,0x0E,0x68,0x61,0xB2,0x65,0x4D,0x9A,0x7B,0xAA,0xDA,0xD2,0x36,0x90,0xE3,0xAC,0xE9,0x46,0xD7,0xA0,0x77,0x88,0xB8,0x4B,0xDB,0x02,0xB2,0xA6,0xEA,0xBE,0x1D,0x87,0x62,0x27,0x4B,0xB2,0xB5,0x57,0x59,0xE6,0x2E,0xBB,0xC7,0x31,0x59,0x3A,0x96,0x6F,0x69,0x4F,0x17,0xC1,0xDA,0xFE,0x39,0xDD,0x3D,0x1B,0x8B,0xC7,0xAA,0x7C,0xA5,0xB3,0x47,0x61,0xB7,0x5C,0xF2,0xFF};
const uint8_t spVISIBILITY[] PROGMEM = {0xE6,0xCA,0xCA,0x8D,0x55,0x73,0x9B,0x23,0x09,0x77,0x76,0xCB,0xE2,0x8E,0x2A,0x4C,0xD5,0xD4,0xB5,0xDB,0x8B,0x50,0x35,0x15,0xDF,0x6B,0xEC,0x36,0x5C,0x95,0x5D,0xAD,0xB6,0x19,0x33,0x75,0xDD,0xB2,0xEA,0xA6,0x4C,0xDD,0xED,0xCD,0xAA,0x9B,0x72,0x75,0xF1,0xD5,0xAB,0xFE,0xCE,0xC4,0x44,0x9D,0x06,0xE0,0x0A,0xE3,0x51,0xBE,0x50,0xE9,0xCC,0x52,0x57,0x31,0x54,0xB8,0x28,0x6D,0x59,0x65,0x55,0xE6,0x6A,0xBC,0x57,0xB5,0xD4,0x87,0xBB,0x67,0x2B,0xD6,0x93,0x50,0xE6,0x9E,0xAD,0x56,0x59,0x6C,0x98,0xAA,0x6C,0x5E,0x65,0x36,0x69,0xA6,0xBE,0x79,0x15,0x8D,0x56,0xB8,0xC9,0xE6,0x52,0x75,0x10,0x2D,0x1C,0x4D,0x57,0xD5,0x70,0x87,0xAB,0x74,0x5E,0x45,0x65,0x63,0x2E,0xB6,0x69,0x55,0x55,0xB6,0x39,0x59,0x6B,0x33,0x64,0xEA,0xE6,0xA4,0xB9,0x0C,0x30,0x85,0x7A,0xCB,0x9F,0x0C,0x66,0xD5,0xDC,0x2B,0xEF,0xC1,0x48,0x2C,0x97,0xAC,0x7C,0x58,0x47,0xAA,0x58,0x3C,0xF2,0xA1,0x0C,0x69,0x72,0x71,0x2A,0xBA,0x10,0xB4,0x8D,0x99,0xAC,0x21,0xA6,0x6A,0x4C,0x6D,0xFF,0x3F};
const uint8_t spDRIZZLE[] PROGMEM = {0x69,0xDD,0x6E,0xD2,0x4D,0x48,0x97,0x6D,0xC6,0xF0,0x66,0x96,0x5D,0x86,0x62,0xC3,0x54,0x2D,0xD9,0x68,0x73,0x92,0x64,0xB7,0x74,0xAB,0x2A,0x4E,0x43,0xCD,0xB6,0xAC,0xB2,0xEA,0x54,0x35,0x7D,0xDD,0xCA,0xC6,0xDA,0xC8,0x7C,0x73,0xA9,0xBF,0x90,0x30,0x92,0xAC,0x65,0xF8,0xB7,0xD0,0x45,0x95,0x08,0x20,0x83,0xE8,0x31,0x67,0x9E,0xE1,0xAE,0x6B,0xDA,0x14,0xD5,0x46,0x98,0x6C,0x71,0x7B,0x30,0x1F,0x6A,0xB6,0x35,0x9C,0x41,0x5F,0x99,0x68,0x5B,0x77,0x07,0xFD,0xC9,0xEA,0x6D,0xDD,0xED,0xED,0xA7,0xA8,0xB7,0xFD,0x7F};
const uint8_t spINDICATED[] PROGMEM = {0xAB,0x1B,0xD6,0xC9,0xAB,0x26,0xAD,0x72,0xA8,0x64,0x99,0x9C,0xB5,0xB2,0x26,0x4D,0x33,0x62,0xF2,0xC8,0xBA,0xC1,0xF2,0x34,0xD7,0x2D,0x6B,0x1A,0x3B,0x5C,0xDD,0x84,0x3C,0x09,0x1A,0xF1,0x4E,0x34,0xEA,0xA1,0x5C,0x99,0xAD,0xD9,0xAA,0xA7,0x70,0x91,0xD4,0x35,0xA3,0x19,0x26,0x90,0x4B,0x5F,0x9B,0xB9,0x39,0xA4,0x59,0xA9,0x84,0xE6,0x29,0x54,0xC4,0xCC,0x71,0x2A,0x66,0xDE,0xD0,0x88,0xB8,0x0E,0x98,0xD6,0xB9,0x55,0x55,0x33,0x67,0x46,0xED,0x55,0xF7,0xA8,0x64,0x99,0x8B,0x57,0x37,0x7C,0x92,0xA4,0xBF,0x59,0x5D,0x0F,0x89,0x1A,0xB1,0x78,0xF5,0xCD,0x18,0x86,0xF7,0xE2,0x34,0x1C,0x67,0x21,0x24,0x91,0xDB,0x74,0x75,0x38,0xB1,0x65,0x59,0x73,0x71,0xCA,0xEE,0x3D,0x67,0xCD,0xD5,0x98,0x98,0xE7,0xE3,0xB1,0x34,0x6B,0xCA,0xE2,0xAB,0xC5,0x2A,0x64,0x45,0x44,0x44,0x94,0xEB,0xFF,0x03};
const uint8_t spSEVERE[] PROGMEM = {0x06,0x78,0xC6,0x55,0x01,0x3F,0xA5,0x18,0xE0,0xB7,0x52,0x0B,0x04,0xE0,0xB7,0xD4,0xD5,0x76,0x11,0x41,0xAE,0x5B,0x56,0x5B,0xB4,0xB9,0xBA,0x6C,0x4D,0x43,0x16,0xEA,0x1A,0xE2,0xD6,0x8D,0x99,0xBB,0xB3,0x4B,0xBA,0x34,0x36,0x69,0x26,0x21,0xEA,0x56,0xD9,0x7D,0x28,0x05,0x77,0x5B,0xE9,0xF0,0x25,0x18,0xB2,0x65,0xC5,0x2D,0x24,0x72,0xC9,0xEA,0x15,0x35,0x3F,0xC4,0x43,0x9B,0x47,0x54,0x72,0xA1,0x0E,0x6E,0x19,0x51,0x8E,0xCE,0xDE,0xBC,0x65,0x24,0xD9,0x27,0x9B,0x79,0x1B,0x95,0x16,0x11,0xA2,0xA6,0x8E,0xFF,0x1F};
const uint8_t spMODERATE[] PROGMEM = {0x22,0xB3,0x2C,0x72,0xC2,0x1C,0x8B,0x4D,0xAA,0xAC,0x21,0x6B,0xE2,0xD6,0x20,0xA4,0x46,0x24,0x59,0x58,0x92,0xE0,0x1C,0xB1,0xB8,0x63,0x8E,0x66,0x5B,0x9D,0x5B,0xAF,0x31,0xE9,0x6B,0x4E,0x6B,0xB3,0xFA,0x2C,0xAF,0x25,0xAD,0xF5,0x6A,0xB3,0xFE,0xB0,0xF2,0x55,0xAB,0x4A,0x6E,0x2C,0xCD,0x57,0x29,0xC0,0x05,0xEB,0x50,0xD7,0xAC,0x12,0xAA,0x4A,0x4A,0x91,0x1B,0xA7,0x78,0xAA,0x4B,0x45,0xAC,0x54,0x6A,0xA9,0xBB,0x15,0xA9,0x52,0x9A,0x99,0xAF,0x55,0xE4,0xCA,0x61,0xEA,0xBD,0x56,0x5E,0x8A,0x73,0x4A,0xB6,0x5A,0x79,0x49,0xCE,0x4E,0xDD,0x98,0x55,0x5C,0x95,0x77,0x64,0x42,0x04,0x4E,0x51,0xAA,0x42,0x35,0x00,0x14,0x30,0x85,0xBA,0x02,0x9E,0xAF,0x10,0xC0,0x8D,0x99,0xFF,0x0F};
const uint8_t spGREENWICH[] PROGMEM = {0x04,0x88,0x2D,0xA2,0x34,0xC5,0x87,0x9B,0x89,0x95,0x56,0xE7,0x2A,0x6E,0xA6,0xF1,0x56,0x9D,0x9B,0x84,0xBB,0xB6,0x5F,0x45,0xC9,0xAE,0x91,0xB2,0x75,0x15,0xC5,0x96,0xC4,0xD8,0xEB,0x55,0x35,0x17,0x12,0x61,0xB7,0x47,0x53,0x2C,0x55,0xAA,0xD9,0x6D,0x4B,0xB1,0x58,0x61,0xEE,0x7A,0xAD,0x5D,0x97,0x68,0xF9,0xA3,0xB1,0x0D,0xD5,0xC2,0xED,0xAF,0xD2,0xDE,0x74,0xB1,0x4C,0xBC,0x0C,0x47,0xB7,0x45,0x1A,0xFE,0x0A,0x81,0x53,0x94,0xAA,0x50,0x0D,0x40,0xC0,0x74,0xE2,0x0A,0xD8,0x29,0xDC,0x01,0xBB,0x64,0x38,0xE0,0xE4,0x6A,0x07,0xCC,0xF2,0xE1,0x80,0xD9,0xC6,0x19,0xD0,0x67,0xD8,0xFF,0x03};
const uint8_t spMEAN[] PROGMEM = {0x66,0x0A,0x5C,0xE3,0x24,0x9C,0x84,0x3D,0x08,0xCE,0xE5,0x48,0x9B,0xE6,0xAC,0x30,0x5B,0x3C,0xCD,0x2A,0x66,0x31,0x82,0x88,0x35,0xAB,0x98,0xCD,0x11,0x33,0x17,0xAF,0x6A,0x36,0x43,0x8C,0x5C,0xBC,0xAA,0xD9,0x14,0x29,0x6B,0xD6,0xA8,0x67,0x15,0xE4,0xEA,0x49,0x63,0x98,0x4D,0x90,0xAB,0x46,0xB5,0x79,0x66,0x42,0xED,0x1E,0xDD,0x96,0xE1,0x89,0x62,0x2A,0x48,0x59,0x9B,0x26,0xCE,0xF1,0x30,0x69,0x6F,0x1A,0xDB,0xD2,0xEC,0x84,0xAB,0x2A,0x6C,0x2B,0x4D,0xE5,0x9E,0x24,0x28,0x23,0xCA,0x89,0xF9,0x8A,0xC2,0xB2,0xD1,0xD4,0xE1,0xAB,0x1A,0xD3,0xCB,0x3D,0x87,0xAF,0x19,0x4C,0xCB,0x70,0x9D,0xBE,0xE6,0x5C,0xCC,0x7D,0xD6,0xFF,0x03};
const uint8_t spMIST[] PROGMEM = {0xAC,0x75,0x2C,0x7C,0x4A,0x93,0x98,0x43,0x4B,0x8F,0x49,0x4B,0x6C,0x56,0xA9,0x3C,0x36,0xB4,0x8E,0x99,0xB5,0xB2,0x98,0xB0,0xC4,0x61,0x0C,0x52,0x6D,0x42,0xEA,0xA4,0x31,0x71,0xD5,0x6A,0xAE,0xBB,0xBA,0xE6,0x8D,0xCD,0xFD,0xF6,0xAA,0xBA,0x0F,0x56,0xF7,0xC7,0xAB,0x6C,0xC1,0xC5,0xAD,0x67,0xAF,0xB6,0xBA,0xE0,0xF0,0x99,0xBD,0xA6,0x6A,0x9B,0x2C,0x6A,0x76,0x5B,0x8B,0x6B,0x32,0xAF,0x5B,0xE9,0x79,0x62,0x46,0x41,0x94,0x1A,0xE0,0x19,0x57,0x05,0xFC,0x94,0x62,0x80,0xDF,0x4A,0x2D,0x10,0x80,0xDF,0x52,0x1D,0xF0,0x4B,0x99,0x01,0x7E,0x2E,0x43,0xE0,0x14,0xA5,0x2A,0x54,0x03,0x00,0x14,0x30,0x85,0xBA,0x00,0x9E,0xAF,0x20,0xC0,0x8D,0x99,0xFF,0x0F};
const uint8_t spESTIMATED[] PROGMEM = {0xE3,0xEE,0xD1,0xD8,0xBD,0x17,0xAF,0xB1,0x7A,0xD5,0xF2,0x9D,0xBD,0xDA,0xEA,0x4C,0xCB,0x67,0xF6,0xAA,0x8A,0x0B,0x0D,0xEF,0x45,0x2B,0x2F,0xD6,0x3C,0xB4,0x17,0xAF,0xE2,0x99,0x30,0x15,0x77,0x52,0x80,0x67,0xB6,0x1C,0x70,0x53,0x0F,0x03,0x4E,0x72,0x0E,0xC0,0x35,0x16,0xCB,0x6F,0x3A,0x4C,0x4D,0x56,0x97,0x22,0xC8,0x70,0x4D,0xDD,0x5C,0x8A,0x28,0xCC,0xAA,0xA4,0xCE,0xCA,0x8B,0x4B,0xD3,0xD0,0xD5,0x2B,0x6F,0x36,0xC4,0xD2,0x16,0xAD,0xA2,0xBB,0x60,0x8F,0x58,0xB4,0xCA,0xE6,0x8D,0xDD,0x72,0xB1,0xEB,0x13,0x33,0xB3,0xF4,0xC6,0xA3,0x1B,0xB6,0x95,0x8D,0x3A,0xAD,0xBA,0x06,0x15,0x93,0x9E,0xBD,0x9A,0xE2,0x45,0xCD,0x7A,0xCA,0x68,0xAB,0x75,0x11,0xF5,0x55,0x6A,0x30,0xBC,0xC2,0x33,0x62,0x88,0x51,0x8B,0x8C,0x8C,0xB4,0xF9,0xFF};
const uint8_t spDECREASING[] PROGMEM = {0x0C,0x28,0x30,0xAC,0x8C,0xCB,0xA6,0xAB,0x45,0xEC,0x55,0x0D,0x65,0x24,0x19,0x77,0x56,0xD5,0xB5,0xA2,0x76,0x3E,0xDE,0x55,0xA9,0x87,0x55,0xB0,0x89,0xD7,0x6A,0x88,0x42,0xB4,0xCB,0x43,0x22,0x70,0x8A,0x52,0x15,0xAA,0x01,0x0C,0x08,0x57,0x95,0x01,0xA1,0x69,0x28,0xA0,0xD4,0xF4,0x95,0xF5,0xE8,0xC4,0xA9,0x5B,0x56,0x3E,0x42,0x20,0x95,0xAD,0xD9,0xF9,0x28,0x46,0x30,0xE4,0xB4,0xD7,0xAD,0x7A,0xAE,0xDB,0x81,0xDC,0x1A,0xE0,0x77,0x73,0x05,0xFC,0x69,0xAE,0x80,0xDF,0x35,0x34,0xB0,0x8A,0xA6,0x43,0x25,0xEC,0xF1,0x9A,0xAA,0x75,0x91,0x8E,0xC7,0x6B,0xAD,0xDA,0xD5,0x2F,0x16,0x95,0xA3,0x1A,0x95,0x3C,0x1B,0x19,0xCE,0x6C,0x39,0xC7,0x25,0xAC,0xB9,0xB3,0xA1,0x31,0x33,0xDB,0xEE,0x2E,0x8E,0x5B,0xC2,0x1D,0x9A,0x27,0x1B,0xC9,0x54,0x8B,0xED,0xDE,0x6C,0xC5,0x53,0xAD,0x72,0xF8,0x5A,0x54,0x8E,0xF4,0xD1,0xE1,0xEB,0x4D,0xD5,0x24,0x46,0xFD,0x3F};
const uint8_t spMOVING[] PROGMEM = {0x6A,0x91,0xB2,0x23,0xC5,0x93,0x98,0xD9,0x2A,0xED,0x14,0x4F,0x12,0xA6,0xA4,0xB8,0x8A,0xD5,0x59,0x99,0xB2,0xA2,0x09,0x66,0x27,0xA5,0x0B,0x26,0x33,0x84,0x9E,0xB4,0x36,0xF1,0x4A,0x77,0xF8,0x5C,0x9A,0x28,0x2B,0x5D,0xE1,0x75,0x69,0x82,0xCE,0x0C,0xA6,0xC5,0xA1,0x8F,0x2A,0xDC,0x55,0x63,0xBB,0xA1,0x33,0x57,0x71,0x8B,0x5D,0x9A,0xA4,0xCC,0xC2,0x2A,0xD5,0xAA,0x9B,0x13,0xB5,0xF0,0x59,0xAB,0xE9,0x41,0xD8,0x2A,0x26,0x8D,0xB6,0x6B,0xE1,0x5A,0xB1,0x5A,0xDA,0xAA,0xA8,0x53,0xC4,0x69,0x69,0xAB,0xA2,0x71,0x51,0x27,0xA9,0xAF,0x92,0xF5,0x13,0xE3,0xFD,0x3F};
const uint8_t spPRESSURE[] PROGMEM = {0x08,0x88,0x44,0xC5,0x00,0xC5,0xB9,0x1A,0xA0,0x64,0xB3,0xD1,0xA5,0x2C,0xA5,0xC5,0x6B,0x56,0x97,0xB3,0xBA,0xA7,0x6E,0x59,0x63,0xC9,0xAE,0x11,0xBA,0x65,0x2D,0x25,0x99,0x5A,0xDA,0xEA,0xB6,0x36,0xEB,0x2A,0xE1,0x29,0x13,0xB0,0xAC,0x6B,0x02,0x66,0xD9,0x4C,0xC0,0xCC,0xDB,0x0E,0x68,0x41,0xA9,0x4D,0xC5,0x27,0x49,0x7B,0xB6,0xB2,0xD6,0x34,0x8C,0xAD,0xFE,0xCB,0x51,0x8E,0xB3,0x15,0x75,0x2D,0x57,0x1E,0x4A,0xBE,0xDC,0x25,0xDD,0xB9,0x09,0xC5,0x4A,0x96,0xF0,0xE4,0xC3,0x9C,0x25,0x5D,0xDC,0x53,0x9E,0x72,0x25,0xA7,0x71,0x6F,0x79,0xA9,0x69,0xAC,0xF4,0xFF,0x01};
const uint8_t spALTERNATE[] PROGMEM = {0xAA,0xB0,0xAF,0x4D,0xA5,0x6B,0x95,0xC9,0xCE,0x4D,0xE5,0x6C,0x32,0x46,0x57,0xB7,0x8C,0xBC,0xCD,0xE8,0x82,0xB9,0x4E,0x91,0xAC,0xAB,0x8E,0xE2,0xA7,0x8C,0xB3,0x8E,0x2C,0xEA,0x9C,0x52,0xF1,0x56,0xB2,0x6C,0x64,0x52,0xC4,0x2D,0x02,0x1C,0xE7,0x24,0x40,0x31,0xEA,0x01,0x18,0xBE,0x6D,0x78,0x4D,0x87,0x8A,0xB9,0x9B,0x95,0x94,0x90,0x4C,0xC3,0xDD,0x56,0x56,0xAA,0xAA,0x85,0xB4,0x6B,0x79,0xB2,0x62,0x11,0x51,0xAF,0x65,0x49,0x89,0x77,0x68,0xDC,0x95,0x36,0x1D,0x12,0x61,0x8B,0x46,0x56,0x45,0x89,0xB7,0x2F,0x5C,0x59,0x13,0x25,0x9E,0xBE,0xA8,0x64,0x45,0x04,0xA7,0xE6,0x46,0x04,0x4E,0x51,0xAA,0x42,0x35,0x00,0x0C,0x30,0xA4,0x9B,0x02,0x36,0x57,0x43,0xE0,0x14,0xA5,0x2A,0x54,0xE3,0xFF,0x01};
const uint8_t spCLEAR[] PROGMEM = {0x0C,0xC8,0xA3,0x39,0x00,0xC5,0x96,0x3B,0xA0,0x73,0x4F,0x03,0x4C,0xAD,0xD5,0xB2,0xCC,0x6C,0x42,0xB8,0xCB,0xCA,0x1A,0xE7,0xAC,0xE4,0xB6,0x2B,0x9F,0x46,0xC2,0x82,0xB6,0xAD,0x62,0x5A,0x37,0x0A,0xDE,0xB6,0x8A,0x19,0xDA,0xC1,0x69,0xDB,0x2A,0xA6,0x2B,0x85,0x90,0xAD,0xAB,0x9C,0xAE,0x04,0x53,0xB6,0xAC,0x72,0xD8,0x12,0x2C,0xD9,0x32,0xAA,0xE6,0x9A,0xB8,0x65,0xCB,0xA8,0xAA,0x6D,0xD4,0x95,0x2E,0xA5,0x2A,0xB6,0x51,0x4F,0xB2,0xA5,0xAA,0xA4,0x45,0x59,0xF1,0xFA,0xFF};
const uint8_t spCURRENT[] PROGMEM = {0x0A,0xC8,0xB3,0xC0,0x01,0xB9,0x34,0x8F,0x3C,0x37,0xB1,0x28,0x4E,0xBB,0xEA,0x34,0xC4,0xB3,0xB8,0xED,0xAA,0x53,0xE7,0xB0,0x32,0xF7,0xAB,0xCE,0x83,0xD3,0x2D,0xDD,0xAF,0x3A,0x17,0xB5,0xD0,0xEC,0xB6,0xAA,0x62,0x52,0x46,0xF3,0x4A,0xAB,0xAA,0x71,0x69,0x9C,0xCA,0xAE,0x4A,0x82,0xBB,0xD8,0x52,0x23,0x70,0x8A,0x52,0x15,0xAA,0x01,0xA0,0x80,0x21,0xDD,0x18,0xB0,0xB9,0xDA,0xFF,0x03};
const uint8_t spBLOWING[] PROGMEM = {0x08,0x28,0xA5,0xD4,0xEC,0xC8,0x8C,0xB9,0xA7,0x9D,0xB4,0x27,0x23,0x3E,0x69,0x4A,0xD2,0x90,0x84,0xAE,0x29,0xAD,0x5B,0x7D,0xA1,0x36,0xA9,0xD4,0x76,0xB5,0x59,0xF4,0xB8,0xC8,0x9E,0x55,0x27,0xB9,0xAD,0xAA,0x5D,0x5A,0x15,0xE5,0xB5,0x98,0xF6,0x6D,0x75,0x30,0x97,0x6E,0xD4,0xA7,0xB5,0x21,0xAE,0xBB,0xC9,0xE6,0x36,0xC4,0x5C,0x92,0x1E,0xAB,0xDA,0x9A,0x83,0x6B,0x46,0xBC,0x6A,0x47,0xF3,0xC1,0x3A,0xDE,0xB9,0x1D,0x3D,0x24,0xCB,0xFA,0xAA,0xF2,0xF6,0xA4,0x6C,0x6B,0x15,0xCB,0x57,0x35,0x47,0x15,0xC5,0x49,0x6F,0x35,0x6C,0x95,0xE2,0x38,0x3D,0xCD,0x53,0x86,0x4B,0x1C,0xF7,0x54,0x4B,0x95,0xAA,0x71,0xDC,0xD3,0x12,0x87,0x5B,0x85,0xF9,0x7F};
const uint8_t spAT[] PROGMEM = {0xA9,0xAC,0x36,0xB9,0x32,0x1F,0xAD,0xB5,0xBA,0x94,0x4C,0x9F,0xBD,0xA6,0xE6,0x4A,0x23,0xED,0xF1,0x1A,0xBB,0x19,0xD3,0xB4,0xCD,0x6B,0xEC,0x6A,0xCC,0xD2,0x36,0xAF,0xB1,0xCB,0x91,0x70,0x7B,0x8D,0xC0,0x29,0x4A,0x55,0xA8,0x06,0x80,0x00,0xA6,0x54,0x37,0xC0,0x55,0x2A,0x04,0x58,0x9C,0xF5,0xFF,0x01};
const uint8_t spTURBULANCE[] PROGMEM = {0x01,0x18,0xCE,0x22,0x01,0xDB,0x55,0x04,0xA0,0x85,0xB6,0x11,0xA7,0x10,0x2C,0xE3,0xDE,0x56,0x9E,0xBB,0x8A,0x17,0x65,0x1B,0x59,0xAA,0xC6,0xDE,0x94,0xA7,0xE4,0xD1,0x07,0xC7,0x90,0x37,0xD6,0x10,0x9F,0x3E,0x69,0x6A,0xCC,0x94,0x84,0x5A,0x44,0xA6,0x6E,0x7D,0x35,0xCE,0x5C,0xD9,0x75,0x0D,0x4D,0x05,0x73,0x66,0xD7,0x35,0x74,0x19,0xCA,0x19,0x5D,0xD6,0x58,0x55,0x9A,0xBB,0x6E,0x5D,0x73,0x47,0x56,0x9E,0xEA,0xB5,0x2D,0x0B,0x73,0x55,0x98,0xF2,0xB5,0x74,0x5A,0x69,0x2E,0x5D,0xD6,0xD4,0xC4,0xB8,0xB8,0x76,0x5E,0x63,0x67,0xED,0x1A,0xB6,0x69,0x0C,0x4D,0x9A,0x94,0x6A,0xEB,0xD0,0x15,0x89,0xDD,0x1C,0x6E,0xC4,0x9A,0xA9,0x45,0xB1,0x39,0x32,0xC0,0x33,0xAE,0x0A,0xF8,0x29,0xC5,0x00,0xBF,0x95,0x5A,0xC0,0x00,0xBF,0xA5,0x1A,0xE0,0x97,0xB2,0xFF,0x07};
const uint8_t spTHINLY[] PROGMEM = {0x08,0x38,0x2C,0x14,0x01,0x4D,0x84,0x0A,0xA0,0xC9,0xF0,0x14,0x37,0x13,0xEA,0x62,0xAD,0x57,0x56,0xAD,0x99,0xAA,0xBD,0x59,0x79,0x73,0xAE,0xEA,0xFE,0x78,0x15,0x4D,0x87,0x5A,0xE8,0xA3,0x51,0x76,0x87,0x56,0x61,0x76,0x47,0xD5,0x0C,0xD9,0xB8,0xDB,0x1B,0xCD,0xA0,0xAE,0x59,0x98,0x64,0x74,0x1B,0xC9,0xB8,0x89,0xDB,0xD5,0x56,0x39,0xAA,0xAE,0x9B,0x4F,0xDB,0x65,0xB1,0x87,0xBD,0x5E,0x7D,0x77,0x89,0x6E,0xF1,0x68,0x0D,0xDD,0x39,0x84,0xE7,0xA2,0x32,0xF4,0x88,0x12,0xDE,0xB5,0xFF,0x1F};
const uint8_t spINCREASING[] PROGMEM = {0xA3,0x69,0x2A,0x58,0x3D,0x1E,0x8D,0x66,0x89,0x54,0x4A,0x5B,0xBD,0xBA,0xC5,0x43,0xA4,0x74,0x55,0xE9,0x9B,0x22,0x59,0xD7,0x68,0x6D,0x68,0x9A,0x64,0x5D,0xAD,0x85,0x21,0x2B,0xCC,0x55,0x93,0x8B,0xC0,0x29,0x4A,0x55,0xA8,0x06,0x10,0x20,0xCD,0x14,0x06,0xC4,0xD6,0x6C,0x80,0x9C,0x32,0x5B,0x96,0xA3,0xA9,0x98,0xB9,0x59,0x79,0x49,0x6C,0xE6,0xD6,0x75,0x14,0xD5,0x28,0xD9,0xD8,0xEA,0x96,0xB5,0xA0,0x28,0xE5,0xAF,0x4B,0x79,0x5D,0xB7,0x00,0xB9,0x35,0xC0,0xF3,0x1E,0x0E,0xF8,0xC9,0x23,0x01,0x3F,0x89,0x8D,0xA4,0xAB,0x60,0xF5,0x58,0xBC,0xDA,0xA1,0x42,0x24,0xFD,0xF5,0x1A,0x96,0x4E,0xA1,0xF2,0x55,0x6B,0x5C,0xCA,0x99,0xCF,0x2B,0xB6,0x71,0x18,0xE1,0x6A,0x89,0xD6,0xC6,0x6E,0xC8,0xCB,0xCD,0x6E,0x1B,0x9A,0x21,0x6F,0x37,0xA7,0x65,0xAC,0x9A,0xCB,0xD4,0x14,0x95,0xA1,0x5A,0xD2,0x50,0x2F,0xFC,0xFF};
const uint8_t spMORE_THAN[] PROGMEM = {0x62,0x4E,0x9C,0x62,0xCC,0x9C,0xBA,0x3D,0x09,0x8E,0x52,0x4F,0x9C,0xE6,0xA2,0xA5,0x82,0x55,0x55,0x99,0xAA,0xA2,0x0C,0x53,0xC5,0x6D,0xEC,0x9A,0xBD,0x43,0xA4,0x8C,0x3E,0xC8,0x9A,0x4D,0x72,0x3A,0xDA,0x28,0x7B,0x26,0xD1,0xE9,0xAA,0x83,0xED,0x1E,0xC3,0x34,0x2B,0x0F,0xFE,0x2C,0x55,0x72,0x8F,0x2C,0xD4,0xD4,0x32,0xD9,0xB5,0xD2,0x98,0xCD,0x3A,0xB4,0xE3,0xC8,0xB2,0x69,0x4A,0x8F,0x45,0xA6,0x76,0x26,0x24,0x35,0x6B,0xA9,0x2E,0x73,0x35,0xF1,0x4A,0x5D,0xBA,0x2E,0x53,0x54,0xAD,0xCD,0xAA,0xAA,0x33,0x35,0xCD,0x55,0xAB,0xEA,0xAA,0x58,0x33,0x5E,0xAD,0xBA,0xC9,0x66,0xCF,0x7C,0xBD,0x9A,0x66,0x9A,0x23,0x73,0xD1,0x6E,0x56,0xDB,0x74,0x73,0x66,0x2C,0xDA,0xED,0x6A,0x9B,0x6A,0xCE,0x88,0x47,0xAB,0x6B,0x56,0x74,0x38,0x9D,0xB4,0xB6,0x1A,0x8A,0x94,0x74,0xD5,0x9A,0x66,0xA9,0xDC,0x42,0x63,0xA9,0xAB,0x46,0x5F,0x4E,0xCD,0xA9,0x2E,0x42,0xE8,0xB2,0x2C,0xFD,0x3F};
const uint8_t spLESS_THAN[] PROGMEM = {0x69,0x5D,0x40,0x2B,0x54,0x92,0xA4,0xE5,0x20,0xEC,0x51,0x71,0x9A,0xC6,0x83,0x70,0x46,0x34,0xDE,0x18,0x16,0xE4,0x09,0x33,0xA7,0xAB,0x2E,0x74,0x32,0x42,0x36,0xAF,0xAA,0x88,0xB6,0x0A,0xFF,0xBC,0xAA,0x12,0x5C,0x53,0xFA,0xF1,0x28,0x6B,0x32,0x0D,0x9C,0x59,0x01,0xF8,0x86,0xC4,0x01,0x7F,0x86,0x1A,0xE0,0xCF,0x52,0x03,0xFC,0x60,0x89,0xC0,0x29,0x4A,0x55,0xA8,0x06,0x8C,0xAC,0x88,0x12,0x37,0x7B,0xB4,0xAA,0x2A,0x5A,0xBC,0xFC,0xF6,0x6A,0x9B,0x6B,0x76,0xF7,0xC7,0xAB,0xAB,0x36,0xB9,0x32,0x1E,0xAD,0xAE,0xBA,0x90,0x8A,0x9C,0xB5,0xBA,0x62,0x52,0xDA,0x72,0xD6,0xE8,0x8B,0x48,0x1D,0xF5,0xB9,0xAD,0xAB,0x86,0xBC,0x25,0x1D,0xB7,0xBE,0x19,0xF2,0x91,0x50,0x3A,0x86,0xA2,0xCB,0x4C,0xB2,0xD3,0xFF,0x03};
const uint8_t spFREEZING[] PROGMEM = {0x04,0x18,0xB6,0x82,0x00,0xD3,0x57,0x08,0x60,0xBA,0x74,0x05,0x34,0x5B,0xD6,0x8A,0x6A,0xD2,0x43,0x4D,0xCE,0x28,0x52,0xA5,0xA6,0xD4,0x2C,0xAB,0x2E,0x89,0x5D,0x5D,0xDA,0xAD,0xAA,0x67,0x25,0x09,0x7B,0xB3,0x8A,0x11,0x1D,0x29,0xED,0xF5,0x28,0x9A,0x27,0xF4,0x8C,0xDB,0xAD,0xA8,0x4A,0x28,0xDD,0x5F,0xB5,0xAA,0x31,0x67,0x33,0xDD,0x35,0xDA,0x8D,0x4D,0xCD,0x2D,0xEF,0x18,0x7E,0x16,0x74,0x57,0x2F,0xAD,0xF9,0x95,0x31,0xCC,0xD3,0x8E,0xB6,0x93,0x64,0x8B,0xDC,0xB8,0xEA,0x1E,0x8C,0x45,0xE3,0xCE,0x6A,0xBA,0x17,0xCA,0xF2,0xC2,0xA3,0x6D,0x06,0xDB,0x43,0x9C,0x8C,0xB6,0x19,0x2C,0x0B,0x76,0xD3,0xDA,0xA2,0xB0,0xCD,0xC5,0x75,0x69,0x93,0xE4,0x31,0x35,0xD7,0xAA,0x77,0x52,0x73,0x25,0x52,0xFD,0x3F};
const uint8_t spAIR[] PROGMEM = {0xAD,0x6F,0x5E,0x38,0xBB,0x1A,0xAE,0xBE,0x67,0x65,0xCF,0x5C,0xB9,0x9A,0x5E,0x83,0xD4,0x7D,0xF3,0xAA,0x5A,0x31,0x2C,0xCF,0xC5,0xA3,0xAC,0xA5,0x20,0x83,0x5F,0x8F,0xB2,0xE6,0x01,0x1F,0xFA,0x34,0xCA,0x52,0x13,0x72,0xE8,0xD5,0x28,0xF2,0x10,0x9E,0xE0,0x57,0xA3,0xCC,0x93,0xB4,0xD5,0x7B,0x95,0xAA,0x6C,0x0C,0x93,0xCE,0xF4,0xFF};
const uint8_t spBELOW[] PROGMEM = {0x0C,0x50,0xD6,0x6C,0x24,0xD5,0x39,0x73,0x58,0xEB,0x55,0x75,0x9F,0x8C,0x65,0x6B,0x56,0xD3,0x9C,0x92,0x94,0x3F,0x19,0x6D,0xD3,0xC6,0x9C,0xB6,0x66,0x74,0x8B,0x89,0x6B,0x52,0xB7,0xD1,0x2D,0xC6,0x11,0xC1,0xE9,0x5B,0xB7,0x04,0x65,0x3A,0x66,0x1F,0xDD,0x16,0x54,0xA5,0xD8,0x6D,0xD5,0x8D,0x66,0xBB,0xF2,0xD6,0x55,0x15,0x9E,0xED,0x2A,0x5B,0x56,0x95,0x79,0x4F,0xA8,0x74,0x19,0x65,0x14,0xD3,0x21,0xD2,0xB9,0x15,0x51,0xCE,0x18,0x6B,0xE7,0x52,0x78,0xBD,0xAD,0xA4,0x9D,0x53,0xE9,0xE5,0xB6,0x91,0x74,0x49,0x55,0x90,0xD3,0xC2,0xBA,0x25,0xD4,0x91,0x74,0xAB,0x69,0x1B,0x57,0x47,0x31,0xEA,0xAA,0x75,0x44,0x23,0x45,0xBB,0x9B,0xCD,0xF9,0x7F};
const uint8_t spAND[] PROGMEM = {0x6B,0xA8,0x2E,0x79,0xAC,0x37,0xAE,0xA5,0xBA,0xE4,0xCE,0x5C,0xB8,0xA6,0xE6,0x92,0xB3,0x62,0xD1,0x9A,0xAA,0x2B,0x8E,0x8A,0x45,0x6B,0xAA,0xA6,0x38,0x33,0x66,0x97,0xA9,0x39,0xCC,0xD0,0xF0,0x9C,0xA6,0x66,0xB1,0x5C,0xD2,0xB3,0x99,0x93,0xA4,0x0E,0x19,0x17,0x64,0xE3,0xBA,0x34,0xB3,0x6D,0x96,0xA7,0x69,0x53,0x57,0xDD,0xD2,0x96,0x6A,0x8A,0x45,0xA2,0xF5,0xFF,0x03};
const uint8_t spFOR[] PROGMEM = {0x08,0xA8,0x56,0x98,0x00,0xD5,0x97,0x13,0x60,0xD8,0x50,0x51,0x58,0x77,0xA5,0x81,0x59,0x62,0x57,0xBA,0x20,0x6E,0x25,0x58,0x5B,0xEB,0x83,0xB9,0xE2,0x14,0xEF,0xA3,0x0F,0x7E,0x2D,0x8A,0xBD,0x8D,0x3E,0x86,0x11,0x4F,0xF3,0x37,0x86,0x64,0x53,0xCB,0x2D,0x77,0x18,0x33,0x2F,0x09,0x97,0x45,0xFF,0x0F};
const uint8_t spHAZE[] PROGMEM = {0x08,0x28,0x5A,0x1C,0x01,0x45,0x7B,0xB4,0xA6,0x39,0x92,0x8E,0x2A,0xBD,0xCA,0x1E,0x8D,0x22,0x63,0xCE,0xAA,0xBA,0x73,0xD2,0xF1,0xDB,0xAB,0xEA,0xCE,0x48,0xC7,0x27,0xAF,0x6A,0x78,0x47,0x9D,0x98,0xBD,0x9A,0xEE,0x14,0x6D,0x73,0xF6,0x18,0x87,0x75,0x94,0xC9,0xC7,0x6D,0x19,0xD6,0x40,0xB6,0x6E,0xB5,0x7D,0x78,0x43,0xDE,0x5A,0x5C,0xF6,0x11,0x14,0x79,0x72,0x71,0x3A,0xBB,0x63,0xB2,0xCE,0xD7,0xE1,0xAC,0x8E,0x54,0x63,0x6A,0xBB,0x2B,0x18,0xF1,0xAE,0xAE,0x15,0xEE,0xCC,0x5D,0x22,0x72,0x55,0x7A,0x3A,0x09,0x27,0xCD,0xBE,0xE5,0x59,0x58,0xDD,0xD4,0xB3,0x86,0xF7,0x05,0xB5,0x61,0x72,0xA2,0x80,0xDF,0x4A,0x15,0xF0,0xAB,0xBB,0x00,0x7E,0x4A,0xFF,0x7F,0x08};
const uint8_t spHIGH[] PROGMEM = {0x28,0x5A,0x1C,0x01,0x45,0x7B,0x94,0x32,0x87,0xB0,0x32,0x8E,0xB2,0xF2,0xE4,0xC6,0x33,0x65,0xF6,0xCA,0x53,0x68,0x8F,0xD4,0xC5,0xAB,0x48,0xA9,0x22,0xDD,0x17,0xAD,0x32,0xD5,0xF4,0x74,0x5F,0xBC,0xBA,0x1C,0xCB,0x32,0x74,0xF1,0x1A,0x8A,0x6F,0x8B,0xD4,0xC5,0x6B,0xAD,0xAE,0xCD,0x4B,0x17,0xAF,0xA3,0xBA,0x56,0x2F,0x7D,0x34,0xEE,0xEA,0x5A,0xAC,0x6D,0x51,0x7B,0x9A,0x6D,0xF1,0xD2,0x47,0xFD,0x2D,0x6F,0xD1,0x21,0x33,0xF9,0x30,0x7D,0x2D,0x88,0x74,0xD4,0xE4,0xF4,0x57,0xAF,0x34,0xD5,0x93,0xD2,0xDF,0x82,0x61,0x76,0xCF,0xFE,0x7F};
const uint8_t spSCATTERED[] PROGMEM = {0x06,0x78,0xC6,0x55,0x01,0x3F,0xA5,0x18,0xE0,0xB7,0x52,0x0B,0x04,0xE0,0xB7,0x54,0x04,0x4E,0x51,0xAA,0x42,0x35,0xC0,0x00,0x3D,0x15,0xAD,0xA0,0x15,0x65,0xCB,0xB8,0xBD,0xB2,0xEA,0x4D,0xB2,0xE2,0xD1,0x2A,0x4A,0x30,0xAD,0x8A,0xDB,0xAB,0xAA,0xC5,0x35,0x23,0xEF,0xAC,0xA6,0x64,0xB5,0xD2,0x2D,0x6D,0xFA,0x49,0xCD,0xD2,0xCB,0x91,0x00,0xBA,0x55,0x6D,0x5D,0x6D,0xC2,0xE1,0xB6,0xA8,0x4C,0x65,0x32,0xB5,0xEB,0xAB,0xB2,0x96,0x65,0x90,0x45,0xBB,0xCB,0x5E,0x5B,0x82,0x0C,0x6F,0x2E,0x67,0xAD,0x45,0xDC,0xBC,0x27,0x9D,0x75,0x88,0xA8,0x44,0x5B,0x75,0x65,0x43,0x56,0x96,0x35,0xD9,0x15,0xA5,0x68,0x79,0x34,0x64,0x40,0x81,0x61,0xE5,0x1E,0xCE,0x4D,0xCC,0x3B,0xFF,0x3F};
const uint8_t spINCREASING_TO[] PROGMEM = {0x6E,0x1D,0x59,0xD1,0x2C,0x9B,0xB4,0x75,0x58,0x03,0x9F,0x9A,0x35,0xBA,0x1E,0x04,0xB3,0x7A,0xF6,0x6A,0x7B,0x52,0xB2,0xA8,0x39,0xAB,0xED,0x3E,0xC8,0x32,0x67,0x9F,0xBE,0x8B,0x62,0xAD,0x58,0xD4,0xFA,0x6E,0x48,0xC7,0xDC,0x69,0x1B,0xBA,0x41,0x6B,0x0B,0xA7,0xA5,0xAF,0x1A,0x63,0xD4,0xED,0xBA,0x21,0x4A,0xCA,0x35,0x8B,0x23,0x66,0xCB,0xCA,0x32,0xAD,0x12,0x02,0xA7,0x28,0x55,0xA1,0x1A,0x60,0x80,0x94,0xBC,0x0C,0x90,0x72,0xB8,0x01,0x72,0x2C,0x1F,0x49,0xC9,0x62,0x92,0xD2,0xF9,0x64,0x2D,0x1A,0x49,0xEA,0x96,0x95,0xF5,0xAC,0x20,0x69,0x8F,0x5B,0xD6,0x3C,0xB1,0x47,0x3D,0x4A,0xC0,0x44,0xAA,0x01,0xF8,0xDE,0x33,0x00,0xBF,0x85,0x27,0xE0,0x3B,0x8F,0x95,0x76,0xED,0xAC,0xEA,0xAB,0x57,0x3E,0x8C,0x13,0x67,0x3C,0x1E,0xC5,0xB0,0x8A,0x32,0x51,0xB9,0x15,0x55,0xB1,0x4D,0x49,0xDC,0x56,0x54,0x49,0xE5,0x66,0xAE,0x5B,0x5E,0x15,0x95,0x9B,0xA9,0x2E,0x59,0x91,0x58,0x25,0xAE,0xC6,0x65,0x51,0xD0,0xA4,0xA4,0x66,0x04,0x4E,0x51,0xAA,0x42,0x35,0xC0,0x00,0x4D,0x8B,0x27,0x60,0xBB,0xEA,0x00,0xF4,0x70,0x5D,0xB2,0xAA,0x55,0xCD,0x74,0x75,0x69,0xB3,0x64,0xCB,0x92,0x37,0xA5,0x8B,0x42,0xA2,0x52,0xDF,0xA4,0x2E,0x4A,0xCE,0x0E,0xDD,0xFC,0xFF};
const uint8_t spIN[] PROGMEM = {0x65,0xED,0xD6,0xD1,0x2A,0x3F,0xB5,0x65,0x98,0x40,0xED,0xDA,0x3C,0xE6,0xA1,0x13,0x79,0x72,0xF5,0x1A,0x87,0x09,0x94,0x8E,0xC7,0x63,0x6C,0xDE,0xD1,0x2A,0x2F,0xB7,0xB1,0x7A,0xE7,0x88,0xBC,0x9C,0xA6,0xE6,0x30,0x53,0xCD,0x49,0x99,0x9A,0xA5,0x70,0x73,0xC7,0x65,0x6A,0x86,0x22,0xD5,0x9D,0xA4,0xB9,0x19,0x8C,0xD0,0x70,0x1D,0xE6,0xAA,0x31,0x4B,0xDD,0x8D,0x5B,0xB2,0xC4,0x31,0xCD,0x44,0xFF,0x0F};
const uint8_t spLOW[] PROGMEM = {0x65,0xDF,0x98,0xA3,0x4A,0xB4,0xE5,0x65,0x4E,0xAB,0x9F,0xD4,0xA2,0x92,0xBC,0x9E,0xB6,0xF2,0xC8,0x71,0xEA,0x7B,0x9B,0xD5,0x24,0x5E,0x3D,0xCC,0x79,0x77,0x3B,0xFB,0xB9,0xF4,0xBD,0xEE,0xF5,0x0C,0x97,0x37,0x5D,0x0B,0x92,0xC7,0xDF,0xFE,0xFD,0x7F,0xA1,0x4A,0x36,0xBD,0xDD,0x3B,0x97,0x2D,0xE6,0xB2,0xD4,0x6C,0x35,0xA6,0x18,0x2A,0x4A,0x6D,0xD3,0x1A,0xB3,0xDA,0x08,0x97,0xDE,0x6B,0x88,0x66,0x3D,0x5D,0x7B,0x8F,0x21,0xA9,0xF6,0x08,0xF1,0x1C,0xE6,0x2C,0xC3,0xD2,0x28,0xB5,0x5B,0x32,0x77,0x0D,0x53,0x27,0x69,0xEB,0xD2,0xD9,0x55,0x1C,0x97,0x65,0x4B,0x33,0xD5,0x70,0x12,0xF6,0x29,0x5A,0x45,0x45,0xC9,0xFF,0x03,0x08,0x9C,0xA2,0x54,0x85,0x6A,0xC0,0xFF,0x03};
const uint8_t spTHUNDERSTORM[] PROGMEM = {0x04,0xE8,0xA6,0x94,0x02,0x14,0x38,0x79,0x15,0x15,0x16,0xB2,0xF9,0xE4,0x4D,0x76,0x7A,0xD2,0x96,0x93,0x37,0xD9,0x61,0x41,0x9B,0x5B,0x5E,0x0D,0x66,0xAB,0x39,0x2B,0x45,0xD6,0xD8,0xA1,0xE1,0xA6,0x54,0xC5,0x50,0xB0,0x5B,0x9B,0xD5,0x35,0x93,0x4A,0x1E,0x69,0x4F,0x53,0x43,0xA1,0x94,0x79,0x5B,0x6D,0x8D,0x09,0x5A,0x96,0x6D,0x0C,0xA5,0x30,0x85,0x47,0xE6,0x00,0x2C,0xC3,0x16,0x80,0x9B,0xC3,0x1C,0xF0,0x4F,0xAB,0x02,0xEE,0x49,0x45,0x40,0x17,0xA0,0xAD,0xDE,0xC6,0x42,0xD8,0xDD,0xAC,0x3E,0xF3,0x0E,0x4A,0xCF,0x36,0x86,0xA8,0xCF,0xB9,0x38,0x5B,0x99,0x43,0x3D,0xB7,0xC2,0xAC,0x6D,0x09,0x6D,0x2C,0x9D,0xEB,0xB6,0x35,0xD6,0x91,0x74,0x49,0x5A,0x8E,0x58,0x5A,0x32,0x24,0x6D,0xD9,0x52,0x4E,0xEE,0xE2,0xB6,0xE5,0xCF,0xC5,0x79,0x8A,0x7B,0xA7,0x3F,0x77,0xB6,0x76,0xEF,0x9D,0xFE,0xDC,0x9C,0xD3,0xCC,0x8B,0xFB,0xB3,0x56,0x35,0x59,0x2B,0xE6,0x8F,0xD6,0xC4,0xAD,0x23,0xAB,0x3F,0x19,0x35,0xA7,0xAE,0x6C,0xFE,0xAC,0xD8,0xD2,0x3D,0x77,0xF9,0x5F,0x71,0x2D,0x65,0xA7,0x04,0xF8,0xCD,0x99,0x00,0x7F,0xB4,0xFC,0x3F};
const uint8_t spOVERCAST[] PROGMEM = {0xAA,0xF1,0xE6,0xC2,0xCC,0x3A,0x97,0x26,0x8A,0x6D,0x31,0xEE,0x36,0x8A,0x4C,0xBB,0xD5,0xD9,0xDB,0xC8,0x22,0xEF,0xB6,0xC0,0x7C,0x2D,0x8D,0x62,0xDA,0x12,0xFD,0xA7,0xCC,0x9B,0x72,0x4F,0x4E,0x2C,0x6A,0x43,0xAA,0x53,0xCD,0x71,0x18,0xBA,0x76,0x73,0x55,0xDB,0xAD,0x8E,0xB1,0x38,0x1A,0xF3,0x8E,0x2E,0xC5,0x44,0x5F,0xEC,0x3D,0xFA,0x52,0x12,0x6C,0xA9,0x4F,0x1B,0x6A,0x5A,0xC4,0xD5,0x2C,0x69,0x6E,0x79,0x80,0x47,0xDB,0x20,0x70,0x8A,0x52,0x15,0xAA,0x01,0x01,0xE8,0x56,0xC8,0x01,0x55,0x29,0xAF,0xB2,0x26,0xE5,0x94,0x9A,0xBD,0xC6,0xE6,0x8B,0xAD,0xEC,0xF5,0x5A,0x9A,0x69,0xD1,0xB1,0xD7,0x6B,0xED,0x7A,0x54,0xC7,0x5E,0xAF,0xB5,0xEB,0x56,0x6B,0xFD,0xBC,0xB6,0x66,0x47,0xB5,0x6C,0xF5,0x38,0x9B,0x6A,0xF5,0xB6,0xCF,0xE3,0xAE,0x21,0xB5,0x2C,0x16,0xB7,0xA7,0xBA,0xD2,0xD6,0x5C,0xDC,0x9E,0x12,0xDD,0x8B,0xA7,0x76,0xBA,0x73,0xB4,0x48,0xDE,0xD8,0x06,0x78,0xC6,0x55,0x01,0x3F,0xA5,0x18,0xE0,0xB7,0x52,0x0B,0x04,0xE0,0xB7,0x54,0x07,0xFC,0x52,0x66,0x80,0x9F,0xCB,0x10,0x38,0x45,0xA9,0x0A,0xD5,0x00,0x50,0xC0,0x90,0x6E,0x0C,0xD8,0x5C,0xED,0xFF,0x01};
const uint8_t spUNLIMITED[] PROGMEM = {0x65,0x4D,0xEE,0xCC,0x33,0x56,0x8D,0x26,0xEB,0x0B,0x2B,0x5F,0xB5,0xAA,0xA2,0xC7,0x3D,0x65,0xF1,0x2A,0x53,0x0A,0x77,0xAB,0xCA,0xA5,0xCC,0x8A,0xDB,0x38,0xDC,0x94,0x32,0x2B,0x1E,0x63,0x77,0x13,0xCA,0xA0,0xB5,0x95,0x3C,0x6D,0xAA,0xA2,0xB1,0x94,0x10,0xB7,0xA5,0x8A,0xA2,0xD3,0x54,0x5A,0xB7,0xAA,0x90,0x98,0x50,0x6A,0xD3,0xAA,0x4A,0xAC,0xC3,0xB1,0xCD,0x2A,0x8A,0xCA,0xE0,0xB0,0x25,0xAB,0xE8,0x22,0x92,0x53,0xD7,0xAC,0x72,0xA8,0x48,0x49,0x5E,0x33,0xAA,0xAA,0xD9,0x32,0xC9,0x4E,0x69,0x8A,0x62,0xCB,0xA2,0xA4,0xA3,0xCF,0x26,0x5D,0x43,0x16,0x8F,0x39,0xBB,0x54,0x4D,0x7F,0xD4,0x96,0xAC,0x2C,0xD2,0x62,0x31,0x02,0xA7,0x28,0x55,0xA1,0x1A,0xE0,0x80,0x26,0x53,0x1D,0xB0,0x09,0x59,0x9B,0xB3,0x13,0x33,0xAF,0xC5,0x63,0x6D,0xDA,0x55,0x53,0xB7,0x94,0xBD,0x58,0x17,0x8D,0xF8,0x53,0x8E,0xAA,0x42,0x25,0x6C,0x4B,0x38,0x87,0x74,0xA3,0xE0,0xAE,0xE4,0x72,0x24,0x7D,0x32,0x52,0xD1,0xBB,0x3C,0xDD,0x19,0xB9,0xD8,0x96,0xFF,0x07};
const uint8_t spLOW2[] PROGMEM = {0x61,0xA9,0xC0,0x3A,0x4C,0xD3,0xA5,0xA5,0x43,0xEE,0x74,0x49,0x97,0x96,0x45,0xA8,0x4A,0x25,0xDB,0x18,0x06,0xD1,0x72,0xA3,0xAC,0xAB,0x6E,0x34,0xDB,0x94,0xFB,0xAE,0xBA,0xD2,0x6A,0x33,0xE9,0xB2,0xAA,0xCC,0xA6,0xCD,0xB4,0xCF,0xAA,0x13,0xDF,0x36,0x95,0xBE,0xA3,0x0D,0x6A,0x2B,0x54,0xFA,0x94,0x21,0x98,0x2B,0x51,0xEF,0x9D,0x16,0x17,0xB7,0x58,0x7C,0x57,0xDA,0x5D,0xD8,0x34,0xD2,0xCE,0xE9,0xD0,0xB3,0x5D,0xB8,0x56,0x87,0x53,0x8F,0x51,0xE5,0x68,0x1C,0x4E,0x95,0xDF,0x44,0x65,0x75,0xB8,0x64,0x3B,0x17,0xF1,0xAE,0xEE,0x56,0xA3,0x43,0xC9,0x5B,0xBB,0x5B,0xF6,0x35,0x15,0x6B,0xE3,0x1E,0x13,0xCF,0x4D,0xB4,0xCF,0xFF,0x03};
const uint8_t spPERCENT[] PROGMEM = {0x02,0xC8,0xD9,0x5C,0x03,0x2D,0x8A,0xB1,0x30,0x46,0x52,0xAF,0xBA,0x86,0x26,0x1A,0xF6,0x77,0x9B,0xD3,0xD5,0x18,0x68,0x69,0x59,0x63,0xEF,0x80,0x5F,0x5A,0x2D,0x60,0x01,0x0B,0x68,0xC0,0x03,0xAB,0x6E,0xDE,0x25,0x2D,0x17,0xDF,0xFA,0x36,0xBB,0x1D,0x53,0xB1,0x6E,0x23,0x5D,0xA7,0x5D,0x23,0x92,0xB9,0xA7,0x62,0x7F,0x20,0x50,0x84,0x72,0x17,0x91,0x0D,0x00,0xA0,0x80,0xA5,0x33,0x0C,0xF0,0xB3,0x27,0x02,0x5A,0x4A,0xFD,0x7F};
const uint8_t spOVER[] PROGMEM = {0x63,0x6F,0xC4,0x7A,0x1D,0xB5,0xED,0x61,0x37,0xBB,0x6E,0x75,0x62,0xD9,0x2D,0xEC,0xBF,0x56,0xAD,0x09,0xBA,0x32,0x8C,0x13,0xC7,0xD6,0xED,0x4D,0x85,0x86,0x99,0xE3,0x3E,0xB7,0x29,0x86,0x90,0x2C,0x76,0xDB,0xE6,0x98,0x95,0xBB,0x38,0x4F,0x5B,0x72,0x29,0xB4,0x51,0x6F,0x7D,0xAF,0x47,0xB9,0x73,0x71,0x8C,0x31,0x3F,0xE1,0xC9,0xA9,0x50,0xD6,0xFD,0xBA,0x27,0x57,0xC5,0x6E,0xCD,0xFD,0xFF};
//  ROM VM61004
const uint8_t spALPHA[] PROGMEM = {0x63,0xA9,0x21,0xB4,0x3C,0x16,0xAF,0xB6,0x84,0xD2,0x0A,0x5F,0xB3,0xAA,0xE2,0xDA,0x32,0xF4,0xCD,0x2A,0x93,0xDF,0x28,0xD7,0x27,0xAB,0xC8,0xE2,0x5B,0x93,0x57,0xAF,0xB2,0xD0,0x1B,0x0B,0xEE,0xB2,0xCA,0x24,0xAE,0xC3,0x28,0x4B,0xA9,0x0B,0xAF,0x0E,0x13,0x47,0x02,0xA8,0xA6,0x4C,0x00,0x4D,0x57,0x08,0xA0,0x99,0x0C,0x01,0x74,0xED,0xB1,0xEA,0x22,0xBA,0xD4,0xA9,0xCD,0xAA,0x2B,0xEF,0xD6,0xE0,0xBD,0x6B,0x69,0xAC,0x5A,0x83,0xF7,0xAE,0xB3,0xB1,0x6A,0x0B,0xDE,0x32,0xF6,0xA2,0x3A,0xC2,0x79,0x73,0xBD,0xF2,0xFD,0xFF};
const uint8_t spBRAVO[] PROGMEM = {0x02,0x10,0x2C,0x34,0xB4,0x46,0xAF,0xC8,0x8A,0xBD,0xD4,0x84,0xA9,0xE6,0x2D,0xFC,0x46,0x1D,0x7B,0x48,0x87,0x2A,0x5F,0x55,0x76,0x13,0xE9,0xBA,0x7A,0x97,0xBB,0x9C,0x55,0x69,0xA3,0xAB,0x48,0xD7,0xD5,0xB1,0x0F,0x63,0xF7,0xA1,0xE6,0x2A,0x3B,0x8E,0x65,0x0C,0xA9,0x52,0x55,0x56,0x8D,0xB6,0x92,0x6A,0x77,0xF1,0xBB,0xC6,0x86,0xB2,0x3A,0x44,0xFD,0x9C,0xDB,0x52,0x48,0xD7,0x38,0xB9,0xEF,0x7B,0xDD,0xC3,0xEE,0x7D,0x67,0xB0,0xF4,0x89,0x67,0xBC,0xFE,0x1F};
const uint8_t spCHARLIE[] PROGMEM = {0x06,0xD8,0x2D,0x2C,0x01,0x33,0xB7,0x67,0xA0,0xC5,0xC5,0x8D,0xC8,0xB2,0xB7,0x96,0x17,0xBF,0x26,0x87,0xF9,0x5A,0x91,0xF3,0xB0,0x1F,0x75,0x19,0x45,0xCE,0xCD,0x71,0xD4,0x65,0x54,0x39,0x8E,0xDA,0x71,0xB6,0xD1,0xC5,0x30,0xE9,0x6E,0x69,0xCB,0x5C,0x51,0x8F,0x15,0x66,0x49,0xFB,0x80,0x31,0xA2,0xE6,0x7D,0x9D,0x55,0xB6,0x59,0xD8,0xEA,0x71,0x0F,0xDE,0xCA,0xE5,0x9B,0xC7,0xD3,0x65,0x92,0x55,0x6C,0x2E,0xEF,0x30,0x49,0x92,0xB1,0x3A,0xBD,0xC3,0x04,0x72,0xE7,0xE6,0xF0,0x75,0xEB,0xA8,0x93,0xAB,0xFF,0x1F};
const uint8_t spDELTA[] PROGMEM = {0x0A,0x28,0x30,0x6C,0xAD,0xC3,0xA7,0xAA,0x70,0xD7,0xD5,0x76,0x5D,0x22,0xEE,0x5B,0x57,0xD9,0xF9,0xB8,0xA6,0x6D,0x59,0x65,0x16,0x9B,0xA1,0xDE,0x7B,0xD5,0x99,0x6D,0xA5,0x58,0xDE,0xD5,0x64,0x11,0x5D,0xC2,0x69,0xCA,0x30,0x25,0x5B,0x85,0x32,0x21,0x40,0x96,0x26,0x0E,0x58,0x4A,0x33,0x00,0x4B,0xB5,0xAD,0xAE,0x9A,0xF0,0x30,0xDF,0xB2,0xC7,0x31,0x35,0x55,0xE9,0x21,0x5D,0xFB,0x34,0xF6,0xAA,0xC6,0x3C,0xA5,0x73,0x3F,0xFE,0x1F};
const uint8_t spECHO[] PROGMEM = {0x2B,0x6F,0xB1,0xD9,0xD3,0x36,0xDF,0xF6,0x36,0xB7,0x26,0x85,0x08,0xE5,0x2E,0x22,0x1B,0x20,0x00,0x25,0xAC,0x2A,0x20,0xCF,0xD3,0x52,0x45,0x53,0x6A,0xA9,0x9E,0x4F,0x9B,0x54,0x47,0xB9,0xE4,0xDF,0xC3,0x1C,0xC6,0x98,0x45,0x65,0xBB,0x78,0x9F,0xCB,0x5C,0xD2,0xEA,0x43,0x67,0xB0,0xE5,0xCD,0x7B,0x38,0x9D,0xAD,0x2C,0x15,0x37,0xF1,0xFC,0x7F};
const uint8_t spFOXTROT[] PROGMEM = {0x04,0x18,0xB6,0x82,0x00,0xD3,0x57,0x08,0x60,0xBA,0xF4,0x91,0xC6,0x58,0x15,0xCA,0x8B,0x47,0x9A,0xFC,0x64,0x1A,0xAF,0x19,0x59,0x4A,0x9D,0xA1,0xFA,0x64,0x64,0xA9,0x65,0x86,0xE4,0xE2,0x91,0xA7,0xEE,0x99,0x92,0xAB,0x04,0xE0,0xA2,0x93,0x04,0x08,0x90,0x9D,0x33,0x03,0x9E,0x71,0x65,0xC0,0x4F,0x29,0x0A,0xF8,0xAD,0xD4,0x02,0x08,0x9C,0xA2,0x54,0x85,0x6A,0x80,0x00,0x86,0x21,0x57,0xC0,0x48,0x53,0x01,0x18,0x36,0xBC,0x65,0xA9,0x4B,0xAA,0x4B,0x9B,0xD6,0xC4,0xEE,0x11,0x41,0x6B,0xDB,0x94,0xEC,0x94,0x36,0xED,0x6D,0x4B,0x76,0x93,0x9E,0xFC,0xA5,0xED,0xD9,0x4D,0x58,0xEA,0x9A,0xBE,0xB7,0x2B,0xC5,0x76,0x4F,0x7F,0x14,0xFE,0xD8,0xCD,0x2B,0x7A,0xB2,0xFA,0x9B,0xF2,0x88,0xF0,0xAE,0x08,0x14,0xA1,0xDC,0x45,0x64,0x03,0x80,0x00,0x8E,0xE0,0x30,0xC0,0xB2,0x53,0xFF,0x0F};
const uint8_t spGOLF[] PROGMEM = {0x0A,0x88,0xA1,0x71,0x15,0x85,0x76,0x45,0x8A,0xFF,0x9B,0xDF,0x6C,0x65,0x99,0x5C,0xB7,0x72,0xDE,0x9D,0xED,0x72,0x77,0x73,0x6C,0x4B,0x54,0x35,0x63,0xE4,0xA6,0xEE,0xF9,0x34,0x57,0x94,0x39,0x63,0xE4,0x86,0x5F,0x04,0x98,0x34,0xDD,0x02,0x0E,0x98,0x32,0x5D,0x03,0x12,0xE0,0xC0,0xFF,0x03};
const uint8_t spHOTEL[] PROGMEM = {0x08,0xC8,0x4A,0x0C,0x01,0xC5,0x74,0x11,0xA0,0xCA,0xEA,0xD1,0x36,0x5A,0xDD,0x46,0xDE,0x56,0x55,0x49,0x76,0x07,0x79,0xDB,0xC5,0x28,0x0A,0xEE,0x6E,0x61,0xFF,0xBD,0xAC,0x0D,0x02,0x45,0x70,0x17,0x11,0xD9,0x00,0x02,0xE8,0x54,0x2D,0x00,0xD5,0x84,0x05,0x60,0x2A,0xB3,0x93,0x35,0x67,0x66,0x9C,0x6B,0x4E,0x56,0xBD,0x9B,0x6A,0xDD,0x39,0x59,0xF1,0xAE,0x6E,0xBD,0xF8,0x14,0xC5,0xA7,0x85,0xE5,0xE2,0x53,0x15,0xD5,0x9E,0x2E,0x9F,0xCF,0x50,0xE4,0xA6,0x07,0xBF,0x59,0x6B,0xC5,0x33,0x19,0xD8,0xA5,0x1C,0x89,0xCE,0x94,0x61,0x9B,0x74,0x7A,0xDD,0x13,0xC4,0x4B,0xFC,0xE9,0x4E,0xA7,0xAE,0x0A,0xA5,0xCD,0xFF,0x03};
const uint8_t spINDIA[] PROGMEM = {0xA3,0x9D,0xD6,0x99,0x32,0x17,0x8F,0x66,0x86,0x16,0x74,0x5F,0xB3,0x9A,0xE1,0x4A,0xC4,0xF4,0xCE,0xAE,0x46,0xD1,0x1D,0x5A,0x46,0x3A,0x99,0x45,0x2B,0xAA,0x82,0xAC,0x08,0x27,0xBE,0x5A,0xDD,0x0C,0x25,0x42,0xBC,0x7B,0xF5,0xD3,0x17,0x61,0xF8,0x96,0xDD,0xEF,0x61,0x2C,0xCD,0x8A,0x44,0xC6,0xE3,0xB1,0x57,0x1B,0x62,0x69,0xAF,0xC7,0x99,0x9C,0x7B,0x66,0x2C,0x6E,0x77,0xF6,0x69,0x11,0xF6,0xAA,0xBC,0x29,0xA4,0x87,0xDB,0xE7,0xF4,0xE5,0x14,0x1E,0x1A,0xAB,0xDD,0x9F,0x62,0x7A,0x68,0xAC,0xFA,0x7F};
const uint8_t spJULIET[] PROGMEM = {0x61,0x5D,0x96,0x49,0x34,0xD2,0x06,0x60,0xC7,0x90,0x0C,0x8C,0x66,0xF6,0x15,0x22,0x4D,0x37,0xAA,0x6A,0xC8,0x2C,0x6D,0xCD,0x28,0xB2,0x15,0x8B,0xE4,0x35,0xB3,0x68,0x79,0x51,0xE6,0xDA,0x9C,0xBE,0x15,0x43,0x89,0xF0,0xA2,0xDB,0x95,0x77,0xA7,0xA6,0x66,0x49,0x77,0xB1,0x9A,0x9E,0x0A,0xD5,0x75,0xEB,0xEE,0xF6,0xB0,0xC6,0xE6,0x83,0xD2,0xE3,0xEB,0x5E,0xD7,0xDA,0x5C,0x48,0x87,0x6D,0x9E,0x7B,0xDF,0xF3,0x89,0x40,0x11,0xCA,0x5D,0x44,0x36,0x00,0x38,0x60,0xEA,0x8C,0x00,0x2C,0xB3,0x6D,0x01,0x01,0x14,0x5F,0x8E,0x81,0xFF,0x07};
const uint8_t spKILO[] PROGMEM = {0x06,0xE8,0x12,0xD9,0x02,0x12,0x68,0xE1,0x8C,0x86,0xD4,0xF5,0x76,0xC6,0x33,0x1A,0xD1,0x74,0x4A,0x54,0x1E,0x6F,0x26,0x2B,0x5B,0xDC,0x42,0x93,0xB2,0xED,0x71,0x4D,0x95,0x7B,0x8E,0x53,0xDF,0xBD,0xAE,0xB5,0xB0,0xCC,0x2A,0xEE,0xBB,0xF7,0x76,0x26,0x53,0xD9,0x4A,0x7D,0xFB,0x59,0x6E,0x1F,0x2B,0x1B,0x75,0x4D,0xBC,0xE3,0x13,0xDE,0xA0,0xA6,0x32,0xC8,0xAF,0xFB,0x93,0x18,0xAF,0x20,0x7D,0xFF,0x0F};
const uint8_t spLIMA[] PROGMEM = {0x61,0x5A,0x90,0xBA,0xC0,0xD7,0xA6,0x69,0x00,0x19,0x85,0x6A,0xDA,0x9A,0xCD,0x24,0xD9,0xCC,0xCB,0x2A,0x46,0x76,0x66,0xF5,0x37,0x3B,0x9B,0xC9,0x48,0x7B,0x50,0xD4,0x8E,0xD9,0xBD,0xA8,0x75,0x6B,0xB3,0x62,0xEE,0xF4,0xB8,0xB5,0xAD,0xFD,0xE8,0x1B,0xAF,0xCC,0xA2,0xCE,0x7B,0xD8,0xFB,0x38,0xB3,0xDA,0xC8,0xD0,0x55,0xFD,0xA9,0x6F,0x7D,0xFF,0x1F};
const uint8_t spMIKE[] PROGMEM = {0x66,0x31,0x3C,0x7C,0x52,0xE3,0xC4,0x69,0xF5,0x85,0x57,0x86,0x51,0xAA,0xD3,0x56,0x75,0xA1,0x69,0x9D,0x6F,0x7D,0xCA,0x6A,0x57,0x23,0x6D,0xF5,0xCD,0x57,0xD1,0x4B,0x50,0x78,0x2C,0xDA,0x75,0x69,0x46,0x77,0xB4,0xCE,0xDB,0xB1,0x45,0xAD,0x08,0xE5,0x2E,0x22,0x1B,0x00,0x18,0xD0,0x3C,0x91,0x03,0x5A,0x09,0xB1,0x80,0x00,0xB2,0x13,0xFE,0x7F};
const uint8_t spNOVEMBER[] PROGMEM = {0x66,0x2D,0x02,0x62,0x4B,0xE3,0x8E,0xA5,0xEB,0x10,0x77,0x6E,0xB3,0xAA,0x2A,0x2A,0x39,0x74,0xCB,0x2A,0x0B,0xCB,0xB2,0xE4,0xAE,0xAB,0x4C,0xBC,0xDB,0x9C,0xFA,0xB6,0x2A,0x8A,0x29,0x33,0xEE,0x93,0xEA,0xA0,0xA6,0xC4,0xB9,0x55,0xE8,0x92,0xA8,0x54,0xA7,0xC4,0x6E,0x18,0x32,0xCC,0x54,0x2D,0xB7,0xB5,0xA9,0x72,0x53,0x51,0xBC,0xAA,0xE2,0x53,0x2C,0xB4,0xF5,0x2A,0x8A,0x2B,0xB5,0xD2,0xD5,0xAB,0x28,0xA6,0xD4,0xDA,0x5A,0xAF,0x22,0xFB,0x32,0x2B,0x4B,0xD3,0x8A,0x14,0xDC,0xDA,0xC8,0x4E,0xA9,0x52,0x24,0x6B,0x53,0xB9,0x6A,0xF0,0x51,0xB5,0x42,0xE9,0x31,0xC0,0x9B,0xB0,0x34,0xA7,0xA6,0xD4,0x85,0x6F,0xCA,0x5A,0xC2,0x0A,0x2E,0xE6,0x6B,0x67,0x89,0xC3,0xB4,0xD8,0x2F,0x5D,0x25,0x0D,0xD3,0x52,0xDF,0xF4,0x14,0xDF,0x44,0x47,0xFB,0xD2,0x53,0x72,0xA2,0x1E,0x75,0x09,0x4F,0x89,0x8D,0x7C,0xB4,0xE7,0xFF,0x01};
const uint8_t spOSCAR[] PROGMEM = {0x6B,0xC8,0xE2,0xB2,0x42,0x3A,0xDF,0xFA,0x16,0x27,0x4F,0xAE,0x7D,0xC4,0x17,0xB7,0x2C,0x45,0xAF,0xA4,0xB6,0x6D,0x80,0x03,0xD8,0x0C,0xF0,0xA7,0x9B,0x07,0x3C,0xE0,0x80,0xEB,0xB5,0x11,0x38,0x45,0xA9,0x0A,0xD5,0x00,0x02,0x34,0x75,0x65,0xB6,0xA6,0xAE,0xA2,0x34,0x6E,0xEA,0x8B,0x9B,0x24,0x13,0xA5,0xAD,0xCD,0xA9,0xC8,0x86,0xF3,0xCE,0x7E,0x8E,0x6D,0xC9,0xCD,0xB0,0x5A,0x7A,0xCF,0xAD,0xEE,0xF5,0x4C,0x77,0x89,0x83,0x3A,0xA9,0x37,0x7F,0xE1,0x2F,0xAD,0x48,0x87,0xB3,0xFC,0x3F};
const uint8_t spPAPA[] PROGMEM = {0x0A,0x28,0x56,0xB9,0xA5,0x45,0x55,0x84,0x49,0xCC,0x93,0x66,0xD7,0x19,0x26,0x4B,0x4E,0x96,0xDD,0x44,0xBA,0xAE,0xBE,0xD9,0xCC,0x10,0x28,0x42,0xB9,0x8B,0xC8,0x06,0x60,0x80,0xF1,0xE9,0xAB,0xCA,0xA6,0x23,0xD4,0x36,0xDF,0xE1,0x8C,0x55,0x74,0x86,0x6B,0x9F,0xB1,0x67,0xBD,0xE1,0xE6,0xBB,0xDB,0x97,0x53,0x45,0x88,0xCF,0xAE,0xDF,0xFF,0x03};
const uint8_t spQUEBEC[] PROGMEM = {0x0C,0x88,0x7E,0x8C,0x02,0xA5,0x0A,0x31,0xDD,0x5C,0xB2,0xAC,0x26,0x5B,0xCF,0x4C,0xEE,0xBB,0xBB,0xDE,0xA7,0xCD,0xA8,0xB4,0x75,0x4D,0x1C,0xB7,0xD1,0xD5,0x28,0xEE,0xE6,0x5B,0x76,0x7B,0x9A,0x1A,0xC4,0x33,0xF3,0xF1,0x6D,0x76,0x3F,0xE7,0xB6,0xB6,0xEC,0x12,0x91,0x9B,0xF2,0x8E,0x40,0x11,0xCA,0x5D,0x44,0x36,0x80,0x00,0x7A,0x2F,0x53,0x40,0x2D,0x24,0x14,0xF8,0x7F};
const uint8_t spROMEO[] PROGMEM = {0xA2,0xD5,0x39,0x38,0xCA,0xEC,0xDB,0xA5,0x4C,0xA1,0x98,0x5A,0xB9,0xF2,0xD3,0x47,0x6F,0xE9,0x69,0xCA,0x4E,0xDD,0x89,0x57,0x0E,0x69,0x3F,0x45,0x61,0xD9,0x95,0x98,0x65,0x67,0x25,0x6B,0x86,0x64,0x4C,0xAC,0xF5,0xE2,0x54,0xCD,0x86,0x7A,0xD0,0xE6,0x35,0x4C,0xD7,0x02,0xA5,0x7B,0xF6,0xB0,0xA7,0xBD,0xAC,0xB5,0xAA,0x54,0x1D,0xDB,0xB2,0xF6,0xEC,0xC3,0xD3,0x64,0x73,0xD9,0x63,0xC8,0x2C,0xD5,0xDF,0xE9,0x0C,0xA1,0x33,0xD8,0xF2,0xE6,0x33,0x5E,0xEE,0x09,0xB6,0xB2,0x54,0xDC,0xF8,0xE7,0xFF,0x01};
const uint8_t spSIERRA[] PROGMEM = {0x0C,0xF8,0xAD,0x54,0x03,0x06,0xF8,0x2D,0xD5,0x01,0xBF,0x94,0x39,0xE0,0xE7,0x32,0x0B,0xB4,0xAC,0x3B,0x25,0x75,0x5F,0xBD,0x8A,0x11,0x0D,0x39,0x63,0xF5,0x28,0x47,0x34,0xE0,0xEA,0x4D,0xA3,0x1A,0x49,0x91,0xBB,0x56,0x8D,0x7A,0x78,0x45,0xD9,0x7C,0xB2,0x9A,0xE1,0x9C,0x78,0xE2,0xF1,0x69,0x86,0x09,0x92,0xB1,0xD7,0xA7,0x6E,0x2E,0xD9,0xC7,0x5E,0x9F,0xBA,0x84,0xE4,0x1C,0x79,0xBD,0xAA,0xD4,0xC4,0xB2,0x79,0xCD,0xA8,0x53,0x97,0xF0,0xA6,0x3C,0xA3,0x4B,0x53,0xC3,0x9A,0xF2,0x8C,0x31,0x55,0x0B,0x1D,0xEA,0xB3,0xF6,0x14,0x3D,0x2D,0x35,0xCF,0xD9,0xB3,0x1B,0xF3,0xD0,0x3E,0xEB,0x2C,0x7A,0xDC,0x53,0x36,0x8F,0x2B,0xC5,0xD6,0x70,0x7F,0xD5,0x9E,0x14,0xDB,0xC2,0x7C,0x55,0xF9,0x72,0x4C,0x2F,0xF1,0x97,0xE9,0xCF,0x6A,0xB5,0xC2,0x76,0x96,0x3F,0x87,0xD2,0xD2,0x58,0xF9,0xFF};
const uint8_t spTANGO[] PROGMEM = {0x0E,0xD8,0x5C,0xCD,0x03,0x2B,0x2A,0xD9,0xD4,0x23,0x2B,0xAD,0xB4,0x26,0x57,0x8F,0x58,0xB2,0xB2,0x56,0x5C,0x2D,0x63,0xF6,0xCA,0x5A,0x36,0xF5,0xCC,0x59,0x2B,0x6B,0x91,0xB5,0xDB,0x42,0xB7,0xBC,0x5A,0xEA,0x34,0x57,0x5D,0xCA,0x62,0x68,0x5C,0x55,0xB5,0xAB,0xA3,0xA2,0x09,0x13,0xA7,0x65,0xA8,0x2A,0x98,0x53,0x56,0x8F,0xA9,0xB2,0x30,0x19,0xDD,0xB3,0xA6,0x22,0xCB,0xA4,0xB4,0xEB,0x18,0xB3,0xEA,0x90,0x92,0x2E,0x6D,0x0D,0xBE,0xC3,0x52,0x3A,0xA7,0x23,0xC4,0x0A,0x4B,0xD9,0x5B,0xAE,0x50,0x32,0x3C,0xA4,0x73,0xF8,0x42,0x0B,0x37,0x93,0xD5,0xE6,0xF3,0x35,0xDD,0x95,0x7F,0xAB,0xCF,0x87,0xF2,0x34,0xDE,0xF7,0xFF};
const uint8_t spUNIFORM[] PROGMEM = {0x61,0x3D,0x56,0x98,0xD4,0xB6,0xE6,0xA5,0x8D,0xC7,0xA8,0x01,0xC5,0xDA,0x33,0x2C,0x97,0x06,0x12,0xD9,0x4F,0xD9,0x6D,0x30,0xA6,0x65,0xDF,0x79,0x4B,0x8B,0x11,0xCF,0xE0,0xAE,0x29,0xCD,0x4E,0x5D,0x38,0xEA,0xF5,0xF4,0x64,0x45,0x47,0x84,0xCA,0xE6,0x5D,0xF5,0x96,0x01,0xCD,0x97,0x6A,0x40,0x03,0x1A,0x28,0x5D,0xD0,0xDB,0x61,0xEC,0x7D,0xF7,0x7B,0x3C,0x53,0x16,0xDB,0x9A,0xEA,0xF5,0x2E,0x6B,0x2D,0x6A,0x43,0x46,0xBC,0xCD,0xB3,0x3D,0xD9,0xB5,0xDA,0x70,0xDF,0x72,0xE7,0x94,0xEA,0xCD,0x9D,0xDD,0x9D,0xBC,0x73,0xA9,0x28,0x35,0x4F,0x12,0x41,0xE1,0x96,0xD4,0x3D,0x4D,0x24,0xA7,0x8A,0x94,0xF8,0xFA,0x37,0x7C,0xCD,0x76,0x78,0x50,0xEA,0xF8,0xFD,0x3F};
const uint8_t spVICTOR[] PROGMEM = {0x6E,0x6E,0x52,0x55,0xCD,0xDD,0xA8,0xAD,0x72,0x55,0x95,0x70,0xE3,0xB6,0xE9,0xDD,0xD4,0x84,0x4E,0xD9,0xA6,0x4B,0x0B,0x65,0xA5,0x2B,0x6D,0x2E,0x4D,0x42,0xB6,0xAC,0xAC,0xDB,0x12,0x49,0x5D,0xBD,0xF2,0x1E,0x02,0x2D,0x6C,0x35,0x30,0xA0,0x72,0x46,0x04,0x4E,0x51,0xAA,0x42,0x35,0x00,0x40,0x01,0x33,0x49,0x3A,0x60,0x5A,0xF1,0x32,0x96,0x6C,0x2C,0x2D,0x5D,0xDA,0x9C,0x63,0x21,0x9F,0xE6,0x2F,0x5B,0x29,0x4D,0xBC,0x94,0xAF,0xED,0xA5,0x34,0xF1,0x72,0xB6,0x74,0x94,0xBA,0x82,0xC3,0xFE,0xCB,0x59,0x46,0x93,0x34,0xE5,0x2B,0x57,0xE9,0x85,0x5A,0xE2,0xC7,0xDD,0xE5,0x0A,0xA7,0x4B,0xA7,0xFF,0x07};
const uint8_t spWHISKEY[] PROGMEM = {0x04,0x88,0xAE,0x8C,0x03,0x12,0x08,0x51,0x74,0x65,0xE9,0xEC,0x68,0x24,0x59,0x46,0x78,0x41,0xD7,0x13,0x37,0x6D,0x62,0xC3,0x5B,0x6F,0xDC,0xD2,0xEA,0x54,0xD2,0xE3,0x89,0x01,0x7E,0x2B,0xF7,0x80,0x07,0x14,0xD0,0xE5,0x15,0x38,0x60,0x8C,0x70,0x03,0x04,0x29,0x36,0xBA,0x5E,0x14,0x34,0x72,0xF6,0xE8,0xA7,0x6F,0x82,0xF4,0x2D,0x73,0xEA,0x47,0x3A,0x67,0x6A,0xC0,0xF0,0x2F,0xF1,0x4E,0xCF,0xA8,0x8A,0x1C,0xB9,0xD8,0xFF,0xEE,0x1F,0xBB,0x59,0xD0,0xD6,0xFE,0x3F};
const uint8_t spXRAY[] PROGMEM = {0xAB,0xAA,0xDE,0xB4,0x62,0x66,0x9F,0xA2,0x75,0x73,0xD3,0x6E,0x72,0xB2,0x56,0x54,0xCB,0xBA,0xB6,0x01,0x92,0xC7,0x26,0x40,0x4B,0x43,0x0C,0xC8,0x29,0xC5,0x01,0xCF,0xB8,0x1A,0xE0,0xA7,0x14,0x07,0xFC,0x56,0xEA,0x01,0x05,0x98,0x60,0x5A,0xEA,0xD4,0x29,0xB5,0xB8,0xEB,0x68,0x53,0x17,0xB3,0x96,0x6E,0xA3,0x2F,0x29,0x54,0x5B,0xF6,0x8D,0xB5,0xA9,0x32,0x5E,0xDB,0x37,0xB6,0xA1,0xDB,0xB1,0x74,0xCB,0x58,0xBA,0x49,0x91,0xF6,0xCD,0xE3,0x1A,0x3A,0x85,0x3A,0x56,0xB7,0x6B,0x98,0x62,0xEA,0xF8,0xDC,0xBE,0x9E,0x83,0xD4,0xE3,0x49,0xF8,0x7B,0x71,0x54,0xAF,0xD9,0xE1,0xEF,0x53,0x55,0xB8,0xE7,0xFE,0x3F};
const uint8_t spZULU[] PROGMEM = {0x6D,0xFE,0xDE,0xC4,0xC4,0xE8,0x29,0x60,0x00,0x2E,0x0F,0x9C,0x6C,0x29,0x71,0x2A,0x4E,0x77,0x93,0x15,0x77,0x2A,0xAE,0xC3,0xCE,0x76,0x3C,0x92,0xA5,0x44,0x78,0xD1,0x6D,0xCF,0x47,0x3B,0xB8,0xBB,0x07,0xF6,0x5B,0x43,0x91,0x6E,0xA9,0xF2,0x65,0x4C,0xC9,0x98,0x97,0x69,0x9F,0xBA,0xE5,0x33,0x9C,0xC1,0x9A,0x8F,0xCA,0xDE,0x70,0x07,0x9D,0xEE,0xC9,0x79,0xE2,0xED,0xFF,0xFF,0x07};
// const uint8_t spAFFIRMATIVE[] PROGMEM = {0xA5,0x4F,0x7A,0xD3,0x3C,0x5A,0x8F,0xAE,0xC8,0xA9,0x70,0xED,0xBD,0xBA,0x2A,0x3B,0xC3,0xD9,0x8F,0x00,0x6C,0x4A,0x21,0x40,0xD3,0xCA,0x08,0x18,0xC2,0x04,0x01,0xC3,0x86,0x11,0x60,0xDA,0x4C,0x05,0x54,0x53,0xDA,0x9C,0x58,0x16,0xED,0xC8,0xEB,0x88,0xE2,0x4C,0xEC,0xC1,0x36,0x23,0xC8,0x65,0xD1,0x17,0xBA,0xB4,0x20,0xE5,0xE4,0x6A,0x8A,0x53,0xA2,0xAC,0x0B,0x73,0x38,0xC9,0xC8,0xB2,0x68,0xCE,0x92,0x24,0x33,0x5B,0x45,0xB1,0xA9,0x11,0xB6,0x6A,0x75,0x4D,0x96,0x98,0xC7,0xAA,0xD6,0x37,0x91,0xEC,0x12,0xAF,0xC8,0xD1,0xB1,0x88,0x97,0x25,0x76,0xC0,0x96,0x22,0x01,0xF8,0x2E,0x2C,0x01,0x53,0x99,0xAD,0xA1,0x7A,0x13,0xF5,0x7A,0xBD,0xE6,0xAE,0x43,0xD4,0x7D,0xCF,0xBA,0xBA,0x0E,0x51,0xF7,0xDD,0xED,0x6A,0xB6,0x94,0xDC,0xF7,0xB4,0xB7,0x5A,0x57,0x09,0xDF,0x9D,0xBE,0x62,0xDC,0xD4,0x75,0xB7,0xFB,0xAA,0x55,0x33,0xE7,0x3E,0xE2,0x2B,0xDC,0x5D,0x35,0xFC,0x98,0xAF,0x79,0x0F,0x0F,0x56,0x6D,0xBE,0xE1,0xA6,0xAA,0x42,0xCE,0xFF,0x03};
// const uint8_t spNEGATIVE[] PROGMEM = {0x66,0x88,0x82,0x3A,0xDD,0xE3,0x84,0x31,0x4B,0x6C,0x0F,0x4F,0x9C,0x86,0xAA,0xA0,0x3D,0xB5,0xF1,0xEA,0xBA,0x33,0x71,0xB5,0x59,0xAB,0x1A,0x36,0x55,0x43,0x57,0xAF,0x72,0xF8,0x52,0x4D,0xDD,0xB2,0xF2,0x91,0x92,0x34,0x64,0x75,0xA9,0x9B,0x31,0x8A,0x94,0x4A,0xA3,0x1E,0x3E,0x41,0x4A,0x56,0xAF,0xB6,0x59,0xC3,0x08,0x5F,0xBD,0xBA,0x6A,0x9C,0xD3,0x7C,0x95,0x9A,0x9D,0xF2,0x28,0x8F,0x06,0x68,0x19,0x4C,0xD8,0xCC,0x6C,0x39,0x60,0x28,0x93,0x00,0x5C,0x19,0xD6,0xCA,0x6A,0x9D,0x5C,0x6B,0xD1,0x18,0x8A,0x31,0xC9,0xA8,0x45,0x63,0xCB,0x3A,0x38,0x2B,0x17,0x95,0xA7,0x04,0x95,0xD0,0x99,0x5D,0x9E,0xE2,0x55,0x43,0xE7,0x75,0x79,0xB3,0x35,0x0D,0xCF,0x55,0xEE,0xCB,0x5E,0x2D,0x38,0x36,0x89,0x3F,0x07,0x33,0x63,0xE9,0x82,0x80,0x60,0x35,0x08,0x50,0x5D,0x2A,0x02,0xAA,0x4D,0xFB,0x7F};
const uint8_t spMAYDAY[] PROGMEM = {0x66,0xB7,0x52,0x7A,0xCC,0x9D,0x84,0xDD,0x4B,0xA9,0x36,0x77,0x12,0x96,0xC8,0x54,0x27,0x2C,0x5E,0x1A,0x8A,0x10,0xEE,0xB4,0x78,0xAB,0xE9,0xD1,0x4C,0x43,0x57,0xAF,0xA2,0x27,0x57,0xF1,0x58,0xB5,0xD2,0x91,0x82,0xCC,0x73,0xF1,0x4A,0x46,0x76,0xB4,0xA8,0x25,0x2B,0x1E,0xCD,0x50,0xBD,0x66,0xAF,0x78,0x24,0x26,0xF5,0x6E,0xBC,0x63,0x02,0x14,0x18,0xD6,0xFA,0x63,0xD3,0xD4,0x39,0xE6,0xAA,0xBB,0x57,0x36,0xA9,0xC5,0xA7,0x6D,0x5E,0xD9,0xAD,0x97,0x9C,0xA1,0xB9,0x60,0x8B,0x58,0x7D,0xC6,0xEE,0x92,0x2D,0x7C,0xCB,0x99,0xBB,0x29,0xD6,0xF2,0xCD,0x77,0x19,0xEB,0xD4,0x25,0x5C,0xB6,0x79,0x6C,0x3D,0x26,0x69,0xF8,0xAA,0xB4,0x57,0x63,0x14,0x93,0x0B,0xD3,0xD9,0x93,0x92,0x45,0xAE,0x49,0xF7,0xB0,0x81,0x32,0xB9,0x38,0xDD,0xCD,0x28,0xE6,0xD4,0xA2,0xF4,0x34,0x69,0xD8,0x5B,0x8B,0xC2,0xDB,0xAB,0x90,0x7B,0xAD,0x36,0x6F,0xEF,0x22,0xA6,0xD5,0xF8,0xFF,0x01};
const uint8_t spWARNING[] PROGMEM = {0x6A,0x15,0x71,0x5C,0xDC,0x23,0x89,0x8D,0xD5,0x36,0xB5,0x8C,0x2D,0x36,0xDA,0xC6,0xCC,0xDD,0x91,0x5A,0xB9,0xBF,0x51,0xC7,0xCC,0x69,0x76,0x6A,0xA6,0x12,0xD2,0xB6,0xCE,0xDB,0x6B,0x0F,0xCC,0xBA,0xAA,0x10,0x2E,0xBC,0x29,0xED,0x2A,0xA2,0x5B,0xF3,0xA5,0x2C,0x2B,0x4F,0xA9,0x25,0x9A,0xBC,0xAE,0xBC,0x74,0xD3,0xF0,0x70,0xD6,0x8A,0xE4,0xC4,0x8A,0x3D,0xEE,0x6A,0x9B,0x57,0x35,0x8F,0xD4,0x6B,0xE8,0x3E,0xD8,0x22,0x16,0xAE,0x71,0xF8,0x20,0x4D,0x5F,0xB4,0xE6,0xE1,0x83,0xB4,0x7C,0xD6,0x58,0x46,0x0A,0x94,0xF1,0x99,0x73,0x09,0x47,0xAF,0x28,0x9D,0x16,0x34,0x1C,0xD5,0x61,0xA5,0xAA,0x13,0x73,0x65,0x43,0x15,0xE2,0x71,0xD2,0x95,0x0D,0x67,0x72,0xD8,0x4E,0x77,0xB1,0x5C,0xCE,0xEE,0xA4,0x3C,0x2D,0xBA,0xA4,0x5A,0xE5,0xF2,0x74,0x57,0x6C,0xA9,0xAB,0xFE,0x1F};
const uint8_t spICING[] PROGMEM = {0x69,0xCA,0x66,0xDD,0xD3,0x16,0xEF,0x71,0x0D,0xC5,0xAC,0x66,0xDB,0xA3,0xD5,0x57,0x57,0xDC,0x6D,0xB7,0x56,0xDB,0xA2,0x63,0x87,0x5F,0x5E,0x55,0xCB,0x4C,0x69,0x35,0xBB,0xD5,0x87,0x17,0xB3,0x66,0x57,0x03,0x3C,0xE3,0x6A,0x80,0x9F,0x52,0x1C,0xF0,0x5B,0xA9,0x07,0x02,0xF0,0x5B,0xEA,0x9A,0xBB,0x0A,0xD1,0xB4,0xC7,0x6B,0xEE,0x2E,0x44,0xCB,0x17,0x97,0xBD,0x67,0x63,0x2F,0x9F,0x94,0x8E,0x16,0x29,0xDA,0x2D,0x4E,0x3A,0xAB,0xE1,0xF2,0xD0,0xD8,0xE9,0x6A,0x86,0x33,0xCC,0x9C,0xA4,0xBB,0x19,0xCE,0x54,0xB5,0xE3,0x9E,0x6A,0x35,0x52,0x2D,0xB6,0x7A,0xBB,0x53,0x2D,0x09,0xBB,0xFF,0x0F};
const uint8_t spDANGER[] PROGMEM = {0x0A,0x28,0x30,0x6C,0xD4,0xC7,0x54,0x19,0xAA,0x9B,0xD5,0x34,0x6B,0xCA,0xEE,0x6B,0x56,0xDD,0xBD,0xA9,0x44,0xAC,0x59,0xD5,0x08,0xC1,0x9C,0xB1,0x7A,0x65,0x33,0x24,0x72,0xE7,0xAC,0x95,0x8C,0x64,0xE0,0x13,0x95,0x57,0xD4,0xBD,0x50,0x8D,0x45,0x19,0x51,0xB3,0x98,0x61,0xAE,0x64,0xA4,0xCD,0x60,0x94,0x85,0xD2,0x90,0x47,0x41,0x35,0xEA,0xEA,0x5A,0x73,0x4A,0x99,0xA0,0x38,0x09,0xC0,0x76,0x42,0xA3,0x9C,0xDA,0x94,0x35,0xF2,0x8C,0xB1,0x66,0x25,0x0D,0xDB,0x3C,0x86,0x9A,0x4B,0xA0,0x35,0xFB,0x98,0x4B,0x72,0xE2,0xB3,0x6C,0x6D,0xCB,0x43,0xC8,0x47,0xF2,0xA5,0x23,0x6F,0x21,0x6F,0xCE,0x16,0x8E,0xBC,0x89,0x2B,0xB5,0x6F,0x38,0xCB,0x32,0xD2,0x96,0x6C,0xEE,0x2C,0xDB,0x48,0x5B,0xF2,0xB9,0xAB,0x2C,0x11,0x2F,0xEE,0x1D,0xEE,0x52,0x07,0x25,0x43,0xFB,0xFF,0x03};
const uint8_t spEMERGENCY[] PROGMEM = {0xA3,0x5B,0xCE,0x18,0x23,0x9F,0xAC,0x76,0x79,0x13,0x88,0x7C,0xB2,0xAA,0x19,0x8C,0x21,0x72,0xF5,0xAA,0x5A,0x50,0xD2,0xB0,0xD5,0xA9,0x76,0x52,0xB2,0x53,0xAD,0x95,0x26,0x72,0xD5,0x1A,0x8D,0xD6,0xDA,0x24,0xC5,0x22,0xC2,0x5E,0xAB,0x93,0xD6,0xB0,0x54,0xA5,0xAB,0x88,0x31,0xCD,0x93,0x92,0xAD,0x3C,0xDB,0x56,0x59,0xF6,0xB6,0x92,0x5C,0x83,0x6C,0x30,0xEB,0x0A,0x4A,0x5D,0xC6,0x45,0xAF,0x23,0xA8,0x53,0xC8,0xC2,0xF2,0xAA,0x24,0x3B,0x12,0xD3,0x6E,0xED,0xF2,0xB3,0x0C,0x99,0xDD,0x4B,0x00,0xB6,0x13,0x3A,0xE5,0xD4,0xA6,0xAC,0x91,0xE7,0x54,0xC3,0xA4,0xA1,0xE9,0xB6,0xD3,0x4E,0x19,0x46,0xA1,0xFD,0x46,0x3B,0xB9,0x8A,0x8E,0xB4,0x29,0x43,0x15,0xC2,0x93,0x1C,0xBD,0x8C,0x45,0xB0,0x8D,0x71,0xBD,0x36,0x6D,0xA6,0xA6,0xA2,0x69,0x0D,0xF0,0x8C,0xAB,0x02,0x7E,0x4A,0x31,0xC0,0x6F,0xA5,0x16,0x18,0x55,0x37,0x2E,0xEA,0xFE,0x65,0x0C,0x43,0xBB,0x50,0xFA,0x96,0x36,0x4E,0x93,0x82,0xE5,0x7B,0xDB,0x32,0x94,0x33,0x6E,0xFC,0x19,0xDB,0x74,0xC1,0x58,0xB1,0xA6,0xEC,0xCB,0x17,0x43,0xFA,0x9A,0x70,0x0C,0x6F,0x60,0x55,0xAB,0xFF,0x1F};
const uint8_t spROGER[] PROGMEM = {0x62,0x11,0xBD,0xD8,0x32,0x95,0xAA,0x99,0xD7,0x26,0x8F,0xB0,0xAB,0x26,0x3E,0x9C,0x2B,0x4D,0x9D,0x1A,0xD5,0x74,0xCA,0x30,0x65,0x61,0x74,0x4D,0x25,0x32,0x98,0xB7,0x36,0x0C,0x71,0x4B,0xD3,0xBE,0xEA,0x98,0x3A,0xCC,0xAD,0xCF,0x2A,0x92,0x1F,0x6F,0xB1,0x2D,0x2B,0x4F,0x7E,0xAC,0xDC,0x36,0xAD,0x38,0xE7,0xD4,0x70,0xDF,0xB4,0xE2,0x52,0x2C,0x54,0x3D,0x53,0x28,0xB2,0xA4,0xF0,0x72,0x57,0xA5,0x5E,0xAD,0x83,0xD9,0x64,0x23,0x60,0x7B,0x93,0x08,0x8C,0x7E,0x44,0x17,0x72,0xF3,0xDB,0x86,0x92,0x85,0xAD,0x7D,0x57,0x1B,0x6B,0x1E,0xA6,0x0C,0xFD,0xE5,0x2C,0x53,0x31,0x5A,0xF3,0xA6,0x3B,0x37,0xA1,0x6C,0xCD,0xE2,0xEE,0x9C,0x8D,0xDD,0x37,0xE9,0xFF,0x03};
const uint8_t spHERTZ[] PROGMEM = {0x08,0x28,0xA6,0x4B,0x00,0x55,0x56,0x23,0xA0,0x9A,0x99,0x12,0xE7,0x12,0x18,0xC3,0x5D,0x56,0x52,0xED,0x29,0xAC,0xE9,0xDF,0xD9,0xAE,0xE7,0x18,0xD6,0x5A,0x12,0xAC,0x34,0x1F,0x02,0xA7,0x28,0x55,0xA1,0x1A,0x00,0x08,0xD8,0x26,0x94,0x01,0xBF,0x95,0x71,0xC0,0x02,0x16,0xD0,0x80,0x07,0x34,0xC0,0x01,0x0E,0xFC,0x3F,0x08,0x9C,0xA2,0x54,0x85,0x6A,0xC0,0xFF,0x03};
const uint8_t spSECURITY[] PROGMEM = {0x02,0xF8,0x59,0xC8,0x00,0xBF,0xB7,0x18,0xE0,0x97,0xB4,0x00,0xFC,0x1E,0xD6,0xA2,0x1F,0xCB,0x44,0x9D,0xDD,0xAA,0xA7,0x0C,0xE1,0xD4,0x2D,0xAB,0x1E,0xB6,0x10,0xCB,0xB6,0x20,0x70,0x8A,0x52,0x15,0xAA,0x01,0x06,0x98,0x36,0xC2,0x01,0xD3,0x09,0x07,0x60,0x96,0xB6,0x91,0xF4,0x98,0x84,0xA9,0x5D,0x46,0x51,0x6D,0x11,0xB7,0xF4,0x1D,0x79,0xD1,0x2D,0x3C,0xDC,0x77,0xE4,0x39,0x34,0xCB,0x88,0xDF,0x51,0xE4,0x98,0x64,0xAD,0x7E,0x47,0x5D,0x42,0xB2,0x45,0xFA,0x29,0x43,0x0D,0xEE,0x8A,0xE1,0xD5,0x01,0x83,0xAB,0x39,0x20,0x03,0xF7,0x35,0x34,0xAF,0x64,0x9A,0xAF,0xC6,0x38,0x8C,0xA3,0x54,0xAC,0x2E,0xCB,0xF0,0x8E,0x14,0xB9,0xB9,0x2E,0x7E,0xFD,0x7F};
const uint8_t spTARGET[] PROGMEM = {0x0A,0xD8,0x5C,0x4D,0x03,0x25,0x8D,0xA9,0x24,0x5A,0x52,0xB6,0x22,0x85,0x31,0x1F,0xDC,0xD2,0xF2,0xB4,0x4C,0xDB,0xE5,0xCA,0xC8,0x52,0x0B,0xEE,0xA6,0xC7,0x2D,0xCF,0x53,0x69,0x43,0x6E,0xA5,0xBA,0x94,0x80,0x2A,0xAA,0x65,0xFA,0x1C,0x88,0x36,0x23,0x51,0x1B,0xEB,0x30,0xF4,0xB0,0x36,0x6B,0xA8,0x51,0x24,0x3D,0xD6,0xAC,0xA1,0x84,0x44,0x4F,0x7F,0xD4,0xE6,0x41,0x46,0x70,0x62,0x23,0x02,0xA7,0x28,0x55,0xA1,0x1A,0x00,0xA0,0x80,0x21,0xDD,0x18,0xB0,0xB9,0xDA,0xFF,0x03};
const uint8_t spVECTORS[] PROGMEM = {0x6A,0x4B,0x3C,0xC5,0x34,0xD2,0x98,0xBD,0x50,0x77,0x91,0x4C,0xAA,0xF6,0x42,0x2C,0xD8,0xD2,0x8D,0x39,0x2A,0x33,0x13,0x75,0x35,0xEE,0xEC,0xDC,0x44,0x45,0x1D,0x8F,0x2C,0xDB,0x10,0xF3,0xC8,0xB4,0xDA,0x6A,0xC3,0x34,0xBD,0xCF,0x6A,0x6A,0x48,0xF1,0xF0,0xCD,0xBB,0x41,0xE0,0x14,0xA5,0x2A,0x54,0x03,0x18,0x50,0x39,0x23,0x02,0xA7,0x28,0x55,0xA1,0x1A,0x90,0x80,0x65,0xD5,0x57,0xD1,0x4C,0x2A,0x66,0x64,0x1D,0x65,0xC9,0x49,0xDC,0x9A,0xAF,0x95,0xA5,0x18,0x5A,0x49,0xDF,0x56,0xD4,0xA2,0xE8,0x61,0xDD,0x5A,0xD1,0x82,0x93,0x6A,0x64,0x55,0xC0,0x53,0x00,0x0A,0x78,0x04,0x38,0x00,0x9B,0xA2,0x30,0xA0,0x60,0xB1,0xFF,0x07};
const uint8_t spLIGHT[] PROGMEM = {0x69,0x18,0x44,0xD2,0x83,0xB2,0x95,0x69,0x63,0x1A,0x17,0x49,0xD7,0xA6,0x85,0x78,0x5D,0xD5,0xFB,0x1A,0x33,0xDF,0x76,0x97,0x2D,0x6B,0x68,0x6C,0x4A,0x53,0xF7,0xAC,0xA9,0x89,0x71,0x2D,0xDD,0x33,0xA6,0x26,0x9B,0xAD,0x6D,0x77,0x5B,0x7A,0x70,0xF4,0xC8,0x45,0xE1,0x69,0x8E,0xA9,0x6B,0x6E,0x89,0x62,0x78,0x45,0x8D,0x7C,0x8C,0xC0,0x29,0x4A,0x55,0xA8,0x06,0x06,0x01,0x0C,0x30,0xA4,0x9B,0x02,0x36,0x57,0x43,0xE0,0x14,0xA5,0x2A,0x54,0xE3,0xFF,0x01};
const uint8_t spFRONT[] PROGMEM = {0x08,0x88,0xDC,0x95,0x01,0x55,0x86,0x2A,0xA0,0x85,0x76,0x05,0xD4,0x90,0x4E,0x00,0x33,0xA9,0x47,0x19,0xBB,0xB4,0x9B,0x7B,0x5B,0x55,0xC8,0xDE,0xE6,0x91,0x65,0x55,0x29,0xB4,0xA5,0xD9,0xE2,0x55,0xE7,0xD0,0x1A,0xEE,0xB3,0x57,0x97,0x53,0x6A,0x78,0xCE,0x69,0x53,0x8A,0x1E,0x1A,0xD5,0x28,0x1C,0x59,0x89,0x27,0x87,0x6D,0x77,0x17,0x25,0x1E,0x62,0x99,0x11,0x38,0x45,0xA9,0x0A,0xD5,0x00,0x50,0xC0,0x90,0x6E,0x0C,0xD8,0x5C,0x0D,0x81,0x53,0x94,0xAA,0x50,0x8D,0xFF,0x07};
const uint8_t spWAY[] PROGMEM = {0xAC,0xE7,0x7E,0xC2,0xD4,0x1C,0xAB,0x8D,0xC7,0x31,0xB5,0xB0,0xAD,0x76,0x91,0xD6,0x8D,0x2D,0x71,0x58,0x4D,0x59,0x67,0x91,0xB5,0x6B,0xC8,0xB2,0x3D,0x9C,0xB6,0xAD,0xA1,0xE9,0xE4,0x48,0x7E,0xB3,0xDA,0x96,0x8D,0x2D,0x6D,0xF5,0xAA,0x7B,0x32,0xD2,0xCC,0xD5,0xAB,0xEE,0xC9,0x51,0x33,0x17,0xAF,0xBA,0x87,0x00,0x8B,0x5C,0x3C,0x9B,0xFF,0x07};
const uint8_t spGLIDE[] PROGMEM = {0x08,0x28,0xBD,0x94,0x8D,0x52,0x45,0xAE,0x93,0x1B,0xB3,0x07,0x5F,0x66,0x66,0xAE,0xC6,0xDC,0xB1,0x8E,0xA9,0xA4,0x9B,0xF3,0x6A,0x1B,0x8E,0x0D,0xE6,0xB6,0xAB,0xAD,0xBC,0x3B,0x8C,0xFA,0xAE,0x36,0xCB,0x2D,0x35,0xD9,0xBC,0xBA,0x22,0x36,0x2D,0x64,0xF3,0xEA,0x8B,0x3C,0xD7,0xD2,0xCD,0x6B,0x2C,0xEA,0x4C,0xDB,0x57,0xAD,0x35,0xDB,0x15,0x2F,0x5B,0xB4,0xB6,0x62,0x46,0xB2,0x6C,0xD1,0xD8,0xB3,0x69,0xA9,0xB6,0x95,0xE3,0x2A,0xC1,0xB4,0x23,0x67,0xB7,0x2B,0x5B,0xD7,0xAD,0xBC,0x59,0xAE,0x92,0x28,0x22,0xA7,0x72,0xBA,0x8A,0x17,0xAE,0xEA,0x49,0xEA,0xF2,0x3C,0xAD,0x22,0x2D,0x93,0xD3,0x93,0x88,0x2E,0x57,0xC2,0xCE,0x46,0x94,0x5D,0x33,0x49,0xAA,0xBA,0x35,0x76,0xF3,0x4D,0xFF,0x0F};
const uint8_t spOPEN[] PROGMEM = {0xA9,0x28,0xC4,0x77,0x84,0xB2,0xB4,0xB2,0x11,0x99,0x35,0xCC,0xDA,0xAA,0x4E,0x78,0xD6,0x31,0x4B,0xAB,0x0B,0xB6,0x2D,0xC5,0xCE,0xAE,0xCD,0xC2,0x5D,0xC3,0x1D,0x23,0x70,0x8A,0x52,0x15,0xAA,0x01,0x08,0x10,0xC3,0x6C,0x0D,0xD9,0xA4,0x5B,0xC8,0xD6,0xB5,0x66,0x13,0xE6,0xE9,0x6B,0xC6,0x5E,0x95,0x5B,0x84,0xAD,0x29,0x67,0x53,0xAC,0x15,0x62,0x37,0x3D,0x5D,0x29,0x67,0x49,0xD4,0xF4,0x0C,0xAB,0x94,0x21,0x56,0xD3,0x3B,0x8C,0x48,0x98,0xC5,0x4D,0x5F,0xE7,0x26,0xE1,0x16,0xC7,0x7D,0x4D,0x73,0x84,0xBA,0x9D,0xFF,0x07};
const uint8_t spLIGHTS[] PROGMEM = {0x69,0x18,0x44,0xD2,0x83,0xB2,0x95,0x69,0x63,0x1A,0x17,0x49,0xD7,0xA6,0x85,0x78,0x5D,0xD5,0xFB,0x1A,0x33,0xDF,0x76,0x97,0x2D,0x6B,0x68,0x6C,0x4A,0x53,0xF7,0xAC,0xA9,0x89,0x71,0x2D,0xDD,0x33,0xA6,0x26,0x9B,0xAD,0x6D,0x77,0x5B,0x7A,0x70,0xF4,0xC8,0x45,0xE1,0x69,0x8E,0xA9,0x6B,0x6E,0x89,0x62,0x78,0x45,0x8D,0x7C,0x8C,0xC0,0x29,0x4A,0x55,0xA8,0x06,0x00,0x03,0xBE,0x13,0x54,0xC0,0x2F,0x61,0x06,0xF8,0xD9,0xCD,0x00,0xCF,0xB8,0x2A,0xE0,0xA7,0x14,0x06,0xFC,0x56,0xCA,0x81,0xFF,0x07};
const uint8_t spON[] PROGMEM = {0x69,0x0C,0x69,0xAB,0x44,0x92,0x96,0x36,0x86,0xED,0x52,0x8D,0xD7,0xDA,0x10,0xB7,0x53,0x35,0x5E,0x6B,0x43,0xB9,0x4A,0xD5,0x78,0xAD,0x0D,0xE9,0x32,0xD4,0x9A,0xB5,0x21,0xBA,0x4B,0x37,0x4B,0xDA,0xE6,0x68,0x2E,0xDD,0x2D,0x6D,0xDB,0x62,0x58,0x37,0xF7,0x34,0xED,0x48,0xAE,0x3D,0xDC,0x53,0xA5,0x33,0xE5,0x54,0xF3,0x6C,0x9D,0xCE,0xE4,0xCA,0x42,0x2A,0x73,0xB8,0x8A,0xE6,0x72,0x4D,0x55,0xE9,0x2A,0x46,0x22,0x24,0x6C,0xA7,0xBB,0x3B,0x0E,0x57,0x57,0x12,0xEE,0x6A,0xC4,0x93,0xCD,0x8E,0x79,0x6A,0xD4,0x60,0x49,0xC7,0xFF,0x0F};
const uint8_t spGUNDISH[] PROGMEM = {0x0E,0xA8,0xB9,0xA5,0x55,0x55,0x85,0x68,0x5B,0xA7,0x55,0x55,0x5D,0x66,0xA1,0x5B,0x56,0x55,0xCC,0x88,0x96,0x6F,0x5E,0x65,0xB6,0x25,0x11,0x7E,0x7B,0x64,0x45,0x97,0x86,0xC4,0x9C,0x96,0x16,0x25,0x19,0x9A,0x8E,0x4B,0x52,0x35,0x75,0x4A,0xA8,0xAE,0x09,0x02,0xA7,0x28,0x55,0xA1,0x1A,0xA0,0x80,0x02,0xC3,0x4A,0x3B,0x54,0x8A,0x8A,0x6F,0x1E,0x43,0xB5,0xCE,0xE6,0x35,0x7B,0x4D,0x4D,0x25,0x6B,0xE4,0xAA,0x31,0x77,0x1E,0x62,0x95,0xAB,0xDA,0x36,0x74,0xB1,0x58,0xEC,0x2E,0xE7,0x88,0x25,0xC2,0xDE,0x5B,0x01,0x3B,0x4E,0x1B,0x60,0xA5,0x6D,0x03,0xEC,0x38,0xAD,0x80,0x15,0xB6,0x05,0xB0,0xCA,0xB6,0x00,0x66,0xBE,0x14,0xC0,0x8C,0xD7,0x0C,0x18,0x6D,0x92,0x00,0xBD,0x97,0xFD,0x3F};
const uint8_t spR_NAV[] PROGMEM = {0x29,0x89,0x7E,0x53,0x5D,0x53,0x8F,0x21,0xAB,0x2F,0x75,0xEB,0xB2,0x86,0x4A,0x77,0xB4,0x34,0xEB,0x1A,0x8A,0xB8,0xE6,0xD6,0xAE,0xAB,0x2B,0xEA,0x5D,0x96,0x3B,0xAF,0xBA,0xF8,0x13,0x5D,0xDA,0xB4,0xEA,0x92,0x9B,0x7C,0x24,0xCF,0x6A,0x4A,0x67,0x4F,0xF7,0xCC,0xBB,0xD9,0x0D,0x80,0x69,0x92,0x95,0x6C,0x76,0x27,0xAD,0x2B,0x96,0x33,0x39,0x1D,0x97,0xBE,0x1A,0x6C,0xD7,0x70,0xBC,0x86,0x1A,0xD4,0xCC,0x7B,0xD1,0x1A,0xAB,0x37,0x8D,0xA8,0xD9,0x6B,0x6A,0x26,0xC5,0x2B,0x9E,0xAC,0xA5,0xEB,0x56,0x29,0x5B,0xBD,0xD6,0xAE,0x5B,0xB5,0x6C,0xCD,0x5E,0xD7,0xDA,0xF4,0xA8,0xB4,0xBF,0x5E,0x7B,0x53,0x6D,0xDA,0xBE,0x7A,0xEF,0xEB,0xAC,0xBA,0xD5,0xDB,0x57,0xB5,0xAB,0xD8,0x32,0x2F,0xBF,0x5D,0xEE,0xA2,0xC6,0x7C,0xFC,0x61,0xB9,0xB3,0x69,0xF3,0xF2,0x99,0xE9,0x4E,0xAE,0xD5,0xDB,0x1F,0x85,0x3B,0xC7,0x34,0x37,0x5D,0xC5,0xA6,0xA8,0xC2,0x5D,0x35,0x36,0x9F,0xF8,0x84,0x80,0x60,0x35,0x08,0x50,0x5D,0xEA,0xFF,0x03};
const uint8_t spSELECT[] PROGMEM = {0x0C,0x78,0xC6,0x95,0x01,0x3F,0xA5,0x28,0xE0,0xB7,0x52,0x0B,0x04,0xE0,0xB7,0x54,0x07,0xFC,0x52,0x66,0x80,0x9F,0xCB,0x46,0xB7,0x44,0xAA,0xA9,0xE4,0x59,0x5D,0x53,0x15,0x6C,0xBA,0x65,0xF5,0x85,0x55,0xB8,0xF3,0xE6,0x35,0x2C,0xA8,0x6B,0xAC,0xC9,0xD6,0xB0,0x90,0xAE,0xB1,0xA5,0x5D,0x5D,0xE5,0x9B,0x1A,0xF6,0x7A,0xB5,0x55,0x8E,0x5B,0xF8,0xE6,0xD5,0x36,0x37,0x9C,0x9A,0xAB,0x46,0xD3,0x63,0x62,0x71,0x4C,0x44,0xE0,0x14,0xA5,0x2A,0x54,0x03,0x00,0x40,0x01,0x43,0xBA,0x09,0x60,0x73,0x35,0x04,0x4E,0x51,0xAA,0x42,0x35,0xFE,0x1F};
const uint8_t spFILED[] PROGMEM = {0x04,0x18,0xB6,0x82,0x00,0xD3,0x57,0x08,0x60,0xBA,0x74,0x05,0x34,0x5B,0xB6,0xCA,0x18,0x27,0xDC,0xA4,0xD5,0xEA,0x52,0xEA,0x08,0xD1,0x4D,0xAB,0x4F,0x69,0x3C,0xD4,0x36,0xAD,0x21,0xBB,0x33,0x2B,0x5B,0xBD,0xC6,0xAA,0xCE,0x65,0x74,0xF5,0x5A,0x9A,0x5C,0xE7,0x91,0xCD,0x6B,0x1D,0xA2,0x8D,0x57,0xBB,0xAC,0xBD,0x89,0x56,0x39,0xDD,0x3C,0xEE,0x6A,0x4B,0x74,0xAC,0x73,0xBB,0x8B,0x1D,0xB1,0xB1,0xDD,0xE5,0x89,0x7E,0x22,0x4C,0x36,0xA5,0x27,0xDA,0xCD,0x50,0xE9,0x12,0x9E,0xA8,0x67,0xDC,0xB8,0x8B,0x7B,0x82,0x9D,0x56,0xE5,0xAE,0xEE,0x8D,0xDE,0x5B,0x49,0xBB,0xAA,0x37,0x7B,0x6B,0x07,0xCE,0x4A,0x5E,0x47,0xD2,0x27,0x23,0x15,0x03,0x0A,0x0C,0x4B,0x7F,0x8F,0x29,0x22,0xB6,0xE5,0xFF,0x01};
const uint8_t spMIG[] PROGMEM = {0x2A,0x95,0xCA,0x3B,0xD3,0xD5,0xB8,0x59,0x6B,0xAD,0x0A,0x75,0x13,0xA6,0xA8,0x28,0xAA,0xCC,0xE9,0x18,0xB3,0x52,0x73,0x97,0xB4,0xAB,0x1F,0x36,0x95,0x52,0xDF,0xAC,0x6A,0xD8,0x60,0x6E,0x7F,0xBC,0xCA,0xEE,0x9C,0xB4,0xE3,0xF6,0x2A,0xBA,0x35,0xF2,0x8E,0xCB,0xA3,0xE9,0xDA,0xD1,0xC6,0x1F,0xA5,0x6E,0x58,0x07,0x1D,0x5D,0x28,0x76,0xCF,0x55,0x6F,0xCC,0x12,0x3B,0x84,0xCC,0xB8,0x50,0xC5,0xE2,0xB0,0x34,0x63,0xCA,0x64,0xA7,0xAB,0xAB,0x44,0xB6,0x48,0x92,0x9E,0x29,0x13,0x71,0x7D,0xB5,0xDB,0x9B,0x08,0x92,0x8B,0x55,0x6E,0x6B,0x51,0x44,0x2D,0x66,0xFD,0x3F};
const uint8_t spALERT[] PROGMEM = {0xAD,0xCD,0xBE,0x45,0x2D,0x5B,0x8F,0xB6,0xC8,0x72,0x57,0xDB,0xD4,0xEA,0x0E,0xBC,0x8D,0xAC,0x6B,0xA9,0x27,0x90,0x49,0x56,0x77,0xA5,0x19,0x50,0xC7,0x58,0xD2,0xAD,0xA6,0x88,0x2C,0x53,0xDE,0xB2,0xAA,0xA2,0x2A,0x2C,0xB8,0xCB,0xA8,0x73,0x68,0xB6,0x96,0xBC,0x63,0x48,0xA9,0x30,0x5B,0xF2,0x94,0x35,0x97,0x80,0x2E,0xDE,0x53,0x8E,0x1A,0x06,0x65,0x24,0x4F,0x7A,0x6A,0x6E,0x94,0xE1,0x3E,0xE9,0x6F,0x3E,0x89,0x2B,0xF2,0x23,0x70,0x8A,0x52,0x15,0xAA,0x01,0x00,0x0A,0x18,0xD2,0x8D,0x01,0x9B,0xAB,0x21,0x70,0x8A,0x52,0x15,0xAA,0xF1,0xFF};
const uint8_t spZONE[] PROGMEM = {0x69,0x79,0x9C,0x4C,0xDC,0xB2,0x96,0xE5,0x39,0x4D,0x43,0xF6,0x6A,0x80,0x09,0x28,0x1C,0xB0,0x09,0x8A,0x01,0x1E,0x46,0x1D,0x53,0xD1,0x16,0x66,0xFE,0x66,0x4C,0xD9,0x44,0xA4,0xE9,0x9B,0xB1,0x24,0xDB,0x19,0x26,0x5B,0xDA,0x12,0xE3,0x84,0x99,0xBE,0x69,0x67,0x34,0x93,0xE1,0xB2,0xA6,0x9D,0xA1,0x54,0x18,0xC7,0xDC,0x76,0x85,0x54,0x69,0x12,0x4D,0xCB,0x15,0x4B,0xA5,0xB1,0x35,0x2D,0x77,0x08,0x59,0x2E,0xD1,0x38,0xDD,0x49,0x79,0xB5,0x6A,0x9D,0x74,0x57,0x2B,0x91,0x66,0x76,0xD3,0xD3,0xBC,0x58,0xAA,0xD9,0x49,0x4F,0x56,0x66,0xA5,0x16,0x27,0xBD,0xCD,0x8A,0x95,0x6A,0x9C,0xF4,0x56,0xCB,0x5E,0xA2,0x51,0xD2,0x9B,0x5D,0xB1,0x5B,0x2C,0x4E,0x5F,0x49,0x16,0xA6,0x55,0xFB,0xFF,0x01};
const uint8_t spTERMINAL[] PROGMEM = {0x0E,0xD8,0x2E,0x35,0x00,0xCB,0x75,0x78,0x60,0x04,0xA9,0x18,0x65,0xF1,0xEA,0x95,0xE4,0x6E,0x9C,0x4B,0x79,0x56,0x9E,0xAA,0x73,0x1C,0x75,0x19,0x65,0xCC,0xA1,0xB5,0xB8,0xA6,0xD5,0xD9,0x9B,0x64,0x52,0xD4,0xD6,0x67,0x6B,0x92,0xCD,0x71,0xD7,0x90,0x4C,0x9B,0x8C,0xAD,0x19,0x53,0x56,0x6D,0xDA,0xF6,0xBA,0xAC,0x49,0x4B,0xB6,0x4A,0x9C,0xB1,0x66,0x6F,0x96,0x21,0xCD,0xC6,0x9E,0x79,0xA7,0x95,0x76,0x19,0x67,0x12,0x53,0x1E,0xDC,0xB5,0x9C,0x51,0x5E,0xAB,0x6B,0xD7,0xF4,0x07,0x7D,0xA5,0x6A,0xAD,0xC3,0x1F,0xCC,0xB7,0x88,0xB7,0x71,0x7F,0x10,0xB7,0x6A,0x9A,0x36,0xFC,0x89,0xF6,0xBA,0x4B,0x5A,0xF7,0x47,0x39,0x13,0xC1,0x79,0xCC,0x57,0x54,0x67,0x8A,0xB8,0xF9,0x7F,0x0E,0x98,0xA1,0xC4,0x01,0xDD,0x28,0x8F,0x74,0x84,0x64,0x73,0xAF,0x75,0xEA,0x1A,0x9D,0x2A,0x73,0xF1,0x69,0x9A,0x2F,0xB6,0xB2,0xC7,0xA7,0xAE,0xBA,0x38,0xDB,0x6F,0x9F,0x2A,0xD9,0x92,0x8E,0x9A,0xDA,0xCA,0x66,0x29,0x5B,0x4A,0x95,0x6B,0x12,0x97,0x68,0xD1,0x5A,0x06,0x78,0xC6,0x55,0x01,0x3F,0xA5,0x18,0xE0,0xB7,0xD2,0x51,0x26,0x35,0x1E,0xAA,0x8B,0x67,0x39,0xAA,0xCC,0xAF,0x44,0xB5,0xCB,0xA8,0x0B,0x99,0x09,0x96,0x2C,0xAD,0xC9,0x64,0x26,0x99,0xBB,0xB4,0x36,0x91,0x9E,0x22,0xCE,0x9A,0xBA,0xC4,0xAA,0x1B,0x2C,0x4B,0xEA,0x0B,0x8D,0x0C,0x23,0xB7,0xFF,0x0F};
const uint8_t spRADIOS[] PROGMEM = {0xA1,0x77,0x8D,0xAD,0x43,0xEC,0xC5,0x3E,0x75,0xA1,0x53,0xA4,0x9B,0xFD,0x55,0x56,0x1F,0xAC,0x2D,0x5B,0x56,0xD9,0x42,0x90,0xB6,0x2D,0x5E,0x65,0x8F,0x8E,0x52,0xFE,0x78,0x54,0x2D,0x08,0x6B,0xE4,0x66,0x33,0x5A,0xE9,0x9E,0xE9,0x31,0xDA,0xB2,0x4D,0x32,0x7A,0xB4,0x19,0x63,0xB7,0x8A,0xDA,0xBD,0xB8,0x8D,0xDD,0x13,0x59,0xD7,0xEC,0x31,0xF7,0x20,0xA8,0x9D,0x8F,0xC7,0xDA,0x9C,0x90,0x8D,0xBF,0x1A,0x67,0xD3,0xA1,0xD4,0xB2,0xA5,0x9D,0xC5,0xA5,0x6A,0xF2,0xEF,0xF6,0x66,0xD5,0xC1,0xC3,0x6B,0xD2,0x97,0x54,0xA7,0x0E,0xEF,0x49,0x5F,0xB4,0x15,0x99,0xB4,0x3B,0xFC,0x31,0xA7,0xBB,0xCA,0x6A,0xF7,0xC7,0x1C,0x69,0x62,0xAB,0xCD,0x9F,0x52,0x84,0x8A,0xAE,0x36,0x7F,0xF2,0xE6,0xAA,0xBE,0xD9,0xFC,0x31,0x06,0x7A,0xC4,0xD2,0xF0,0x17,0x55,0xC6,0x6A,0x59,0xD3,0xF7,0x9B,0xA5,0xA9,0x49,0x0D,0xFB,0xF7,0x11,0x26,0xCC,0x4C,0x01,0xDF,0x23,0xFD,0x3F};
const uint8_t spSPEED[] PROGMEM = {0x0C,0x78,0xC6,0x95,0x01,0x3F,0xA5,0x28,0xE0,0xB7,0x52,0x0B,0x04,0xE0,0xB7,0x54,0x04,0x4E,0x51,0xAA,0x42,0x35,0x00,0x0C,0x50,0x94,0x73,0x4B,0x7B,0x30,0xA6,0x90,0x35,0x23,0x9B,0xC9,0x09,0xD3,0xD6,0x8C,0x72,0x78,0x45,0xDE,0x5A,0xDC,0xDA,0x11,0x04,0x74,0xFA,0x51,0xEB,0x67,0x30,0xC0,0xA9,0xC5,0x6D,0x99,0xDE,0x80,0xA6,0x16,0xB7,0x6D,0x6A,0x41,0xD9,0x9C,0x54,0xF6,0x26,0x84,0x7C,0x73,0x91,0x3A,0x22,0xF1,0xA8,0xB2,0x48,0xEC,0xF4,0x34,0x22,0x32,0x6D,0x89,0x2B,0x92,0xB4,0x0C,0xAF,0x55,0xAE,0x69,0xDA,0x48,0x25,0x2D,0x03,0x0A,0x0C,0x4B,0x4F,0xCF,0x6C,0x2A,0xB9,0xFA,0xFF,0x01};
const uint8_t spKNOTS[] PROGMEM = {0x6E,0x4A,0x92,0xBA,0x45,0x1D,0xA7,0x39,0x4B,0xEA,0x52,0x4D,0x92,0xA6,0xAA,0xB1,0xDD,0xCC,0xC9,0x98,0xAA,0x95,0x52,0xB5,0xA6,0x6B,0xCC,0x7A,0x9C,0xDB,0x17,0xAF,0xA1,0xF2,0x6D,0x6E,0x6B,0xB3,0xA6,0x22,0xB7,0x68,0xAC,0xCD,0x9A,0xB3,0xDE,0x94,0xB6,0x25,0xEB,0x28,0x62,0x8B,0xDB,0x36,0x8F,0xB3,0x98,0x75,0x6D,0x5D,0xDD,0xAE,0x12,0x56,0x3C,0xEC,0x95,0xBB,0xCB,0x8C,0x30,0xCE,0xC6,0x08,0x9C,0xA2,0x54,0x85,0x6A,0x00,0x10,0x60,0x50,0x31,0x06,0xFC,0xA0,0x68,0x80,0x67,0x5C,0x15,0xF0,0x53,0x0A,0x03,0x7E,0x2B,0xE5,0xC0,0xFF,0x03};
const uint8_t spEXPECT[] PROGMEM = {0x6B,0xE8,0xAA,0xD5,0x53,0x36,0xAF,0xA1,0xAB,0x16,0x6B,0x5D,0xB5,0xFA,0x66,0x0A,0x73,0x7D,0x25,0x03,0x72,0x00,0x45,0x40,0x96,0x4E,0x06,0x78,0xC6,0x55,0x01,0x3F,0xA5,0x18,0xE0,0xB7,0x52,0x0B,0x20,0x70,0x8A,0x52,0x15,0xAA,0x01,0x0E,0xC8,0x26,0x65,0xE5,0xC5,0x87,0x5A,0xD8,0xEA,0x95,0x57,0x17,0xE2,0xE1,0x4F,0x56,0x56,0x5D,0x4A,0x64,0x2C,0x5E,0x59,0x0D,0x2A,0xE3,0x35,0x6B,0x64,0xAD,0x08,0x8D,0x55,0xA5,0x54,0x74,0x13,0xA4,0x11,0xAE,0x11,0x38,0x45,0xA9,0x0A,0xD5,0x00,0x00,0x50,0xC0,0x90,0x6E,0x02,0xD8,0x5C,0x0D,0x81,0x53,0x94,0xAA,0x50,0x8D,0xFF,0x07};
const uint8_t spACTION[] PROGMEM = {0x63,0x6C,0x39,0x25,0xC3,0xE7,0x8C,0xAE,0xD5,0xF0,0x30,0x9F,0xB3,0x9A,0x5A,0x2C,0xC2,0x63,0xEA,0xAA,0x5B,0x49,0x8B,0xD0,0x39,0xAB,0xAA,0x55,0xB5,0x3C,0xA6,0x08,0x20,0x18,0x61,0x04,0x4E,0x51,0xAA,0x42,0x35,0xC0,0x00,0x2D,0x44,0x24,0x60,0x97,0x9E,0x02,0xCC,0x34,0x5B,0x80,0x95,0xA6,0x46,0x3E,0x92,0x33,0xBB,0x74,0x5E,0x79,0x77,0x26,0x9C,0xBA,0x65,0x55,0x4D,0xA9,0x5A,0xF9,0xAA,0x56,0x36,0x0B,0x15,0x6E,0x71,0x47,0xD1,0x2D,0x46,0xBA,0xDA,0x1D,0x45,0xB3,0x58,0xEE,0xE6,0x66,0x54,0x55,0x9A,0x65,0xC4,0xAC,0xFF,0x07};
const uint8_t spRADIAL[] PROGMEM = {0x6A,0x66,0x69,0xCC,0x3C,0xED,0x84,0xD9,0x36,0xCA,0x4C,0xF1,0x3A,0xC6,0xD4,0x29,0x34,0x2C,0xDB,0x6A,0x4B,0x09,0x53,0x97,0xAE,0xAB,0xEA,0xAE,0x85,0x93,0xD7,0xAC,0xA2,0x97,0x64,0x51,0x7D,0x32,0xB2,0x9E,0x84,0xD5,0xEC,0x71,0xA8,0x32,0x65,0xB3,0xAA,0x44,0xAB,0x98,0xCE,0x91,0x23,0x96,0xAC,0x6A,0x04,0x47,0xAE,0x5C,0xB2,0xEA,0x11,0x1D,0xA9,0x62,0xCD,0x6A,0x7A,0x54,0x94,0xF2,0x35,0xAB,0xAD,0x32,0x54,0xCA,0xBB,0xAC,0x3E,0xC9,0x32,0x4F,0xDE,0xBC,0xC6,0x24,0xD7,0xCD,0xB9,0xCF,0x1E,0xDB,0x10,0xC5,0x86,0x07,0xE5,0x09,0x83,0x73,0xEB,0xAE,0xB4,0xE9,0xFF,0x01};
const uint8_t spPOWER[] PROGMEM = {0x0A,0x88,0x22,0xDC,0x00,0x45,0x57,0x8C,0xAA,0xE9,0x88,0x4A,0x4A,0xB4,0x8A,0xEC,0x3A,0xD3,0x79,0xF1,0xCA,0x93,0x5F,0xF7,0xD4,0xC7,0x2B,0x4B,0x6E,0x33,0x82,0x17,0xAF,0x2C,0xA4,0x8D,0x70,0x5A,0xDD,0x32,0x5F,0xD7,0x3D,0x70,0xF3,0x28,0x42,0x3A,0xB7,0xC6,0xDE,0xA3,0x0A,0x61,0x55,0x97,0xFA,0xAC,0x31,0x86,0xA2,0x6C,0xF1,0xB2,0x8E,0x14,0x86,0x7D,0xD8,0x6F,0x3B,0x73,0x69,0xB4,0xE5,0xDC,0xF5,0x29,0x6F,0xF1,0x83,0x74,0xEE,0x37,0xBC,0x35,0x2E,0xCA,0xBA,0xEE,0xF8,0xFD,0x3F};
const uint8_t spGAS[] PROGMEM = {0x01,0x28,0xD6,0xC4,0x00,0x39,0x08,0x8D,0xAA,0x44,0x97,0xD2,0x98,0xBC,0xBA,0x12,0x43,0x22,0x7D,0xF6,0x9A,0xAA,0x2D,0xD3,0xB6,0xC5,0x6B,0xAD,0xAE,0xCC,0xCA,0x56,0xAF,0xAD,0xDA,0x32,0x2F,0x7B,0xBD,0x8E,0xEA,0xCB,0xAC,0x6C,0xF1,0x38,0xAA,0x2F,0x8D,0xF4,0xC7,0xED,0xAE,0x3E,0xAD,0xD4,0x67,0xF7,0x3B,0xBD,0xB5,0x58,0x99,0x74,0x13,0xF3,0x95,0x6D,0x21,0x92,0xB1,0x19,0x50,0x85,0x0B,0x03,0x9A,0x4F,0x21,0x40,0x2B,0x6D,0x02,0x68,0x3A,0xED,0xFF,0x01};
const uint8_t spINFORMATION[] PROGMEM = {0xAE,0xE8,0x39,0x98,0xBC,0xD6,0x8C,0xA2,0x19,0xE5,0x98,0x98,0xB4,0x8A,0x6E,0x55,0xBC,0xA3,0xD6,0x2A,0x9B,0x36,0xF5,0xF2,0x59,0xAB,0x6C,0x96,0x2A,0x5C,0xED,0x8C,0x2A,0x2B,0xAD,0x10,0x8E,0x93,0xAA,0x6C,0xC5,0x95,0xB2,0xA1,0xEB,0x96,0x49,0x33,0x33,0xC7,0xA9,0x9F,0x2E,0x33,0x42,0x14,0x3B,0xA0,0xB9,0xF6,0x51,0x26,0x57,0x6A,0x4D,0x59,0x46,0x97,0x5C,0xA9,0x37,0x6C,0x49,0x7D,0xB0,0xEA,0x15,0x54,0xB7,0xF4,0xC9,0x4A,0x94,0x52,0xBD,0xD5,0x14,0x9D,0xA6,0xAD,0xAB,0x57,0xDD,0x54,0xA8,0x8D,0x6F,0x5E,0x55,0x77,0xCE,0xD6,0xBE,0x6A,0x15,0x3D,0x28,0x5B,0xE5,0xC2,0x56,0x8E,0xAA,0xCC,0xE6,0xAD,0x13,0x30,0x72,0x5B,0x02,0x66,0xE9,0x4E,0xC0,0x4A,0x1B,0x09,0xE8,0xA5,0x7D,0x15,0x2D,0xAA,0x72,0xD8,0xE6,0x55,0xB7,0xA0,0x26,0xE1,0xAB,0x5B,0x53,0x0D,0x76,0xAA,0xC4,0x29,0x75,0x35,0x38,0x66,0xE2,0x64,0xD4,0x55,0x73,0xA6,0x48,0x9C,0x51,0x17,0x6D,0x6E,0x1E,0x8D,0xFE,0x1F};
const uint8_t spTRUE[] PROGMEM = {0x06,0xE8,0x36,0xB4,0x00,0x53,0xB7,0x25,0xA0,0xDB,0xF5,0x00,0x94,0x54,0xDE,0x8A,0x58,0x54,0x43,0x2C,0x6B,0x2B,0x63,0x94,0x32,0x95,0xE6,0xAD,0x4C,0xC6,0xC2,0x82,0xDA,0xB7,0xA2,0x10,0x2F,0x69,0xCE,0x9E,0x8A,0x4C,0xA2,0xA4,0xB0,0x6B,0xCA,0x13,0x89,0xB2,0x86,0x2E,0x21,0x0F,0x2C,0xCB,0x13,0xB6,0x84,0xCC,0xAB,0x0A,0x75,0x7E,0x12,0x32,0xAF,0xD2,0x2C,0xBC,0xCD,0xFF,0x03};
// const uint8_t spPRESSURE[] PROGMEM = {0x08,0x88,0x44,0xC5,0x00,0xC5,0xB9,0x1A,0xA0,0x64,0xB3,0xD1,0xA5,0x2C,0xA5,0xC5,0x6B,0x56,0x97,0xB3,0xBA,0xA7,0x6E,0x59,0x63,0xC9,0xAE,0x11,0xBA,0x65,0x2D,0x25,0x99,0x5A,0xDA,0xEA,0xB6,0x36,0xEB,0x2A,0xE1,0x29,0x13,0xB0,0xAC,0x6B,0x02,0x66,0xD9,0x4C,0xC0,0xCC,0xDB,0x0E,0x68,0x41,0xA9,0x4D,0xC5,0x27,0x49,0x7B,0xB6,0xB2,0xD6,0x34,0x8C,0xAD,0xFE,0xCB,0x51,0x8E,0xB3,0x15,0x75,0x2D,0x57,0x1E,0x4A,0xBE,0xDC,0x25,0xDD,0xB9,0x09,0xC5,0x4A,0x96,0xF0,0xE4,0xC3,0x9C,0x25,0x5D,0xDC,0x53,0x9E,0x72,0x25,0xA7,0x71,0x6F,0x79,0xA9,0x69,0xAC,0xF4,0xFF,0x01};
const uint8_t spCHECK[] PROGMEM = {0x0C,0xD8,0x39,0xC4,0x01,0xBB,0xA6,0x04,0x60,0xB6,0x90,0x04,0x8C,0x54,0xBE,0x8A,0x9A,0x5D,0x3D,0x7D,0xCD,0x2E,0x56,0xD1,0x7C,0x49,0x94,0xAF,0x5E,0x79,0x2B,0xC5,0xA1,0xB6,0x18,0x81,0x53,0x94,0xAA,0x50,0x0D,0x00,0x06,0xD4,0x39,0xC4,0x80,0xBA,0x8C,0x11,0x10,0x1D,0xF1,0xFF,0x03};
const uint8_t spDECREASE[] PROGMEM = {0x0C,0x28,0x30,0x6C,0x0D,0x5B,0x97,0xB2,0x88,0xBF,0xD3,0x4D,0x93,0x4C,0x6E,0x5B,0x56,0x3F,0x42,0x21,0xA6,0x6F,0x6E,0xFD,0xC8,0x09,0x9C,0xB6,0x19,0x81,0x53,0x94,0xAA,0x50,0x0D,0x50,0x40,0x6A,0x2D,0x0A,0xC8,0xB1,0x42,0x01,0xA9,0x96,0x8F,0x22,0x17,0x4E,0x33,0x4D,0xB7,0xCA,0x9A,0xC4,0xCC,0xA5,0xEB,0x28,0x9A,0x73,0xD2,0xD2,0xAD,0x2D,0x1D,0x29,0x80,0xD3,0x1E,0xB7,0xB4,0x19,0xC6,0xE8,0x5A,0xDC,0xD2,0x2A,0x85,0x32,0x6A,0x95,0x02,0x9E,0x71,0x55,0xC0,0x4F,0x29,0x06,0xF8,0xAD,0xD4,0x02,0x0C,0xF8,0x2D,0x95,0x01,0xBF,0x94,0x31,0xE0,0xE7,0xB2,0xFF,0x07};
const uint8_t spADVISE[] PROGMEM = {0x63,0xEC,0xBA,0x55,0xCB,0xD7,0xAC,0xB1,0x9B,0x56,0x75,0x5B,0xB3,0xC6,0x66,0x43,0xC2,0x6D,0xB5,0x98,0xBC,0x55,0x71,0xEF,0x99,0x6A,0xD6,0x22,0x23,0xC3,0x6A,0xAA,0x25,0x90,0x34,0x4F,0x6B,0x2C,0x16,0xCB,0xD3,0x35,0x3D,0x49,0x38,0xBA,0x0A,0x53,0x51,0xDB,0xAB,0x4F,0x66,0xC2,0x9C,0x37,0xAD,0xAE,0x88,0x6D,0x0B,0xE9,0xB3,0xBA,0x22,0xB6,0x3C,0x64,0xCB,0xEA,0x2A,0xDF,0xD2,0xB4,0x2D,0xAB,0x6D,0x62,0xD3,0x52,0xB7,0xAC,0xA6,0xF3,0x75,0x2F,0xD9,0xBC,0x9A,0x21,0xD6,0xBC,0x64,0xF5,0xAA,0xBB,0x1D,0x0E,0xB7,0xD7,0xAB,0x6A,0xA6,0xA8,0x3C,0x5F,0xAD,0xAA,0xCB,0xC2,0xB2,0x9A,0xDD,0x9A,0x2A,0x12,0x93,0x67,0x72,0xEB,0xBE,0x62,0x37,0x8A,0x2C,0x0A,0x78,0xC6,0x55,0x01,0x3F,0xA5,0x18,0xE0,0xB7,0xD2,0xFF,0x07};
const uint8_t spYOU[] PROGMEM = {0xA9,0x2A,0x42,0x38,0xBA,0x63,0xA6,0xAE,0x0B,0x21,0x8D,0x69,0x98,0xFA,0x29,0x15,0x25,0x6A,0x56,0xE9,0xBB,0x53,0xE4,0xCA,0xC5,0xA3,0xED,0xCA,0x99,0x5A,0xDB,0xB6,0xB6,0x50,0x77,0x2D,0xEE,0x1A,0xBA,0x84,0xA2,0x24,0xA9,0xAB,0xEB,0x03,0xED,0xD4,0xA4,0xD5,0x6E,0x12,0xAA,0xB2,0x9C,0x13,0xFD,0x3F};
const uint8_t spHAVE[] PROGMEM = {0x08,0x48,0xCC,0x0C,0x03,0x2B,0x6B,0xD9,0x34,0x34,0xA7,0xAC,0xAA,0x25,0xD7,0xB0,0x98,0xB3,0xAA,0x96,0x5C,0x23,0x7C,0xCE,0xAA,0x6A,0x72,0x4D,0x8B,0x39,0xAB,0xAD,0xD1,0xB5,0x34,0xA7,0xAC,0xBE,0xC6,0xD4,0xD2,0x98,0xBC,0xA6,0x1A,0x53,0x53,0x62,0xF2,0x58,0x4B,0x74,0x2B,0x8D,0xC9,0xE3,0x28,0xD1,0x2D,0xCC,0x66,0x8F,0xB3,0xE8,0xD2,0x28,0x5B,0x34,0xCE,0x62,0x53,0x23,0x65,0x31,0x02,0x82,0xD5,0x20,0x40,0x75,0xA9,0x08,0xA8,0x36,0xED,0xFF,0x01};
const uint8_t spERROR2[] PROGMEM = {0x6D,0x6C,0x6E,0x89,0x5B,0x36,0x8F,0xA9,0x9B,0x11,0x5A,0xE9,0x33,0xA7,0x31,0x17,0xB7,0x4A,0x47,0xFD,0xC6,0x92,0x9A,0x8B,0x2F,0x65,0x4B,0x6B,0x1C,0xE4,0xD5,0xD8,0x2D,0xAF,0x65,0x8D,0x83,0xAD,0x9A,0xB2,0x95,0x23,0x76,0x93,0x58,0xCA,0xD7,0xCE,0xEC,0x57,0xF8,0xD8,0x5B,0x3A,0x8B,0x3D,0xC5,0xE7,0x7C,0xE9,0xCD,0xBD,0x30,0x86,0xDA,0x86,0x2F,0x97,0x82,0x38,0xEC,0x13,0xFE,0xE4,0x07,0xED,0x35,0x4B,0xF8,0x73,0x4E,0xEC,0xD2,0x3C,0xEE,0x2F,0xCB,0xB9,0x9D,0x3B,0xFF,0x3F};
const uint8_t spALL[] PROGMEM = {0x0A,0x48,0x71,0xA9,0xE4,0x45,0x9F,0x9B,0x99,0xEB,0x56,0x04,0x3F,0x6E,0xA6,0xBD,0x5A,0x15,0x7D,0x97,0x1B,0x6F,0x69,0x55,0xB4,0xD3,0xEE,0xB4,0xA7,0x55,0xD1,0x5C,0x8B,0xCB,0xDE,0x56,0x06,0x77,0x2D,0xA6,0x7B,0x5A,0x19,0xED,0x97,0x98,0x6D,0x69,0x45,0xB4,0x57,0xA6,0xB6,0xB9,0x15,0x51,0x7D,0x9B,0x68,0x97,0x52,0x04,0xDF,0x63,0xE8,0x5D,0x4B,0x11,0xF5,0x76,0x83,0xA6,0x2D,0x55,0x14,0x5F,0xCE,0xD6,0x39,0xD5,0xC1,0x7D,0x38,0x67,0xA7,0xFF,0x07};
const uint8_t spLONG[] PROGMEM = {0x6C,0xB1,0xAE,0x5D,0x4D,0x93,0x9A,0xCB,0xB9,0x14,0x4F,0xB7,0x2D,0x4E,0x5B,0x4C,0x22,0x9D,0xAD,0xDB,0x5C,0xA3,0x28,0x57,0x77,0x6D,0xF5,0xC9,0xD3,0x42,0xD2,0xAE,0x29,0x98,0xA9,0x08,0xCA,0x72,0x86,0x68,0xB7,0x23,0xA8,0xCB,0xE9,0xA2,0xBD,0x36,0x97,0x2C,0xAB,0x0E,0xE1,0x52,0x43,0x5B,0xAF,0x22,0xD4,0x31,0x8B,0x58,0xB4,0xB2,0x58,0xDB,0xDC,0xB2,0xF1,0x48,0xB3,0x6C,0x5F,0x0A,0x25,0x2D,0x2D,0x5A,0xAB,0xD9,0x54,0x8F,0xAC,0x28,0xCE,0x92,0x54,0x34,0xF2,0xEA,0xC4,0x9B,0xCB,0xF2,0xFF,0x03};
const uint8_t spNO[] PROGMEM = {0x62,0xF2,0x5C,0x72,0x4A,0x62,0x9B,0x35,0x70,0xCE,0x49,0xA9,0xE5,0xD6,0xC8,0x39,0x27,0x65,0x76,0x58,0x8A,0x20,0xEF,0xE4,0x39,0x63,0xAE,0x4A,0xD4,0x43,0x66,0xAF,0x3E,0x07,0x77,0xF1,0x78,0xB3,0xDA,0x6C,0x23,0x52,0xFC,0xCD,0xAA,0xB2,0xA9,0x28,0xA1,0x2F,0xAB,0x88,0x62,0xB2,0x9C,0xBA,0x8C,0x2C,0xE8,0xF7,0x60,0xEA,0xD2,0x52,0x6B,0xCF,0x93,0xA5,0x53,0x49,0x5C,0x98,0x48,0x90,0x4D,0x29,0x31,0x7E,0x23,0x48,0x36,0x85,0xCC,0x9A,0x89,0x24,0xEE,0xFC,0xFF};
const uint8_t spIMMEDIATELY[] PROGMEM = {0xAE,0xEC,0x81,0xD9,0xA2,0x6A,0xB7,0xBE,0x2B,0x25,0xEB,0x9C,0xBD,0xBA,0xA6,0x95,0xB5,0x7D,0x71,0xE9,0x92,0x64,0xEF,0x92,0x24,0xA5,0x2B,0x8A,0xAC,0x4B,0x93,0xB4,0xAE,0x1A,0xD2,0x4A,0x4D,0xD2,0xBA,0x22,0x59,0xAB,0xD4,0x4D,0x69,0x93,0x64,0xEF,0x10,0xB7,0xAB,0x1A,0x29,0x98,0x83,0x57,0xAF,0x72,0xA6,0x64,0x0C,0x5D,0xB3,0xF2,0x99,0x8A,0xD1,0x74,0x4D,0xC9,0x2B,0x15,0x89,0xF6,0xDA,0xA9,0x29,0xC2,0xD0,0x2A,0x1B,0x8F,0x6A,0x7A,0x07,0xCE,0x58,0xBC,0xEA,0xE9,0x1C,0xA8,0x73,0xF1,0x18,0x86,0x73,0xE0,0xC9,0x5B,0x6B,0x1C,0xDA,0x91,0x27,0x1E,0xAF,0xA5,0xAB,0x20,0x6D,0x7F,0x85,0xC0,0x29,0x4A,0x55,0xA8,0x06,0x10,0xE0,0x78,0x61,0x06,0x34,0xA6,0x52,0xD6,0x8D,0x79,0x93,0xB9,0xCB,0xD8,0x2F,0xC7,0x69,0xA6,0x36,0x6B,0x6F,0x34,0xD3,0x42,0xF3,0xAD,0x7D,0x89,0x0A,0x4A,0xEB,0xBA,0xAE,0x29,0xDB,0x30,0x6D,0xCF,0xB8,0x87,0x4D,0xE6,0xB4,0xCD,0xE5,0xEE,0xD1,0x51,0x32,0x5F,0xA7,0xA7,0x67,0x25,0xD5,0x6E,0x6C,0xDE,0xDE,0x84,0x4C,0x73,0xF6,0xFF,0x03};
const uint8_t spFINAL[] PROGMEM = {0x08,0x48,0x4C,0x45,0x00,0x43,0x87,0x0A,0xA0,0xBB,0x0A,0x06,0x74,0x37,0xA9,0x80,0x21,0xC3,0x56,0x15,0x7D,0x67,0x38,0x2F,0x5E,0x55,0x56,0x93,0x9E,0xBC,0x79,0x55,0xC5,0xB4,0x47,0xE8,0xE6,0x55,0x16,0x97,0x9A,0x65,0xAB,0x56,0x51,0x7C,0x48,0x75,0x2C,0x5E,0x45,0xF1,0x66,0x65,0x9D,0xA8,0x15,0x59,0x9B,0xB7,0xA4,0xAA,0x95,0x27,0xDB,0x56,0x61,0x69,0x56,0x9E,0xCC,0x86,0x9B,0x74,0x1E,0x59,0xC1,0x33,0xA6,0x92,0x75,0x64,0x15,0xD5,0x84,0x72,0xDA,0x96,0x65,0x12,0xB5,0xCC,0x6D,0x4B,0xD1,0x40,0xB6,0xA9,0xB6,0x55,0x9D,0xB2,0x25,0x16,0x69,0xF7,0xFF,0x01};
const uint8_t spPLEASE[] PROGMEM = {0x02,0x28,0x92,0xAD,0x95,0x45,0x6A,0xBB,0xA8,0xDB,0x51,0x15,0x16,0x5D,0x4C,0x6B,0x56,0xB5,0x84,0xB4,0x39,0x75,0x5D,0x45,0xD7,0x61,0xEC,0xBC,0x66,0x65,0xD3,0x85,0x60,0xE8,0x9A,0x95,0x2E,0xEB,0x0C,0x1D,0x4B,0x46,0x36,0x8C,0x22,0x77,0xBE,0x19,0x59,0x57,0x4A,0x1A,0xFE,0x66,0xE4,0x5D,0xA9,0xA8,0xE9,0xE6,0x51,0xFE,0x10,0x22,0x2C,0x4E,0x0D,0xF0,0x8C,0xAB,0x02,0x7E,0x4A,0xF9,0x7F};
// const uint8_t spSTART[] PROGMEM = {0x0C,0x78,0xC6,0x95,0x01,0x3F,0xA5,0x28,0xE0,0xB7,0x52,0x0B,0x04,0xE0,0xB7,0x54,0x04,0x4E,0x51,0xAA,0x42,0x35,0x40,0x01,0x43,0xBA,0x31,0x60,0x73,0xB5,0x55,0xE6,0x98,0xEA,0xA5,0x5B,0x46,0x9D,0x5D,0x6B,0x0E,0xF5,0x19,0x75,0xB1,0xC7,0xBE,0x94,0xBB,0x55,0xB9,0x1B,0x9F,0xD8,0xAD,0x5E,0xB5,0xB2,0x0C,0xA3,0x71,0xED,0x90,0x8A,0xBA,0xD8,0x55,0x22,0x09,0x02,0xA7,0x28,0x55,0xA1,0x1A,0x00,0x10,0x80,0x21,0xDD,0x14,0xB0,0xB9,0x1A,0x02,0xA7,0x28,0x55,0xA1,0x1A,0xFF,0x0F};
const uint8_t spCOURSE[] PROGMEM = {0x02,0x08,0xCB,0x50,0x01,0xB1,0x17,0x95,0xDA,0xF7,0xF0,0x14,0xE9,0xD2,0x06,0x1F,0xD6,0x65,0xC8,0x4F,0x1B,0x43,0x38,0xE3,0x65,0xBF,0x65,0x89,0x6E,0xD9,0x0E,0x7B,0x97,0x35,0x85,0xC2,0x1A,0xD8,0x53,0xF6,0x5C,0x1D,0xB3,0xA4,0x6B,0x3A,0x72,0x11,0x0D,0xB3,0x2E,0x06,0x78,0xC6,0x55,0x01,0x3F,0xA5,0x28,0xE0,0xB7,0x52,0x0D,0x28,0xE0,0xB7,0x54,0x06,0xFC,0x52,0xC6,0x80,0x9F,0xCB,0xFE,0x1F};
const uint8_t spRADAR[] PROGMEM = {0x22,0x0B,0x34,0xA2,0xC2,0x9C,0xB0,0x8C,0x77,0x97,0x08,0x77,0xE2,0x56,0xDD,0xD4,0xD2,0xDC,0x49,0x9A,0x43,0x27,0x0F,0x57,0x6F,0x6D,0xC8,0x9D,0x93,0x43,0xF3,0x8D,0xAA,0xFA,0x54,0x0B,0x5D,0xB3,0xAA,0xEE,0x9B,0xB9,0xE4,0xCD,0xC8,0xA6,0x6F,0xC2,0xD2,0x35,0x23,0x9D,0x71,0x08,0x5D,0xD6,0x8C,0xBC,0x67,0x61,0x31,0x5D,0x5D,0xDA,0x69,0x5C,0x48,0x2D,0xCD,0x68,0xAA,0x0B,0x76,0xF3,0x27,0xA3,0x2F,0xBA,0x24,0x4B,0xD6,0xB4,0x31,0x99,0x75,0x1F,0xDA,0xD3,0xC6,0xAC,0x2E,0x74,0xB1,0x4F,0x19,0x8B,0xB8,0xE0,0xA3,0x3E,0x65,0xCA,0x66,0x4D,0x8F,0xFA,0xA4,0x39,0xC7,0x96,0x58,0xCA,0x93,0x96,0x94,0x9A,0x63,0x39,0x5F,0x58,0x63,0x4F,0xCE,0xA5,0xBC,0xFF,0x0F};
const uint8_t spPLAN[] PROGMEM = {0x02,0x48,0xC2,0x4B,0x01,0xC3,0xB3,0xA5,0xBA,0x09,0xCE,0x4C,0xB3,0x3D,0xEA,0x64,0xAA,0x42,0x78,0xED,0xAA,0xAB,0xE8,0xB0,0xE4,0xCF,0xAB,0x6B,0xBC,0xDC,0x46,0x57,0xAD,0xBE,0xAB,0x52,0x1B,0x9D,0xB5,0xA6,0xAE,0x4A,0x6C,0x6C,0xF6,0x5A,0x9B,0x2C,0xB1,0xB5,0x45,0x63,0xEB,0xA2,0x55,0xD7,0x16,0x8D,0xA3,0xEB,0x12,0x2F,0x5D,0xD4,0xAE,0x26,0x5B,0x6C,0x6C,0x51,0xBB,0x8A,0x29,0xC9,0xF0,0x59,0xE9,0x2A,0x56,0xCA,0xA9,0x1C,0xA7,0xBB,0x68,0xCE,0xA2,0x70,0x1A,0x9E,0x62,0x38,0x8B,0xDD,0x49,0x78,0x8A,0xD1,0x48,0x36,0x27,0xE1,0x6D,0x9E,0x43,0x2D,0x1C,0xFF,0x3F};
// const uint8_t spTARGET[] PROGMEM = {0x01,0xD8,0xD6,0x23,0x00,0xDD,0xB5,0x0B,0xC0,0x47,0xD6,0x51,0xA4,0x34,0x9C,0x8D,0x5D,0x56,0x9D,0xCA,0x48,0x0E,0x74,0x5E,0x6D,0xEE,0xC5,0x39,0xB4,0x79,0x75,0xA5,0x0E,0xDB,0xE2,0x96,0x35,0xD4,0x7C,0xC4,0x4B,0x7D,0xC2,0x58,0x6F,0x81,0x36,0xF5,0x62,0x6B,0x70,0x68,0x3F,0x6A,0xBB,0x1C,0xC3,0x24,0x8B,0xAB,0x92,0xB1,0x35,0x1F,0x60,0x6B,0xAB,0xC6,0x36,0x74,0x0B,0xB5,0x6E,0x6E,0x57,0x17,0xC5,0xD2,0xFE,0xCB,0xDD,0xC5,0x3A,0x45,0xD4,0x47,0x04,0x4E,0x51,0xAA,0x42,0x35,0x00,0x40,0x01,0x43,0xBA,0x31,0x60,0x73,0x35,0x04,0x4E,0x51,0xAA,0x42,0x35,0xFE,0x1F};
const uint8_t spWINDOWS[] PROGMEM = {0x6A,0x50,0xC5,0xAC,0xDC,0x62,0x97,0xDE,0xDA,0x2A,0x77,0x4E,0xB3,0xAA,0x2C,0xD3,0x35,0x78,0xCB,0x2A,0xAB,0x76,0xF5,0xD0,0x27,0xAB,0xA8,0xC6,0xD5,0xCC,0x6E,0xB7,0xA2,0x19,0xC8,0x76,0x8B,0x3B,0x8A,0xAA,0x28,0xCA,0xCD,0x69,0xA9,0x8A,0xC4,0x6A,0x35,0xA7,0xA1,0xCE,0x02,0x27,0xCC,0x53,0x8D,0x61,0x38,0x73,0x16,0x4D,0xB3,0x86,0xAC,0x4A,0xCD,0xF3,0xD1,0x18,0xB3,0x69,0x31,0xF7,0x4F,0x63,0x49,0xBA,0x3C,0xDC,0x76,0x8D,0x2D,0x99,0x8C,0x32,0xD9,0xD4,0x8E,0xA8,0x3A,0xCA,0x64,0x4F,0x39,0x93,0xEE,0x08,0xE3,0xDE,0xE1,0x0E,0xB6,0xA2,0x45,0x76,0x87,0x37,0xC6,0x08,0x27,0x5F,0xE3,0xBE,0xE0,0x23,0xCC,0xB4,0x93,0xFB,0x83,0x09,0x2B,0xD3,0xD5,0xE6,0x8F,0x36,0x54,0xC3,0x57,0x87,0xEF,0x05,0xB5,0x61,0x72,0x92,0x7F,0x05,0xFC,0x56,0xAA,0x80,0x5F,0xDD,0x05,0xF0,0x53,0xFA,0xFF,0x03};
const uint8_t spWATCH[] PROGMEM = {0x66,0xD5,0xEA,0x4B,0x5C,0x9C,0xA6,0xCD,0xEA,0x6F,0x72,0x73,0xDF,0xE6,0x60,0xBF,0xC8,0x23,0xFB,0x58,0xA2,0xBE,0x52,0x57,0x7F,0x6B,0x2D,0x72,0xCB,0x93,0xF3,0xAC,0xB3,0xA8,0x4D,0x0F,0xEE,0x83,0xC0,0x29,0x4A,0x55,0xA8,0x06,0x00,0x00,0x01,0xB6,0x17,0x33,0xC0,0xAE,0x13,0x16,0x70,0xC0,0xAA,0x17,0x01,0x98,0xB9,0xD5,0x00,0xB3,0xB4,0xFE,0x3F};
const uint8_t spUSE[] PROGMEM = {0x69,0x1E,0x4C,0x44,0xBA,0x66,0x95,0x69,0x28,0x25,0xEE,0x5A,0xDC,0xC6,0x1E,0x04,0x25,0x73,0xF1,0x18,0x9A,0x13,0xB2,0xF4,0x55,0xA3,0xAB,0x5A,0x24,0x42,0x5F,0xB7,0xA6,0x08,0xD5,0x4C,0xFE,0x52,0xEA,0xC8,0xC3,0x3C,0xEC,0x73,0xAA,0xA2,0xD2,0x54,0xCB,0xCD,0x06,0x78,0xC6,0x55,0x01,0x3F,0xA5,0x18,0xE0,0xB7,0x52,0x0B,0x04,0xE0,0xB7,0x54,0x07,0xFC,0x52,0x66,0x80,0x9F,0xCB,0xFE,0x1F};
const uint8_t spTURN[] PROGMEM = {0x09,0xD8,0x3E,0x2D,0x00,0x3D,0x8F,0x2B,0xA0,0x54,0xE3,0x56,0xA4,0xC1,0xD2,0xC5,0xAD,0x56,0x95,0xB7,0x51,0x15,0x75,0x19,0x55,0xDE,0x45,0x3E,0xD4,0x65,0x55,0x25,0x2F,0xF3,0x52,0x97,0x55,0xD5,0x38,0x2C,0xC3,0x59,0x57,0x55,0xB3,0x91,0x47,0x54,0x1B,0x65,0x51,0x62,0xA9,0x5A,0x75,0x94,0x55,0xB1,0x95,0x69,0xDC,0x5E,0xB6,0xB2,0x48,0x8E,0x52,0xB7,0xD3,0xAA,0xAA,0x55,0x32,0xD2,0xE6,0xFF,0x03};
const uint8_t spTRAFFIC[] PROGMEM = {0x08,0x18,0x55,0xCD,0x01,0xD3,0xA9,0x05,0x60,0xE8,0x76,0x07,0x94,0x58,0xDE,0xB2,0x54,0xD5,0xAD,0xCC,0xCD,0xC8,0x73,0xD3,0xB0,0xE2,0x2D,0xA3,0xCA,0xD5,0xAD,0xDC,0x5E,0xAF,0xAA,0x9A,0x15,0x6F,0x59,0xBD,0xEA,0x12,0x52,0xCB,0x6D,0x36,0x02,0xAA,0x0C,0xE3,0x80,0x02,0xBA,0x09,0x2D,0x55,0xC9,0xEA,0x2E,0x55,0x65,0xCC,0x25,0x98,0x86,0xE5,0xEC,0xB1,0xD4,0xA0,0x92,0x56,0xAB,0xCA,0x56,0xA3,0x60,0x55,0xAE,0x44,0xE0,0x14,0xA5,0x2A,0x54,0x03,0x18,0xD0,0x52,0xB0,0x02,0x6A,0x08,0x52,0x40,0x0B,0x41,0x04,0x88,0xDA,0xF0,0xFF,0x01};
//const uint8_t spCHECK[] PROGMEM = {0x01,0xB8,0xD2,0xD4,0x03,0xAB,0xAE,0xD1,0xD5,0x2D,0x17,0xAF,0xA1,0xA9,0x12,0x6D,0x7B,0xBD,0xA6,0x6E,0x47,0xA5,0x6D,0xF5,0x9A,0xBB,0x6D,0xD5,0xB6,0x55,0x6B,0x1D,0xBA,0x55,0xDB,0x56,0x8D,0xAD,0xDB,0x16,0x1D,0x5B,0x34,0xAE,0xE6,0x82,0xA3,0x63,0x51,0xB8,0x6B,0x24,0x9B,0xEC,0xD2,0xE6,0xEE,0xC5,0xA0,0xDB,0x2B,0x22,0xB0,0xA8,0x52,0x15,0xAA,0x01,0xA0,0x80,0xDE,0x5C,0x19,0xD0,0xBC,0x08,0x03,0x5A,0x31,0x46,0x40,0x8D,0x2C,0xFF,0x0F};
const uint8_t spSLOW[] PROGMEM = {0x0A,0xB8,0x9C,0xC4,0x00,0xBF,0x68,0x1A,0xE0,0x3F,0xF1,0x00,0xFC,0x24,0xE9,0x80,0x9F,0x2C,0x0D,0x70,0x84,0x47,0xA9,0x3A,0xD2,0x11,0x97,0x6C,0xA3,0xAA,0xC4,0xD6,0x8C,0xB3,0xAC,0x32,0xB3,0x1A,0x57,0xE9,0xB2,0xEA,0xCC,0x7B,0xC2,0xB8,0xEB,0xAA,0x93,0xE8,0x71,0x93,0x6E,0xAB,0x49,0xAA,0x3B,0x9D,0xFB,0xB5,0x36,0xA8,0xAD,0x50,0xE9,0xDB,0x86,0x60,0xA7,0x5C,0xB4,0x4B,0x1A,0x5D,0xAD,0x54,0xF6,0x5D,0xE9,0x36,0x3D,0x4A,0x28,0x17,0x87,0xCB,0xB4,0x0E,0x63,0xDD,0xED,0x6E,0x53,0x3A,0x5D,0xB8,0xB3,0x7B,0x6C,0x5A,0x77,0xE5,0x3E,0xEE,0xB3,0xAD,0xC5,0xD5,0xF6,0xFC,0x3F};
const uint8_t spRELEASE[] PROGMEM = {0xA2,0x11,0xD5,0xAC,0x42,0xD5,0x99,0x45,0x16,0xB3,0x0A,0x75,0xEB,0x66,0x5F,0xC8,0xDB,0xDC,0x7E,0x19,0x4B,0xE6,0x42,0x2B,0x67,0xAB,0x6D,0x26,0x99,0xCA,0xBB,0xAC,0x66,0xB8,0x44,0x2A,0xDB,0x32,0xDA,0x16,0x0C,0xA4,0x6D,0xCD,0xE8,0x17,0xE5,0x50,0xF5,0x76,0xA3,0x5F,0x88,0x5B,0xA4,0x66,0xAF,0x7E,0x33,0x4D,0x66,0x4F,0xBB,0x9A,0xA6,0x43,0xD8,0xFD,0xF1,0xAA,0xBB,0x33,0x92,0xC8,0xD7,0x2B,0x9F,0xC1,0x91,0x22,0x17,0x8F,0xAC,0x3B,0x01,0x9F,0x9E,0x5D,0xD2,0x26,0x14,0xB3,0x72,0x71,0xC9,0x7F,0xAA,0x4C,0x44,0x25,0x0E,0xF8,0xC9,0xC2,0x01,0xBF,0xB8,0x3B,0xE0,0xA7,0x08,0x07,0xDC,0xEA,0xFE,0xFF};
const uint8_t spKEY[] PROGMEM = {0x09,0xE8,0x4A,0x35,0x01,0x53,0x8B,0x04,0x60,0x15,0x97,0x92,0x76,0x47,0xAC,0x5D,0x93,0x47,0x36,0x93,0x22,0x65,0xAF,0x19,0xD9,0x2C,0x8A,0x14,0xBD,0x65,0xE5,0xB3,0x28,0x52,0xF5,0x92,0x95,0xCF,0xA8,0xC8,0xDD,0xB3,0x47,0xB1,0xB2,0x21,0x65,0x3F,0x6E,0xE5,0xCC,0x82,0x5C,0xF9,0x44,0x97,0xB9,0xFC,0x7F};
const uint8_t spIGNITION[] PROGMEM = {0xAD,0x2F,0xDE,0x38,0xCB,0x7B,0x8F,0xA1,0xC5,0x04,0x6B,0xDB,0x3C,0x87,0x30,0x15,0xEE,0x90,0xCF,0x31,0xC3,0x14,0x0D,0xC5,0x5A,0x58,0x4E,0xCB,0x14,0xC2,0x96,0x95,0xD4,0x4D,0x4A,0xA6,0x7B,0x56,0xCC,0x30,0x25,0xA3,0xA3,0xE4,0xAA,0x5A,0xD7,0x0C,0x44,0x86,0xB9,0x59,0x75,0xB7,0x2E,0x1A,0x32,0x7B,0x15,0x43,0x85,0x4A,0xDB,0xA2,0x55,0x74,0x6F,0x62,0x1E,0xB3,0x5A,0x31,0xAC,0x31,0x9B,0x2D,0x1A,0xD5,0xCA,0xB3,0x9B,0x21,0x39,0x01,0x33,0x6D,0x27,0x60,0xA5,0xE9,0x00,0xF4,0xB6,0x39,0xDA,0x9A,0x58,0xCD,0x73,0xD5,0x68,0x6B,0x34,0x31,0x8F,0xCF,0xEB,0x18,0x26,0xD5,0x42,0xF7,0x8C,0xA3,0x7B,0xD6,0x74,0x89,0x9B,0xCE,0xEE,0x85,0x32,0x24,0x5A,0x3A,0xBB,0x15,0x29,0xD7,0x68,0xE1,0xE9,0x4E,0xB8,0x5C,0xA3,0x85,0xB7,0x5A,0xB1,0x64,0xAD,0xFB,0xFF};
const uint8_t spDEGREE[] PROGMEM = {0x0C,0x28,0x30,0x2C,0x45,0x43,0x9A,0x72,0xD8,0xEB,0x9D,0xAD,0xBA,0x0B,0x67,0x6E,0x7F,0x3D,0x9A,0xA1,0x1D,0xB9,0xF5,0x0B,0x02,0xA7,0x28,0x55,0xA1,0x1A,0x10,0xD6,0x5C,0x3A,0x35,0x2C,0x66,0x1A,0xA2,0x75,0x73,0x33,0xA7,0xA9,0x0F,0x51,0xD2,0x54,0xDD,0xB6,0x3A,0x27,0x6A,0x4A,0xCB,0xB6,0xCA,0x92,0xC8,0x2C,0x6C,0xED,0x2A,0x7B,0x54,0xD4,0xF2,0xD7,0xA3,0x1A,0xDE,0x50,0x26,0x1E,0xB7,0x7A,0x04,0x05,0x99,0x7C,0xDC,0xEA,0x19,0x0D,0xA8,0xEB,0x76,0xAB,0x66,0x30,0xA0,0xAA,0x59,0xAD,0x1A,0x41,0x40,0xAA,0x67,0xA5,0xAA,0x79,0x14,0xAB,0x9E,0xFD,0xFF};
//const uint8_t spRAIN[] PROGMEM = {0xE1,0x48,0xA5,0xCB,0x42,0x6C,0xB7,0xB1,0xE6,0x60,0x33,0x57,0x32,0xDA,0x54,0x38,0x5C,0xC3,0xD9,0x68,0x72,0xE5,0x28,0xF3,0xE4,0xAB,0xCE,0x59,0x3D,0x23,0xBA,0x8E,0xAA,0x78,0xE7,0x6E,0x7F,0xBC,0xCA,0xEE,0x9D,0xA2,0xFD,0xD2,0x2A,0x86,0x33,0xCA,0xB5,0xD2,0xAB,0xE8,0x56,0xA9,0x56,0xAA,0x8C,0xB2,0x39,0x8C,0x8C,0x88,0x33,0xAA,0x6E,0x31,0x32,0xDC,0xC9,0x68,0xBA,0xC1,0x48,0x77,0x27,0xAD,0xED,0x4A,0x39,0xC3,0x6A,0xF7,0xE1,0xFF,0x01};
const uint8_t spREPAIR[] PROGMEM = {0x62,0x14,0xCD,0xB8,0xBC,0xEC,0xBA,0xC9,0x35,0xB2,0xF4,0x54,0x96,0xA6,0x34,0xC9,0xC5,0xDB,0xDE,0x1A,0x6A,0x93,0x60,0xF1,0x6C,0x67,0xE8,0x3E,0x91,0xC3,0xB6,0x8C,0xA1,0x15,0x47,0x0E,0xDD,0x22,0x82,0xC0,0xDD,0x26,0xC5,0x09,0x02,0x12,0x33,0xC3,0x00,0x06,0x0C,0x50,0x9C,0x73,0xC9,0x6A,0x12,0x33,0xB5,0x59,0xAB,0x28,0x89,0x22,0xBC,0xAB,0x9C,0xA2,0xC5,0x62,0x0B,0xDD,0x72,0x8A,0x96,0x9A,0x35,0xE4,0xCB,0x29,0x5A,0x1E,0xD6,0x90,0x35,0xAB,0x6A,0xB9,0xD0,0x4A,0xBE,0x8C,0xA1,0xA5,0x42,0x1B,0xF9,0xD2,0xD6,0x1A,0x86,0x74,0x65,0xCB,0xD8,0x4B,0x5C,0x96,0xE5,0x2E,0xE3,0xA8,0x6E,0x85,0x8F,0xB6,0xB6,0xBB,0xA4,0x25,0x59,0xEE,0x52,0xEE,0xEA,0x8E,0xE9,0xB8,0xEB,0xFF,0x03};
const uint8_t spCANCEL[] PROGMEM = {0x0E,0x98,0xC5,0x25,0x00,0xB3,0x94,0x38,0x60,0x64,0x96,0x93,0xB5,0x2A,0xEA,0xD6,0xB3,0x4F,0xD5,0xAA,0x6A,0x58,0x2D,0x39,0x75,0xCB,0x66,0x61,0xB5,0xF8,0x54,0xB5,0xA8,0xBB,0x6E,0xED,0x55,0xD5,0x90,0x5A,0xB4,0x71,0x5A,0xD5,0x0C,0x85,0x69,0x7A,0x2A,0x45,0xD5,0x98,0xA1,0xE9,0x3A,0x54,0x85,0x93,0x2D,0x45,0x93,0xD6,0x56,0xC9,0x6A,0xE2,0x76,0x0C,0xF0,0x6B,0xA9,0x07,0x02,0xF0,0x5B,0x4A,0x00,0x9E,0xF2,0x68,0x45,0x11,0xEE,0xA9,0xB2,0xA6,0xAD,0x51,0x4C,0x86,0xEA,0xE6,0x72,0x66,0xD6,0x9D,0xC6,0x59,0xD2,0x1F,0x65,0x77,0x2B,0x75,0x09,0xBF,0xD7,0xD3,0x21,0xD2,0x35,0xFC,0x51,0xD6,0xA4,0x71,0xD6,0xF0,0x47,0x99,0x93,0x86,0x6D,0xC2,0x9F,0x79,0x4D,0x3A,0x66,0x31,0x5F,0x51,0x5E,0xE9,0xDC,0xE4,0xFF,0x01};
const uint8_t spVERIFY[] PROGMEM = {0xE6,0x68,0x52,0x8D,0x5D,0xDC,0x84,0x63,0xE4,0x09,0x57,0x51,0xD2,0xFA,0x6E,0x4D,0xC5,0xA5,0xCB,0x69,0x9B,0x77,0x55,0x97,0xCD,0xA7,0x6D,0xB6,0x54,0xC3,0xB6,0x9C,0xB6,0x04,0x37,0x77,0xCF,0x76,0xDA,0x5C,0xD5,0xDD,0x3D,0xDB,0xE8,0x52,0xE3,0x70,0x77,0x6F,0xAB,0xCF,0x55,0xD2,0x2C,0xBD,0x9D,0xA9,0xF8,0xD4,0x34,0xCB,0xBA,0xE6,0x12,0x5A,0xC2,0x65,0x73,0x1A,0x5B,0x2E,0x73,0xA5,0x25,0x0C,0x68,0xBA,0x94,0x01,0x43,0x97,0x09,0x60,0xB8,0x4A,0x03,0x14,0x2D,0x3E,0xDA,0x14,0xBC,0x82,0x7C,0xC9,0x5A,0x8A,0x9E,0x0C,0x97,0x2F,0x6B,0xED,0xAC,0xDB,0x52,0xB6,0xAC,0xBD,0xCA,0x4D,0x4F,0xD9,0xD2,0xAE,0xA2,0x36,0x3C,0xF5,0xF5,0x78,0xAA,0xEA,0xC8,0x94,0x35,0xED,0xEB,0xA2,0x3D,0x5A,0xD6,0x94,0xAF,0xE9,0xB6,0x0C,0xFE,0x52,0xFE,0x9A,0xD4,0xCA,0x7A,0x4A,0xFA,0x5B,0x74,0x4D,0xB7,0xC5,0xFF,0x0F};
//const uint8_t spREADY[] PROGMEM = {0x62,0x57,0x8D,0x2D,0xDD,0xD5,0xA5,0x3D,0x36,0x36,0x77,0x77,0x36,0x96,0xDC,0x38,0x25,0xCC,0xDB,0x19,0x4B,0xB0,0xD0,0xB0,0xAE,0xA7,0x6B,0xDE,0x35,0xCC,0xB6,0x9C,0xAA,0x05,0x57,0x67,0xDB,0x92,0xAA,0x6A,0xC8,0x82,0x7D,0x0B,0xEA,0x3C,0xB7,0xB0,0xAC,0x86,0x04,0xE8,0xC0,0xAD,0x8D,0x2D,0x88,0x98,0xF5,0x9D,0xB1,0x0C,0xEF,0x24,0xE1,0x6B,0xDA,0x3E,0x7D,0x12,0x86,0x7F,0x69,0xD7,0xF4,0x2D,0x10,0xB6,0xA5,0x5F,0xE5,0x99,0x21,0x11,0x2B,0x5E,0xD7,0xEF,0xFF,0x01};
const uint8_t spUSE2[] PROGMEM = {0x6D,0x38,0x86,0x14,0x3C,0x57,0x8F,0x7E,0x07,0x53,0x60,0xDD,0x3A,0xAA,0xEE,0x84,0x28,0xF3,0xC9,0x28,0x5A,0x20,0x96,0xAC,0xC5,0x23,0xEB,0x59,0x51,0xCC,0xDE,0xAC,0xAC,0x7B,0x27,0x31,0xD9,0xB2,0x8A,0xA6,0x54,0x2C,0x64,0xCD,0x2E,0x4A,0x1D,0x99,0x7B,0x16,0x6D,0x4E,0x53,0x60,0xE9,0x55,0xD4,0x26,0xCC,0x5E,0x9B,0xA7,0xCA,0x96,0xB4,0x47,0x2D,0x99,0x6A,0x5B,0xD2,0x91,0x14,0x47,0xB8,0x6E,0x49,0x67,0x32,0x1C,0xAE,0xB5,0x24,0x5D,0x8D,0x9A,0x93,0x45,0xB7,0x74,0x3F,0x8B,0xA9,0x14,0x6B,0xCB,0xFD,0x14,0x87,0x88,0x7A,0x6B,0xD7,0xB7,0x9E,0xCA,0xA2,0xCE,0x00,0x1B,0x50,0x3A,0xE0,0x11,0x0E,0x03,0x3C,0x82,0xEA,0x80,0x2F,0x50,0xFE,0x1F};
const uint8_t spOUT[] PROGMEM = {0x65,0x4A,0x6E,0xBC,0xD5,0x3B,0x8F,0xBE,0xA8,0xF5,0x72,0xED,0xBC,0x9A,0xAA,0x36,0x22,0x75,0xCB,0x6A,0x8B,0x9D,0x28,0xD3,0xCD,0xAB,0xCD,0x66,0xB2,0x5C,0x36,0xAF,0x3E,0xD9,0x8D,0x52,0xE9,0x3C,0xFA,0xE8,0x36,0x5A,0xB5,0xF7,0x68,0xA2,0x1D,0x4B,0xB5,0xDE,0xA6,0x4D,0xBC,0xD2,0x1D,0x3E,0x23,0x70,0x8A,0x52,0x15,0xAA,0x01,0x00,0x0E,0x98,0x42,0xDD,0x00,0xCF,0x57,0xFC,0x3F};
const uint8_t spOTHER[] PROGMEM = {0x6D,0xCC,0xBE,0xB4,0xC2,0x57,0x8D,0xB1,0xD8,0xB1,0x74,0xDD,0xB4,0xBA,0x6C,0xC6,0xD3,0x6C,0xD5,0xAA,0xA3,0x1E,0x2F,0xF5,0xD9,0xAE,0x4A,0x32,0x35,0xC8,0x67,0x87,0xA1,0x88,0x94,0xE4,0x4C,0xDC,0x86,0xA2,0x43,0x52,0x7C,0xF6,0x18,0x72,0x34,0x71,0xF7,0x55,0x63,0x2C,0x31,0x30,0x4A,0xF6,0xB4,0xB5,0xA4,0x46,0x1D,0xEE,0x53,0xAE,0x9A,0x17,0x65,0xB0,0x6F,0xBA,0xCB,0x0C,0x88,0xA2,0x2E,0xE9,0x29,0xB3,0xD0,0x1A,0xFB,0xA4,0xA7,0xF4,0x01,0x6F,0xEA,0x13,0xDE,0x72,0x02,0x46,0x79,0x4F,0xF8,0xCA,0x52,0xAC,0xD2,0x76,0xFF,0x0F};
const uint8_t spOIL[] PROGMEM = {0xA1,0x0C,0x61,0xBC,0x44,0x3A,0xA6,0xC5,0x95,0xB3,0x10,0xEB,0xD5,0x86,0x10,0x2E,0xCC,0x25,0xEF,0x6A,0xA3,0xDA,0xF4,0xE4,0xAC,0xAB,0xC9,0x7C,0xDC,0x9B,0xFB,0xAC,0xA6,0x88,0x56,0x1B,0xD9,0xB3,0xDA,0x2A,0x46,0x64,0xAD,0xCB,0x1A,0x2A,0x6B,0xF7,0x96,0x4D,0x6B,0xCC,0x6C,0xB2,0x5C,0xF2,0x8C,0x35,0xB1,0xED,0x52,0x49,0x5B,0xD6,0xC8,0x7B,0x52,0x38,0x6B,0x5A,0x23,0xAF,0x4E,0xE1,0xAE,0x69,0x4B,0x3C,0xBC,0xC9,0x5A,0xFF,0x3F};
const uint8_t spOFF[] PROGMEM = {0x69,0x70,0xBB,0xCD,0x25,0x36,0xB5,0xCE,0xD7,0x0D,0x57,0xED,0x3C,0x3A,0x5F,0x2F,0xCD,0xB4,0xF3,0xE8,0x7D,0xBE,0x34,0xD3,0xCE,0x63,0x08,0xFE,0xD3,0xDC,0x32,0x8F,0x39,0xFA,0x0F,0x73,0xCF,0xD4,0x8E,0xE8,0x3E,0xCC,0xBC,0x77,0x99,0x63,0xB8,0x30,0xF3,0x4E,0xE9,0x8E,0x79,0xDC,0x25,0x76,0xFA,0x9B,0x00,0xC3,0x56,0x10,0x60,0xFA,0x0A,0x01,0x4C,0x97,0xAE,0x80,0x66,0xCB,0x08,0x30,0x54,0xFA,0xFF,0x03};
const uint8_t spNEAR[] PROGMEM = {0xAE,0x4D,0x0A,0xD7,0xCD,0x1D,0x9B,0x36,0x48,0x5A,0x55,0x4F,0xAD,0xDA,0x24,0xF1,0xCC,0x24,0xB3,0xAB,0xBD,0x94,0x55,0xD7,0xD4,0xAD,0x2A,0x8A,0x2D,0x2A,0x4A,0x8D,0xAA,0x3B,0x65,0xEB,0x98,0xB4,0xEA,0x11,0x9C,0xB8,0xFD,0xD6,0xA8,0x7B,0x30,0x94,0xB1,0x47,0xAD,0xA9,0x51,0xD1,0x47,0x5F,0xB5,0xA6,0x64,0xC3,0x18,0xDE,0x54,0xEA,0x5C,0x1D,0xED,0xB8,0x77,0xA9,0x53,0x4D,0x94,0xA7,0x3C,0xA5,0x4A,0xB9,0x50,0x9F,0xF2,0x94,0x29,0xC5,0xC6,0x38,0xCA,0x93,0xCE,0xE8,0x17,0x7B,0xB8,0xE7,0xFF,0x03};
const uint8_t spGREAT[] PROGMEM = {0x6E,0xF3,0x59,0xC2,0x46,0xD9,0xA9,0xCD,0x0C,0x95,0x0E,0x55,0x6E,0x36,0x3D,0x9D,0xAA,0x4C,0xAE,0xD9,0xF4,0x0C,0xCC,0x36,0x7B,0x6E,0xF5,0x8B,0xF4,0x4C,0xB2,0x95,0x29,0x76,0xCC,0xD2,0xF4,0xB6,0xA6,0x5C,0xC4,0xD3,0xAA,0xEF,0x9A,0xAA,0x2F,0x8C,0x8C,0x4D,0x6B,0x19,0x6E,0x48,0xD2,0x56,0xAD,0x7D,0xB8,0x42,0x4E,0x5F,0xDD,0xCE,0x6E,0x0C,0x7C,0x72,0x71,0x38,0x87,0x36,0xD0,0xCE,0xD9,0x6C,0x1B,0x5A,0xC9,0x22,0x12,0x23,0x70,0x8A,0x52,0x15,0xAA,0x01,0x00,0x0E,0x18,0xD2,0xCD,0x01,0x9B,0xAB,0x09,0xE0,0x98,0x2D,0x01,0x2C,0x15,0x86,0x80,0x1A,0x15,0xFE,0x1F};
const uint8_t spMIXTURE[] PROGMEM = {0x61,0x8C,0x92,0x6B,0x4D,0xEA,0x94,0x31,0x0B,0xF6,0x29,0x49,0xDC,0x86,0x2A,0x44,0xB3,0x2D,0xCD,0xEA,0xAB,0x0A,0xD7,0xD0,0xDE,0xAB,0xEB,0x2A,0x55,0xD3,0x7B,0xAF,0xBE,0xDB,0x24,0x0F,0xDB,0x84,0xC0,0x29,0x4A,0x55,0xA8,0x06,0x04,0x60,0xEB,0xE9,0x00,0x7C,0x9B,0xED,0x80,0xDF,0x42,0x14,0xF0,0x7B,0x28,0x02,0xA7,0x28,0x55,0xA1,0x1A,0xA0,0x80,0xB3,0x3B,0x13,0xB0,0x82,0xE9,0xE8,0x7A,0x4C,0x26,0xB3,0xBC,0xA3,0xAB,0x59,0x58,0x4B,0xF7,0xB6,0x29,0x27,0xA1,0x2C,0xF9,0xDA,0xB6,0x5C,0x92,0x64,0xA9,0x6F,0x3B,0x73,0x57,0xCE,0xE6,0x3E,0xE9,0xCA,0xDD,0x31,0x86,0xFA,0x95,0x27,0x97,0x44,0x5F,0xEA,0x9F,0xFE,0xD4,0x94,0xAA,0xB9,0x5F,0xF8,0x53,0x15,0x9A,0xB2,0x7C,0xFF,0x0F};
const uint8_t spMUCH[] PROGMEM = {0x61,0x4A,0x92,0xAA,0xC5,0x13,0xA7,0xA9,0x08,0xD1,0x16,0x8D,0xDB,0xC6,0xCE,0x5C,0xDA,0x31,0xEE,0x1A,0x2A,0x6B,0x6F,0xA3,0x24,0xAB,0x49,0x6E,0xC3,0xDD,0x36,0xAD,0x3A,0xDB,0xB6,0x92,0xD8,0xB8,0xCA,0x9C,0x9C,0xDB,0xAB,0x31,0xAB,0x3D,0x4B,0xAB,0x0C,0x99,0x08,0x9C,0xA2,0x54,0x85,0x6A,0x00,0x01,0x66,0x55,0x55,0xC0,0x6C,0x9D,0x0E,0x98,0x7D,0x26,0x00,0xAB,0x4F,0x39,0x60,0xB6,0x99,0x00,0xCC,0x3E,0x15,0x80,0xD9,0x3A,0x15,0x30,0xFB,0xD6,0xFF,0x03};
const uint8_t spGREAT2[] PROGMEM = {0x6A,0xD1,0x55,0x75,0xC2,0x95,0xAA,0x5D,0x0C,0xD1,0x4E,0x55,0x66,0x56,0x35,0x58,0x3B,0xD5,0x99,0x99,0xCD,0x24,0x9F,0x50,0x77,0x61,0x0A,0x03,0xAB,0x4C,0xB2,0xB5,0x3E,0x2D,0x2C,0x0B,0xCD,0xBA,0xBA,0x52,0x35,0xC4,0x2D,0xDB,0x6A,0x9B,0x2B,0xD1,0xB4,0x2D,0xAB,0x1A,0xB6,0x88,0xD3,0xB7,0xAC,0x7C,0xD8,0x44,0xAE,0x5C,0xB3,0xD2,0xE1,0x1D,0x34,0x73,0xC9,0x48,0x47,0x12,0x34,0xEB,0x26,0x26,0xDB,0x8C,0x59,0xAD,0x1A,0x21,0x70,0x8A,0x52,0x15,0xAA,0x01,0xE0,0x80,0x2D,0xC3,0x1C,0xF0,0xAD,0xFB,0xFF,0x03};
//const uint8_t spIS[] PROGMEM = {0xA3,0xED,0xC6,0x30,0x3D,0x57,0xAD,0x7E,0xA8,0x42,0xA9,0x5C,0xB5,0xFA,0xA9,0x8A,0xB8,0x62,0xF3,0xEA,0x86,0x48,0xE6,0x8A,0x57,0xAB,0xEB,0x22,0x58,0x23,0x5E,0xAF,0xAE,0xCA,0x64,0xF5,0x7C,0x3C,0xBA,0xCA,0x93,0xD5,0xE3,0x76,0xEB,0x3B,0x4E,0x55,0xB3,0x4D,0x65,0xB8,0x58,0x5D,0xDD,0x72,0x97,0xE9,0x1B,0x55,0x27,0x4D,0xD3,0xE6,0x85,0xD5,0x4D,0x3D,0x6B,0xF9,0x5F,0x50,0x1B,0x26,0x27,0x0A,0xF8,0xAD,0x54,0x01,0xBF,0xBA,0x0B,0xE0,0xA7,0xF4,0xFF,0x07};
const uint8_t spCAUTION[] PROGMEM = {0x0A,0xC8,0xF9,0xD9,0x01,0xD9,0x3D,0x19,0x20,0xA5,0xA1,0x11,0x45,0xBB,0x56,0xC2,0xAD,0x46,0x91,0xCC,0x56,0x24,0x75,0x19,0x65,0x52,0x57,0x5A,0xBC,0x65,0xE6,0xA3,0x88,0xA9,0xA4,0xC3,0x33,0x2A,0xC0,0x71,0xB3,0x04,0xAC,0x50,0x99,0x80,0x15,0xBB,0x13,0x30,0xE3,0xD6,0x98,0xA7,0xDF,0x48,0x61,0x36,0x6B,0xA9,0x3E,0x59,0x33,0xBA,0xAC,0xB5,0xCA,0x14,0xAF,0xD8,0xDC,0xB6,0xE2,0xC4,0x52,0x72,0x51,0x39,0xBB,0x32,0x9C,0xE0,0xB9,0xE5,0x6A,0xDA,0xB8,0xC4,0xEA,0x96,0xBB,0x4B,0xA7,0x52,0xA9,0x57,0xEE,0x6A,0xC4,0x52,0x22,0x6E,0x7D,0xD2,0x53,0xB3,0xB9,0x8A,0xD6,0xFA,0x7F};
//const uint8_t spBELOW[] PROGMEM = {0x0C,0x50,0xD6,0x6C,0x24,0xD5,0x39,0x73,0x58,0xEB,0x55,0x75,0x9F,0x8C,0x65,0x6B,0x56,0xD3,0x9C,0x92,0x94,0x3F,0x19,0x6D,0xD3,0xC6,0x9C,0xB6,0x66,0x74,0x8B,0x89,0x6B,0x52,0xB7,0xD1,0x2D,0xC6,0x11,0xC1,0xE9,0x5B,0xB7,0x04,0x65,0x3A,0x66,0x1F,0xDD,0x16,0x54,0xA5,0xD8,0x6D,0xD5,0x8D,0x66,0xBB,0xF2,0xD6,0x55,0x15,0x9E,0xED,0x2A,0x5B,0x56,0x95,0x79,0x4F,0xA8,0x74,0x19,0x65,0x14,0xD3,0x21,0xD2,0xB9,0x15,0x51,0xCE,0x18,0x6B,0xE7,0x52,0x78,0xBD,0xAD,0xA4,0x9D,0x53,0xE9,0xE5,0xB6,0x91,0x74,0x49,0x55,0x90,0xD3,0xC2,0xBA,0x25,0xD4,0x91,0x74,0xAB,0x69,0x1B,0x57,0x47,0x31,0xEA,0xAA,0x75,0x44,0x23,0x45,0xBB,0x9B,0xCD,0xF9,0x7F};
const uint8_t spCYLINDER[] PROGMEM = {0x0C,0x78,0xC6,0x95,0x01,0x3F,0xA5,0x28,0xE0,0xB7,0x52,0x0B,0x04,0xE0,0xB7,0xD4,0x51,0x0C,0x9E,0x6A,0x6A,0xBD,0x57,0xD1,0x44,0xBA,0x84,0x6E,0x5E,0x45,0xC7,0xD1,0xE6,0xBA,0x75,0x15,0x87,0xD2,0xB4,0xB3,0xDB,0x55,0x1E,0x4C,0x55,0xA9,0x4E,0x56,0xD1,0x60,0xA7,0xBB,0xB5,0x5E,0x65,0xC7,0x1D,0x1A,0xB6,0x79,0x94,0x4D,0x91,0x8D,0xBB,0xBD,0x56,0x56,0x85,0x31,0x1E,0xF2,0x52,0x99,0x05,0xE6,0xA9,0xC6,0x53,0xAD,0x17,0xDC,0xC3,0x59,0x79,0x0D,0x53,0x87,0xB3,0x4A,0xD6,0x55,0x56,0x5D,0x42,0xE9,0xD9,0x56,0x59,0xED,0x12,0x0D,0x67,0x1D,0x55,0x89,0x8B,0xBC,0x94,0x67,0x54,0x39,0x34,0xD8,0xB2,0xEF,0x5A,0x85,0x32,0xF8,0xC6,0x2C,0xE8,0xFD,0xFF};
const uint8_t spCONTACT[] PROGMEM = {0x0E,0x28,0x79,0xC4,0x00,0x39,0x3B,0x8C,0x22,0xC7,0xF0,0x36,0xAB,0xB5,0x86,0xAC,0x27,0xBD,0x64,0xF3,0x1A,0x2B,0xDB,0x96,0xF6,0x2E,0xAB,0x2B,0xE6,0xCC,0xD3,0x16,0xAD,0xBA,0xD8,0x15,0x4F,0x5F,0xB4,0xAA,0x6A,0xC2,0x92,0xB2,0x6D,0x2B,0x9B,0x66,0x1B,0x2E,0x4D,0xA1,0xCA,0x92,0x3A,0xA9,0x55,0xB1,0x2E,0x0A,0x57,0xD7,0xB2,0x94,0x80,0xC9,0x8A,0x4A,0xD1,0x43,0xB1,0x52,0xD6,0x59,0x45,0xF1,0xA6,0x69,0x5D,0x79,0x55,0xD5,0xA7,0x96,0xE7,0xE2,0xD5,0x96,0x50,0x52,0x11,0x8B,0x57,0x53,0xB3,0x5B,0x69,0xCF,0x1E,0x75,0xAD,0x46,0x2D,0x5D,0x06,0x81,0x53,0x94,0xAA,0x50,0x0D,0x00,0x00,0x03,0x4C,0xA1,0x6E,0x80,0xE7,0x2B,0xFE,0x1F};
//const uint8_t spAND[] PROGMEM = {0x6B,0xA8,0x2E,0x79,0xAC,0x37,0xAE,0xA5,0xBA,0xE4,0xCE,0x5C,0xB8,0xA6,0xE6,0x92,0xB3,0x62,0xD1,0x9A,0xAA,0x2B,0x8E,0x8A,0x45,0x6B,0xAA,0xA6,0x38,0x33,0x66,0x97,0xA9,0x39,0xCC,0xD0,0xF0,0x9C,0xA6,0x66,0xB1,0x5C,0xD2,0xB3,0x99,0x93,0xA4,0x0E,0x19,0x17,0x64,0xE3,0xBA,0x34,0xB3,0x6D,0x96,0xA7,0x69,0x53,0x57,0xDD,0xD2,0x96,0x6A,0x8A,0x45,0xA2,0xF5,0xFF,0x03};
const uint8_t spFUEL[] PROGMEM = {0x04,0x18,0xB6,0x82,0x00,0xD3,0x57,0x08,0x60,0xBA,0x74,0x05,0x34,0x5B,0xB6,0x8A,0x19,0x92,0x21,0x7D,0xF3,0x2E,0x56,0x31,0x62,0x09,0xA4,0x6C,0x59,0x65,0xE3,0xA6,0xDA,0xB2,0xB5,0xD4,0x41,0xA4,0x67,0xD2,0xEA,0xD4,0x5B,0x3D,0x11,0x4E,0x5B,0xD2,0x1A,0xF8,0x86,0x07,0xEE,0x2D,0x5B,0xA2,0x5B,0xA6,0x9A,0x35,0x1D,0x89,0x6E,0xBB,0x48,0xBF,0xF4,0x26,0x3E,0x53,0xCC,0x59,0xD3,0x97,0x68,0x6F,0x09,0xA7,0x09,0x7F,0x14,0x35,0x21,0xD4,0xE4,0xFF,0x01};
//const uint8_t spFOR[] PROGMEM = {0x08,0xA8,0x56,0x98,0x00,0xD5,0x97,0x13,0x60,0xD8,0x50,0x51,0x58,0x77,0xA5,0x81,0x59,0x62,0x57,0xBA,0x20,0x6E,0x25,0x58,0x5B,0xEB,0x83,0xB9,0xE2,0x14,0xEF,0xA3,0x0F,0x7E,0x2D,0x8A,0xBD,0x8D,0x3E,0x86,0x11,0x4F,0xF3,0x37,0x86,0x64,0x53,0xCB,0x2D,0x77,0x18,0x33,0x2F,0x09,0x97,0x45,0xFF,0x0F};
const uint8_t spSEQUENCE[] PROGMEM = {0x0C,0xF8,0x4E,0xCC,0x00,0x3F,0xBB,0x1B,0xE0,0x77,0x57,0x03,0xFC,0x15,0x12,0x80,0x3F,0x4D,0x57,0xD2,0x8D,0xB2,0xB8,0x2F,0x5E,0xE9,0xF0,0xCE,0xE4,0xFE,0x78,0x65,0x23,0x18,0x52,0xE5,0xE2,0x94,0x8F,0x4A,0x10,0xDD,0x95,0x10,0x38,0x45,0xA9,0x0A,0xD5,0x00,0x04,0x84,0x7C,0x82,0x00,0x55,0xDD,0x5A,0x16,0x4D,0x87,0x15,0x6F,0x5E,0x4B,0x56,0x15,0xDE,0xB2,0x79,0x6C,0x59,0xA7,0x47,0xDB,0xAA,0x72,0x66,0x9D,0x96,0xED,0x0B,0xC3,0x93,0x4C,0x78,0x57,0xCC,0x0C,0x7F,0xB5,0x1C,0x23,0x95,0x58,0xFD,0x59,0x73,0xA4,0x7A,0x62,0xF2,0x37,0x6E,0xE2,0x66,0x6E,0x08,0xF0,0x1D,0x91,0x00,0x7E,0x71,0x34,0xC0,0x1F,0x29,0x06,0xF8,0xB5,0xD4,0x00,0xBF,0x17,0x1B,0xE0,0x67,0x43,0x05,0xBC,0xEE,0xF2,0xFF};
const uint8_t spSIDE[] PROGMEM = {0x06,0x38,0x00,0xD5,0x01,0x3F,0x31,0x3B,0xE0,0x1F,0xB1,0x00,0xFC,0xAE,0x56,0x8A,0x5F,0xCD,0x8B,0x8D,0xE9,0x2A,0x2A,0x1F,0x97,0xB4,0xD5,0xAB,0x2B,0x72,0xDC,0xCA,0x36,0xAF,0xAE,0x89,0x4D,0x29,0xDB,0xB2,0xBA,0x2E,0x26,0xB4,0xAC,0xCB,0x6A,0xAB,0x2D,0xCD,0xB4,0xD5,0xAB,0xA9,0x21,0x24,0x23,0x16,0xAD,0xAA,0x5A,0xE7,0xCE,0x9C,0x95,0xAA,0x2C,0x8D,0xC2,0x2B,0xA1,0xAA,0xB9,0x49,0x1B,0x2B,0x8B,0xAE,0x1E,0x46,0x94,0xCC,0xD2,0x94,0xA1,0x6A,0x55,0xB5,0x5C,0xF5,0xFF};
//const uint8_t spSLOW[] PROGMEM = {0x04,0xF8,0x8E,0x98,0x00,0xDF,0x30,0x2A,0xE0,0x27,0x11,0x07,0xFC,0x64,0x6C,0x80,0x9F,0xD5,0x1C,0xF0,0x8B,0x48,0xEB,0x2B,0xCE,0x52,0x93,0x2C,0xAD,0xCF,0x38,0xBB,0x02,0xB3,0xAE,0x2E,0xB1,0xE9,0x62,0xEE,0xBB,0xDA,0x24,0x7B,0x42,0xB8,0xEF,0x6A,0x0A,0xC9,0x4E,0xE7,0x6C,0xAB,0x8A,0x7C,0xCA,0x8D,0xF3,0xB4,0x2A,0xC8,0x2D,0x57,0xEE,0x5D,0x4A,0xAF,0x37,0xDD,0xB0,0xB7,0x2B,0x55,0x9C,0x30,0xE1,0x8E,0xAC,0x96,0xFA,0xC2,0xD9,0xDC,0xFC,0x3F};
const uint8_t spTO[] PROGMEM = {0x09,0xD8,0x4E,0x34,0x00,0x4B,0xA7,0xA5,0xBC,0xE9,0x62,0x55,0x4B,0x53,0x9A,0xAC,0x5C,0x2D,0xF9,0x4B,0xE9,0x32,0x73,0xD3,0xA1,0x3D,0xA5,0x4F,0x52,0x2D,0x9B,0xB6,0xA4,0x21,0x79,0x95,0xC0,0xAC,0xAD,0x16,0xED,0xDC,0x22,0x23,0xC2,0xFF,0x03};
const uint8_t spRICH[] PROGMEM = {0xAE,0x50,0xD1,0xA2,0x94,0xAD,0xB9,0xDA,0x44,0xF3,0x74,0x8E,0xE3,0x5A,0x9D,0xCC,0xDC,0xD5,0x6E,0xE8,0x6C,0xD2,0x74,0x55,0x67,0xA9,0x0D,0x89,0x3C,0x42,0x93,0xB7,0x2A,0x0F,0x4A,0x72,0x4B,0xB7,0xCA,0x1A,0x4D,0xD5,0x75,0xCD,0x2A,0x9A,0x0B,0xB6,0xB0,0xD7,0xAB,0x6C,0x36,0xC9,0xC2,0x5F,0xAD,0xB6,0x05,0x67,0xF7,0x58,0x55,0xE6,0xEA,0x83,0xCC,0xE3,0x13,0x02,0xA7,0x28,0x55,0xA1,0x1A,0x40,0x80,0x59,0x55,0x15,0x30,0x5B,0xA7,0x03,0x66,0x9F,0x09,0xC0,0xEA,0x53,0x0E,0x98,0x6D,0x26,0x00,0xB3,0x4F,0x05,0x60,0xB6,0x4E,0x05,0xCC,0xBE,0xC5,0x80,0xD1,0xA6,0xFE,0x1F};
const uint8_t spPUMPS[] PROGMEM = {0x02,0x88,0xCE,0x53,0x00,0xC9,0x86,0xA6,0x22,0x9A,0xCE,0x64,0x69,0xB5,0xDA,0x64,0x36,0xDD,0x75,0xF3,0xEA,0x32,0xDF,0xB6,0x92,0xCE,0x63,0xCE,0x7C,0xCB,0x4A,0x37,0xB7,0x3D,0xA9,0x0D,0x4B,0x5D,0x9C,0x8E,0x10,0x3A,0xC3,0x62,0x49,0x38,0x83,0x0A,0x2F,0x12,0x37,0xFA,0x44,0xE0,0x14,0xA5,0x2A,0x54,0x03,0x00,0x40,0x01,0x49,0x79,0x1A,0xE0,0x19,0x57,0x05,0xFC,0x94,0x62,0x80,0xDF,0x4A,0x2D,0xA0,0x80,0xDF,0x52,0x15,0xF0,0x4B,0xD9,0xFF,0x03};
const uint8_t spLEVEL[] PROGMEM = {0x69,0xAB,0xC4,0xB3,0xD8,0x92,0x86,0x2D,0x83,0xEE,0x60,0xCD,0x12,0xD6,0x0C,0x66,0x45,0x2C,0x73,0x58,0x0B,0xA8,0x53,0xD6,0xAC,0x6D,0xE9,0xC0,0x57,0xC5,0xB2,0xAE,0xA1,0xB0,0x49,0x0D,0x7B,0xBD,0x86,0xA2,0x47,0x35,0xE3,0xF5,0xEA,0xB2,0x4B,0x4B,0xCB,0xC7,0xA3,0xCD,0xDE,0x23,0x59,0x1A,0x9A,0x31,0x8B,0xB0,0x54,0x76,0xE3,0xC6,0x26,0x5C,0x2C,0xCC,0x76,0x6B,0x92,0xBC,0x34,0x95,0xC6,0xA3,0xCE,0x74,0xDB,0x85,0x3B,0x8F,0xBA,0x90,0x9C,0x51,0xCC,0xD6,0xEA,0x4C,0x63,0x56,0x30,0x6D,0xA9,0x23,0xCF,0x59,0xD0,0x34,0xB5,0xF9,0x7F};
const uint8_t spLOWER[] PROGMEM = {0x66,0x4D,0xA8,0x2A,0x4C,0xDA,0x9A,0x3D,0xC2,0x6D,0x31,0x6F,0xE3,0xB6,0x06,0x7C,0x55,0x22,0xA9,0x5B,0x23,0xE8,0x31,0xD3,0x34,0x61,0x49,0x28,0xBB,0x83,0xB2,0x94,0xB9,0x02,0xEB,0x4A,0xF2,0xBB,0xC6,0x42,0x23,0x43,0x2D,0xEE,0xEA,0x0B,0xA9,0x09,0xE3,0x6E,0xAB,0x29,0x24,0x27,0x95,0xBD,0xAD,0x3A,0xB1,0x9E,0x50,0xCA,0x36,0xAA,0xC0,0x67,0x5C,0xD9,0x6B,0xAA,0x9C,0xBE,0x36,0x23,0x2F,0xA5,0xB2,0xFE,0x42,0x42,0xFC,0x8C,0x22,0xC4,0x15,0x2B,0xCE,0x33,0x8A,0x98,0x9D,0xA7,0xA9,0x77,0x2B,0x52,0x17,0xDE,0xE4,0xDC,0xAD,0x48,0x2D,0x60,0x8B,0x73,0x97,0x3C,0x35,0x83,0x2D,0xCA,0xF2,0xFF};
const uint8_t spREAR[] PROGMEM = {0x66,0x54,0xCD,0xCD,0x43,0x95,0x9A,0x49,0x95,0x50,0x4F,0x71,0xEA,0x26,0x53,0x4C,0x23,0xD9,0x4D,0x1A,0x62,0xC5,0x70,0xD7,0x74,0xAB,0xAD,0x9D,0x9D,0x42,0xDB,0xAD,0xBA,0xFB,0x52,0x68,0x59,0xBB,0xAA,0xEE,0x92,0x61,0x74,0xF5,0xAA,0x7B,0x2C,0x82,0xD1,0xCD,0xAB,0x6B,0x21,0x91,0x46,0x37,0x8F,0xB9,0x7A,0x47,0x5F,0x7D,0xDD,0xE6,0x1A,0x12,0x75,0xF9,0x53,0x39,0x6A,0x6E,0xD4,0xC5,0xDD,0xED,0x28,0x65,0xD0,0x16,0x7B,0x87,0x3B,0x97,0x01,0x3D,0xEA,0x1B,0xBE,0x9C,0x16,0xF9,0xB1,0x6F,0xF8,0x73,0x2B,0x88,0xA1,0x2E,0xE1,0xCF,0xDB,0x21,0x9B,0xDA,0x84,0x3F,0x6F,0x87,0x49,0xEA,0x1C,0xFE,0x3C,0x12,0xA6,0x25,0x4B,0xF8,0xF3,0x54,0x3E,0xD7,0xD4,0xFF,0x0F};
const uint8_t spHOLD[] PROGMEM = {0x08,0x28,0xDA,0x03,0x03,0xA1,0x1F,0xD0,0xFD,0x83,0x12,0xB7,0x36,0xCA,0xDA,0x40,0xCD,0xD2,0xDA,0xCC,0xFD,0x82,0xA8,0x6B,0x6B,0x12,0xF3,0x2B,0xA6,0xAE,0xAD,0x8E,0x2C,0xB7,0x09,0xDB,0xB6,0x3A,0xD1,0x9A,0x11,0x68,0xDB,0xAA,0x8C,0x6B,0x4B,0xA0,0x6D,0xAB,0x32,0xC9,0x2D,0xC1,0xB4,0xAD,0x48,0x2C,0xB7,0x98,0xD2,0x96,0x3C,0x31,0xDB,0x60,0xC9,0x56,0xB2,0x24,0x6C,0x9C,0xD5,0x6B,0xCA,0x93,0x90,0x0A,0x35,0x37,0xA9,0xCA,0x54,0xDD,0x32,0x92,0x8E,0xB4,0x8A,0x16,0xD5,0x78,0x3D,0x8A,0x6A,0x8A,0x4C,0x6B,0xF1,0xFF,0x03};
//const uint8_t spLONG[] PROGMEM = {0xAE,0xAF,0xC0,0x32,0x92,0xB3,0x86,0xB5,0x02,0x2F,0x77,0xEE,0x17,0xD6,0x0C,0xB3,0xD5,0xB5,0x4B,0x58,0x0A,0xF0,0xCE,0xA0,0x3E,0x63,0xAE,0xC8,0xAB,0x03,0xB2,0x8C,0x31,0xAA,0x9B,0x60,0xED,0xB2,0x86,0xE0,0x6E,0x9C,0xAD,0xED,0xEA,0xA3,0xBD,0x71,0xB6,0xAE,0xAB,0x8D,0xEE,0xC6,0xC4,0xDB,0xAE,0x36,0xFA,0x6B,0x53,0x6F,0xBB,0x9A,0x18,0xB7,0x4C,0x3D,0xCB,0xAA,0x43,0x9C,0x34,0xF5,0x36,0xA3,0x8A,0xA6,0xAB,0xD9,0x93,0xB6,0xAA,0x70,0xF3,0x53,0xB7,0xD3,0xEA,0xC2,0xD5,0xD7,0xCC,0x6E,0xAB,0x9B,0x26,0x6B,0x77,0x25,0xAD,0x4E,0xC6,0x2A,0xD8,0xE5,0xFC,0x3F};
//const uint8_t spLEVEL[] PROGMEM = {0xA5,0x1E,0x40,0x27,0x84,0xF3,0x94,0xB6,0x03,0x5F,0x65,0x8F,0x9B,0xBA,0x09,0x64,0x1D,0xA3,0xCE,0x6A,0x2B,0xEB,0x34,0xB5,0xC7,0xAB,0xAE,0x62,0x4C,0x23,0x67,0xAF,0xBA,0xE8,0x11,0xF7,0x5C,0xBC,0xEA,0x62,0x4B,0x43,0x63,0xF1,0xAA,0x53,0xF0,0x0A,0xCD,0xD9,0x66,0xCC,0x22,0x2C,0x95,0xDD,0xB8,0xB1,0x09,0x17,0x0B,0xB3,0x1D,0xF6,0x22,0x23,0xD3,0x39,0x96,0x99,0x6D,0xEB,0x10,0x89,0xC5,0x65,0x09,0xFA,0xDA,0x44,0x7A,0xB7,0x2D,0xF1,0x1D,0x17,0xCD,0x52,0xF6,0xC4,0xAE,0x9D,0xA5,0x6F,0x3A,0x12,0xBD,0x76,0x96,0x2C,0xE9,0x8C,0xFC,0xCB,0x59,0xBB,0xB8,0x3B,0xCA,0xED,0x62,0xEE,0xA4,0x1E,0xEF,0x3E,0x9D,0xBC,0xF5,0xFF,0x03};
const uint8_t spLEFT[] PROGMEM = {0x6E,0x4C,0xB8,0x8B,0xB5,0xDA,0xA6,0x75,0x23,0xEA,0x24,0x4B,0x1B,0xD6,0x0D,0x69,0x02,0xBD,0x5D,0x59,0x36,0xA2,0x49,0xB4,0x76,0x65,0xDC,0x88,0xC7,0x31,0x96,0xAD,0xA1,0xF1,0x8A,0x30,0xD9,0xB2,0xBA,0x2E,0xDB,0xC2,0x74,0xCB,0x6A,0x9B,0x29,0x4D,0xB3,0x35,0xAB,0x6B,0xAE,0x25,0x2D,0x56,0xAF,0xB1,0xF8,0xD4,0xB2,0x9C,0x23,0x80,0x6A,0x52,0x05,0xD0,0x75,0x28,0x03,0xBA,0x29,0xE5,0x00,0x02,0xA7,0x28,0x55,0xA1,0x1A,0x00,0x0A,0x18,0xD2,0x8D,0x01,0x9B,0xAB,0x21,0x70,0x8A,0x52,0x15,0xAA,0xF1,0xFF};
const uint8_t spRIGHT[] PROGMEM = {0xAA,0x90,0xD5,0xAD,0x55,0x9D,0xA9,0x56,0x94,0xD4,0x0A,0x97,0xAB,0x7A,0x39,0x9C,0xBB,0x44,0x5D,0xE8,0xFD,0x14,0x3D,0x53,0xF7,0xAD,0x09,0x5D,0xAB,0xD4,0xDD,0xAD,0x3A,0xCB,0x0B,0x2F,0xE9,0xBC,0xEA,0xA2,0xCF,0xBC,0x74,0xD5,0xAA,0xAB,0x1D,0x89,0xD2,0xC7,0xAB,0xAD,0x21,0xA9,0xD2,0x1F,0x8F,0xB1,0x5A,0xA7,0xA9,0x7A,0x54,0x8E,0xE1,0x12,0xBC,0xF2,0x65,0x38,0xBB,0x67,0x8A,0xEE,0x56,0x08,0x9C,0xA2,0x54,0x85,0x6A,0x00,0x80,0x03,0xA6,0x50,0x77,0xC0,0xF3,0x15,0x04,0xD8,0xCA,0xEC,0xFF,0x01};
//const uint8_t spOPEN[] PROGMEM = {0xA5,0x4D,0xB2,0xD7,0x84,0xBA,0xB4,0x2A,0xCA,0x59,0x16,0xDD,0x3A,0xCA,0xC4,0x67,0x85,0xA5,0xDF,0x2A,0x2A,0xCA,0x75,0xE5,0x6C,0x2D,0xCF,0x28,0x27,0x9C,0xBD,0x21,0x70,0x8A,0x52,0x15,0xAA,0x01,0x90,0xA2,0xAE,0xCA,0x5C,0xD5,0xF1,0xCA,0xAB,0x32,0xAF,0xA0,0xCE,0xAB,0x2C,0x3A,0xDC,0x4D,0xBE,0x8C,0xB2,0x38,0x0D,0x91,0x9C,0xD3,0x8A,0x6E,0x48,0xC7,0x2C,0x6E,0x29,0x9A,0x64,0x1D,0xB3,0xB8,0xA5,0xAC,0x5C,0x74,0xCC,0x92,0x96,0x2A,0x6B,0x73,0x97,0xAC,0xFD,0xFF};
const uint8_t spSTRAY[] PROGMEM = {0x04,0x78,0xC6,0x95,0x01,0x3F,0xA5,0x28,0xE0,0xB7,0x52,0x0D,0x18,0xE0,0xB7,0x54,0x05,0xFC,0x52,0x86,0xC0,0x29,0x4A,0x55,0xA8,0x06,0x30,0x20,0x1A,0x51,0x75,0xD4,0xD8,0x99,0x69,0x76,0x46,0x13,0x07,0x87,0x95,0xA4,0x5F,0x75,0x1A,0x92,0x5A,0x9C,0x6E,0xD5,0xB9,0x9A,0x5B,0x71,0xB6,0x55,0xE6,0x9C,0xE2,0x25,0x5B,0x56,0x59,0x6D,0xB1,0xB5,0xBE,0x5E,0x75,0x57,0xC5,0x3A,0xB6,0x7A,0x4D,0x5D,0x05,0x7B,0xDB,0xA3,0x31,0x37,0x1B,0x64,0x1D,0x8F,0xC6,0xD1,0xA3,0xB2,0x47,0xDE,0x6E,0x67,0x0B,0xCC,0x59,0x75,0xB9,0xDD,0xCD,0x91,0x74,0xE5,0xE4,0xF2,0x74,0xE7,0x28,0x9B,0xB3,0xD3,0xDB,0x8D,0xA1,0x5D,0x3E,0x2A,0x6F,0x33,0x42,0x39,0xBD,0x38,0xFD,0xA3,0x3B,0xAA,0xE7,0x9A,0xF0,0x8F,0xA1,0xA4,0x56,0x4B,0xCC,0x3F,0x96,0xB3,0x48,0x2C,0xF9,0x7F};
const uint8_t spCLOSE[] PROGMEM = {0x0C,0x88,0xBD,0xD2,0x00,0x59,0x4D,0x19,0xA0,0x8A,0x2E,0x05,0x74,0x65,0x11,0x8A,0x4C,0xA3,0x47,0xB0,0xE9,0x28,0x33,0xAB,0x09,0xE1,0xCE,0xA3,0xA9,0x24,0x26,0x8C,0xFB,0x8C,0xA6,0xD0,0x1A,0x55,0xE9,0x33,0xBA,0xC4,0xA7,0xCD,0x64,0x6B,0x1B,0xA2,0xDA,0x34,0x95,0xCD,0x65,0xF5,0x7E,0x5D,0xD5,0x37,0xA7,0xDD,0xFB,0x4A,0x13,0xDD,0x94,0x8E,0xA0,0x2B,0xCD,0x78,0x93,0x3B,0x83,0xA9,0x50,0x93,0xCD,0xE6,0x0B,0xD6,0x32,0xC4,0x57,0xBB,0x2F,0x79,0x33,0x95,0x58,0xAC,0xBE,0x64,0x4D,0x4D,0xFC,0x91,0x7B,0x06,0x76,0x17,0xB3,0x6C,0xEE,0xB9,0x96,0x3D,0x49,0xD2,0xA5,0xF7,0x39,0xD1,0x22,0xCE,0x46,0x5E,0x47,0xD2,0x27,0x23,0x15,0x7F,0xD3,0xDB,0x9D,0x91,0x8B,0x6D,0x71,0x6F,0x8F,0x29,0x22,0xB6,0xE5,0xFF,0x01};
const uint8_t spEVACUATE[] PROGMEM = {0x21,0x19,0xDA,0x89,0xAA,0x16,0x8F,0x7E,0x6A,0x63,0xAA,0x5A,0x7C,0xFA,0x69,0x83,0x31,0x72,0xCD,0x69,0x86,0x0F,0xA2,0xF4,0x2D,0xA3,0x6D,0x4E,0xD8,0x42,0xBB,0x94,0xBE,0x3A,0x33,0x55,0x69,0x9D,0xC6,0xAE,0xCD,0x54,0xCD,0x4D,0x19,0x87,0x72,0x17,0x31,0x37,0xAB,0xAB,0xDE,0xD5,0x54,0x5B,0x9F,0xAA,0xF9,0xD0,0x50,0x5B,0x73,0x8A,0x66,0x5A,0xC2,0x63,0xCD,0xC9,0x6A,0x0C,0x2D,0xEB,0xC5,0x27,0xAB,0x49,0xBD,0x6C,0x1A,0x8D,0xA4,0x15,0xF6,0x92,0x93,0x8C,0xC0,0x29,0x4A,0x55,0xA8,0x06,0x18,0x60,0x45,0x57,0x03,0x9C,0x3C,0xB2,0xD2,0x11,0x12,0xB1,0x6C,0xCB,0xEA,0x9A,0x72,0xD2,0xD6,0x2D,0xA3,0x2F,0xA8,0x52,0x9A,0xBA,0x96,0x29,0xF2,0x4D,0x2B,0xE8,0xD2,0xE6,0x4C,0x27,0xAD,0xB1,0xEF,0x9A,0x9B,0x69,0xF3,0xC4,0x6D,0x67,0x6F,0x3E,0xD5,0x52,0xBB,0xAD,0xA3,0x87,0x36,0x4A,0xED,0xBA,0xCE,0x1E,0x52,0x38,0x7D,0xF3,0x3E,0xD3,0x35,0x6C,0x32,0x55,0x6C,0xB1,0x37,0x02,0xA7,0x28,0x55,0xA1,0x1A,0x00,0xA0,0x80,0x29,0xD4,0x05,0xF0,0x7C,0xC5,0xFF,0x03};
const uint8_t spFAILURE[] PROGMEM = {0x04,0x18,0xB6,0x82,0x02,0x04,0x98,0xBE,0x42,0x00,0xD3,0xA5,0x6B,0x60,0xD5,0xC3,0x95,0x48,0xC8,0x96,0xD5,0x0D,0x57,0xCC,0xA5,0xAB,0x57,0xDF,0x54,0xB0,0xB5,0xAD,0x5E,0xC3,0x60,0x95,0x62,0x9A,0xAE,0x2D,0x9D,0xBA,0x7B,0xA8,0xF7,0xB4,0x36,0x19,0x4E,0xEE,0xE9,0xCA,0xDA,0x75,0x20,0xB7,0x6D,0x69,0x6B,0xD3,0x81,0x32,0xB1,0xA6,0x6D,0xCD,0x05,0x68,0x47,0xDF,0xB2,0x37,0x5F,0x24,0x2D,0x5D,0xC2,0x55,0x5C,0x92,0x9C,0xF4,0x09,0x6F,0xB6,0x85,0x76,0x96,0xC5,0xBD,0xD9,0x37,0xE8,0x9A,0x3E,0xF7,0xE6,0x16,0x90,0x69,0xDE,0xDC,0x97,0xAB,0x63,0xB4,0xA7,0xFD,0x7F};
const uint8_t spSERVICE[] PROGMEM = {0x0C,0xF8,0x29,0x45,0x01,0xBF,0x95,0x5A,0x20,0x00,0xBF,0xA5,0x3A,0xE0,0x97,0x32,0x03,0xFC,0x5C,0x56,0xF2,0x6A,0x2A,0x20,0x2C,0xF9,0xC8,0x8A,0x2F,0xC1,0x95,0xEC,0x23,0xCD,0x31,0x99,0x97,0xB3,0x8F,0x34,0xBB,0x12,0x5A,0xF1,0x1E,0xF2,0xE4,0x42,0xA5,0xC8,0xA9,0x98,0x9C,0x49,0xD5,0x08,0x37,0x6D,0x29,0x26,0x55,0x52,0xBA,0xB6,0xB5,0x58,0x17,0x0F,0x7F,0xDD,0xCE,0x6C,0x5D,0xC2,0xF3,0xD7,0x78,0x9A,0x49,0x51,0xB3,0xCE,0xE5,0xAB,0x3A,0xD9,0xCC,0x76,0x95,0xBF,0xDB,0x76,0x15,0xF6,0x67,0x80,0x5F,0x53,0x0C,0xF0,0x6B,0xB2,0x03,0x7E,0x4E,0x37,0xC0,0x6F,0x66,0x0A,0xF8,0xAB,0xD9,0x00,0x7F,0xA6,0x29,0xE0,0xB7,0x92,0xFF,0x07};
const uint8_t spABORT[] PROGMEM = {0xAD,0x4E,0x66,0x4A,0xDC,0x17,0xAF,0xA5,0xC8,0x19,0x35,0xDD,0xBA,0x86,0x22,0x7A,0xCC,0x64,0xEB,0x1A,0x92,0x9A,0x56,0xB3,0x2E,0x6A,0x36,0x31,0x85,0x2C,0x5A,0x89,0x45,0xDB,0x56,0xB2,0x68,0x2D,0x56,0x69,0xCA,0x59,0xBD,0x35,0x5B,0xB9,0xEA,0x50,0xB5,0x2E,0x6C,0xE5,0xA2,0xBA,0x5C,0x5D,0x8F,0x26,0xF1,0x19,0x55,0xCE,0xBA,0xEA,0x28,0x66,0xCC,0x28,0xFB,0xAA,0x12,0xEB,0x55,0x67,0xF7,0xAB,0x08,0xFA,0x5A,0x82,0xBD,0x9D,0x2C,0xDA,0x0D,0x29,0xD1,0xB6,0x92,0x58,0x8B,0xB3,0xA8,0xCF,0x8A,0x72,0x4E,0xCA,0x32,0xAD,0x25,0x2C,0xDB,0x8C,0xD5,0x95,0x22,0x70,0x8A,0x52,0x15,0xAA,0x01,0xE0,0x80,0x21,0xDD,0x0C,0xB0,0xB9,0x1A,0x03,0xA7,0x28,0x55,0xA1,0x1A,0xFF,0x0F};
const uint8_t spIDEMTIFY[] PROGMEM = {0xA9,0x8C,0x23,0xDD,0xB3,0xA7,0x9C,0xB1,0xA9,0x89,0x08,0x59,0x73,0x86,0xA6,0xCA,0xB2,0x74,0xF3,0xE9,0xBB,0x1A,0xD6,0xB6,0xCD,0xA3,0x1F,0x6A,0x88,0x4A,0x3F,0x22,0x70,0x8A,0x52,0x15,0xAA,0x01,0x02,0xC8,0xA0,0xEC,0x14,0xD5,0x26,0x95,0xE7,0xE2,0x93,0x15,0xDD,0x5C,0x15,0x8B,0x4E,0x96,0x4D,0x49,0x47,0xD5,0x1E,0x59,0x36,0xEE,0x43,0x1D,0xA9,0x54,0xC7,0x87,0x8A,0x8B,0x9D,0x55,0x54,0x95,0x92,0x12,0x8B,0x46,0x91,0x83,0x6B,0x70,0xCE,0x6E,0x75,0xF6,0x61,0x89,0xD1,0x04,0x14,0xD0,0x5D,0x88,0x01,0x9A,0x6B,0x1F,0x59,0x51,0x1D,0xA9,0x92,0x7A,0xD4,0x31,0x76,0xB8,0xC9,0xEB,0x35,0x44,0x37,0x11,0xA6,0xAF,0xD7,0x98,0xF5,0x85,0x85,0xBE,0x5E,0x63,0x15,0x1B,0x5A,0xBA,0x7A,0xCD,0x5D,0xB4,0x7B,0xEB,0xE6,0xB5,0x74,0x59,0xA2,0x6D,0x9B,0xD7,0xDA,0x75,0x91,0xB4,0xAF,0xFA,0x7F};
const uint8_t spTOO_LOW[] PROGMEM = {0x01,0xD8,0x41,0x33,0x00,0x33,0x66,0x29,0xA0,0x58,0xA3,0x92,0x04,0x63,0xEE,0xE5,0x93,0x46,0x5A,0x98,0xA5,0x14,0xB7,0x6D,0x59,0x61,0x16,0x56,0xD0,0x35,0x65,0x85,0x6A,0x5A,0x43,0xB6,0x54,0x64,0xC3,0x95,0x01,0xF1,0x5A,0xD5,0x85,0x78,0x14,0xB4,0x6B,0x75,0x27,0x52,0x9E,0xD0,0x6D,0xD5,0x83,0x6A,0x7B,0x60,0xB7,0x53,0x77,0xE6,0x6D,0x8E,0xFD,0x4E,0xDB,0x68,0x8C,0x07,0xF5,0x3B,0x6D,0xA5,0xD9,0x11,0x94,0x6F,0xF5,0x85,0xD5,0x84,0x73,0xF6,0x31,0x16,0x56,0x93,0x26,0xF9,0xC7,0x9A,0x59,0x4D,0x9A,0xF8,0x6B,0x67,0xE6,0x35,0xA1,0xE2,0xB7,0x5C,0x89,0x77,0xA7,0xAA,0xBF,0xF2,0x44,0x39,0xED,0x2A,0x79,0xCA,0x13,0xD4,0x96,0x8A,0xE5,0x2D,0x4F,0x70,0x5B,0x2A,0x96,0xA7,0xFC,0xC1,0x4E,0xB9,0x72,0x6E,0xF7,0x7B,0x7F,0xA9,0x2C,0x79,0xCC,0x6F,0xD2,0xBA,0x8A,0xF5,0xF9,0x7F};
const uint8_t spCENTRE[] PROGMEM = {0x0A,0xF8,0xAD,0xD4,0x00,0xBF,0xA5,0x3B,0xE0,0xB7,0x72,0x07,0xFC,0x59,0x1E,0x80,0x1F,0xD5,0x56,0xD6,0xAD,0xAB,0xA9,0x6C,0x59,0x55,0xCB,0xAE,0xA6,0xB9,0x66,0x0D,0x35,0xA5,0xBA,0xE6,0xEC,0x35,0xD6,0xE8,0xEA,0x52,0x73,0xDA,0xD4,0x1C,0xA7,0x88,0x27,0x71,0x43,0x91,0xE8,0x95,0x61,0x0F,0x12,0xF0,0x94,0x5A,0x02,0xA6,0x32,0x2B,0xC7,0x8A,0xEA,0xAA,0x6A,0xBB,0xEC,0x2D,0xA6,0x88,0x49,0xA7,0x74,0x94,0xA2,0x54,0xA9,0x9D,0xC2,0x59,0x8A,0x62,0x97,0x6E,0x4E,0x57,0xA9,0x8D,0x36,0xDC,0x25,0xDC,0xD5,0x1D,0xC3,0x4A,0xBE,0xF0,0x34,0x73,0x0C,0x67,0xFE,0xC2,0x5B,0xEA,0x02,0xAD,0xE4,0x31,0x6F,0x79,0x81,0xE9,0xD4,0xF9,0xFF,0x01};
const uint8_t spAREA[] PROGMEM = {0xA5,0xAF,0x89,0x35,0xB2,0x6B,0xAF,0xAE,0xFB,0x62,0x6E,0xDB,0xBC,0xEA,0xEE,0x46,0x78,0x64,0xCB,0xAA,0x6A,0x6E,0x96,0xA1,0xAE,0xAB,0xCA,0x8B,0x3D,0x92,0xB3,0xB6,0x2A,0x1D,0x4A,0x73,0xCE,0x3A,0xEA,0xB2,0x29,0xD5,0x24,0xF3,0xAA,0xEB,0x64,0x09,0xD3,0xD5,0x6B,0xA8,0x59,0x30,0x32,0x36,0xAD,0xB1,0x05,0x07,0x8F,0xDC,0xBC,0xE6,0x6A,0x1D,0x23,0xEA,0xD5,0x5A,0x9B,0x29,0x0A,0xCD,0x4D,0x6B,0x6D,0xAA,0x38,0x34,0x5F,0xAF,0xB5,0xD3,0xA1,0xD0,0x5C,0xDC,0xD6,0xC1,0x52,0x5C,0x65,0xCF,0xFF,0x03};
const uint8_t spBASE[] PROGMEM = {0x0C,0x50,0xD6,0x6C,0x75,0xC5,0x86,0x48,0x46,0x9B,0xD5,0x54,0xEF,0xA2,0xEE,0x6B,0x56,0xD3,0xA3,0x8A,0x7A,0x2E,0x5E,0x55,0x4F,0x42,0x66,0x35,0x7B,0x94,0x3D,0x10,0x45,0xCC,0xE2,0x52,0x36,0x87,0x1A,0x39,0x75,0x4A,0xFB,0x74,0x99,0xA0,0x7A,0x35,0xC0,0x33,0xAE,0x0A,0xF8,0x29,0xC5,0x00,0xBF,0x95,0xFE,0x3F};
const uint8_t spCONTROL[] PROGMEM = {0x0A,0xA8,0xBA,0xB8,0x14,0xDD,0x9C,0x92,0x98,0xEB,0x55,0x54,0xDD,0xA6,0x61,0x9D,0x57,0xDB,0x78,0xBB,0xA6,0x6E,0x5E,0x6D,0xE3,0x6E,0x99,0xDC,0xB8,0x74,0x55,0x89,0xAF,0x70,0xF4,0xD4,0x67,0x45,0xDD,0x6C,0x76,0x55,0x19,0x44,0x46,0xB1,0x39,0x32,0xC0,0xB0,0xC5,0x0E,0x18,0xB6,0x53,0x01,0xC1,0x98,0x94,0x2A,0x14,0x4B,0x09,0xC9,0xB2,0xAA,0x68,0x2A,0x3D,0xD8,0xFB,0x2A,0x93,0x98,0x76,0x63,0xEF,0xA7,0xCC,0x6C,0x3A,0x8D,0xB3,0xAE,0x2A,0xB1,0xED,0x64,0xC9,0x32,0xEA,0x82,0x67,0x4A,0x28,0x6B,0x6B,0x33,0xA9,0x69,0x94,0xAC,0xBD,0x2D,0x43,0xD4,0xDD,0x01,0x9A,0x2F,0x4C,0x59,0xC9,0x38,0xAA,0xDF,0xFF,0x07};
const uint8_t spMEASURED[] PROGMEM = {0x61,0xF0,0xDC,0xA3,0x42,0x9C,0x94,0x3E,0x09,0xB5,0x4A,0x4E,0xD2,0xDA,0xCA,0x45,0xBD,0xCD,0xC9,0x6A,0xAB,0x0B,0xD3,0xD0,0xC5,0xAB,0xA9,0x3A,0xD4,0xDA,0x1F,0xAF,0xBA,0xEB,0x50,0x6D,0x7F,0xBD,0x9A,0xE6,0x43,0xD4,0x7D,0xD1,0x18,0x46,0x30,0x65,0xF5,0xCE,0x6D,0xDE,0xAD,0xC2,0x50,0x98,0x05,0x60,0x45,0xD7,0x00,0x74,0xAD,0xD4,0x96,0x92,0x85,0xB4,0xAC,0x73,0xD9,0x72,0x36,0xD4,0xD1,0xBC,0xE5,0xCC,0xD9,0xD0,0x57,0xF3,0xA5,0x27,0x17,0x43,0x1F,0xE9,0x93,0x9E,0x9C,0x1C,0x7D,0x2C,0x5F,0x79,0x4B,0x54,0xB2,0xCC,0x6C,0xE6,0x2B,0x91,0x4C,0x39,0x1A,0x8B,0xAF,0x69,0x94,0x88,0x4E,0xCC,0xFE,0x88,0xDC,0x2B,0x32,0x71,0xFA,0xBB,0x35,0x67,0xF3,0xD4,0xE1,0xA9,0x59,0x55,0xD4,0x57,0xFF,0x3F};
//const uint8_t spD[] PROGMEM = {0x08,0x20,0xBA,0x0D,0x03,0x6D,0x3E,0x2C,0x55,0x45,0xB3,0x8C,0xBE,0x05,0x65,0xD5,0x78,0x32,0xDA,0xEE,0x85,0x34,0xF2,0xF6,0xE8,0x86,0x33,0xE0,0xCA,0xC7,0xAD,0x9B,0xCE,0x81,0xBB,0x66,0xB7,0x61,0x06,0x07,0xEE,0x9C,0xD5,0xC6,0xA9,0x1D,0x65,0x72,0xD1,0xFF,0x03};
//const uint8_t spTHE[] PROGMEM = {0x08,0x20,0xBA,0x0D,0x03,0x69,0xDF,0xA8,0xCD,0x85,0x3B,0xD7,0x79,0xF4,0x59,0xB7,0xA9,0xFA,0xA2,0xD5,0x27,0xD9,0x6E,0x11,0x8B,0xC6,0x90,0xB4,0x47,0xA8,0x6D,0xFA,0x7F};
const uint8_t spVACUUM[] PROGMEM = {0x66,0x2B,0x2E,0xCC,0x98,0x12,0xBB,0xA3,0x4B,0x77,0x13,0xB7,0x5D,0x8E,0x6A,0x5C,0x43,0xAD,0xF5,0xEA,0x72,0x30,0x77,0xAB,0xD9,0xAB,0x29,0x3E,0x2C,0xAC,0x16,0xAF,0xA6,0xF8,0xB4,0xB4,0x5A,0xBC,0xEA,0x9A,0xDC,0xCA,0xBA,0xF6,0xA8,0x6B,0x11,0x0F,0xEB,0x50,0x08,0x9C,0xA2,0x54,0x85,0x6A,0x80,0x01,0x66,0x0C,0x56,0xC0,0x89,0xA5,0x06,0x98,0x21,0xB9,0x4D,0xCD,0x2B,0x6A,0xFB,0xA6,0x36,0x37,0xEF,0xC4,0xED,0x7B,0xDA,0xD6,0xAC,0xB3,0xB4,0xF6,0x69,0x7B,0xB5,0x2E,0x56,0xD2,0xBB,0x1C,0xD9,0x84,0x45,0x4A,0xD3,0x72,0x66,0x55,0x1E,0x2E,0xF1,0xCA,0xD5,0x94,0x5B,0x98,0x9A,0x29,0x77,0x17,0xAE,0xE1,0x1C,0x25,0x3D,0x4D,0xA6,0x85,0x8B,0x99,0xFF,0x07};
const uint8_t spABEAN[] PROGMEM = {0xAD,0xCF,0x3E,0x25,0xAC,0x56,0xF5,0x7E,0xF6,0xAA,0x13,0xB6,0x4D,0xC3,0x6A,0xAB,0x41,0x9A,0x32,0x0B,0x4D,0xEC,0x06,0xA7,0x5D,0x33,0xDC,0xF1,0x1A,0x7A,0x74,0x61,0xE7,0x37,0xAB,0x1E,0xD1,0x19,0xD3,0xB6,0xAC,0x7A,0x3A,0x63,0xEC,0x58,0xB3,0x9A,0xE9,0x8D,0x68,0xA3,0xD2,0xEA,0x86,0x53,0xD2,0x8B,0xC0,0x63,0x9C,0x4E,0x49,0x2E,0x43,0x8F,0x65,0x68,0x65,0x3D,0x37,0xDD,0xB6,0x61,0x94,0x75,0x3D,0x54,0x39,0x9A,0x21,0xCB,0xB6,0x8A,0xE5,0xA9,0x8A,0xAD,0x4A,0x6C,0x97,0xA7,0x28,0xB6,0x4C,0x8D,0x5D,0xDE,0xAC,0xD8,0x2B,0x4C,0x4E,0x39,0x9B,0xE1,0x34,0x0A,0x25,0xE5,0xAC,0x4A,0x23,0xD1,0x94,0xA4,0xAB,0x19,0x4A,0x13,0x53,0x92,0xAE,0x66,0x38,0x92,0x55,0xCE,0xFF,0x03};
//  ROM VM61005
const uint8_t spATU[] PROGMEM = {0x29,0xE9,0x25,0x94,0x23,0xEA,0x8C,0x79,0x78,0x67,0xAE,0x5C,0xB3,0xE6,0x11,0x82,0x39,0xAA,0xF5,0x6A,0xA7,0x4F,0xA2,0xAC,0x25,0xBB,0x5D,0xD5,0x8C,0x45,0x18,0xB9,0x74,0xE5,0x33,0x35,0x62,0xE4,0x92,0x91,0x8D,0x2C,0x28,0x59,0x4B,0x10,0x38,0x45,0xA9,0x0A,0xD5,0x00,0x04,0x14,0xAA,0x62,0x80,0xAA,0x94,0x05,0xE0,0x34,0x65,0x0B,0x8B,0x22,0xAB,0xCD,0xC8,0x23,0x1D,0x45,0x90,0xB2,0xE6,0x8C,0x6C,0x66,0x41,0xAA,0x9E,0x33,0xB2,0x99,0x04,0xA9,0x7B,0x49,0xCB,0x66,0x64,0xE4,0x9E,0x25,0x25,0x9F,0x91,0x91,0x6B,0x16,0x97,0x62,0x46,0x46,0xEE,0x59,0x52,0x8A,0x11,0x09,0xB9,0x67,0x71,0x29,0x46,0x26,0x94,0xAE,0x25,0xAD,0x18,0x45,0x90,0x2A,0x9E,0x8C,0x7C,0x04,0x25,0x2A,0x5F,0x3B,0xF2,0x69,0x8D,0xA9,0x64,0xED,0x28,0xBB,0x56,0xD1,0xE2,0x2F,0xA3,0xAD,0xC2,0x4D,0x92,0xB7,0x94,0x21,0x49,0x37,0x4F,0xFA,0x12,0x06,0x17,0x2C,0x83,0x7D,0xB1,0x9A,0x64,0x33,0x75,0xCF,0x55,0x6A,0x12,0x25,0x3D,0x54,0x3B,0xBB,0x59,0x9B,0x49,0x73,0xF1,0xE2,0x56,0xA7,0x3A,0xC2,0xC5,0x8B,0x5B,0x03,0xEF,0x72,0x53,0xB5,0x7E,0x73,0x9B,0xD7,0x1D,0xA9,0xAC,0xF5,0xFF,0x01};
const uint8_t spFSS[] PROGMEM = {0x6D,0xEE,0xC6,0x55,0x3A,0x56,0xAF,0xB1,0x79,0x17,0xEB,0x58,0xBD,0xEA,0x66,0x53,0x3C,0x63,0xF1,0x2A,0x6B,0x72,0x4D,0xEB,0xC6,0x2B,0x2B,0x45,0xC3,0x6C,0xA2,0x84,0x72,0xAA,0x60,0x13,0xB1,0x43,0x80,0x61,0x2B,0x28,0x40,0x80,0xE9,0x2B,0x08,0x30,0x5D,0x3A,0x01,0x9A,0x2D,0x43,0xE0,0x14,0xA5,0x2A,0x54,0x03,0x60,0xB4,0x2D,0x9A,0x84,0xF7,0xE2,0xD5,0xB4,0x60,0x92,0x51,0x8B,0x57,0xD5,0x5C,0xB2,0x47,0x2E,0x59,0x55,0x8D,0x6E,0x6E,0xBD,0x78,0x95,0x35,0x5B,0xB0,0x4F,0xEC,0x56,0x76,0x36,0xAC,0x16,0x35,0x05,0xF0,0x8C,0xAB,0x00,0x7E,0x4A,0x11,0xC0,0x6F,0xA5,0x12,0x50,0xC0,0x6F,0xA9,0x0A,0xF8,0xA5,0x4C,0x01,0x3F,0x97,0x21,0x70,0x8A,0x52,0x15,0xAA,0x01,0xCA,0xEF,0x51,0xD5,0xB5,0xB6,0x8E,0xBE,0x39,0xE7,0x8C,0x9C,0xBD,0xFA,0xEE,0x8A,0x3D,0xEC,0xF5,0xAA,0x9A,0x0F,0x8E,0x88,0x27,0xAB,0xAA,0xDE,0x25,0xA3,0xEE,0xAC,0xBA,0xC5,0x12,0xB7,0x78,0xB2,0xA6,0xA1,0x46,0x2C,0xF4,0xF3,0xD8,0xAB,0x2F,0x0E,0xEF,0xC7,0xE1,0xAE,0xDD,0x5D,0x74,0x13,0x0B,0xE0,0x19,0x57,0x01,0xFC,0x94,0x22,0x80,0xDF,0x4A,0x35,0xA0,0x80,0xDF,0x52,0x05,0xF0,0x4B,0x99,0x00,0x7E,0x2E,0x13,0xC0,0x4F,0x69,0x04,0xF8,0xAD,0x94,0x00,0xBF,0xBA,0xFF,0x3F};
const uint8_t spILS[] PROGMEM = {0x66,0x0B,0x63,0x45,0x2F,0x27,0xB6,0x2D,0xB9,0x2B,0x0D,0x9F,0x3D,0x96,0xAC,0x76,0x34,0x6D,0xCD,0x18,0x2B,0xDF,0xB1,0xD2,0xB5,0xAB,0xAF,0xF2,0x52,0xCB,0xD6,0xAC,0xBA,0x89,0x0D,0x6F,0xFD,0xBC,0xAA,0xAE,0x46,0xA2,0xF4,0xD5,0x2A,0x9B,0x4F,0x2A,0x8F,0xC7,0xAB,0xE8,0x3E,0x31,0x22,0x16,0xAF,0xA2,0xDB,0xC0,0xC8,0x5C,0xBC,0xCA,0xEE,0x92,0x22,0x72,0xF1,0xAA,0x9A,0x2B,0x8A,0xC8,0x25,0xAB,0xAE,0xA6,0xA4,0x2C,0x1E,0xAF,0xBA,0x98,0xD1,0x52,0x7F,0xBC,0xAA,0xEC,0xC7,0x43,0x62,0x71,0xAB,0xA2,0x3D,0x73,0xC9,0x45,0xA5,0x8C,0xE6,0xD2,0xC9,0x16,0xA7,0x2A,0x98,0x73,0x63,0x5B,0x3C,0xAA,0x2C,0xCE,0x4D,0x6D,0xF5,0xAA,0xB2,0x1A,0x0D,0xCB,0xDB,0xAB,0xAE,0xAA,0x25,0x2C,0x1E,0xAF,0xAE,0x9A,0x92,0xF0,0x7C,0x3C,0x86,0xEA,0x8A,0xC3,0xEB,0x71,0x5B,0xAB,0x2D,0x8E,0xC8,0xC7,0xED,0xCC,0x26,0x35,0xB3,0x66,0x95,0xB7,0xD8,0xB0,0xD2,0x5A,0xDC,0xFE,0x1A,0x52,0x43,0x7B,0x76,0x7A,0x73,0x34,0x37,0xDF,0x58,0xEE,0xA8,0xD1,0x52,0x64,0x1D,0x19,0xE0,0x19,0x57,0x05,0xFC,0x94,0x62,0x80,0xDF,0x4A,0x2D,0x10,0x80,0xDF,0x52,0x1D,0xF0,0x4B,0x99,0x01,0x7E,0x2E,0xFB,0x7F};
const uint8_t spIFR[] PROGMEM = {0x66,0x0B,0x63,0x45,0x2F,0x27,0xB6,0x2D,0xB9,0x2B,0x0D,0x9F,0x3D,0x96,0xAC,0x76,0x34,0x6D,0xCD,0x18,0x2B,0xDF,0xB1,0xD2,0xB5,0xAB,0xAF,0xF2,0x52,0xCB,0xD6,0xAC,0xBA,0x89,0x0D,0x6F,0xFD,0xBC,0xAA,0xAE,0x46,0xA2,0xF4,0xD5,0x2A,0x9B,0x4F,0x2A,0x8F,0xC7,0xAB,0xE8,0x3E,0x31,0x22,0x16,0xAF,0xA2,0xDB,0xC0,0xC8,0x5C,0xBC,0xCA,0xEE,0x92,0x22,0x72,0xF1,0x2E,0x57,0xDD,0xBC,0x4B,0x44,0x2F,0x5E,0x75,0x75,0x21,0x11,0x3D,0x7B,0x55,0xD5,0xA5,0x84,0xF7,0xEC,0x55,0xE5,0x50,0x9A,0xDE,0xB3,0x57,0x99,0x7D,0x99,0xCB,0xD4,0x4E,0x65,0x2A,0x25,0x69,0x19,0xC6,0x00,0xC3,0x56,0x28,0x60,0xFA,0x0A,0x05,0x4C,0x97,0xAE,0x80,0x66,0xCB,0x5A,0x13,0xCD,0xB6,0x2B,0x6F,0x1E,0x6D,0x32,0xD7,0xAA,0xBA,0x7A,0x74,0x49,0x5F,0x9B,0xE9,0xE6,0xD1,0x25,0x75,0x25,0xAE,0x5B,0xDA,0x10,0xDD,0x27,0x97,0x6F,0x6E,0x4B,0x74,0x97,0x5A,0xBA,0xB9,0xED,0xC9,0x5D,0x6A,0xEB,0xE6,0x72,0xC6,0x32,0xE6,0xAD,0x9B,0xD3,0x1D,0xE3,0xB8,0xAF,0xF4,0x4E,0x4F,0x4A,0x6D,0xBA,0xD2,0x27,0x3D,0x39,0xB5,0xDB,0x72,0x96,0xF4,0xA6,0x92,0x1A,0x27,0x7D,0xC2,0x9B,0xA7,0x4B,0xB5,0x76,0x36,0x5F,0xBE,0x12,0x23,0xBA,0x98,0x7E,0xFF,0x0F};
const uint8_t spVFR[] PROGMEM = {0xE6,0xCC,0xC6,0x44,0x53,0xB3,0xB8,0x35,0x6B,0x53,0x4D,0xCD,0x1B,0x96,0x64,0x55,0x2D,0xB4,0xB3,0x5B,0x8B,0x31,0x15,0x53,0xCF,0x6E,0xEB,0xCA,0x59,0x54,0x1D,0x87,0x7D,0x5A,0x73,0x61,0x55,0x5C,0xA6,0xE9,0x5C,0x58,0x5C,0xCD,0x68,0x67,0x08,0x01,0xD3,0xB6,0xAB,0x9E,0xC1,0x18,0xDD,0x97,0xAC,0x6A,0xA6,0x20,0xD0,0x58,0xB2,0xAA,0x15,0x83,0xC0,0x62,0xC9,0x2A,0x67,0x0E,0xA4,0xC8,0x27,0xAB,0xEC,0x5E,0xC8,0xA3,0xE6,0xAC,0xAA,0x07,0x93,0xF0,0xBC,0xB3,0xEA,0x6A,0x43,0x32,0xE2,0xF1,0xAE,0x57,0x5B,0x7D,0x4A,0x5A,0x3C,0x5E,0x6D,0xF1,0x6E,0x21,0xB6,0xD0,0x00,0xC3,0x56,0x28,0x60,0xFA,0x0A,0x05,0x4C,0x97,0xAE,0x80,0x66,0xCB,0x5A,0x13,0xCD,0xB6,0x2B,0x6F,0x1E,0x6D,0x32,0xD7,0xAA,0xBA,0x7A,0x74,0x49,0x5F,0x9B,0xE9,0xE6,0xD1,0x25,0x75,0x25,0xAE,0x5B,0xDA,0x10,0xDD,0x27,0x97,0x6F,0x6E,0x4B,0x74,0x97,0x5A,0xBA,0xB9,0xED,0xC9,0x5D,0x6A,0xEB,0xE6,0x72,0xC6,0x32,0xE6,0xAD,0x9B,0xD3,0x1D,0xE3,0xB8,0xAF,0xF4,0x4E,0x4F,0x4A,0x6D,0xBA,0xD2,0x27,0x3D,0x39,0xB5,0xDB,0x72,0x96,0xF4,0xA6,0x92,0x1A,0x27,0x7D,0xC2,0x9B,0xA7,0x4B,0xB5,0x76,0x36,0x5F,0xBE,0x12,0x23,0xBA,0x98,0x7E,0xFF,0x0F};
const uint8_t spVHE[] PROGMEM = {0x66,0xCD,0x32,0x1C,0x3D,0xD2,0xBA,0xB5,0x2A,0x77,0x74,0x4E,0x13,0xB6,0x2A,0x4D,0x45,0xCC,0x4D,0xD8,0xA6,0x0B,0x56,0x11,0xB5,0x65,0x9D,0xAE,0xDD,0x98,0xD9,0xB4,0x7E,0xDA,0x34,0x16,0xD5,0x36,0xEA,0x6A,0x99,0x2D,0x73,0xF5,0x2A,0x46,0x52,0xA2,0x88,0x25,0x2B,0x1F,0x99,0x89,0xA3,0x96,0xAC,0x74,0x24,0x41,0xAA,0x5E,0x32,0x92,0x11,0x08,0xB5,0x67,0xCE,0x48,0x66,0x64,0x94,0x9A,0x25,0x2B,0x9D,0x51,0x40,0x72,0xE6,0x34,0x6B,0x18,0x85,0xE8,0x99,0x12,0xE8,0xEE,0x05,0x32,0xEF,0x76,0x1B,0x46,0x72,0x34,0xED,0xD5,0x67,0x6E,0x56,0xB8,0xB3,0xAB,0x9C,0x76,0xFA,0x44,0xCD,0x58,0x72,0xCA,0x51,0x8C,0xCC,0x6B,0xC9,0x29,0x67,0x0B,0x50,0xAF,0x25,0x27,0x9F,0x5D,0xC1,0xA2,0x97,0xAC,0x62,0x76,0x03,0xB1,0x5E,0x52,0x9A,0x26,0x89,0xAD,0xB3,0xB1,0x00,0xBA,0x40,0x73,0xC0,0x69,0x29,0x0E,0x38,0x79,0x3B,0x01,0x2B,0x85,0x04,0x60,0x7A,0x21,0x04,0x4E,0x51,0xAA,0x42,0x35,0xA0,0x75,0xB3,0x08,0x72,0xF6,0x9C,0xD6,0xAC,0x64,0x88,0x59,0xB3,0x47,0xB3,0x4A,0x22,0x78,0x2E,0x19,0xED,0x6A,0x81,0x60,0xB5,0x64,0x74,0xAB,0x3A,0x60,0xD4,0x92,0xD1,0xAF,0x1A,0x40,0x5E,0xB3,0xC7,0xBC,0xA2,0x01,0x57,0xCF,0x6E,0xEB,0xCA,0x06,0x14,0x3D,0xBB,0x6C,0x2B,0x19,0x70,0xF6,0xA3,0xB4,0x4F,0xAF,0x20,0xDD,0xB3,0xC3,0x31,0x83,0x82,0xF4,0x3C,0x0A,0xE7,0x0C,0x0A,0xD2,0x73,0x2B,0x5C,0xB3,0x2B,0xB2,0xF7,0xEC,0x70,0xCF,0xE2,0xC0,0x5E,0x4B,0xC2,0xB3,0x52,0x02,0x79,0xBD,0x0E,0xEF,0xCC,0x0A,0x9A,0xB3,0xEA,0xFF,0x01};
const uint8_t spLANDING_GEAR[] PROGMEM = {0x66,0x1F,0xC0,0xC7,0xD5,0xB2,0x85,0x2D,0xA1,0x4D,0x72,0xEF,0x54,0xD6,0x06,0xB2,0x59,0x3D,0xCB,0x98,0xAB,0x98,0x70,0xD5,0xC7,0x6B,0xA8,0xAA,0xDD,0x3D,0x1E,0xAF,0xAE,0xAB,0x56,0xCB,0x58,0xB5,0xAA,0xAE,0x8B,0x23,0x73,0xF1,0x2A,0xBA,0x2E,0xCE,0xAC,0xD9,0xAB,0x68,0xB6,0x39,0x35,0x67,0x97,0xA2,0x3B,0x28,0xD7,0xE0,0xE4,0xAA,0xAA,0x60,0x9C,0x43,0xA3,0xE9,0xAA,0xE2,0x0C,0x0A,0xD9,0x6D,0x9A,0xA2,0x58,0x2C,0x16,0xAD,0xB6,0x3B,0x65,0xD3,0x5E,0xBC,0xBA,0x11,0x14,0x2D,0x6A,0x76,0xEB,0x47,0x26,0xAA,0x0A,0x23,0x69,0xE8,0x0E,0xC6,0x4D,0xDD,0xA4,0xA1,0x19,0x1C,0x57,0x71,0xEB,0xC6,0xA2,0x68,0x45,0x25,0x8B,0x9A,0xA2,0xA4,0x75,0x71,0x2F,0x69,0x59,0x29,0x41,0x2D,0x92,0xA4,0x65,0x24,0x03,0xF1,0x5E,0x3D,0xA6,0x91,0x0C,0x25,0x6A,0xC9,0x18,0x47,0x74,0x94,0x8A,0x27,0x63,0x6E,0x3E,0x41,0xC7,0x3E,0xB7,0xA5,0xC5,0x01,0x19,0xDE,0x53,0xD6,0x5A,0x12,0x7C,0x78,0x4B,0x59,0x4B,0x2F,0xC8,0xA2,0x4D,0x65,0x2F,0xBD,0x20,0x1A,0x7F,0x97,0xB3,0xE4,0x06,0x5B,0xEA,0x52,0xAE,0x92,0x06,0x74,0x69,0x4F,0xB9,0xB3,0x6F,0x88,0x91,0xB4,0xE9,0xC9,0x25,0xA0,0x87,0x56,0xA5,0x27,0x97,0x80,0x4D,0xDE,0x1B,0xDE,0x3C,0x95,0xCB,0xC4,0xED,0xFF,0x03};
const uint8_t spLEVEL_OFF[] PROGMEM = {0x66,0xC8,0xA0,0xCB,0x4C,0xDA,0x84,0x2D,0x81,0x6A,0x57,0x4D,0x1A,0xD7,0xB0,0x34,0x90,0xC3,0x6A,0xBD,0xD6,0x5C,0x58,0x87,0xB1,0xAC,0x59,0x7D,0xD1,0x9D,0x26,0xF1,0x64,0x35,0x55,0xB7,0x9B,0xC6,0x92,0x55,0x14,0x57,0xEE,0x52,0x8B,0x57,0x9E,0x6D,0x64,0x88,0x37,0x0E,0x55,0x91,0xE5,0xC1,0xE2,0x38,0x55,0x83,0x9B,0x85,0x6A,0xEC,0x96,0x67,0xD1,0x6D,0xA2,0x76,0x56,0x5A,0x68,0x4D,0x33,0x75,0x1E,0x69,0x23,0x36,0xA7,0xE0,0xB5,0xA5,0x85,0xFA,0x2E,0x61,0x97,0x94,0x45,0xEE,0xE7,0x68,0xAD,0x47,0x56,0xF0,0x74,0x13,0x77,0x1E,0x45,0x16,0xD3,0x4D,0xBC,0x69,0x94,0x49,0x6E,0x17,0x4B,0xEF,0x55,0x45,0x73,0x95,0x6C,0xBD,0x57,0x13,0xED,0x55,0xB0,0xF5,0x1E,0x7D,0x08,0x9F,0xC1,0xDE,0x7B,0x4C,0xD1,0x7E,0x06,0x7B,0x9E,0xB6,0x47,0x73,0x95,0xA2,0x79,0xC6,0x15,0xFD,0x65,0x88,0xF7,0x69,0x4F,0x0C,0x9B,0x21,0xD6,0xBB,0x3C,0xB1,0x8E,0x27,0xE5,0x2E,0x77,0xA5,0xE2,0x6B,0x5C,0x8D,0x08,0x30,0x6C,0x05,0x01,0xA6,0xAF,0x10,0xC0,0x74,0xE9,0x0A,0x68,0xB6,0x8C,0x01,0xDD,0x65,0x12,0xA0,0x9B,0xF4,0xFF,0x07};
const uint8_t spUNDERCARRIAGE[] PROGMEM = {0x6D,0x4C,0x7A,0xCB,0xCA,0x3B,0xAF,0xAE,0xF2,0x29,0x2B,0xEB,0xBC,0xEA,0x26,0x26,0x24,0x75,0xF5,0xAE,0x57,0xD1,0x0C,0x87,0x8B,0xB9,0x69,0x59,0x55,0x54,0x2E,0xE1,0x3A,0x65,0x59,0x52,0x85,0x54,0x63,0x95,0x37,0x6B,0xC6,0x6C,0x6D,0x56,0x51,0x63,0x30,0x47,0xE4,0x5D,0x45,0x09,0x85,0xDA,0x9A,0x77,0x95,0xCD,0x2C,0xD2,0x88,0xBF,0xD2,0x74,0x3E,0x84,0xA3,0x79,0x54,0x57,0x8C,0xA2,0x67,0x64,0x01,0x03,0xCC,0x1A,0x12,0x80,0x61,0x0D,0x1D,0x30,0x43,0xD0,0x6A,0x9B,0x77,0xB2,0x8C,0xD5,0xAB,0xEB,0xBE,0x98,0xCB,0xB6,0xAC,0x7E,0xAA,0x76,0x1C,0xEF,0xBA,0x86,0x21,0x3B,0x70,0xB5,0xEF,0xDA,0x9A,0x1E,0xE7,0x95,0x7C,0x63,0xCF,0xD5,0xCC,0xCB,0xB2,0xB5,0x35,0x0F,0xF1,0x70,0xCB,0xDE,0xCE,0xD2,0x4C,0xDD,0x3C,0x7D,0xBB,0x8A,0x6F,0xB2,0xB2,0xED,0xE3,0xEE,0x76,0x84,0x53,0xBB,0x94,0xBB,0xEB,0x62,0x2E,0xDF,0x5D,0x9E,0xA1,0x52,0x38,0xBD,0x4B,0x78,0xA6,0x0E,0xE1,0xD0,0xAE,0x08,0x9C,0xA2,0x54,0x85,0x6A,0x80,0x00,0xBA,0x61,0x51,0xC0,0xEE,0x21,0x06,0x58,0x6D,0x47,0x3D,0x7D,0x4D,0xBA,0xA3,0x96,0xFF,0x07};
const uint8_t spSPOILERS[] PROGMEM = {0x04,0xB8,0x81,0x51,0x00,0x7F,0xB8,0x28,0xE0,0x77,0x27,0x03,0xFC,0x5E,0x6C,0x80,0x7F,0x4B,0x0C,0xF0,0xA6,0x2A,0x02,0xA7,0x28,0x55,0xA1,0x1A,0x80,0x80,0x42,0x45,0x5B,0x9A,0x55,0xA6,0xBB,0x5B,0x6E,0x65,0xE2,0xB5,0xE6,0x98,0xAE,0x95,0x49,0xCE,0x8A,0x72,0xB6,0x91,0x47,0x35,0x2D,0xC1,0xD9,0x46,0x96,0xDC,0x98,0x26,0x6F,0x19,0x79,0x76,0xCD,0x56,0xBC,0x6A,0x55,0x45,0x0F,0xEB,0xC8,0xEA,0x51,0x55,0xD1,0xEA,0x29,0x9F,0x47,0x57,0x49,0xA5,0x27,0x76,0x2D,0x4B,0xA2,0xD3,0x66,0x92,0xAF,0xAC,0x59,0xB6,0xA5,0xE3,0x9A,0xB2,0xE6,0x98,0xA6,0x29,0x5D,0xCA,0x5E,0x4A,0x0B,0xB7,0xF8,0x2F,0x67,0xA9,0x83,0xD2,0xEA,0x2D,0xDD,0xA5,0x37,0x58,0xA9,0xFF,0xF4,0x96,0x19,0x68,0xA5,0x59,0xC3,0x5B,0x6A,0xA0,0xB6,0x66,0x0B,0x6F,0xF1,0x49,0xDC,0x9E,0x3D,0x7D,0x97,0x84,0x88,0x4B,0xDE,0xF4,0x5D,0xC4,0x6E,0x1E,0x6E,0xF2,0x57,0xFE,0xEF,0x23,0x4C,0x98,0x99,0x02,0xBE,0x47,0x12,0xC0,0x86,0x9C,0xFF,0x0F};
const uint8_t spAIR_BRAKES[] PROGMEM = {0x6D,0x6E,0x56,0x38,0xAA,0x56,0x9E,0xAE,0xFB,0x60,0x2E,0xDF,0x72,0xEA,0x9E,0x82,0x24,0xED,0xCD,0x29,0x5A,0x2E,0xB2,0x94,0x27,0x2B,0xAB,0xDD,0xA8,0x5C,0x1E,0x8F,0xB4,0xB4,0x80,0x49,0x5E,0xDC,0xD2,0xDC,0x15,0x37,0x79,0x75,0xC9,0x52,0x57,0x9C,0xC2,0xD5,0xA6,0xE3,0x39,0xD9,0xC2,0xED,0xB0,0x55,0xA9,0x09,0x55,0xB7,0x83,0x00,0xE0,0x36,0x5A,0xDB,0x75,0xA5,0xA8,0x59,0x19,0x6D,0x4A,0x25,0x74,0xEC,0x7D,0x8D,0x25,0x96,0xD2,0x8A,0xF7,0xB5,0x34,0xDB,0x01,0xED,0xDE,0xD7,0xD2,0x6D,0x39,0x96,0x65,0x5F,0x47,0x0B,0xA5,0x94,0xDA,0x65,0x9C,0xDD,0x17,0x63,0xF9,0x9E,0xB2,0xD6,0x48,0x3C,0x5B,0xAB,0xEA,0x1A,0xFE,0x5E,0x05,0x2C,0x63,0x31,0x02,0xA7,0x28,0x55,0xA1,0x1A,0x40,0x80,0xA1,0xDA,0x11,0x50,0x6D,0xAB,0x02,0x9E,0x71,0x55,0xC0,0x4F,0x29,0x0C,0xF8,0xAD,0x94,0x02,0x08,0xF8,0x2D,0xF5,0xFF,0x01};
//const uint8_t spAERIAL[] PROGMEM = {0xA3,0x6F,0x41,0x59,0x27,0x56,0xAD,0xA6,0xC7,0x66,0x4E,0x6F,0xB3,0x8A,0xEE,0x86,0xB9,0xB5,0xCB,0xCA,0x4A,0x49,0xB6,0x92,0xBC,0x23,0xCB,0x8B,0xC3,0x82,0xB3,0xB4,0x2C,0x4D,0x6A,0x49,0xEA,0xDC,0xB2,0x34,0xA8,0x39,0x25,0xD7,0xC8,0xF3,0xA0,0x14,0xF3,0x2C,0xAB,0xAC,0xC5,0xC9,0x4D,0xB6,0xAC,0xA6,0xBB,0x44,0x69,0xDF,0xB2,0x86,0xE1,0x0A,0xB9,0x6C,0xF3,0x9A,0xBA,0x09,0xD4,0xF6,0xCF,0x6B,0x19,0x26,0x99,0x52,0xF7,0xAE,0xAD,0xD9,0x34,0x75,0xD9,0xD2,0xF6,0x6C,0xD2,0xD2,0xED,0x73,0x39,0x42,0xD8,0xA4,0xAA,0xCE,0xE9,0xF4,0x71,0xCB,0x34,0x7A,0xA5,0x33,0xA9,0x9E,0x34,0xCE,0x9C,0xAE,0x28,0x67,0x5C,0x25,0x6B,0xB8,0x82,0xEE,0x09,0xA5,0x7C,0xE6,0xF6,0xE6,0x86,0xD4,0x9A,0xFD,0x3F};
const uint8_t spENGINE[] PROGMEM = {0xAB,0x1F,0xC1,0xC9,0x33,0x67,0xAD,0x7A,0x9A,0x64,0x9D,0x98,0xB5,0x8A,0xE1,0x8B,0x35,0x7D,0xD6,0xCA,0xBA,0x09,0x8E,0x8C,0xD9,0x2B,0xED,0x8E,0xD3,0xD4,0x13,0xAF,0xA4,0x19,0x4A,0x37,0x73,0xB5,0x92,0xAA,0xA8,0xCC,0xD4,0x75,0x4B,0xB3,0xA0,0x76,0x09,0xD7,0x2D,0x4F,0x82,0xCB,0xC2,0x13,0x8F,0x62,0x58,0x12,0xB5,0x4A,0xE5,0x80,0xC2,0x58,0x56,0x3F,0x63,0xB9,0x30,0xEB,0x59,0x7D,0x0B,0x2A,0x12,0xBE,0x7A,0x0D,0xDD,0x86,0x52,0xD8,0xD6,0xB5,0x76,0x9D,0xC6,0xA1,0x5B,0xD6,0x36,0x75,0xB8,0x04,0xF7,0x2D,0x47,0xB3,0xE4,0xA5,0x66,0xB7,0x9C,0x45,0xB2,0x97,0x58,0xD4,0x72,0x15,0xC5,0xD6,0xA2,0x71,0xEB,0x1D,0xEE,0xAA,0xB1,0x3C,0x5C,0x4D,0x78,0x9A,0xC6,0x08,0x0F,0x25,0xFF,0x0F};
const uint8_t spFLAME_OUT[] PROGMEM = {0x04,0x18,0xB6,0x82,0x02,0x04,0x98,0xBE,0x42,0x00,0xD3,0xA5,0x2B,0xA0,0xD9,0xB2,0x56,0x65,0x29,0xEB,0xCC,0x59,0x57,0xD9,0x69,0x8F,0x18,0x65,0x59,0x79,0x17,0x1D,0xEA,0xB2,0x66,0x65,0xCD,0x84,0x44,0xC6,0xEC,0x95,0x76,0x67,0xE4,0x13,0x93,0x56,0xD6,0xAD,0x91,0xAF,0x55,0x1A,0x45,0xF7,0x64,0x69,0x96,0x64,0x54,0xD5,0xB0,0xA7,0x89,0xDD,0xD1,0x35,0xAD,0x92,0xC1,0x71,0x47,0xDF,0x44,0xA7,0x14,0x6F,0x1E,0x73,0xE3,0x5D,0xD6,0xB2,0x65,0xAC,0x8D,0x77,0x6B,0xE9,0x96,0xB6,0x37,0xD6,0xAD,0xAD,0x7B,0xDB,0x5E,0xC4,0xB4,0x96,0x75,0xE9,0x7B,0xBB,0xB2,0xDA,0xB2,0xD2,0xDD,0xE9,0x89,0x6E,0x22,0x42,0x5B,0xB9,0x2F,0xE4,0xAA,0x50,0x5B,0x84,0xC0,0x29,0x4A,0x55,0xA8,0x06,0x00,0x18,0x60,0x0A,0x75,0x01,0x3C,0x5F,0xF1,0xFF};
const uint8_t spFLAK_LOAD[] PROGMEM = {0x04,0x18,0xB6,0x82,0x00,0xD3,0x57,0x08,0x60,0xBA,0x74,0x05,0x34,0x5B,0x96,0x9A,0x24,0x6D,0x43,0xD9,0x4D,0xE9,0xBD,0xEB,0x0A,0xD2,0x25,0xAB,0xCB,0x72,0xD3,0x8C,0x17,0xAF,0xBA,0xA8,0x0B,0x37,0x7B,0xB3,0xCA,0x62,0x47,0x23,0x72,0xC9,0xCA,0x8B,0x6F,0xAD,0xC8,0xC5,0x2B,0x2B,0x29,0xAC,0x2C,0x67,0x8F,0x2C,0x87,0xB4,0x52,0x2F,0x85,0xC0,0x29,0x4A,0x55,0xA8,0x06,0x08,0x20,0x1A,0x51,0x73,0xD4,0xD8,0x99,0x69,0x76,0x4C,0x1B,0xA5,0x4F,0x40,0x26,0x8D,0x63,0x9A,0x13,0x8D,0x1A,0xA2,0xD5,0x63,0x6E,0x38,0x3B,0x8D,0xBA,0xAC,0xA9,0x92,0xEA,0x30,0xEA,0xB2,0xE6,0x42,0xBB,0xCD,0xB4,0x4B,0x5B,0x92,0xD8,0x52,0xB3,0xDE,0x6D,0x4F,0x6A,0x22,0x94,0xF7,0x94,0x2B,0xA9,0x0D,0x33,0xED,0x1D,0xAE,0xE0,0xDA,0x0A,0xED,0x77,0x78,0xA2,0xAD,0x48,0x96,0x2E,0xE1,0x8B,0xB2,0x3D,0x55,0xBA,0xB8,0x3F,0xEA,0xD6,0x10,0xEF,0xEB,0xFE,0x1C,0xDC,0x54,0xBD,0x8B,0xFA,0x92,0x73,0x36,0xC9,0x34,0xEC,0xCB,0x86,0x2C,0xD0,0x57,0x93,0xDB,0x91,0xF4,0xC9,0x48,0x45,0xEF,0xB4,0x77,0x67,0xE4,0x62,0x5B,0xDC,0xD9,0x63,0x8A,0x88,0x6D,0xF9,0x7F};
const uint8_t spINBOUND[] PROGMEM = {0xAA,0x1C,0x91,0xC9,0x6C,0x13,0x8F,0x7A,0x58,0x43,0xCD,0x9A,0x3D,0xCA,0xE9,0x92,0x38,0xE2,0xC9,0xC8,0x86,0x4B,0x66,0x8F,0x27,0x2B,0x9B,0x32,0x94,0xC3,0x6E,0xAF,0x64,0x38,0xB4,0x34,0x4F,0xB6,0x92,0x61,0xC9,0xD2,0xDD,0xD9,0x4A,0x9B,0xA4,0x34,0x73,0xC7,0x23,0x2B,0x82,0x2A,0xDC,0x1C,0xB7,0x3C,0x71,0x19,0x77,0x4F,0x9C,0x0A,0x2F,0xA5,0xD3,0xAC,0xB6,0x6B,0x85,0xD1,0x76,0xCE,0xD4,0xBE,0x5D,0x7D,0xD1,0x69,0x66,0xDC,0x78,0x35,0x45,0xB5,0x6B,0xCA,0xEA,0xD5,0x17,0xDD,0xEE,0x29,0x8F,0xD6,0x50,0xF4,0xB8,0x97,0xBE,0x5E,0x73,0x55,0xE3,0x5E,0xF2,0x7A,0x2D,0x55,0xAD,0x5B,0xCA,0xEB,0xB5,0x55,0xB9,0x29,0xA5,0x9B,0xD7,0xD9,0xF8,0x16,0x97,0x6E,0x59,0x67,0xD1,0x97,0x92,0xB2,0xBA,0x9D,0x59,0x5F,0x70,0xE9,0xAB,0x76,0x26,0xB7,0xEE,0x2E,0x8B,0xD2,0x19,0x4A,0x9B,0x59,0x2C,0x0E,0x67,0x28,0xA5,0xC1,0x55,0x39,0x5C,0x59,0x94,0x35,0x5B,0x95,0x70,0x55,0xCD,0xD1,0x12,0x6A,0xC2,0xD5,0x0C,0x79,0x4B,0x2A,0x35,0x57,0x91,0x14,0x43,0x51,0x47,0x5C,0x49,0x71,0x19,0x6D,0xAD,0xF4,0x0C,0x93,0x21,0xA6,0xA9,0xC7,0xD7,0x82,0x9B,0xB1,0xAF,0x09,0x77,0xCD,0xE6,0x42,0xDD,0xF8,0xFF,0x01};
const uint8_t spIGNITE[] PROGMEM = {0x65,0x28,0x52,0xBD,0xBA,0x62,0xAF,0x61,0xC8,0x20,0xED,0x5C,0xBC,0x87,0xD5,0xF7,0x68,0xE0,0x15,0x77,0xDA,0xD0,0x8B,0x82,0x77,0x2C,0x72,0x53,0x92,0x22,0x93,0x52,0x1B,0x81,0x53,0x94,0xAA,0x50,0x0D,0x30,0x53,0x94,0x9C,0xA3,0xE1,0xBA,0x0C,0xCD,0x41,0xA6,0xB9,0x9B,0xD5,0xD5,0x10,0xE1,0xAC,0x4B,0x56,0x5D,0x7C,0x6B,0xB8,0xDE,0x19,0x75,0xF1,0xA3,0x9E,0x7A,0x67,0xD5,0xD5,0xB4,0x46,0xEB,0xED,0xD5,0x56,0x5F,0x9C,0x69,0x8F,0xCA,0xD0,0x82,0x51,0x67,0x4E,0xAA,0x43,0x19,0x5B,0x66,0x4A,0xAB,0xD9,0x08,0x9C,0xAA,0x54,0x85,0x6A,0x00,0x00,0x28,0x60,0x0A,0x75,0x02,0x3C,0x5F,0xF1,0xFF};
const uint8_t spNO_TURN[] PROGMEM = {0x6A,0xF5,0x4C,0x63,0x52,0x6B,0x9B,0x35,0x70,0x89,0x09,0x5B,0xE4,0xD6,0xC8,0xC4,0xBB,0x64,0xB1,0x5B,0x33,0x11,0xAF,0xE2,0xC5,0x6D,0xE9,0x5A,0x4C,0x95,0xBA,0xAE,0xBE,0x78,0x4B,0xE3,0x78,0xB3,0xDA,0xAC,0x32,0xD2,0xE4,0xCD,0x2A,0xB3,0x9C,0x34,0xA3,0x2D,0x2B,0x8B,0x6C,0x53,0xC2,0x5A,0xB7,0xD4,0xAB,0xCD,0x30,0xDA,0x5C,0x52,0xAF,0x27,0xCC,0xAC,0xB3,0xAA,0x5C,0x12,0xCA,0x2E,0xD7,0x08,0x9C,0xA2,0x54,0x85,0x6A,0x00,0x04,0xE0,0x4A,0x53,0x0F,0x04,0x60,0x2A,0xB3,0x15,0x94,0x14,0xAC,0xA5,0x59,0x56,0x5A,0x62,0x91,0x2E,0x77,0x19,0x79,0x71,0x4D,0xFC,0x94,0x65,0xE4,0xB9,0x26,0xFA,0x51,0xE7,0x51,0xE6,0xD2,0x68,0xC7,0x9D,0x47,0x57,0xD2,0x90,0x1C,0x77,0x19,0x7D,0x0D,0xC3,0x7C,0xDC,0x65,0x2C,0xCD,0xAF,0xE0,0x72,0x96,0xB1,0x35,0x3F,0x82,0xAB,0x59,0xC7,0xD1,0x5C,0x0B,0x75,0xB8,0x1B,0x67,0x0B,0xA1,0x12,0xD1,0xB4,0x5C,0xCD,0xAB,0x84,0x4A,0xDD,0x72,0x37,0x6F,0x6E,0xA4,0x75,0xCA,0x53,0x0D,0x79,0xA9,0xC5,0x2D,0x4F,0x33,0xA2,0xA9,0x12,0x37,0xBD,0x3D,0x8A,0xB9,0x69,0xE3,0xF4,0x57,0x6B,0xEA,0x69,0x0B,0xD3,0xDF,0x82,0xAB,0xBB,0xAD,0xFE,0x7F};
const uint8_t spFLAPS[] PROGMEM = {0x04,0x18,0xB6,0x82,0x00,0xD3,0x57,0x08,0x60,0xBA,0x74,0x05,0x34,0x5B,0xD6,0x8A,0xA2,0x65,0xD2,0xD8,0xED,0xE8,0xA2,0xE9,0x0E,0x92,0x36,0xAB,0x4D,0x6A,0xD3,0x55,0x16,0xAF,0x3A,0x9B,0x75,0x73,0x5F,0xBC,0xAA,0x1C,0xDA,0xCA,0x73,0xF6,0xAA,0x72,0x0C,0x6F,0xEB,0x29,0xAB,0xC9,0x31,0x6D,0xBC,0x27,0xB7,0x31,0xC5,0x88,0xB1,0x99,0xDC,0xCE,0x12,0xD3,0xDA,0x72,0x76,0xBF,0xC2,0x9D,0x93,0x7B,0x5A,0x2E,0x41,0xE0,0x14,0xA5,0x2A,0x54,0x03,0x00,0xC0,0x00,0xD1,0x88,0x32,0xE0,0x19,0x57,0x06,0xFC,0x94,0x42,0x80,0xDF,0x4A,0x29,0x40,0x80,0xDF,0x52,0xFF,0x1F};
const uint8_t spEVACUATION[] PROGMEM = {0xA5,0xEF,0x4C,0x45,0xB6,0x16,0x95,0x71,0x6A,0x67,0xEC,0x5C,0xDD,0xC6,0x1E,0x9D,0xA8,0x6C,0x4B,0x58,0xAB,0x30,0x95,0x52,0xAF,0xE6,0x48,0x5C,0xD5,0xC3,0x93,0xB8,0xA3,0x6B,0x57,0x66,0x75,0xBA,0x86,0xEA,0x42,0xCD,0xB4,0xCD,0xEA,0x9A,0x2E,0xF1,0xB0,0xCD,0xAB,0xAB,0xAE,0x34,0x3D,0x56,0xAF,0xA6,0x86,0xD4,0xB2,0x5A,0xB4,0xAA,0x9A,0xCC,0xD2,0xAB,0xF6,0x2C,0x10,0x38,0x45,0xA9,0x0A,0xD5,0x00,0x03,0xAC,0xE8,0x6A,0x80,0x93,0x47,0x0C,0xB0,0x53,0x4A,0x2B,0x7A,0x74,0xE0,0xB4,0x35,0xAD,0x2A,0x34,0xC4,0x86,0xB7,0xA4,0xDA,0xF3,0x0D,0x09,0xDC,0x5C,0xDA,0xC0,0xAF,0x38,0xB8,0xF3,0xAA,0x93,0xD8,0xD0,0xA0,0xDE,0xAB,0x2A,0xB2,0xC5,0x92,0x37,0xAF,0xB2,0xF9,0x22,0x73,0xD9,0xBC,0x8A,0x1E,0x0D,0xDD,0x7D,0x75,0xA8,0x5A,0x20,0xF6,0xCA,0x45,0x0C,0x38,0x71,0x54,0x01,0xBB,0x6D,0x19,0x60,0x97,0xEB,0x00,0xEC,0xB2,0x16,0x80,0x95,0x2F,0xD6,0xD4,0x54,0xA8,0x94,0x77,0x6E,0x73,0xD3,0xA1,0x1E,0xB2,0xBA,0xAD,0xDD,0xB1,0x94,0x8B,0xB5,0xB1,0x77,0xCB,0x52,0xAE,0xD6,0xCA,0x31,0x9C,0x48,0xA8,0x45,0x4D,0xE7,0x70,0x46,0x61,0x12,0x2D,0x5D,0x53,0x3B,0x99,0x73,0xB4,0x74,0x0F,0xED,0x92,0xAA,0x51,0xD3,0xD3,0x5C,0xBA,0xAB,0xA5,0xF9,0x7F};
const uint8_t spDOORS[] PROGMEM = {0x0A,0x28,0x30,0xAC,0x35,0x43,0x85,0x89,0x58,0xDE,0x51,0x67,0xED,0x6E,0xAE,0xAB,0x57,0x9D,0x44,0x87,0x26,0x77,0x1D,0x4D,0xA2,0x53,0x16,0xEC,0x6D,0x36,0xA5,0xF7,0x75,0xD4,0x93,0xBC,0xB5,0x25,0xB4,0xE6,0x4C,0xCE,0x9A,0xB6,0x50,0x9B,0x2A,0xA9,0x5F,0x3A,0xE2,0x70,0x69,0xC7,0x3E,0x69,0x8B,0xD3,0xB9,0x03,0xFB,0x86,0x2B,0xD5,0xC4,0x6C,0xF6,0x93,0x9E,0x5C,0x12,0xAA,0xC4,0x6F,0x7A,0xF2,0x34,0xF2,0x56,0xBF,0xE9,0xC9,0xCD,0x30,0xCA,0xFC,0xA5,0x27,0x17,0x65,0xAD,0xE8,0x13,0xDE,0xEC,0x44,0xC3,0x63,0xB3,0x79,0x93,0x15,0xF1,0xC8,0xD5,0xE9,0xBB,0x24,0x44,0x5C,0xF2,0xA6,0xFF,0x22,0x76,0xF3,0x70,0x93,0xFF,0xF4,0x7F,0x1F,0x61,0xC2,0xCC,0x14,0xF0,0x3C,0x92,0x06,0xFE,0x1F};
const uint8_t spCABIN[] PROGMEM = {0x06,0x28,0x42,0xCD,0x01,0x23,0x8A,0x18,0xA0,0x1B,0xE5,0x55,0xB4,0x64,0x6A,0x1E,0x8B,0x57,0x59,0x83,0x6B,0x64,0x2C,0x5E,0x45,0xF1,0xA9,0x95,0xB1,0x78,0xE5,0x25,0x84,0x95,0xE5,0xEC,0x95,0x95,0x98,0x96,0x12,0xB3,0x4D,0x6D,0xBD,0xAB,0xBB,0xB5,0x32,0xAD,0x51,0x61,0xE1,0x9E,0x66,0x35,0xC5,0xBB,0xBA,0xC4,0xA2,0xD5,0x16,0x13,0x12,0x56,0xB3,0xD7,0xD8,0x8C,0x59,0xB0,0xD5,0x6C,0x63,0xB7,0xA8,0xE3,0x6E,0xAF,0x8D,0xC3,0x12,0xB7,0x9B,0xB5,0x32,0x37,0x45,0xB2,0xAE,0xD6,0xEB,0xE2,0x56,0x2F,0x35,0x4B,0xAA,0x8C,0xD8,0x94,0xC8,0x8C,0x4C,0x27,0xFF,0x0F};
const uint8_t spARRIVAL[] PROGMEM = {0x65,0x4D,0x66,0xD3,0x8A,0xBB,0x8C,0x25,0xF9,0x49,0x29,0xCD,0x37,0xE6,0x58,0xC3,0x6D,0xD8,0x5F,0x98,0xFD,0x64,0xCF,0x62,0x7D,0x6E,0xB6,0x57,0x34,0xCA,0xD4,0xB9,0xC9,0x1C,0x15,0xEF,0x60,0x96,0x46,0xBF,0xD9,0xA2,0x45,0xEB,0x18,0x62,0xF1,0xF0,0x61,0x3D,0xAB,0x4B,0x76,0x23,0x42,0xF3,0xAC,0x26,0xEB,0xF5,0x4C,0xD9,0xB4,0x8A,0x1C,0xCA,0xCA,0x62,0xD5,0x4A,0x4B,0x74,0x6D,0xAB,0xD9,0x2B,0xA9,0xC1,0xB4,0xBD,0x26,0xAF,0xB8,0x65,0x93,0xD0,0x98,0xD5,0xD2,0xEC,0x54,0xC3,0x74,0x51,0x28,0x8A,0x74,0x09,0x63,0x37,0xA1,0x9F,0xCA,0xD4,0xD5,0xAC,0xA4,0xBE,0xF3,0xF0,0x74,0xB6,0xDD,0xFA,0xCC,0x7A,0x42,0x31,0x4B,0xEB,0x2B,0xAA,0x2D,0xC1,0x6C,0x6D,0x68,0x30,0xB7,0x15,0xB2,0xB7,0xB1,0xC3,0x9C,0x56,0xC8,0xDF,0xA6,0x06,0x6A,0x52,0x31,0x6F,0x9F,0xCA,0xD2,0x41,0x4E,0x18,0xF7,0xFD,0x7F};
const uint8_t spACKNOWLEDGE[] PROGMEM = {0xAD,0x2E,0xB6,0xD4,0x27,0x26,0xAD,0xA9,0x9A,0x56,0xEF,0x78,0xBC,0xC6,0x66,0x5B,0xAD,0xFD,0xCD,0x1A,0x9A,0x1F,0xF1,0xF2,0xD7,0x6B,0xA8,0x3D,0xA9,0x24,0x66,0x23,0x70,0x8A,0x52,0x15,0xAA,0x01,0x40,0x80,0xA8,0xDC,0x43,0x1E,0xA5,0x78,0xAB,0x27,0x29,0x5D,0xD1,0xE8,0xEB,0x52,0x77,0xF4,0xD5,0x91,0x27,0x5B,0xD2,0xD5,0x55,0xD5,0x66,0xC1,0x8F,0x57,0x53,0x45,0xA7,0x25,0x6D,0x5E,0x75,0x56,0x9B,0x1E,0xBC,0x65,0x55,0x59,0x5F,0xBA,0xEB,0xEE,0x95,0x25,0x7F,0x11,0x6A,0xAB,0x47,0x1A,0xC2,0x64,0x41,0x36,0x1E,0x49,0x46,0x1F,0x6E,0xD2,0x69,0xC5,0x29,0xB4,0x15,0x4D,0xED,0x15,0x97,0x98,0x9A,0x3C,0xB5,0x57,0x5C,0x7D,0x72,0x48,0xCD,0x5E,0x49,0xB5,0x2A,0x69,0x3D,0x5B,0x25,0x56,0x5A,0x45,0x67,0x0C,0x91,0x09,0x63,0xD5,0x59,0x16,0x53,0xB5,0x33,0xA3,0x68,0x74,0x49,0xD7,0x8C,0xA4,0xAC,0xDE,0x24,0x5D,0xAB,0x96,0x02,0x8A,0x5D,0x03,0x34,0x4E,0xE4,0x80,0xD9,0xD2,0xFF,0x1F};
const uint8_t spRAISE[] PROGMEM = {0x62,0x63,0x65,0x45,0xC3,0xED,0xAA,0x55,0x2C,0x67,0xCF,0x70,0x9A,0x06,0xDB,0xD9,0xBD,0xC5,0xEF,0x68,0x52,0xE7,0xB0,0x94,0x6C,0xAB,0x2A,0x39,0x54,0x53,0xBA,0xAE,0xB2,0xF9,0x66,0x49,0x5D,0xBD,0x8A,0xEE,0x8A,0x24,0xED,0xF1,0xAA,0x86,0x2B,0x92,0xF4,0xC5,0xAB,0x1B,0x26,0x50,0x3B,0x16,0xAF,0xBE,0x1B,0x43,0xEF,0x5A,0x3C,0xA6,0xE1,0x0C,0xAC,0x6B,0xF6,0x58,0x7A,0x64,0xF4,0xEA,0xD9,0x65,0x1D,0x41,0x41,0xAB,0x1E,0x97,0x6D,0x24,0x43,0xCE,0x5A,0x5C,0xF6,0xEE,0x04,0xAD,0xEA,0x71,0x78,0xBA,0x57,0x34,0x8F,0xD7,0xEE,0x69,0x5A,0xD1,0xC3,0x3F,0x9B,0xBF,0x48,0xA3,0xF4,0x58,0xEC,0xFE,0x6A,0x8D,0x4D,0x62,0x75,0x5A,0x2F,0x09,0x11,0x97,0xBC,0x61,0xBD,0x88,0xDD,0x3C,0xDC,0xC4,0xB5,0xEC,0xDF,0x47,0x98,0x30,0x33,0x05,0x7C,0x8F,0x24,0x80,0x0D,0x39,0xFF,0x1F};
const uint8_t spLIST[] PROGMEM = {0x66,0x19,0x98,0xB2,0x8C,0xDB,0x85,0xB5,0x43,0xEE,0x22,0x5B,0x93,0x96,0x0E,0x75,0x0C,0x63,0x75,0x9B,0x36,0xC3,0x2E,0x96,0xB5,0xA3,0x3F,0x9C,0x3A,0x50,0xDA,0xAE,0xBA,0x9A,0x74,0x15,0x5B,0xB3,0xCA,0x26,0x4B,0x25,0x74,0xCD,0x2A,0xBB,0x2A,0xD1,0xD0,0x35,0xAB,0xAA,0x3A,0x24,0x3C,0x16,0x8F,0xA5,0x58,0x97,0xB0,0x9A,0xD5,0xF6,0x12,0x5D,0x4D,0xBA,0xB4,0x01,0x9E,0x71,0x55,0xC0,0x4F,0x29,0x06,0xF8,0xAD,0xD4,0x02,0x01,0xF8,0x2D,0xD5,0x01,0xBF,0x94,0x19,0xE0,0xE7,0x32,0x04,0x4E,0x51,0xAA,0x42,0x35,0x00,0x14,0x30,0xA4,0x1B,0x03,0x36,0x57,0xFB,0x7F};
const uint8_t spAPPROACH[] PROGMEM = {0xA9,0xCA,0xBA,0xCB,0x4D,0xB7,0x9C,0xA9,0x88,0x69,0x71,0xDB,0x7A,0x86,0xAC,0x37,0xC5,0x6D,0xF3,0x18,0x92,0x19,0x37,0x97,0xDE,0xB6,0x46,0xE0,0x14,0xA5,0x2A,0x54,0x03,0x10,0x10,0x98,0xA9,0x02,0x72,0x30,0x2B,0x49,0x0E,0x11,0x16,0xA6,0x64,0x64,0xB1,0x6A,0x4A,0x72,0x96,0x95,0x67,0x15,0x6D,0x21,0xE9,0x57,0x5E,0x44,0xA7,0x25,0xF6,0x5D,0x79,0xE1,0x9D,0x1A,0xD8,0x77,0x64,0x91,0x77,0x69,0x48,0x36,0x97,0x99,0xE4,0x16,0x11,0x99,0x11,0x38,0x45,0xA9,0x0A,0xD5,0x00,0x02,0xCC,0xAA,0xAA,0x80,0xD9,0x3A,0x1D,0x30,0xFB,0x4C,0x00,0x56,0x9F,0x72,0xC0,0x6C,0x33,0x01,0x98,0x7D,0x2A,0x00,0xB3,0x75,0x2A,0x60,0xF6,0x2D,0x06,0x8C,0x36,0xF5,0xFF};
const uint8_t spDEPARTURE[] PROGMEM = {0x0A,0x28,0x30,0x6C,0x0C,0x4B,0x86,0xA3,0xD9,0xEA,0xD5,0x4D,0xE5,0xCA,0x6E,0x5B,0x56,0x37,0x6C,0x08,0x9B,0x6F,0x59,0x5D,0x31,0x26,0xE6,0xD1,0x09,0x81,0x53,0x94,0xAA,0x50,0x0D,0x20,0x80,0x37,0x2E,0xAD,0x09,0xF1,0xD8,0xDD,0x35,0xAD,0x22,0x8E,0xD2,0x4C,0xEE,0xB2,0x8A,0x14,0x56,0x7C,0xA9,0xCF,0xCA,0x72,0x1A,0xAE,0xA6,0xCD,0x2D,0x2B,0x35,0xB0,0x53,0x72,0x95,0xAC,0x66,0x56,0x71,0x4D,0x85,0xC0,0x29,0x4A,0x55,0xA8,0x06,0x10,0x60,0x56,0x55,0x05,0xCC,0xD6,0xE9,0x80,0xD9,0x67,0x46,0x53,0x3A,0x53,0x94,0x75,0x2D,0x6D,0x1E,0x4C,0x95,0xFC,0xB9,0x8D,0xB9,0x28,0xC6,0x70,0x9F,0x36,0x97,0xAC,0xE8,0x63,0xF9,0xD2,0x5A,0x3A,0x4A,0x78,0x6C,0x65,0x87,0xD1,0xE2,0xEB,0x19,0xF3,0xFF,0x01};
const uint8_t spCLEARANCE_DELIVERY[] PROGMEM = {0x02,0xC8,0x71,0xD2,0x03,0x06,0x18,0xCA,0xA7,0x25,0x95,0x44,0x9B,0x59,0x92,0x95,0x55,0x1B,0x6E,0x26,0x6B,0x56,0xDE,0x42,0x09,0x05,0xAF,0x5D,0x79,0x33,0xA5,0xD8,0xBA,0x6D,0xE4,0x39,0x71,0x58,0x4A,0xB7,0x96,0xA5,0x4A,0xE9,0x12,0xCE,0x46,0x96,0x8B,0x94,0x58,0xB8,0x5D,0x69,0x0E,0x5A,0xEA,0x91,0x7A,0xA5,0xC5,0xBA,0x7B,0xF8,0xA2,0x96,0x65,0x29,0xD9,0xE2,0x71,0x43,0x5A,0x04,0xD6,0x8A,0x25,0x49,0xC5,0x12,0x26,0xAA,0xE6,0xC4,0x00,0x3F,0x84,0x58,0xC0,0x01,0x7F,0x66,0x18,0xE0,0x19,0x57,0x04,0x4E,0x51,0xAA,0x42,0x35,0x20,0x00,0x4B,0x84,0xAF,0x62,0x09,0x0D,0x0E,0xE9,0xBB,0xB2,0xC6,0x22,0xC4,0x65,0xCB,0x28,0x26,0x96,0x31,0xB2,0xAD,0xAD,0x9C,0x50,0xD7,0xC0,0xB6,0xAC,0x62,0x62,0x6D,0x13,0x6D,0xBB,0xF2,0x26,0xCB,0x55,0x75,0xF5,0xCA,0x9B,0x2A,0xE3,0xB0,0x35,0x2B,0x2F,0xAE,0x94,0x53,0xDA,0xA4,0x22,0x59,0x0D,0x0D,0xB5,0xA3,0xFA,0xA0,0xCB,0xC5,0x5C,0x89,0x5A,0x12,0x0B,0x77,0x73,0x55,0x61,0x0F,0x93,0x2D,0x52,0xB5,0xA6,0x29,0x0E,0x2C,0x2D,0xCE,0xD2,0x96,0xDC,0x38,0xB9,0xA5,0xCB,0x58,0x73,0x52,0xB3,0x8C,0xAE,0x63,0xAF,0xAE,0x48,0xCB,0x37,0x8F,0xBB,0x59,0xC7,0xA8,0xD8,0x5C,0x9E,0x61,0x82,0xA4,0x7C,0x75,0xFA,0xBB,0x74,0x92,0xCD,0x55,0xE1,0xEF,0xDA,0x50,0x27,0x5F,0xA5,0x7F,0x8C,0x60,0x56,0xDF,0x6A,0xFE,0x3E,0xD9,0xD5,0x72,0xD2,0xFF,0x03};
//const uint8_t spFUEL[] PROGMEM = {0x04,0x98,0xB6,0x52,0x00,0xCD,0x85,0x29,0x60,0xF8,0x32,0x01,0x0C,0xDF,0xC1,0x01,0x97,0xCE,0xB1,0x29,0x81,0x8C,0x4B,0xDE,0x93,0x22,0x85,0xAF,0x19,0xF9,0x70,0x41,0x58,0xB6,0x75,0xA4,0x9D,0x9A,0x49,0x71,0xB7,0x96,0x16,0x5A,0x21,0x01,0x79,0x5A,0xDA,0x70,0x94,0x37,0xF8,0x2B,0x79,0xA6,0x51,0x55,0x90,0xB7,0xE4,0x99,0x59,0x77,0x90,0xB7,0x56,0x55,0x2A,0x3D,0x49,0xEA,0x5A,0x5D,0xA9,0xCC,0x04,0xBA,0x6B,0x6D,0xA5,0x3C,0xE3,0x98,0xAE,0xF4,0x95,0xC9,0xB6,0x60,0x97,0xD4,0x17,0x2A,0x5B,0x8C,0x5D,0xD2,0x98,0x49,0xF4,0x10,0x77,0x0E,0x63,0x05,0x55,0x25,0xB8,0xFB,0xFF,0x01};
const uint8_t spIDLE[] PROGMEM = {0x61,0x89,0xEE,0x3C,0xD2,0x57,0xB7,0x3E,0xAB,0x0B,0x2B,0xDB,0xBC,0xDA,0x1C,0x56,0xA3,0x7C,0xF1,0xAA,0x4B,0x4C,0x4B,0xF3,0xC5,0xAB,0xAC,0x21,0x29,0xD3,0x57,0xAF,0xB2,0x87,0x42,0x0F,0x5F,0x32,0xCA,0x1A,0x9D,0xDC,0xBC,0xB5,0x02,0x0A,0x0C,0x1B,0x53,0xB6,0xAE,0xC9,0xDE,0x79,0x8D,0x1D,0x55,0x46,0x70,0x9F,0x31,0x0F,0x50,0x95,0x41,0x79,0xDB,0xD6,0x41,0x75,0x3B,0xF9,0x6B,0x47,0x26,0xDB,0x25,0x9C,0x25,0xDD,0x89,0x7F,0x05,0x73,0x9F,0x70,0x07,0x73,0xE9,0x64,0xBD,0xC3,0x1F,0xCC,0x56,0xB0,0x74,0x72,0xBF,0x77,0x17,0x22,0xDE,0xE9,0xFF,0x01};
const uint8_t spINCREASE[] PROGMEM = {0xAD,0x6F,0xD4,0xC4,0x2F,0x63,0xAD,0x7E,0xEA,0x60,0xEA,0x58,0xBD,0xFA,0xE1,0x92,0x25,0xE3,0xD1,0xEA,0xBA,0x31,0xF6,0xB4,0x59,0xA5,0xAB,0x06,0xB3,0x5C,0x9D,0x94,0xAE,0x6A,0xF2,0x49,0x51,0x12,0xFA,0xA4,0xA8,0x57,0x45,0x29,0x02,0xA7,0x28,0x55,0xA1,0x1A,0x40,0x80,0xDC,0x57,0x05,0x90,0x72,0x99,0x02,0xF2,0xA8,0x68,0x69,0x2A,0xEC,0x52,0xD6,0x75,0x65,0x25,0xAA,0x4A,0xCA,0xD6,0x95,0xF4,0xEC,0xC2,0x2E,0x6B,0x46,0xDC,0x13,0x91,0x47,0x2D,0x29,0x71,0x73,0x28,0x99,0xB3,0xA4,0x44,0x53,0x28,0x49,0x7A,0x17,0x05,0x3C,0xE3,0xAA,0x80,0x9F,0x52,0x0C,0xF0,0x5B,0xA9,0x05,0x0C,0xF0,0x5B,0x2A,0x03,0x7E,0x29,0xFB,0x7F};
const uint8_t spUP[] PROGMEM = {0x69,0x2C,0x6A,0x32,0xCC,0x97,0xAC,0xA1,0xC8,0x4D,0x37,0x5F,0xB3,0xFA,0xA2,0x36,0x42,0x63,0xC9,0x6A,0x93,0x9B,0x08,0xCD,0x25,0xAB,0xCD,0x76,0x32,0x25,0x96,0x94,0x21,0x96,0x4A,0x97,0xB9,0xE3,0xA6,0xD0,0x3D,0x2C,0xF6,0x0A,0x02,0xA7,0x28,0x55,0xA1,0x1A,0x00,0x00,0x04,0x70,0x2E,0x44,0x00,0x39,0xB9,0x23,0x20,0x35,0xD7,0xFF,0x07};
const uint8_t spTAXI[] PROGMEM = {0x0A,0xD8,0x5C,0x4D,0x03,0x23,0xA8,0xD6,0x34,0x2C,0x1A,0xAD,0xAA,0x84,0xB4,0x48,0x5F,0xB2,0x9A,0xAA,0xDB,0xBD,0x75,0xCD,0x6A,0x9A,0x6D,0x8D,0xB6,0xD5,0xAB,0x69,0xA5,0xA8,0x3C,0x1A,0x81,0x02,0x6A,0x28,0x33,0xC0,0x4B,0xE5,0x0E,0x78,0xCE,0x4C,0x01,0xAF,0x86,0xA7,0xE2,0x59,0x37,0x96,0x70,0xD3,0xCA,0x6E,0x9D,0xD4,0xED,0x4D,0xAB,0xBA,0x36,0xD4,0x8A,0x37,0xAD,0x1C,0x4E,0xD1,0xAB,0x16,0xB7,0x72,0x78,0x81,0xC8,0x9A,0x5D,0xCA,0xE1,0x15,0xA2,0x66,0x51,0x2A,0x46,0x50,0xF0,0x98,0xC5,0xA1,0x68,0x8A,0x79,0xB2,0x43,0xA9,0xA2,0x7B,0x45,0x31,0x8F,0xFD,0xFF};
const uint8_t spAS[] PROGMEM = {0x63,0xAF,0x26,0xC4,0x33,0x6B,0xAF,0xB9,0xCA,0x92,0xEC,0xB8,0xB5,0xE6,0x66,0x4A,0xBC,0xFC,0xF1,0x9A,0xBA,0x6A,0xF1,0xF2,0xC7,0x6B,0x6A,0xB2,0x25,0xD2,0x1F,0xAD,0xB1,0xAA,0xE2,0xB0,0xBC,0xDD,0xE6,0xA2,0x42,0x82,0x73,0x51,0x59,0x16,0x35,0x35,0xD7,0xBE,0x0E,0x58,0x80,0xDC,0x00,0x9F,0x22,0xFF,0x3F};
const uint8_t spCONVERGING[] PROGMEM = {0x0C,0x28,0x65,0xCD,0x03,0xAD,0x28,0xB1,0x99,0xC2,0x1A,0xAD,0xB2,0xEA,0x32,0x4D,0xDD,0xB2,0x9A,0x46,0x33,0xB4,0x6D,0x75,0x6B,0xAA,0x22,0xDD,0xE4,0xBA,0xA3,0x6B,0x82,0x65,0x42,0xE2,0x8D,0xAE,0x72,0xD5,0x74,0xA9,0x92,0xC6,0x68,0x4C,0xD3,0xC4,0xA9,0x59,0xBD,0x2A,0xD3,0x74,0x27,0x65,0x6B,0x3A,0x4C,0x45,0x1D,0xB7,0x3E,0xC5,0xA4,0x28,0xCE,0xBA,0xDA,0x94,0x03,0x63,0x28,0xEF,0xAA,0x8A,0x5B,0xC6,0x53,0xFD,0xAB,0x6C,0x6A,0x1D,0x46,0xB5,0xAF,0xA2,0x74,0x23,0x0D,0xCD,0x5E,0xAA,0x3A,0x48,0x84,0x23,0x59,0x68,0x9A,0x62,0x11,0xCF,0x2C,0x09,0x98,0x82,0x69,0xD5,0x2B,0xA5,0x90,0xA9,0xB7,0x55,0x34,0x6B,0xC2,0x15,0xAD,0x57,0x31,0x62,0x08,0xA5,0xAD,0x19,0x65,0x6F,0x42,0x9A,0x3E,0x6B,0x94,0xCD,0x61,0x66,0xB8,0xD9,0x51,0x56,0x4D,0x95,0x66,0x6A,0x5A,0x59,0x25,0x55,0x9A,0xA9,0xF9,0x7F};
const uint8_t spABOVE[] PROGMEM = {0x6D,0x89,0x6E,0x33,0x43,0x5B,0xAD,0x29,0xEB,0x09,0x77,0xDB,0xB4,0xA6,0x2C,0x27,0x2D,0xB4,0x73,0x1A,0xA3,0x2A,0x37,0xA1,0x9D,0x66,0x51,0xBE,0x54,0xCC,0x5B,0x99,0xC5,0xD8,0x52,0x15,0xDF,0x64,0x56,0x61,0xCA,0x45,0xBD,0xF5,0xEA,0x1A,0xAF,0x0A,0xA3,0x2C,0xAB,0x2B,0x72,0xCA,0x54,0x36,0xAF,0x2E,0xEB,0x4D,0x67,0xDB,0xB4,0xBA,0x6C,0x36,0x82,0x6D,0xD5,0x6A,0xB3,0xBC,0x70,0xB6,0x4D,0xAB,0x4D,0xB6,0xC2,0x59,0x17,0xA5,0x2E,0xE9,0xF4,0x60,0x69,0xE9,0xE6,0xCC,0xC2,0xCC,0xC4,0xB5,0x5B,0xB7,0x0D,0x13,0x61,0x25,0xFF,0x0F};
const uint8_t spBRAKE[] PROGMEM = {0x6C,0xE5,0x7C,0xBC,0x3D,0x2D,0x91,0x8D,0xA8,0xC9,0x34,0x77,0x64,0x36,0x4F,0xD2,0xDD,0xC3,0x49,0x39,0x62,0x08,0x97,0x14,0xE5,0x63,0x88,0xC5,0x4C,0x93,0xDD,0xAF,0x3E,0x35,0x0B,0x4D,0xCA,0xBE,0xDA,0x1C,0x52,0xB5,0xAD,0xFB,0x6A,0x9B,0x2E,0xE5,0xD5,0x2D,0xAB,0x19,0xB2,0x94,0xC6,0xB7,0xAC,0x66,0xD8,0x64,0x6E,0x5B,0xBD,0x9B,0xD2,0x0C,0x1B,0x44,0x13,0xAF,0x11,0x38,0x45,0xA9,0x0A,0xD5,0x00,0x10,0x40,0x9D,0x43,0x0C,0xA8,0xCB,0x98,0x03,0xFF,0x0F};
const uint8_t spCALM[] PROGMEM = {0x06,0x28,0x2D,0xC9,0x00,0xA5,0x3B,0x2B,0x20,0x16,0xE6,0x51,0x25,0xB7,0xA1,0xA9,0x99,0x4F,0x9D,0xCD,0x96,0x24,0x77,0x59,0x4D,0xE1,0xDB,0x5C,0xDA,0x65,0x34,0xC9,0x5C,0x71,0xD9,0xAA,0xD1,0x46,0x77,0x29,0xE5,0x8D,0x5B,0x17,0xE2,0x85,0x74,0x34,0x1E,0x73,0x0C,0xE7,0xDA,0xD1,0xA8,0x1C,0x21,0x9D,0x4B,0x47,0xE3,0x72,0x86,0x78,0xA1,0xE5,0x8D,0xCB,0x15,0xF2,0xB9,0x94,0x37,0x2E,0x57,0x8C,0x1B,0x16,0xDA,0xBA,0xDC,0x99,0x6F,0x84,0x49,0x92,0xF4,0x14,0xC5,0x96,0xA9,0xB1,0xD3,0x9B,0x15,0x7B,0x85,0xC9,0x49,0x67,0x55,0x1A,0x89,0xA6,0x24,0x9F,0xE9,0x6A,0x86,0xD2,0xC4,0x94,0xA4,0xAB,0x19,0x8E,0x64,0x95,0xF3,0xFF};
const uint8_t spBREAKING[] PROGMEM = {0x04,0x50,0xD6,0x2C,0xB5,0xA1,0xB8,0x5A,0x9A,0xFB,0x35,0xE4,0x14,0x21,0x69,0xEA,0x57,0x97,0x8B,0x87,0x84,0xE5,0x5B,0x6D,0x33,0xC9,0xD6,0xB6,0x65,0xD5,0x23,0x14,0x72,0xD9,0xEA,0x52,0x8D,0x2B,0x24,0x92,0x4B,0x58,0xD3,0x85,0x92,0x86,0xB9,0x26,0xC0,0xB4,0xCA,0x0E,0x98,0x4C,0xA4,0x24,0x3B,0x36,0x2B,0xAB,0xD3,0x55,0x8E,0xC4,0xA4,0xD5,0xB3,0x47,0x3D,0x22,0x51,0x74,0x95,0x1E,0x75,0x0F,0x68,0x5D,0x66,0x76,0xD4,0xDD,0x60,0x64,0xA8,0x9A,0xD1,0x0C,0x8B,0x9E,0x69,0x4A,0x5B,0xDB,0x35,0x66,0xBA,0x39,0x69,0x43,0xD3,0x18,0xE3,0xAA,0x34,0xB5,0x4D,0xA3,0x6D,0x85,0x99,0xFF,0x07};
const uint8_t spCALL[] PROGMEM = {0x0C,0x48,0xE9,0x59,0x00,0xD9,0x3D,0xB5,0xBD,0xE8,0x55,0x33,0x69,0xBC,0xDA,0x64,0xD6,0xC2,0x24,0xD7,0xE8,0x83,0xDF,0x34,0xD7,0x3E,0x63,0xF4,0x71,0xC3,0x42,0xB3,0xB6,0xC9,0xD7,0x75,0x73,0xEB,0xDA,0x56,0x5F,0x36,0x5C,0xAD,0x6F,0xDB,0x7C,0x9E,0x4C,0xF1,0x5C,0x65,0x0F,0xAD,0xD3,0xD9,0x7A,0x96,0xDD,0xED,0x51,0x97,0xEE,0x95,0x0E,0xB7,0xC7,0x5C,0x7A,0x77,0x3A,0xDD,0x1E,0x0D,0xDE,0x4D,0xE9,0xB2,0xFD,0xD4,0xA4,0x77,0xA7,0xCB,0x97,0xAE,0x80,0xDC,0x9D,0xEE,0xE0,0x6A,0x95,0x35,0x4B,0x7A,0x82,0xD9,0x68,0x90,0x2E,0xFF,0x0F};
const uint8_t spCROSSWIND[] PROGMEM = {0x08,0x08,0x75,0x85,0x01,0xC1,0x6F,0x38,0xA0,0xEA,0xE2,0x92,0x66,0x5F,0xA9,0x56,0x72,0x47,0x19,0xAA,0x95,0x16,0xB7,0x5E,0x75,0xC8,0x55,0x1E,0xD2,0x6D,0x35,0xD1,0x5E,0x69,0x72,0x97,0x55,0x47,0xFD,0x29,0x29,0x9B,0x47,0x15,0xC2,0xAB,0xA5,0x6F,0x2A,0x55,0xC8,0xAD,0x25,0xD1,0x48,0x01,0x7F,0x19,0x79,0x20,0x00,0xBF,0x85,0x18,0xE0,0xBF,0x10,0x03,0x14,0x5D,0x65,0x0A,0x67,0xC6,0x2D,0x25,0x89,0x99,0x9C,0xB8,0xC1,0xE0,0xC4,0x69,0xF0,0x62,0x8B,0x93,0xBB,0xAC,0xBE,0xB0,0x72,0x6A,0xD9,0x72,0xBA,0x26,0x43,0x75,0x64,0xD1,0x6A,0x1B,0x77,0xD3,0xB5,0x59,0xAB,0x2D,0xD2,0xCD,0xC7,0x2A,0x8D,0xB6,0x49,0x89,0x50,0xAF,0x3A,0xDA,0x26,0xD9,0xD3,0x2D,0x6E,0xE9,0x9A,0xC6,0xE8,0x30,0x7B,0xAE,0x4B,0x02,0x27,0xC5,0x93,0x94,0x71,0x47,0x0B,0x15,0x71,0xD2,0x86,0xC1,0xDC,0xC4,0xAC,0xF7,0xFF,0x03};
const uint8_t spCRYSTALS[] PROGMEM = {0x08,0x88,0x5B,0x4A,0x00,0x39,0x67,0x96,0xAC,0xA4,0x70,0x11,0xF5,0xB2,0xAA,0x12,0x25,0xC4,0xAD,0xCB,0xAA,0xAB,0x2C,0xD1,0xB4,0x35,0xAD,0x6D,0x22,0xC4,0xC5,0x3B,0x05,0xE0,0x59,0x31,0x05,0xBC,0x97,0xCC,0x80,0x1D,0x19,0x15,0x70,0x92,0x49,0x89,0x7F,0xF0,0x0C,0x55,0xA7,0xAD,0x2A,0x34,0x53,0x5C,0xD6,0xB4,0xB6,0x21,0x1F,0x0B,0xEA,0xD2,0xDA,0x8A,0x7C,0xDC,0xA8,0x4B,0x6B,0x1B,0xF2,0x71,0xC5,0x3E,0xAD,0xCD,0xA4,0xCA,0x59,0x5A,0xA7,0xAE,0xC1,0x8C,0x10,0xC9,0x93,0xD6,0x4B,0x42,0xC4,0x25,0xAF,0x02,0xBE,0x47,0x12,0xC0,0x86,0x9C,0x0A,0xF8,0xD9,0xFC,0xFF,0x01};
//const uint8_t spCYLINDER[] PROGMEM = {0x0C,0xF8,0x8E,0x59,0x00,0x7F,0x06,0x29,0xE0,0x37,0x47,0x03,0xFC,0x1E,0xE2,0x80,0x5F,0x43,0x02,0xF0,0x6B,0xB0,0x03,0x7E,0x15,0x5D,0xC9,0xA4,0xE6,0xE2,0x9E,0x65,0x95,0x4D,0x94,0x73,0xE8,0x9A,0x55,0x77,0x5A,0xCD,0x6E,0x5B,0x57,0x7D,0x28,0x55,0x87,0x38,0x1B,0x75,0x43,0x5D,0x6E,0xE2,0x66,0x95,0x45,0x4C,0x98,0x59,0xCB,0x55,0x36,0x3C,0x1E,0xA6,0xAD,0x5A,0xD5,0x14,0x46,0x6B,0xB0,0x29,0x75,0x95,0x18,0x6D,0xA6,0x2C,0xD5,0x45,0x60,0xAC,0xB1,0xF3,0xD2,0x8C,0xC0,0xC6,0x26,0x49,0x5B,0x55,0x5D,0x08,0x65,0x74,0x19,0x65,0x49,0x81,0xDA,0xDC,0x65,0x94,0x25,0x35,0xCA,0x72,0x9E,0x56,0x96,0xDC,0x20,0x47,0x79,0x5A,0x59,0x7C,0x23,0x1F,0xE7,0x09,0x79,0x8A,0xC2,0x5B,0xBE,0x2A,0x0D,0x25,0x28,0x8F,0x57,0xAD,0xFF,0x07};
const uint8_t spCYCLE[] PROGMEM = {0x08,0x78,0x1C,0x51,0x00,0x3F,0x0B,0x29,0xE0,0xB7,0x52,0x05,0xFC,0xE2,0xEA,0x80,0xDF,0x8D,0x1D,0xF0,0x93,0xE9,0x8A,0xAB,0xA8,0x30,0x97,0x36,0xAB,0x4E,0x7E,0x4C,0x33,0x36,0xAF,0xBA,0x84,0x32,0x77,0x5F,0xBD,0xAA,0x1A,0x5C,0x33,0x72,0xD1,0xA8,0x5A,0x11,0x09,0xCB,0x4A,0xAE,0xA9,0x0E,0xA5,0x3D,0x22,0x81,0x00,0x72,0x5A,0x1E,0x43,0x12,0x13,0xE1,0xD2,0x79,0xCC,0x89,0x5F,0xBB,0xAA,0xB7,0xB6,0x16,0xB4,0x13,0x22,0xD9,0xCB,0x5A,0xD0,0x4C,0x0A,0x67,0x2B,0x7B,0xA6,0xD5,0x25,0x94,0xD5,0x1D,0x89,0x7A,0xAE,0x48,0xDA,0xFF,0x07};
const uint8_t spDOWN[] PROGMEM = {0x02,0x28,0x30,0x6C,0x55,0x4D,0x25,0xAB,0xF9,0xEA,0x55,0x57,0x9B,0xA2,0x6E,0x6B,0x56,0x53,0x74,0xAA,0xB7,0xAF,0x5E,0x4D,0xD5,0x6D,0xD6,0xBA,0x78,0x75,0xC5,0xB6,0x79,0xEB,0xE2,0x35,0x64,0x3B,0xA6,0x63,0x4B,0xF6,0xB0,0x96,0xEC,0xD6,0xB4,0x6D,0xC9,0xDA,0x52,0x58,0xD3,0xB6,0xC5,0x6D,0x4B,0xFE,0x4C,0xDA,0x17,0x97,0x3D,0xB4,0xB6,0x48,0x9F,0x5C,0x8E,0x2C,0x2D,0x47,0xC2,0x76,0x3D,0xCB,0x59,0xB9,0xDA,0x68,0x4A,0x2D,0x57,0xB7,0xAC,0x25,0xE1,0xE4,0xFF,0x01};
const uint8_t spGROUND[] PROGMEM = {0x02,0x28,0xBD,0xD4,0xEC,0xC1,0x97,0x99,0x99,0xAB,0x31,0xA4,0xAC,0x69,0xAE,0xF6,0x56,0x97,0x8A,0xA6,0xA5,0x24,0x5F,0x5D,0x6A,0x96,0xEE,0xD6,0x76,0xB5,0xA9,0xA6,0x87,0xFB,0xE6,0xD5,0x64,0xBF,0xEA,0xA9,0x8B,0x57,0x9D,0xE2,0x8A,0x87,0x2F,0x59,0x55,0x8C,0x6D,0xEE,0xB9,0x64,0x94,0xD1,0x75,0x94,0x66,0xAB,0x56,0x55,0xC9,0xD9,0xEC,0x8E,0x43,0x9D,0x25,0x8D,0xB3,0x64,0x11,0x43,0xE0,0xE1,0x21,0x19,0x53,0x0E,0x61,0xEF,0xCE,0xC8,0xC5,0xB6,0xFC,0x3F};
const uint8_t spFULL[] PROGMEM = {0x04,0xA8,0x4C,0x85,0x00,0xC3,0x56,0x10,0x60,0xFA,0x0A,0x01,0x4C,0x97,0xAE,0x80,0x66,0xCB,0x5A,0xD9,0x44,0xA4,0x9B,0xD9,0x19,0x55,0x12,0x3D,0x26,0xD4,0x75,0x56,0xAB,0x2A,0x34,0xD7,0x19,0xBB,0xAD,0xAA,0x11,0xDB,0x14,0xCC,0x36,0xCA,0x4E,0x78,0xDA,0xD1,0xFD,0x28,0x1B,0x91,0x69,0x43,0xF7,0xAD,0xCA,0x4C,0x37,0x99,0xD3,0x95,0x2A,0x4B,0x5D,0x27,0x71,0x57,0x2B,0xD7,0x78,0x6B,0x29,0x52,0x4E,0xFF,0x1F};
const uint8_t spNEW[] PROGMEM = {0xA9,0x2F,0x12,0x27,0x44,0xDC,0xA6,0xA1,0x29,0x18,0x0F,0x4D,0x1C,0x86,0x24,0x78,0x45,0x34,0x75,0x1A,0xAA,0xC4,0x71,0xD5,0xD8,0xAD,0x2F,0x0A,0xDB,0xCD,0x62,0xAF,0xAE,0x1B,0x33,0x0A,0x7B,0xBC,0xEA,0x6E,0x4D,0x39,0xE4,0xC9,0xAA,0x9B,0x52,0x95,0x92,0xD5,0xAD,0xCD,0xDC,0xDC,0x4B,0x3E,0x95,0x21,0xCA,0x70,0x0F,0x7D,0x1D,0x16,0xA7,0x33,0xCA,0xE4,0x91,0xDB,0xBC,0x2C,0x0F,0xA7,0x2F,0xEE,0xF0,0xB2,0xDD,0x9D,0xD6,0xA8,0xCB,0xCB,0x71,0x73,0x5A,0x63,0x5E,0x2B,0x26,0x32,0xA8,0xAD,0xFA,0x9C,0x19,0x37,0x95,0xAC,0xE6,0xF7,0xBE,0xDC,0x55,0xD3,0x9A,0xDF,0xA9,0xF1,0x30,0x49,0x6A,0x7E,0xAF,0xDB,0x42,0x79,0x8D,0xF9,0x43,0x76,0x73,0x8A,0x35,0xFF,0x0F};
const uint8_t spLEG[] PROGMEM = {0xA9,0x1F,0x40,0x26,0x84,0xDC,0xA6,0x61,0x00,0xDD,0x42,0xCA,0x5A,0xFA,0x01,0x75,0x1D,0xA4,0xC9,0xEA,0x2B,0xAB,0x32,0xB5,0xD5,0xAB,0x6D,0xA2,0x43,0xDD,0x56,0xAF,0xAE,0xC8,0xB4,0xA8,0x58,0xBC,0x86,0x2A,0x4B,0xBD,0x72,0xF1,0x9A,0xAB,0x4A,0x89,0xCA,0xC7,0xE3,0x6C,0x36,0xC9,0x2A,0x16,0x97,0xAB,0x05,0x47,0xEF,0x78,0xE4,0x9E,0xDE,0x19,0xBC,0x62,0x96,0x78,0xB2,0x62,0xDA,0x35,0xCB,0xEC,0x09,0x42,0x7D,0xDB,0x64,0x93,0xD7,0x53,0xCF,0x4E,0x93,0x42,0xDE,0x8A,0x55,0x2C,0x22,0x71,0xFA,0x46,0x3C,0x33,0x33,0xDB,0xE9,0xAB,0x81,0xA9,0x22,0x17,0x87,0xAF,0x45,0xC5,0x8C,0x5C,0xF4,0xFF};
const uint8_t spMAINTAIN[] PROGMEM = {0xAD,0xCD,0xDC,0xA4,0xDD,0xE2,0x94,0x21,0x73,0x93,0x76,0x8D,0xB3,0xFA,0x1A,0xD5,0xCC,0x7C,0xC9,0xEA,0xBB,0x4F,0x91,0x8C,0xC7,0xAB,0x1B,0x2E,0x59,0x3A,0x1E,0xAF,0x66,0x84,0x24,0xE9,0x98,0x35,0xEA,0xE1,0x1D,0x75,0x7D,0xE2,0xA8,0x9B,0x26,0xEF,0xB0,0xB8,0xAD,0x29,0x92,0x7C,0xDC,0xEC,0xA6,0x36,0x4B,0xAC,0x70,0x77,0x6C,0xFA,0x26,0xB1,0x3C,0x58,0x49,0x00,0xA6,0x49,0x4F,0xC0,0xB5,0xED,0xAD,0xEA,0x26,0x98,0xAD,0x66,0xAF,0xBA,0x7B,0x17,0xF1,0x58,0xB2,0xEA,0x61,0x4B,0x29,0xED,0xCD,0xEA,0xBA,0x0C,0x91,0xCD,0xC5,0xAB,0x1F,0x26,0x45,0xC6,0x1F,0xAD,0x7E,0xDA,0x64,0x1E,0x5F,0xB4,0xFA,0xE9,0x92,0x64,0x63,0xE6,0xEA,0xA6,0x0E,0xD6,0xF3,0x8A,0xAB,0x1B,0xCA,0xD8,0xD7,0x46,0xB5,0xAE,0x19,0x8C,0x72,0xB3,0xDB,0xFA,0xA6,0x29,0xDA,0xCC,0x6E,0xE9,0x9B,0xC1,0x0C,0x73,0x55,0xAD,0x6F,0xC1,0x55,0x25,0x6A,0x86,0xA1,0x28,0xD5,0x10,0x8F,0x6C,0xFA,0xEA,0x54,0x95,0xBD,0xF2,0xFF,0x03};
const uint8_t spLANDING[] PROGMEM = {0x61,0x1B,0x88,0x67,0x05,0xBB,0x84,0x35,0x91,0x5A,0x45,0x5B,0xBA,0x96,0xAC,0xBB,0xD4,0x75,0xF3,0x1A,0xAB,0x6A,0xD7,0xB0,0xC5,0x6B,0xA8,0x36,0xD5,0x33,0x1E,0xAF,0xAA,0x3A,0x97,0xCA,0x9C,0xBD,0x8A,0xE6,0x83,0x33,0x6B,0xF2,0xCA,0x8B,0x0B,0x29,0xAF,0xCA,0x23,0x6B,0x86,0x32,0x35,0x55,0xB5,0x7C,0x78,0xCC,0x32,0x67,0xE5,0xAA,0x2A,0x50,0x9E,0xC3,0x75,0x19,0xB6,0x4D,0x53,0x56,0x3B,0xAB,0x6E,0xCE,0x4C,0xA4,0xE7,0xAC,0xB6,0x7B,0x67,0xB6,0xBE,0xB3,0x86,0x69,0x93,0x39,0xE3,0xF1,0x1A,0x87,0x77,0x94,0x89,0x99,0x65,0xEA,0x1E,0x6D,0xD2,0x82,0xB5,0xB9,0x1B,0xF2,0x0A,0xB1,0x5B,0xD6,0x6E,0xC9,0x2A,0xD5,0x6A,0x59,0xBB,0x26,0xAB,0xD4,0xA8,0x61,0xAD,0x92,0xBC,0x8B,0xAD,0x99,0x23,0x61,0xB3,0x0D,0xB6,0xFB,0xFF};
const uint8_t spLEAN[] PROGMEM = {0x61,0x1B,0x88,0x67,0x05,0xBB,0x84,0x35,0x91,0x5A,0x45,0x5B,0xBA,0x9A,0xC6,0xC3,0x44,0xAD,0xCB,0x2A,0xAA,0x56,0xD5,0x8C,0x27,0x2B,0x1F,0x5E,0x99,0x33,0x9E,0xAC,0x6C,0xE6,0x60,0x8C,0x98,0xBD,0xF2,0x99,0x8C,0xB8,0x73,0xD4,0xAA,0x87,0x17,0xB2,0x8D,0x20,0x63,0x18,0x46,0x28,0xCE,0xC3,0xB4,0x71,0x3A,0x45,0x3F,0x37,0xD3,0x96,0xE9,0x85,0xEC,0xC2,0x4C,0xDB,0x87,0x65,0xB6,0x75,0xD3,0xE5,0x18,0x51,0xD8,0x26,0x4A,0xA5,0x67,0x44,0x74,0x6F,0x75,0x9C,0xDE,0x11,0xD1,0xBD,0xD4,0x71,0x7A,0x47,0xA4,0x70,0x75,0x55,0xE9,0x2D,0x32,0x5D,0xCB,0x63,0xFD,0x3F};
const uint8_t spSET[] PROGMEM = {0x08,0xD8,0x84,0x99,0x01,0xCF,0xB8,0x32,0xE0,0xA7,0x14,0x05,0xFC,0x56,0x6A,0x81,0x00,0xFC,0x96,0xEA,0x80,0x5F,0xCA,0x56,0x3E,0x79,0xAA,0xAA,0xB7,0x5E,0x45,0xD3,0xA9,0x6A,0xF9,0x64,0x15,0xDD,0xB4,0x99,0xC6,0x9A,0x55,0xD4,0x50,0x62,0xD6,0xB5,0x4B,0xD6,0x78,0x4B,0x58,0xCD,0x44,0xE0,0x14,0xA5,0x2A,0x54,0x03,0x00,0x14,0x30,0x85,0x3A,0x03,0x9E,0xAF,0xF8,0x7F};
const uint8_t spSHORT[] PROGMEM = {0x0C,0x38,0x71,0x54,0x01,0xBB,0x6D,0x19,0x60,0x97,0xEB,0x00,0xEC,0xB2,0x16,0x80,0x95,0x2F,0x02,0x30,0xFB,0xB8,0x03,0x7A,0x0E,0x69,0x45,0xF5,0x1D,0x21,0x22,0xA7,0x95,0xD1,0xB6,0x6B,0xB1,0xF6,0x56,0x87,0xD6,0x62,0xC9,0xDE,0x5A,0x1B,0x46,0x72,0x2C,0x7A,0x6B,0x5D,0x1C,0x81,0x35,0x98,0xA7,0x4C,0xA9,0x3A,0xE6,0xAA,0x1F,0x04,0x4E,0x51,0xAA,0x42,0x35,0x00,0x40,0x01,0x43,0xBA,0x31,0x60,0x73,0x35,0x04,0x4E,0x51,0xAA,0x42,0x35,0xFE,0x1F};
const uint8_t spWAKE[] PROGMEM = {0x62,0x21,0xE9,0x3A,0x54,0x9D,0x88,0x83,0xA4,0xCF,0x10,0x76,0x2C,0x4E,0x52,0x2E,0x83,0xC5,0xB1,0x3A,0x59,0xDD,0x74,0xD6,0x8C,0xEE,0x10,0xB3,0x92,0x45,0x3A,0x8F,0x25,0xC4,0xCC,0x60,0xED,0xB2,0xA6,0xE2,0xC3,0x42,0xFC,0xCD,0xEA,0xAA,0x57,0x49,0xCF,0xC5,0xAB,0xEE,0x41,0x29,0x22,0xAF,0xAC,0x7C,0x14,0x05,0x8F,0xBA,0x9D,0xB2,0xD1,0x09,0x32,0x7A,0xA1,0xA8,0xA6,0x19,0x32,0x55,0x3B,0x08,0x2C,0xAA,0x54,0x85,0x6A,0x00,0x28,0xA0,0x79,0x11,0x0D,0x08,0xA0,0x15,0xE3,0xFF,0x07,0x08,0x9C,0xA2,0x54,0x85,0x6A,0xC0,0xFF,0x03};
const uint8_t spADIS[] PROGMEM = {0x6D,0xEA,0x36,0x48,0x2A,0x57,0x8D,0x69,0xFA,0x66,0xCC,0x58,0xBD,0xDA,0xE9,0x8A,0x28,0x63,0xCD,0xAA,0x47,0x48,0x94,0x8C,0x25,0xAB,0x1A,0x49,0xD0,0xAC,0x9B,0x80,0x00,0x9E,0x32,0x6D,0x59,0xF3,0x2A,0x26,0xDD,0xB8,0x65,0xD5,0xA9,0xB8,0xCC,0xE2,0x91,0x15,0xE5,0xE2,0xD1,0xB3,0x47,0xD6,0x44,0xB2,0x4A,0xAE,0x32,0xC0,0x33,0xAE,0x0A,0xF8,0x29,0xC5,0x00,0xBF,0x95,0x5A,0x20,0x00,0xBF,0xA5,0x3A,0xE0,0x97,0x32,0x03,0xFC,0x5C,0xF6,0xFF};
const uint8_t spNOTEM[] PROGMEM = {0x66,0x8B,0x52,0xBC,0xCD,0x26,0x85,0x35,0x08,0xC9,0x31,0xAD,0x1C,0x97,0x36,0x77,0xE5,0xA6,0x46,0xAB,0x57,0x9B,0xF5,0x88,0x54,0x2D,0x59,0x55,0x51,0x6D,0x6E,0xBC,0x76,0x15,0xD9,0x94,0xA7,0xF0,0xEB,0x91,0x27,0x93,0xA6,0xA6,0x6B,0x5A,0x9E,0xB2,0x8A,0xA4,0xA7,0x41,0xE0,0x14,0xA5,0x2A,0x54,0x03,0x04,0xF0,0x94,0xA9,0x07,0x56,0x55,0xBD,0x8B,0xA5,0xB7,0x5A,0x4D,0x4B,0xAE,0xE6,0xFE,0x78,0x0D,0xCD,0xA6,0x48,0xDB,0xEA,0xF2,0x24,0x9F,0x11,0xEE,0x8D,0xCB,0x53,0x64,0x7A,0x0A,0x39,0x4D,0x77,0x65,0xE3,0x2E,0x62,0x37,0xDD,0x8D,0xB6,0x96,0x48,0xD4,0x70,0x27,0x5F,0x96,0x6C,0x4E,0xFE,0x1F};
const uint8_t spRVRS[] PROGMEM = {0x65,0x8C,0x79,0x22,0xCC,0x12,0xAF,0x31,0xE9,0x2B,0x4E,0xEB,0xBD,0xC6,0x64,0x2F,0xA5,0xA4,0xCF,0x1A,0x52,0x38,0xF5,0xA1,0xCE,0xAB,0x2D,0xF6,0xC4,0x0F,0x7B,0xAF,0x2A,0xC7,0xC1,0x5E,0xDC,0xB4,0x8A,0x3C,0x12,0xCF,0x79,0x63,0xCB,0x73,0x53,0x5E,0xE7,0x9E,0xA9,0x4E,0x51,0xCD,0x4D,0x9D,0xBA,0x26,0xC9,0xA2,0x30,0xF5,0xE2,0xBA,0xC6,0x4C,0xD4,0x22,0xF1,0xA8,0x9A,0x71,0x52,0xF7,0xBA,0x2B,0xEB,0x51,0xC9,0x3C,0xD6,0xAC,0x6C,0x04,0x43,0x8D,0x5C,0xB2,0xF2,0x61,0x15,0xB4,0x6B,0xF6,0x2A,0x87,0x33,0xD0,0xAE,0x39,0xAB,0xEE,0x46,0xD1,0x27,0x97,0xAC,0xBA,0x1A,0xE7,0x70,0xBF,0xBD,0xDA,0x14,0x93,0xCB,0xE2,0xF6,0xEA,0x62,0x1C,0xC9,0xE2,0x55,0xAB,0x8F,0x69,0x24,0x93,0x5E,0x8D,0x21,0xD6,0x96,0x0A,0x7A,0x35,0xE6,0x58,0xDB,0xA2,0xF8,0xF5,0x98,0x53,0x4D,0x8F,0xE6,0xCD,0x63,0xCF,0xCD,0x3D,0x8B,0x56,0xB7,0x23,0xE7,0xB0,0x18,0xFA,0xDC,0xCE,0xDC,0x42,0xB3,0x69,0x73,0xBA,0x72,0x29,0x8E,0xA1,0xDD,0xE1,0x4A,0xD5,0x78,0x9A,0x3F,0xA5,0x3B,0x25,0xE3,0x59,0xDD,0x1D,0xEE,0x1C,0x9D,0xAA,0xBC,0xB7,0x7B,0x8A,0x0F,0xB2,0x89,0x4C,0xE9,0x29,0x2E,0x89,0xBB,0x5A,0xBB,0xB7,0x7A,0x13,0x93,0x58,0x9C,0xBE,0x63,0xC3,0x8D,0xC4,0x5D,0xFA,0x2F,0x09,0x11,0x97,0xBC,0xE1,0xBF,0x88,0xDD,0x3C,0xDC,0x28,0xE0,0x7B,0x24,0x01,0x6C,0xC8,0x89,0x80,0xE5,0xDD,0xFF,0x1F};
const uint8_t spSQUALKING[] PROGMEM = {0x0C,0x78,0xC6,0x95,0x01,0x3F,0xA5,0x28,0xE0,0xB7,0x52,0x0B,0x20,0x70,0x8A,0x52,0x15,0xAA,0x81,0x80,0xC4,0xCC,0x30,0xC0,0x81,0x92,0x79,0xBB,0xA1,0x49,0x59,0x47,0xE9,0xE2,0xA6,0x05,0x65,0x5B,0x65,0x48,0x17,0x12,0xDA,0x77,0x55,0x31,0x9E,0x69,0x5A,0xEF,0x55,0xC7,0xD6,0x16,0x26,0x9D,0x5A,0x97,0xE2,0x72,0x39,0xF7,0x01,0x05,0x54,0x1F,0xAA,0x80,0x6A,0x8D,0x47,0xD3,0xB2,0x90,0x47,0x2E,0x1E,0xF3,0xF0,0x25,0x58,0xF6,0xA6,0xED,0xDD,0x1A,0xEB,0xF9,0xC4,0x70,0x35,0xCB,0x5A,0xCB,0x61,0xC3,0xD5,0x0C,0x67,0xA8,0x39,0x76,0x77,0x31,0xDC,0xAE,0xEA,0xD8,0x3D,0xD5,0x48,0xA5,0x98,0x92,0xFF,0x07};
const uint8_t spMAGNETOS[] PROGMEM = {0x6A,0xD5,0x3A,0xB3,0xD5,0xED,0xBA,0x35,0x08,0xCD,0x0A,0x73,0x9A,0xD6,0xA4,0x38,0xCA,0xDD,0xC9,0x59,0x8A,0x2F,0x97,0x90,0xCD,0x67,0x6A,0xA6,0x5C,0x4B,0xD7,0x9C,0xB1,0xDB,0x72,0x69,0x5D,0x73,0x86,0x6E,0x4A,0x64,0x7D,0xF3,0x19,0x7A,0x59,0xC2,0xD1,0x55,0x6D,0x68,0xD1,0xC0,0x47,0x2A,0xA9,0x51,0x19,0xAF,0x26,0x49,0xAC,0x46,0x27,0xB4,0xDA,0x3D,0x91,0x1B,0x82,0xE0,0x1E,0x35,0xD7,0xAB,0x6D,0x8E,0xC5,0xAD,0x07,0xAF,0xA2,0x07,0x65,0xCB,0x1C,0xBD,0xB2,0x91,0x94,0x34,0x73,0xD2,0xCA,0x46,0x64,0xB2,0xA8,0x59,0x25,0x1F,0x46,0xC9,0x4C,0x3B,0xAF,0xBC,0x6B,0x17,0x53,0x5D,0xB3,0xB2,0xAA,0x52,0xDD,0x74,0xE9,0x2A,0x8A,0x28,0x0B,0x97,0xD7,0xAB,0x2C,0xAC,0xDD,0x43,0x3E,0xEF,0x72,0x55,0x95,0x54,0x5A,0xE8,0xAA,0x55,0x55,0x96,0xAE,0xC2,0x9B,0x47,0x3B,0x84,0x85,0x89,0x78,0x4B,0xEB,0x45,0xEC,0xE6,0xE1,0xA6,0xEC,0xDF,0x47,0x98,0x30,0x33,0x05,0x7C,0x8F,0x24,0x80,0x0D,0x39,0xFF,0x1F};
const uint8_t spSTABILISER[] PROGMEM = {0x0C,0x78,0xC6,0x95,0x01,0x3F,0xA5,0x28,0xE0,0xB7,0x52,0x0B,0x30,0xE0,0xFB,0x08,0x04,0x4E,0x51,0xAA,0x42,0x35,0x40,0x00,0x4F,0x99,0xAE,0xA8,0x6B,0x57,0x75,0x5F,0xBD,0xCA,0xEE,0x42,0xC4,0xFD,0xCE,0xAA,0xBA,0x77,0x56,0x8F,0x39,0xA3,0x6A,0xCE,0xD9,0xDC,0x17,0xBB,0xDA,0xA8,0x8C,0x70,0x6E,0xC5,0x7A,0xE6,0xDA,0xCC,0x23,0xF5,0x98,0x92,0xEC,0x54,0xD3,0x34,0xA3,0x2F,0xB4,0x26,0x8C,0xBA,0x95,0xB1,0x62,0x1F,0x77,0xE8,0xB2,0xC6,0x4A,0xAA,0xC3,0xA9,0xEB,0x1A,0x1B,0xAD,0xB6,0xE0,0x2D,0x6B,0xAC,0x7C,0x52,0x53,0x37,0xAF,0xB9,0xC9,0x09,0x49,0xD9,0xBC,0x96,0x2E,0xCB,0xB5,0x65,0xF3,0x5A,0x9B,0x48,0x8D,0xB1,0x57,0x6D,0x2F,0x41,0x2C,0xA2,0x27,0x85,0xFD,0x97,0xF6,0x00,0x91,0x5D,0x0F,0x03,0xFC,0xEC,0x6A,0x81,0xB6,0x37,0x1F,0xC2,0xA1,0x6D,0xD2,0x55,0x72,0x92,0xB4,0xE4,0x0B,0x4F,0x59,0xCA,0x91,0xD2,0xD7,0xBC,0x65,0x08,0xE5,0x70,0x67,0xF7,0xA5,0xE4,0xE8,0xE7,0x69,0xCC,0x57,0x86,0x52,0xB6,0x76,0x31,0x7F,0x59,0x2C,0x95,0xBA,0xFA,0xFF,0x01};
const uint8_t spPAKM[] PROGMEM = {0x0A,0xD8,0x5C,0x4D,0x03,0xAB,0xA8,0x21,0x2C,0x3D,0x96,0xAC,0xAA,0xFA,0xD2,0x08,0x5B,0xB2,0xAA,0x16,0x53,0x32,0x7C,0x49,0xAB,0x4A,0x12,0x39,0xEB,0x30,0x08,0x9C,0xA2,0x54,0x85,0x6A,0x80,0x02,0x9A,0x0B,0x56,0x40,0xCF,0x46,0xAB,0x69,0xC9,0x28,0x2D,0x67,0xAF,0xBE,0x3A,0xE7,0x6C,0xBF,0xBD,0xC6,0x6A,0x43,0x72,0xFC,0xD6,0x58,0x9A,0x4A,0x89,0xF5,0x47,0xE3,0x68,0xBA,0xC4,0xC6,0x66,0xB5,0xA3,0xEA,0x94,0x68,0xAB,0xDD,0xCE,0x2A,0x5A,0xA3,0x6D,0x71,0xB9,0x8A,0x0F,0x2D,0x8F,0xD9,0xE5,0x49,0xBA,0xB4,0x32,0x26,0xD5,0xA7,0x3E,0xE5,0x6D,0x86,0x2D,0xCC,0xEC,0x96,0x77,0x78,0x96,0x30,0x8F,0x9A,0xDE,0x6A,0x24,0x4C,0x23,0x4E,0x7E,0xFF,0x1F};
const uint8_t spSELCAL[] PROGMEM = {0x0C,0xF8,0x29,0x45,0x01,0xBF,0x95,0x5A,0x20,0x00,0xBF,0xA5,0x3A,0xE0,0x97,0x32,0x03,0xFC,0x5C,0xB6,0x92,0xA6,0x4B,0x39,0x6D,0xF5,0x4A,0x8B,0x4C,0x8B,0xB4,0xD7,0x2B,0xAB,0x7C,0xDC,0x52,0x5F,0xAE,0x2C,0xEA,0x0D,0x37,0xDD,0xBC,0xF2,0x68,0x26,0xD3,0x38,0xB3,0x2A,0x32,0x29,0x35,0x93,0xAC,0x08,0x9C,0xA2,0x54,0x85,0x6A,0x80,0x03,0xAA,0x35,0x72,0x40,0x31,0xC2,0xAB,0xAD,0x45,0xC5,0x3D,0x5B,0xAF,0xAE,0x14,0x95,0xC8,0x5C,0xBC,0xFA,0x62,0x52,0x63,0xED,0xF5,0x6A,0x8B,0x6F,0xB1,0xD6,0x55,0xEB,0x2C,0x7E,0x55,0x4B,0x17,0x8D,0xAB,0xA8,0x75,0x19,0x5B,0xBC,0xFE,0x6C,0xD6,0x3C,0x75,0x76,0x79,0xA3,0x5F,0xF3,0xB0,0xD9,0xE9,0x4F,0xF2,0x4B,0x43,0x37,0xA7,0x3F,0x98,0xAF,0x30,0xE9,0xEC,0x7E,0xEF,0x3E,0x52,0xB5,0x8B,0xFB,0x43,0xE8,0x6A,0xD2,0xD6,0x08,0x70,0xDE,0x03,0x01,0xC1,0x5A,0xFE,0x3F};
const uint8_t spVORTAC[] PROGMEM = {0x66,0x8D,0x2E,0xDC,0x95,0x9B,0xB8,0xAD,0x30,0x0F,0x29,0x51,0xE2,0x8E,0xCA,0x54,0x35,0xCC,0xB1,0x3B,0x87,0x34,0x65,0x55,0xC5,0x65,0x9B,0x3A,0x53,0x83,0x1C,0xB5,0x2E,0xD8,0x4A,0x4D,0x89,0x3D,0x1A,0xEF,0x2F,0xD4,0x39,0xED,0x68,0x82,0xB9,0x92,0x22,0x6F,0xA3,0x70,0x79,0xD5,0x9A,0xB3,0x8D,0x22,0xD4,0xA2,0x29,0xEC,0x32,0x8A,0xD4,0x94,0xBB,0x38,0xF7,0x28,0xEB,0x70,0x71,0x36,0x27,0x08,0x9C,0xA2,0x54,0x85,0x6A,0x80,0x00,0x9E,0x32,0x95,0xC0,0xAA,0x4B,0x08,0x0A,0xCF,0x8C,0xAB,0xCB,0x3E,0x24,0x3A,0x56,0xAF,0xA1,0xB8,0x12,0x1F,0xDF,0xBC,0xA6,0x6A,0x5B,0x74,0x6C,0xF3,0xDA,0xAA,0x2D,0xB5,0xD6,0xD5,0xE3,0xAC,0xAE,0xC4,0xDB,0x5F,0xB5,0xAF,0xFA,0x94,0x68,0x5B,0x54,0xBE,0x66,0x9B,0x6C,0x6D,0x93,0xFB,0xDB,0x11,0x5E,0x8F,0x98,0x08,0x9C,0xA2,0x54,0x85,0x6A,0x80,0x00,0xBA,0x6F,0x66,0x40,0x8B,0x41,0x14,0xF8,0x7F};
const uint8_t spVOR[] PROGMEM = {0x6E,0x2D,0xDA,0x45,0x5C,0xDD,0x84,0xAD,0x1A,0x57,0x51,0x51,0x93,0xF6,0xA1,0xC2,0x58,0x59,0x49,0x3A,0x96,0xAF,0x20,0x51,0xC5,0x6D,0xE8,0xC6,0x48,0x2D,0x32,0xAF,0xB6,0x47,0x63,0x0A,0x5B,0xBD,0xAA,0x11,0x9C,0x30,0xE3,0xCD,0x2A,0x67,0x74,0x86,0xC8,0x35,0xAB,0x98,0xC1,0x08,0x33,0x97,0xAC,0x62,0x64,0x43,0xCA,0x58,0xBD,0x8A,0x91,0x1D,0x39,0x6C,0xCD,0x2A,0x9A,0x56,0x89,0x94,0xAD,0xAB,0xCC,0xAA,0x4D,0xDD,0x5A,0x8F,0x2A,0xEA,0x75,0x73,0xD9,0xD2,0xEA,0xA8,0x2E,0xDD,0xB8,0x77,0xAF,0x5B,0x1D,0xD4,0x65,0x18,0xE5,0x29,0x75,0x50,0x57,0x6E,0x94,0xB7,0xD4,0x4E,0x5F,0xBB,0xB1,0x9F,0x52,0x7B,0x73,0xAD,0xAA,0x79,0x5A,0x15,0xF4,0xB6,0x07,0xE5,0x59,0x75,0xF0,0x97,0xE2,0x9E,0x6F,0xD5,0xC1,0x5D,0x6A,0x58,0xB6,0xD5,0x44,0x7B,0xA9,0x29,0x7D,0x57,0x17,0xE2,0xB9,0x94,0x75,0x5E,0x7D,0x4C,0x6B,0x56,0xDA,0x65,0x2D,0x31,0x8E,0x7B,0x4B,0xE7,0xB5,0xA4,0x5C,0x96,0x45,0x9D,0xC7,0x91,0x62,0x9B,0x0D,0xF7,0x2D,0x57,0xCA,0x65,0xB6,0xDC,0x25,0xDD,0x29,0x96,0xE9,0x73,0x9F,0xF2,0xA4,0x12,0x9A,0xCB,0xAD,0xD3,0x9B,0x8B,0x73,0x2E,0x6D,0x0E,0x6F,0x2A,0x49,0x71,0xB2,0x25,0xBD,0xB9,0x05,0x76,0x6B,0x67,0xF7,0xE5,0x16,0x30,0x6E,0x9D,0xDD,0x57,0xB6,0xE1,0xB8,0x65,0x34,0x5F,0x79,0x62,0x65,0xD2,0xFA,0xFF,0x01};
const uint8_t spBARKER[] PROGMEM = {0xA1,0x0D,0xDA,0xCB,0xC1,0x9D,0xA6,0x3E,0x2A,0xAF,0x04,0x8D,0xDB,0xFA,0xAC,0x2C,0x5B,0xD8,0x4A,0xEB,0x7D,0xD9,0xB4,0xA4,0xA6,0xAD,0x0D,0x79,0x25,0x96,0x56,0xF7,0x76,0x54,0x31,0x0E,0xD7,0xD2,0xA6,0x51,0x25,0x3F,0x98,0x4F,0x9B,0x4A,0x5D,0xC2,0x83,0xA7,0x38,0x41,0xE0,0x14,0xA5,0x2A,0x54,0x03,0x18,0xD0,0xCD,0x9B,0x02,0x4A,0x4C,0x34,0x40,0xCC,0x68,0x6D,0xCC,0x53,0xB1,0x8A,0x77,0xB7,0x35,0xF7,0x44,0x39,0xEA,0xDB,0xD6,0xD2,0x9B,0x78,0x29,0x6F,0x3A,0x4B,0x5E,0x81,0xE3,0x7C,0xE9,0xC9,0xAD,0xD0,0x46,0x73,0x87,0xB7,0xB4,0x42,0x1D,0xCA,0x63,0xBE,0xF2,0x98,0x47,0x74,0xF7,0xFF,0x03};
const uint8_t spHEADING[] PROGMEM = {0x08,0x08,0x06,0x05,0x01,0x51,0x81,0x96,0xB6,0x67,0xA3,0x10,0x8B,0xB4,0xAA,0x62,0xD9,0x3A,0x2A,0xD2,0x2A,0x5B,0x72,0xF6,0xC8,0x25,0xAB,0x6A,0x36,0xD8,0x33,0x1F,0xAF,0xAA,0xAB,0x64,0xF3,0xB8,0xAD,0x1A,0x6E,0xC2,0xA3,0x32,0x62,0xEA,0x0A,0x52,0xCB,0x8C,0xD4,0xAB,0xEA,0xCE,0x49,0xB5,0x96,0xAC,0xAA,0x07,0x43,0xF5,0x9A,0xB3,0xEA,0x1E,0x88,0xAB,0xB2,0xF0,0xA8,0x9B,0xC1,0x4E,0x57,0xA5,0xA3,0x6E,0x06,0x2B,0x5C,0xED,0xAC,0xBA,0x69,0x8A,0x72,0x8D,0x5B,0x9A,0xA6,0xC8,0x37,0xC5,0xEE,0xFF,0x03};
const uint8_t spETA[] PROGMEM = {0xAD,0x5F,0x31,0x18,0x3C,0x97,0xAC,0x6E,0xC5,0x22,0xF0,0x5C,0xBA,0x9A,0x15,0x03,0xA1,0x6A,0xCE,0x2A,0x67,0x71,0xC0,0xAA,0xC5,0xAB,0x98,0x41,0x41,0xBA,0x17,0xAB,0xCA,0xD2,0xC8,0x2D,0xB5,0x83,0xC0,0x29,0x4A,0x55,0xA8,0x06,0x28,0x60,0x50,0x95,0x04,0x7C,0x9B,0x96,0x80,0xED,0xAF,0x46,0xD6,0x0D,0xB3,0x57,0xD7,0x5E,0xF9,0xCC,0x8E,0x14,0xB9,0x64,0x15,0x2B,0x07,0x62,0xC4,0x92,0x55,0xAE,0x1C,0x88,0x99,0x4B,0x56,0x35,0x73,0x20,0x66,0x2E,0x19,0xD5,0x8C,0x06,0xDC,0xF9,0x64,0xD5,0x23,0x18,0x4A,0xC6,0x9C,0xD5,0x0C,0x9F,0x24,0xE9,0x8F,0x57,0xD7,0x6D,0x90,0x55,0x3C,0x5E,0x43,0x37,0x41,0xD6,0xFE,0x78,0xCD,0xDD,0x24,0x59,0xFB,0xE3,0xB5,0x76,0x13,0xEC,0x13,0x8B,0xC6,0x31,0x6C,0x92,0xB4,0xBF,0x1A,0x77,0x77,0x46,0xDE,0x31,0xBB,0x3C,0xC3,0x05,0x4A,0xFB,0xE3,0xF4,0x0D,0x17,0xA0,0x13,0xAF,0xD2,0xD7,0x8D,0x60,0x4D,0xDD,0x2A,0xFF,0xC8,0x42,0x96,0xD5,0x26,0xFD,0xA3,0x10,0x7B,0x74,0x5B,0xF3,0xF7,0x22,0xAE,0x1C,0x65,0xFE,0x1F};
const uint8_t spDOWNWIND[] PROGMEM = {0x0C,0x28,0x30,0xAC,0x95,0xCB,0x4E,0x85,0xAA,0x9B,0xD5,0x4F,0x15,0x46,0xA1,0x7D,0x57,0x57,0x6D,0xA8,0x96,0xAF,0x59,0x6D,0xB5,0x65,0x1E,0xF6,0x7A,0x35,0xC5,0xAF,0x59,0xD8,0xA3,0x55,0x65,0xB7,0x6A,0xE9,0x8B,0x57,0x99,0xFC,0x68,0x78,0xCC,0x59,0x59,0x8C,0x99,0xAE,0x59,0x67,0x65,0x55,0x4B,0x85,0xA4,0xAA,0x96,0x35,0x45,0xD5,0x12,0xAA,0x47,0x99,0xB4,0x4D,0x50,0x3A,0x2E,0x75,0xD4,0xB2,0x89,0xA1,0x26,0x35,0x41,0xEB,0x16,0x49,0xDD,0x55,0x47,0x93,0x59,0x42,0x8B,0x57,0x55,0xB4,0x5B,0x3A,0xBF,0x5E,0x65,0xD3,0x2E,0x91,0x7A,0x7B,0x95,0xCD,0x98,0x44,0xFA,0xE5,0x55,0x16,0xCB,0xA5,0x5E,0x55,0x46,0x55,0x35,0x75,0xA8,0xC5,0x69,0x55,0x55,0xD8,0x61,0xEA,0xA4,0xD5,0x59,0x52,0x87,0x69,0x62,0x57,0x3B,0x29,0x9D,0xDC,0x15,0x5B,0xBF,0x98,0xB9,0xB0,0xF5,0xF9,0x7F};
//const uint8_t spCEILING[] PROGMEM = {0x0C,0xF8,0x29,0x45,0x01,0xBF,0x95,0x5A,0x20,0x00,0xBF,0xA5,0x3A,0xE0,0x97,0xB2,0x95,0x0E,0xED,0x8A,0x61,0x6B,0x46,0x39,0x7C,0x30,0x86,0x7E,0x19,0xC5,0x88,0x4E,0x94,0xFA,0x65,0x15,0xDD,0x29,0x6B,0xEB,0xEA,0x56,0x54,0xA6,0x16,0xC5,0xAB,0x47,0x31,0xB0,0xA6,0x85,0xB6,0x59,0x79,0x53,0xCE,0x91,0x3E,0x6B,0x14,0x4D,0xA9,0x54,0x79,0xA9,0x52,0x54,0x8D,0x39,0x21,0x56,0x4B,0xD1,0x34,0x76,0xB9,0xDA,0x2D,0x79,0xD3,0x58,0xED,0x6A,0x37,0xE5,0x59,0x51,0x55,0xB0,0x13,0x91,0x31,0x57,0x61,0x6A,0x69,0x48,0xA6,0x59,0x55,0x85,0xCB,0xF9,0x7F};
const uint8_t spMIDPOINT[] PROGMEM = {0xE2,0xE0,0x62,0xAA,0x5D,0xED,0x98,0x5D,0xA8,0x8C,0x0A,0x8D,0xE3,0x36,0xAD,0x2D,0xCA,0x2D,0xB6,0xDB,0x8C,0xB2,0x68,0xD7,0x38,0x6B,0xA9,0x4A,0x4D,0xCB,0x5A,0xAF,0xBE,0x59,0x55,0xCD,0x78,0xB5,0xEA,0x6E,0x9C,0xD5,0xE3,0xCE,0x2A,0xBB,0x49,0x11,0xF5,0x27,0xA2,0x14,0x2A,0xA3,0xBD,0x03,0xB1,0x5A,0x88,0x8E,0x0E,0xB7,0xC4,0x6A,0x21,0x2A,0xC2,0x23,0x31,0x69,0x1D,0x8E,0xAA,0x4C,0xDB,0x08,0x00,0x7A,0x12,0x03,0x0A,0x08,0xD6,0x3D,0x55,0xD5,0xA4,0x3B,0x99,0xAD,0x52,0x79,0x3F,0x99,0x42,0xAD,0x4E,0x19,0xED,0x54,0x05,0xB6,0x39,0x55,0xD4,0xDB,0x96,0xB4,0xF4,0x54,0xD1,0x4C,0x78,0xEA,0xD2,0x53,0x65,0x57,0xEA,0xE5,0x6B,0x4E,0x55,0x54,0x4A,0x6E,0x34,0x6A,0x55,0x54,0x52,0x65,0x69,0x51,0x35,0x5A,0x46,0xB4,0x99,0x23,0x03,0x4C,0xA1,0xEE,0x80,0xE7,0x2B,0x04,0x70,0x63,0xE6,0xFF,0x03};
const uint8_t spSIGNET[] PROGMEM = {0x0C,0x78,0xC6,0x95,0x01,0x3F,0xA5,0x28,0xE0,0xB7,0x52,0x0B,0x04,0xE0,0xB7,0x54,0x07,0xFC,0x52,0x76,0x8A,0x2E,0xC3,0xD8,0x6D,0xF5,0xC9,0xBB,0x4E,0x95,0xF0,0xD7,0xA7,0xE8,0x3A,0x59,0xD2,0x57,0xAF,0x62,0xA4,0x00,0x0D,0x5D,0xED,0xEA,0x22,0x99,0xBA,0xAD,0xA2,0x68,0xB9,0xED,0x4C,0x37,0x59,0x62,0xE0,0x6A,0xC3,0xCD,0x9C,0xA8,0xD1,0xB0,0x8E,0x70,0x4F,0x9C,0xE6,0xA8,0xCD,0xC3,0xB5,0x4E,0x9E,0xCB,0x58,0xAC,0xBB,0xA5,0x3E,0x2E,0x73,0xD1,0xEE,0xD1,0xFE,0x68,0xAC,0x4D,0xBB,0x7A,0xD9,0xAB,0xB2,0x57,0xE3,0x1A,0xEE,0x3F,0x11,0x38,0x45,0xA9,0x0A,0xD5,0x00,0x00,0x05,0x4C,0xA1,0x2E,0x80,0xE7,0x2B,0x08,0x70,0x63,0xE6,0xFF,0x03};
const uint8_t spROLL_OUT[] PROGMEM = {0x2C,0x16,0x31,0xA5,0xD2,0xE5,0x9A,0x53,0xFB,0x51,0xF5,0x88,0xA2,0x0E,0x91,0x5A,0x2C,0xCD,0xAE,0x3B,0x5C,0x36,0xC9,0x50,0x7B,0x65,0x0D,0x45,0x34,0x43,0x9C,0x8F,0x29,0x64,0x0F,0x4D,0x4D,0x3F,0xFA,0xA8,0xBA,0xD2,0xA9,0xEB,0xE8,0xA2,0x98,0x71,0xA3,0xAE,0xA3,0x4E,0xB4,0x37,0x95,0xB2,0x8E,0x32,0x91,0xD9,0x10,0xCE,0x3A,0xAA,0x28,0x7A,0x52,0x38,0xDD,0xA8,0x83,0xCA,0x6A,0xB4,0x64,0xA3,0xC9,0xC2,0x6A,0x50,0xEB,0xAC,0x36,0xCB,0x4D,0x33,0xDB,0xBC,0xFA,0xA4,0x37,0x34,0x7C,0xF5,0xEA,0xB3,0xDE,0xD0,0xF4,0xD5,0xAB,0xCB,0x7A,0x43,0xD3,0x5B,0x8F,0x36,0x86,0x35,0xCF,0x68,0x39,0xEA,0x58,0xCA,0xDC,0x72,0x51,0x2B,0x43,0xCE,0x0C,0x8D,0x45,0xA9,0x4C,0x31,0xDC,0x24,0x6A,0x9B,0x36,0xF1,0x4A,0x77,0xF8,0x8C,0xC0,0x29,0x4A,0x55,0xA8,0x06,0x80,0x02,0xA6,0x50,0x57,0xC0,0xF3,0x15,0x02,0xB8,0x31,0xF3,0xFF,0x01};
const uint8_t spCROCS[] PROGMEM = {0x0A,0x28,0x4A,0x5D,0x01,0xA5,0xB8,0xBB,0xA4,0x94,0xEA,0x72,0xB7,0x32,0x92,0xD8,0x24,0x5D,0x2D,0xCB,0xAA,0x52,0xAC,0x74,0x37,0x2F,0xAB,0x4A,0x7E,0x22,0x5D,0x36,0xAF,0x2A,0xFB,0xF1,0x74,0x59,0xB3,0xAB,0x55,0xE7,0x54,0x51,0x62,0x4B,0x5A,0x93,0x6C,0x46,0xAA,0xC4,0x41,0xE0,0x14,0xA5,0x2A,0x54,0x03,0x00,0x0C,0x10,0x8D,0xA8,0x02,0x9E,0x71,0x55,0xC0,0x4F,0x29,0x06,0xF8,0xAD,0xD4,0x02,0x0A,0xF8,0x2D,0x95,0x01,0xBF,0x94,0x31,0xE0,0xE7,0xB2,0xFF,0x07};
const uint8_t spAIRCRAFT[] PROGMEM = {0x61,0xEE,0xCA,0x44,0x3B,0x63,0xAD,0xB9,0x19,0x67,0xDD,0x6C,0xB5,0xBA,0x16,0x8B,0xA4,0x6D,0xF3,0x6A,0x5A,0x1A,0x92,0xE1,0x2D,0xA3,0x2A,0x79,0x50,0x96,0x36,0xB7,0x2A,0xFB,0x45,0x3D,0xDC,0x9D,0xBA,0x64,0x07,0xA2,0x39,0x31,0x02,0xA7,0x28,0x55,0xA1,0x1A,0x40,0x80,0x62,0x5E,0x05,0x90,0xDB,0xA8,0x02,0x72,0x6B,0x1F,0x59,0x9E,0x14,0xA9,0x96,0x69,0xD4,0xB9,0xB1,0x97,0xD9,0xE6,0xD5,0x17,0xDB,0x62,0x23,0x9B,0xD7,0x54,0xD5,0xA8,0xAE,0x6E,0x5E,0x73,0x57,0xA3,0x32,0xB2,0x79,0xAD,0x4D,0xAD,0xEA,0xE8,0xE6,0xB5,0x96,0x50,0x9C,0x61,0xAB,0x0C,0x50,0x4D,0xAA,0x01,0xBA,0x0E,0x65,0x40,0x37,0xA5,0x1C,0x40,0xE0,0x14,0xA5,0x2A,0x54,0x03,0xC0,0x00,0x43,0xBA,0x29,0x60,0x73,0x35,0x04,0x4E,0x51,0xAA,0x42,0x35,0xFE,0x1F};
const uint8_t spALTIMETER[] PROGMEM = {0x23,0xCF,0xBE,0x38,0x23,0x57,0xAF,0x2A,0xDB,0xF6,0x34,0x7B,0xBD,0xAA,0xE4,0xD6,0xC3,0x6C,0xF3,0x2A,0x93,0xBA,0x08,0xB3,0xDE,0xAB,0x4A,0xBA,0xA2,0x45,0xBB,0x84,0x2E,0x2B,0x4D,0x67,0x69,0x03,0x06,0x78,0x31,0x23,0x02,0x2B,0x5B,0xDA,0x44,0x92,0x3B,0xAD,0xB4,0xB9,0x34,0x31,0xED,0xBC,0xB2,0xE2,0xD2,0x2C,0x75,0xF5,0xC8,0x92,0xCD,0x6C,0x65,0x2B,0x23,0xCB,0x26,0x63,0x54,0xC2,0x9C,0x22,0x9B,0x8C,0x74,0x69,0x73,0xCA,0xA2,0xCB,0x3C,0x6C,0xD3,0xA9,0xAA,0x0E,0x4B,0xB1,0xD5,0xA9,0x0E,0x4A,0xB2,0x38,0x12,0x8D,0x66,0x86,0x0A,0x55,0x55,0xDA,0xFA,0x11,0x5A,0x44,0x55,0xE9,0x18,0x72,0x63,0x09,0xB3,0xAC,0x63,0x2C,0xC5,0x30,0x5A,0xBA,0x8C,0xA5,0x84,0x42,0x5D,0xC9,0xDA,0xD6,0x12,0x17,0x69,0xD5,0x5B,0xDB,0x4A,0x29,0xD4,0x95,0xAC,0x65,0x2F,0xA5,0x50,0x57,0xB2,0xFC,0x3F,0x61,0x0C,0x21,0x29,0x3D,0xDC,0xBA,0xD9,0x35,0xB5,0x30,0x97,0xEB,0x06,0xDF,0x39,0x2C,0x9C,0x6B,0xEB,0x42,0xD5,0xD0,0x74,0x76,0xAB,0x4E,0x21,0xD3,0x82,0xDB,0xAE,0x3A,0x9B,0x0D,0x0D,0xD9,0xBC,0xEA,0x1C,0xD3,0xCD,0x7D,0xF5,0xA8,0x8B,0xE5,0x72,0x4D,0x39,0xA5,0x29,0x9A,0x3A,0xC5,0x9C,0xB4,0x2E,0x1B,0x6D,0xA7,0x74,0x9C,0xA6,0xE8,0xBC,0x8A,0x24,0x5E,0x98,0xBD,0x89,0x1C,0xE1,0xA4,0x61,0x37,0x61,0xC3,0x03,0xB3,0xB4,0x3D,0xF8,0x0D,0x0B,0xCA,0x3B,0xF6,0xAC,0xDB,0xBC,0xA8,0xEF,0x3A,0xAA,0x6D,0xF1,0x92,0xCD,0xEB,0xAA,0xBA,0xC4,0xC6,0xB6,0xAC,0xAB,0xE9,0x14,0x6D,0x5F,0xDD,0xEE,0xA6,0x93,0x75,0x7C,0x73,0x7B,0x9A,0x75,0xF2,0x8E,0xD5,0xE5,0x6B,0x49,0xD9,0x23,0x67,0x87,0xBF,0x3B,0x43,0xAB,0x98,0xF5,0xFF};
const uint8_t spAUTOPILOT[] PROGMEM = {0x65,0x8F,0xB6,0xCB,0x5C,0x9D,0x8C,0x3D,0x9A,0x5D,0x55,0x6D,0xBB,0xA6,0x2C,0x66,0x5D,0xA5,0xEB,0x1A,0x92,0xBA,0x76,0xD5,0xDE,0xAB,0x2D,0x6A,0x32,0x45,0xF2,0xB6,0xA9,0x59,0xC9,0x70,0x52,0xB3,0x8A,0x1C,0xCB,0x9D,0x35,0xD5,0xAA,0xB2,0x1A,0x55,0x8F,0x4C,0xAB,0x2E,0x74,0xDC,0xC2,0x7C,0xAF,0x3A,0x93,0x4D,0x35,0xC9,0x53,0x5A,0x6F,0x36,0x4D,0xB8,0x13,0x02,0x9F,0x2A,0x55,0xA1,0x1A,0x20,0x80,0x2C,0xCA,0x5B,0x95,0x55,0x5A,0xA8,0xC5,0x5A,0x55,0xF2,0x93,0x69,0xB4,0x6A,0x75,0xD9,0x4D,0x86,0xF3,0x96,0xD5,0x55,0xB5,0x69,0xC5,0x5B,0x56,0x57,0xEC,0x9A,0x96,0xAE,0x5E,0x5D,0x71,0x63,0x1E,0xB6,0x79,0xB5,0x03,0x55,0x0B,0x67,0x9B,0xD5,0x74,0xDC,0xA5,0x9C,0x69,0x56,0x55,0x5C,0x69,0x72,0xAC,0x5C,0x65,0xB3,0x4B,0xC9,0xB1,0x64,0x15,0xD5,0x06,0x27,0xD5,0x62,0x36,0x48,0x1D,0x1E,0x99,0x2D,0xFF,0x1F};
const uint8_t spLOCALIZER[] PROGMEM = {0x2C,0x2B,0x40,0x3A,0x52,0x93,0x88,0xD5,0x91,0x9A,0x0C,0x49,0xAD,0xD6,0x80,0x63,0x32,0x38,0xB3,0x5B,0x12,0xD6,0xEE,0xE0,0xD4,0x69,0xEE,0x84,0xB2,0x9B,0xDC,0x8E,0xBA,0x50,0xDF,0x12,0x6A,0x77,0x8A,0xC2,0x62,0x53,0x38,0xDB,0x49,0x32,0xCB,0x0E,0xE5,0xAC,0x21,0x0A,0x62,0x5A,0x94,0x72,0x93,0xC4,0xCA,0x0E,0x17,0x51,0x03,0x0C,0x48,0xFA,0xA5,0x85,0x49,0x77,0x98,0x69,0xCB,0x91,0x25,0x95,0xE3,0x4E,0x59,0x4B,0xE5,0xCD,0x56,0x12,0xA7,0x29,0x75,0x46,0x3B,0x6C,0xDC,0x69,0xB5,0x49,0x4D,0xBB,0xE8,0xE6,0xD5,0x17,0x31,0x15,0xAA,0x5B,0xD6,0x58,0xC5,0x94,0xA7,0x6D,0x59,0x53,0x53,0x13,0x5A,0xFA,0x79,0xCD,0x5D,0x8F,0x49,0xDB,0xAB,0x31,0x57,0x6F,0x52,0x99,0x97,0x04,0xB0,0x20,0xB1,0x07,0x0C,0xF0,0xB3,0xEB,0xDA,0x9B,0x0F,0xE1,0xD0,0x36,0xED,0x2A,0x39,0x49,0x5A,0xF2,0xB5,0xA7,0x2C,0xE5,0x48,0xE9,0x5B,0xDE,0x32,0x84,0x72,0xB8,0x73,0xFA,0x52,0x72,0xF4,0xF3,0x34,0xE9,0x2B,0x43,0x29,0x5B,0xBB,0x84,0xBF,0x2C,0x96,0x4A,0x5D,0xFD,0xFF};
const uint8_t spCOWL[] PROGMEM = {0x06,0x68,0x61,0xC4,0x01,0x45,0x27,0x39,0xA0,0xB6,0xE2,0x91,0x97,0x94,0x62,0x69,0x89,0x57,0x9E,0x73,0x79,0xB9,0x2E,0x5E,0x65,0xB6,0x1B,0x96,0xBC,0x65,0x94,0xC9,0x6D,0x44,0xC8,0x96,0x51,0x46,0x7F,0x61,0xAE,0x9B,0x47,0x15,0xED,0x65,0x98,0x6C,0x69,0x75,0xD4,0x5F,0xEE,0xDC,0xA5,0xD5,0xC1,0x7E,0xA9,0xCA,0x96,0x56,0x07,0xFF,0x69,0xA2,0xAB,0x4B,0xE9,0xE3,0x95,0x91,0xAD,0x4E,0xB9,0x8B,0x3B,0x42,0xD1,0x26,0x64,0x36,0xEE,0x08,0x66,0xAA,0x98,0x85,0x3C,0xC8,0x8F,0x00,0x6F,0xF2,0xFF};
const uint8_t spINFLIGHT[] PROGMEM = {0x6D,0xE8,0x5A,0x28,0xAA,0x2B,0xAF,0xB6,0x39,0x21,0xEF,0x9A,0xBD,0x9A,0xEE,0x8D,0x2C,0x6B,0xF6,0x2A,0x6B,0x14,0xB5,0x98,0x3A,0x25,0xAB,0x1A,0x3A,0x2C,0x12,0xB7,0xB4,0x28,0x6A,0xB7,0x48,0x3C,0xD2,0x2A,0xA9,0xC2,0xDD,0x75,0x49,0xAA,0xC4,0x0E,0x77,0x4F,0x21,0x4D,0x82,0xA6,0xD4,0x35,0x9B,0xBC,0xB0,0xD0,0x52,0x93,0x45,0x80,0x61,0x2B,0x08,0x30,0x7D,0x85,0x00,0xA6,0x4B,0x57,0x40,0xB3,0x65,0x0A,0x18,0x86,0xB4,0xB4,0x41,0x55,0x85,0xF0,0x92,0xD1,0x16,0xBA,0x63,0x4E,0x6B,0x56,0x5F,0xE9,0xB5,0xBA,0xAE,0x5E,0x7D,0x51,0x17,0x9E,0xBE,0x68,0x75,0xD5,0x8E,0x44,0xF8,0xAA,0x55,0x37,0xEF,0xDC,0x5E,0xB3,0x57,0xDB,0xBC,0xF0,0xF8,0xD6,0x6E,0x6D,0x33,0xCC,0xED,0x13,0x1B,0x81,0x53,0x94,0xAA,0x50,0x0D,0x00,0x05,0x0C,0xE9,0xC6,0x80,0xCD,0xD5,0x10,0x38,0x45,0xA9,0x0A,0xD5,0xF8,0x7F};
const uint8_t spOVERSPEED[] PROGMEM = {0xA9,0x0B,0x7A,0x87,0x59,0xB7,0x94,0x3A,0x8A,0x59,0x11,0xDE,0x5A,0xAA,0xC8,0x6B,0x4D,0xA9,0x4B,0x2B,0x22,0xEF,0x51,0xA3,0x2E,0x2D,0x8F,0xBC,0xCB,0x1D,0x53,0x9B,0x3A,0xA2,0xF4,0xB4,0x90,0x1D,0x9A,0x69,0x5C,0x94,0x5C,0x75,0x2B,0xA3,0x4D,0x77,0x77,0xBB,0xAD,0x88,0xD1,0xB8,0x92,0xB6,0x94,0x32,0x25,0xC3,0x1C,0xEA,0x53,0xCA,0xDC,0x1C,0x6C,0xA8,0x4F,0x29,0xCB,0x24,0xCA,0x90,0x3E,0xAD,0x9C,0xA6,0x84,0xCC,0x9C,0x06,0xE0,0x47,0x55,0x07,0xFC,0xE2,0x62,0x80,0x3F,0x4B,0x0C,0xF0,0xBD,0x32,0x02,0xA7,0x28,0x55,0xA1,0x1A,0x20,0x80,0xE2,0xC2,0x5B,0xD9,0x1C,0xB3,0x96,0xAD,0x1E,0x55,0x8F,0x42,0xDC,0xFE,0xB8,0xD5,0xC3,0x0B,0xF2,0xE6,0xE3,0x56,0x8F,0x28,0x28,0x9B,0xB3,0x4A,0x33,0xA2,0x80,0x6C,0xCD,0x2A,0xCD,0x0C,0x02,0x72,0x39,0xAB,0x34,0xD3,0x29,0xF0,0xD6,0xA4,0xD2,0x74,0xAE,0xA4,0xED,0x0B,0x45,0xCB,0x74,0x55,0x8B,0x44,0x66,0xBD,0x50,0x95,0xAD,0x6C,0xA9,0x4C,0xDD,0x88,0x72,0x64,0xE7,0xFF,0x07};
//const uint8_t spDEPARTURE[] PROGMEM = {0x0A,0x28,0x30,0xAC,0x65,0x5D,0xBA,0x8A,0xD9,0xE6,0x51,0x55,0x65,0x2A,0x6E,0xAB,0x43,0x9D,0x8C,0x99,0x86,0xCC,0x42,0xE0,0x14,0xA5,0x2A,0x54,0x03,0x40,0x00,0x55,0xA4,0x31,0x20,0x99,0xB6,0x52,0xC4,0xD2,0x52,0x89,0x69,0x46,0x15,0xCB,0xB2,0x0F,0x6C,0x19,0x75,0x4A,0xC3,0xB1,0xB8,0x67,0xB4,0xC5,0xAD,0xF0,0x51,0x9F,0xD1,0x95,0x50,0x64,0x2B,0x7D,0xD3,0x90,0x0B,0x6B,0x87,0xBB,0x02,0x05,0x0C,0xAB,0x92,0x80,0x9D,0x3A,0x13,0x30,0xD3,0x86,0x03,0x8A,0x16,0x29,0x4D,0x69,0x42,0xD1,0xD2,0xBB,0xAD,0xA5,0x07,0xC9,0x50,0xDF,0x74,0x95,0x56,0x44,0x47,0xF9,0xCA,0x53,0xB6,0x51,0x14,0xE5,0x75,0x7F,0x9E,0x4A,0xD1,0x92,0x27,0xFC,0x79,0x19,0x5A,0x4B,0xDE,0xF0,0xE7,0xAE,0x58,0xE3,0x9E,0xCD,0x5F,0x9E,0x6A,0x29,0x67,0x51,0x7F,0xED,0x25,0xEE,0x2A,0xE7,0xFF,0x01};
const uint8_t spLAUNCH[] PROGMEM = {0x6E,0x2E,0xD0,0xA3,0x8A,0x32,0xA7,0x25,0xC3,0xAC,0x4E,0xCA,0xB4,0xE6,0x4C,0xAA,0xDB,0x28,0xED,0x1A,0xA2,0xBA,0x71,0xD1,0xB6,0xAB,0x4F,0x72,0x3B,0xD4,0xD2,0xAE,0x26,0xBA,0xA9,0x30,0xEB,0xBC,0xAA,0x58,0xCB,0x5D,0x63,0xD5,0xC8,0x92,0x2F,0x4B,0x8D,0x44,0x29,0x4B,0x4A,0xA3,0xA8,0x1C,0xB9,0x2C,0x2A,0xC9,0x90,0x8A,0x85,0xC0,0x29,0x4A,0x55,0xA8,0x06,0x28,0x60,0xB6,0x4E,0x07,0xCC,0x3E,0x13,0x80,0xD5,0xA7,0x02,0x30,0xDB,0x8C,0x03,0x66,0x9F,0x72,0xC0,0x6C,0x9D,0x0A,0x98,0x7D,0x4B,0x00,0xA3,0x4D,0xFD,0x3F};
const uint8_t spTOWER[] PROGMEM = {0x06,0x78,0x4A,0x2D,0x00,0x53,0x99,0xB5,0x2A,0xDB,0x62,0x8B,0x4C,0x34,0xAA,0x12,0xCB,0xC2,0x6C,0xF1,0x18,0x8A,0x9E,0xB0,0x94,0xCD,0x6B,0x2A,0x72,0x4A,0x8B,0xBA,0xAC,0x39,0xCB,0x6D,0x29,0xEE,0xD2,0xD6,0x68,0xAE,0xA5,0xA9,0x4B,0xD9,0x83,0xBB,0xD4,0xC1,0x2E,0x6D,0x8F,0xE1,0xCC,0x16,0xB3,0x94,0x23,0xD9,0x53,0x39,0xEC,0x53,0xCE,0x5C,0x06,0xFD,0x30,0x4B,0xB9,0x72,0x5D,0xB4,0xC3,0xDE,0xE9,0xCE,0x65,0xC1,0x8E,0xFB,0x86,0xBB,0xAC,0xC0,0x0A,0x69,0x1B,0x9E,0xD2,0x12,0xAA,0xB5,0x53,0x78,0xF3,0x33,0x6E,0xB1,0x4C,0xFF,0x0F};
const uint8_t spFLIGHTWATCH[] PROGMEM = {0x02,0x18,0x2E,0xDD,0x00,0xDD,0x74,0x18,0x60,0x86,0x72,0x03,0x8C,0x90,0x92,0xA2,0x2A,0xB8,0x7A,0x4C,0xEE,0xCA,0x92,0xD8,0x36,0x93,0x24,0x2B,0xCF,0xE2,0xD2,0x4C,0x57,0xAF,0x2C,0x87,0xB1,0x94,0x58,0xBC,0xB2,0x1A,0x52,0x4A,0x73,0xCE,0xCA,0x5B,0x48,0x2C,0xCF,0x45,0xA3,0x6A,0x59,0x30,0xAD,0x1B,0x23,0x70,0x8A,0x52,0x15,0xAA,0x01,0x08,0x28,0xDE,0x54,0xAC,0x5A,0x77,0x84,0x86,0x22,0xB5,0x09,0xBB,0x91,0xAA,0x4A,0xD5,0x26,0xF2,0xB9,0xBA,0xB8,0x0D,0x8B,0xC9,0x17,0x16,0xE4,0x77,0x2C,0xC1,0x6D,0x6A,0xB1,0xBF,0x35,0x27,0x7D,0x2D,0xC9,0x79,0xD6,0x5A,0xC4,0x8E,0x24,0xF7,0x1D,0x5B,0x65,0x3B,0x9C,0xD2,0x67,0xEC,0x45,0x6F,0x5A,0xF1,0xE6,0x74,0xA7,0xD0,0x96,0x69,0x2B,0x11,0x38,0x45,0xA9,0x0A,0xD5,0x00,0x00,0x05,0xAC,0x12,0x1E,0x80,0x55,0x3A,0x02,0xB0,0xCA,0x76,0x00,0x66,0xDE,0x74,0xC0,0xE8,0x9B,0x0A,0x18,0x75,0x8A,0x00,0xAD,0xA6,0xFE,0x3F};
const uint8_t spSTALL[] PROGMEM = {0x0C,0x78,0xC6,0x95,0x01,0x3F,0xA5,0x28,0xE0,0xB7,0x52,0x0B,0x04,0xE0,0xB7,0x54,0x04,0x4E,0x51,0xAA,0x42,0x35,0x40,0x01,0x43,0xBA,0x31,0x60,0x73,0xB5,0x95,0x35,0x91,0x4E,0x29,0x5B,0x57,0x9D,0x64,0x85,0xA5,0x6C,0x59,0x6D,0x92,0x5D,0x9E,0xD4,0x75,0xF5,0xD1,0x4C,0x45,0x50,0xDF,0x35,0x44,0x3B,0x95,0x46,0x7D,0xC7,0x1A,0xDC,0x54,0x28,0xF7,0x1D,0x5B,0xB4,0x53,0xA9,0xDC,0xA5,0xED,0xC1,0x4F,0x35,0xCB,0x9E,0x76,0x44,0xBB,0x95,0x22,0x7D,0xDA,0x19,0xDD,0x54,0xB3,0xF4,0x29,0x57,0x70,0x53,0x25,0xDA,0x39,0xDD,0x21,0x5C,0x26,0x69,0xE7,0xF4,0x04,0x7B,0x55,0x22,0x59,0xC2,0x13,0x7C,0x4D,0x92,0xE6,0x75,0xAF,0xAE,0xDD,0xC2,0x91,0x59,0x7E,0xFF,0x0F};
const uint8_t spTOUCHDOWN[] PROGMEM = {0x02,0x78,0x4A,0xCD,0x00,0x53,0x99,0xB5,0x64,0xE8,0x10,0x57,0x59,0xB9,0xB2,0x92,0x52,0x5D,0x6D,0xCD,0x2A,0x4A,0x2C,0x89,0xF0,0xD5,0xAB,0x28,0x21,0x39,0x3D,0x56,0x33,0xC0,0x7A,0x76,0x04,0x74,0x4E,0x66,0x80,0x9B,0x33,0x02,0x70,0x4B,0x4D,0x00,0x6E,0xAE,0x36,0xC0,0xCD,0x53,0x08,0x28,0x30,0x4C,0x03,0xAB,0x6E,0x2A,0x54,0x4B,0x57,0xAF,0xAE,0x98,0x30,0x6F,0x5B,0xB2,0xBA,0xE2,0x5B,0xB5,0x75,0xF5,0x58,0x8B,0x1F,0x93,0xD6,0x55,0x63,0xAB,0x7A,0x83,0x46,0xD6,0x8C,0xB3,0xD8,0x35,0x6E,0x59,0xD2,0xCE,0xA2,0xD7,0x69,0x74,0x4D,0x79,0x92,0x1F,0xF3,0xD2,0x39,0xE1,0x8D,0x7E,0xCC,0x5A,0xE7,0xB8,0x3F,0x8C,0xD0,0xC8,0x98,0xE2,0x7E,0xD7,0xDA,0xC3,0x23,0x96,0xF9,0x7D,0x6C,0x0B,0x8B,0x5A,0xE6,0xCF,0x46,0xAC,0x3C,0x1D,0xBB,0xBF,0x3A,0xD5,0xD4,0xB0,0xFD,0xFF};
const uint8_t spSQUALK[] PROGMEM = {0x0C,0x78,0xC6,0x95,0x01,0x3F,0xA5,0x28,0xE0,0xB7,0x52,0x0B,0x04,0xE0,0xB7,0x54,0x04,0x4E,0x51,0xAA,0x42,0x35,0x00,0x10,0xE0,0xC3,0x4B,0xCA,0xBC,0x3B,0x72,0x73,0x4F,0xAB,0x0E,0x6E,0xC2,0x82,0xB2,0xAD,0x2A,0x9A,0x69,0x0F,0xF6,0xB6,0x8A,0xE0,0xB6,0xD2,0x39,0xCB,0xC8,0x42,0xDA,0x70,0xB5,0x9E,0x23,0x8D,0x75,0xDC,0x54,0x3B,0xBA,0x2C,0xB5,0x65,0x15,0x76,0x8D,0xC0,0xA2,0x4A,0x55,0xA8,0x06,0x80,0x02,0x7A,0x73,0x65,0x40,0xF3,0x22,0x0C,0x68,0xC5,0x18,0x01,0x35,0xB2,0xFC,0x3F};
const uint8_t spELEVATION[] PROGMEM = {0x23,0x69,0xC1,0x25,0xAD,0x6A,0xAF,0xAA,0xCA,0x51,0x4F,0xDB,0xBC,0xAA,0x42,0xAE,0x22,0x64,0x75,0x2B,0x0B,0xBC,0x11,0xD5,0xB6,0xA3,0x28,0xE8,0x5A,0x4D,0x63,0xAF,0x22,0xF3,0x2D,0x17,0xED,0xBC,0xCA,0xCC,0xBB,0xDC,0x34,0xF3,0xA8,0xB2,0x4E,0xF7,0x90,0x44,0xA1,0xCD,0x3A,0xDD,0x9D,0x12,0x85,0xBE,0x8A,0x52,0x0D,0x72,0xB2,0xFA,0x1A,0x42,0xCD,0x74,0xF5,0xAA,0xBA,0x6B,0x15,0x97,0xCD,0xAB,0x9E,0xBA,0x15,0x53,0xB7,0xAC,0x7A,0x9A,0x62,0x2C,0xDF,0xBC,0xBA,0xEE,0x02,0xA5,0x62,0xF3,0xE8,0x67,0x1C,0x45,0xD1,0x2C,0x09,0x98,0x79,0x2B,0x01,0x27,0x75,0x27,0x60,0x96,0xED,0x04,0x8C,0xD8,0x36,0xEA,0x16,0x44,0xCC,0x7D,0xD5,0x9A,0xBA,0x4B,0xE1,0xD0,0xBD,0x63,0x9F,0x2A,0x9D,0x43,0xFB,0xB5,0x63,0xA9,0x36,0x71,0xEC,0x57,0xCE,0xA6,0x45,0xCA,0x35,0x5E,0xB9,0xBA,0x52,0x49,0xD7,0x68,0xE5,0xEE,0x56,0x35,0xD4,0x9D,0x96,0xA7,0x19,0x09,0x37,0x73,0x12,0x9E,0x6C,0x5B,0xCC,0xB2,0x76,0x78,0x8B,0xB1,0x30,0xCD,0x3A,0xFF,0x0F};
const uint8_t spCLIMB[] PROGMEM = {0x06,0xC8,0x39,0x29,0x00,0x8D,0x45,0x06,0x60,0xF2,0xC8,0x96,0x35,0x50,0x39,0x41,0x6E,0x46,0x56,0xD8,0x8C,0x19,0xAF,0x19,0x45,0xA5,0xB3,0x1A,0xB2,0x66,0x55,0x45,0x5C,0x49,0xDA,0x9A,0x55,0x17,0xB5,0x25,0x65,0x6B,0x56,0x5D,0xF4,0x25,0xB7,0xB5,0x5E,0x75,0x35,0x17,0xDC,0xD6,0x66,0x35,0x4D,0xAF,0x4B,0x69,0xEB,0xD5,0x34,0xDF,0xAA,0x69,0xAB,0x57,0x55,0x9C,0x69,0x74,0x2C,0x1A,0x65,0x33,0xA2,0xA5,0x9E,0xBA,0x14,0xCD,0x88,0x16,0x47,0x92,0x52,0x54,0x2D,0x5A,0x1C,0x49,0x4A,0x5E,0x35,0x47,0x52,0xB8,0xAE,0x79,0xCA,0x72,0x0E,0x17,0x89,0x86,0x29,0x4B,0xC9,0xD4,0xBC,0x43,0xFE,0x3F};
const uint8_t spBANK[] PROGMEM = {0xA9,0x1A,0xCA,0xCD,0xDD,0x92,0xAE,0xAC,0xD8,0x16,0x69,0x79,0xBD,0xEA,0x62,0x4A,0x7C,0xF4,0xF5,0xAA,0xAA,0x2B,0xB1,0xB6,0xC7,0xAB,0xAA,0x2E,0xC5,0xDB,0x66,0xAF,0xBA,0xF9,0x14,0x6F,0x5B,0xBC,0x86,0xEE,0x92,0xBD,0x7D,0xD1,0x1A,0xBB,0x2B,0xB6,0xF1,0x45,0x6B,0x1B,0x3A,0xD9,0x36,0x56,0xED,0xAD,0x1D,0xD3,0x36,0xF1,0xFA,0xC2,0x7E,0x98,0x33,0x08,0xC9,0x31,0xAD,0x6C,0x4F,0x04,0x16,0x55,0xAA,0x42,0x35,0x00,0x14,0xD0,0x9B,0x2B,0x03,0x9A,0x17,0x61,0x40,0x2B,0xC6,0x08,0xA8,0x91,0xE5,0xFF,0x01};
const uint8_t spACCELERATED[] PROGMEM = {0x6D,0xAA,0xA6,0xD5,0x3B,0x1E,0xB7,0xB1,0xD9,0x56,0x6B,0x7F,0xB3,0x86,0xE6,0x47,0xBC,0xFC,0xF5,0x18,0x6A,0x4F,0x2A,0x89,0xD9,0x08,0x9C,0xA2,0x54,0x85,0x6A,0x00,0x10,0x20,0x2A,0xF7,0x00,0x7C,0xD5,0x15,0x80,0xEF,0x3D,0x1D,0xF0,0x43,0x44,0x00,0xFE,0x88,0x58,0xF9,0xA0,0xA9,0xEA,0x9E,0x69,0xE5,0xD5,0xB4,0x9A,0xDB,0xEB,0x55,0x64,0xD7,0xE6,0xAE,0x8F,0x57,0x91,0xCC,0xB9,0x9B,0xAC,0x6E,0x79,0xB0,0x13,0xC3,0xD2,0xAC,0x14,0x21,0xEB,0xA8,0xB4,0xB6,0x52,0xF8,0x2E,0x59,0x5C,0xEA,0x52,0x19,0x1A,0x57,0xB8,0x6B,0x69,0x55,0x2C,0x5C,0x16,0xE6,0x67,0x55,0x39,0xBA,0x59,0x58,0xDE,0x55,0x35,0x53,0x6C,0xA9,0x9B,0x57,0xD5,0x6C,0x92,0x87,0x6F,0x1E,0x75,0x8B,0xCE,0x4E,0xB1,0x38,0x0D,0xDB,0x95,0x29,0xA9,0xE2,0x55,0x77,0x9D,0x64,0x1A,0x8B,0x57,0xDD,0x54,0xB0,0x45,0x2C,0x5E,0x4D,0xD3,0x49,0x92,0xF1,0xB8,0xB5,0x4D,0x27,0x8B,0xEA,0x63,0x37,0x34,0x66,0x64,0x2E,0xAB,0xFF,0x1F};
const uint8_t spTRIM[] PROGMEM = {0x0E,0x68,0xCE,0xD4,0x01,0x57,0x9A,0x06,0x60,0x2A,0xB3,0x56,0xE6,0xA2,0x66,0x66,0x4E,0x57,0x95,0x9B,0x9A,0xA5,0x34,0x5F,0x55,0x49,0x26,0x56,0xD2,0x7D,0x55,0xCD,0x07,0x6B,0x4B,0x9B,0x55,0x57,0xEB,0x1A,0xA9,0x73,0x46,0x53,0x85,0x4B,0xB8,0xC4,0x6D,0x5D,0x93,0x2E,0xE9,0x1C,0xB7,0xF5,0x55,0xB8,0xA5,0x71,0xDC,0xD6,0x35,0xE1,0x5A,0x4E,0x71,0x4B,0x9B,0x69,0x68,0x3B,0x35,0x2D,0x7D,0x50,0xE1,0x45,0xE2,0xE6,0xFF,0x01};
const uint8_t spUNICOM[] PROGMEM = {0x6A,0xA8,0x40,0xBD,0x2E,0x4D,0xBA,0xB6,0x22,0xB1,0x9C,0xA8,0xDD,0xCA,0xEE,0x84,0xB8,0x63,0xD5,0x2A,0xBA,0x55,0x91,0x94,0x37,0xA3,0x68,0x46,0xCC,0x83,0x9E,0x94,0xB2,0x2A,0xEC,0x34,0x49,0x5A,0xEA,0xAA,0xB0,0xD2,0x25,0xDE,0xEA,0xAA,0x49,0x17,0x93,0x35,0xAB,0xAF,0xD2,0xD5,0x53,0x1F,0x95,0xB5,0x4B,0x67,0x2B,0xFE,0x82,0xC0,0x29,0x4A,0x55,0xA8,0x06,0x80,0x01,0x72,0x50,0x51,0x40,0xC9,0x8A,0xA3,0x4B,0xC5,0x2D,0x8A,0x5B,0xAD,0x36,0xC7,0x76,0x2F,0xDE,0xB2,0xE6,0xA2,0xA6,0x64,0xA4,0xCD,0x5A,0x8A,0x9C,0x96,0x96,0x36,0x6B,0x6B,0x7C,0x86,0x5B,0xBA,0x8E,0xBB,0xB1,0x19,0x69,0x69,0xDB,0xEE,0xCA,0x77,0xB8,0xB4,0x6B,0xF9,0xB3,0xBE,0xA2,0xD6,0x35,0xE5,0x8F,0x69,0xC2,0x42,0xE6,0x94,0x3F,0xEB,0xF2,0x12,0xB4,0x5A,0xBE,0x22,0xCA,0x4B,0xD1,0x6C,0xF9,0x8A,0x8B,0x2C,0x35,0x29,0xE5,0x6B,0xDA,0xBD,0x4C,0xCC,0x84,0x2F,0xBA,0x8A,0x34,0xAB,0xFB,0xFF};
const uint8_t spSLOKE[] PROGMEM = {0x02,0xF8,0x56,0xC4,0x00,0x3F,0xBA,0x28,0xE0,0x07,0x0B,0x03,0xFC,0x60,0x66,0x80,0x5F,0xD4,0x0C,0xF0,0x4B,0xA8,0x02,0x7E,0x31,0x29,0xFD,0x10,0xEA,0x96,0xEC,0xAE,0xF5,0x95,0x7A,0xA6,0xC3,0xD6,0xD5,0x17,0x61,0x55,0x4C,0xAD,0x57,0x5B,0x58,0x76,0x29,0xF6,0x5D,0x55,0x61,0x31,0xA1,0xD4,0x77,0x15,0x89,0xF7,0x98,0x4A,0x9F,0x92,0x79,0xB5,0xA5,0x6C,0xBD,0x11,0x38,0x45,0xA9,0x0A,0xD5,0x00,0x10,0x40,0x32,0x26,0x02,0x48,0x41,0x85,0x00,0xCE,0x2B,0xFE,0x3F};
const uint8_t spNINER[] PROGMEM = {0x66,0xAA,0x1A,0xB5,0xDC,0x9A,0x84,0x35,0x4B,0xCA,0xD4,0x68,0x1C,0xD6,0x24,0x29,0x53,0xA3,0x4E,0x59,0xAA,0x22,0x2F,0xB3,0xBA,0x6D,0x6A,0x9A,0xAC,0x4D,0xE3,0xAE,0xB1,0xB8,0x36,0x33,0x7B,0xBC,0xDA,0x6A,0xC7,0x2D,0x64,0xF5,0xAA,0x9B,0xD9,0x90,0x94,0x2D,0xAB,0xEA,0xAA,0x4D,0x47,0x57,0xAF,0xA2,0xB9,0xA4,0x18,0x5F,0xB4,0xCA,0xE6,0x9D,0xAA,0x63,0x52,0x6B,0xAA,0xC5,0x72,0x0B,0xC7,0x63,0x68,0x85,0x9D,0x33,0x13,0x8D,0xA5,0x66,0xC7,0x2C,0xDD,0xD4,0xD6,0x66,0x4F,0xF0,0x38,0x6F,0xDB,0x6B,0x5C,0xE2,0xA5,0xBC,0xE1,0x2C,0xF1,0x88,0x8E,0xFA,0xA6,0xAF,0xD9,0x67,0x3C,0xCE,0x5B,0xFE,0x1A,0x17,0x7C,0x35,0xB7,0xFB,0xCB,0x36,0x5A,0x97,0x59,0xF0,0xFF};
const uint8_t spGALLEY[] PROGMEM = {0x04,0x68,0x41,0x7D,0xB4,0x3D,0x18,0x49,0xFA,0xEA,0x55,0xB5,0x28,0xEC,0x1D,0x4F,0x56,0x5D,0x7D,0x70,0xB4,0x3F,0x59,0x75,0xF5,0x25,0x95,0xF6,0x78,0x55,0xC5,0xAE,0x95,0xDB,0xAD,0x51,0xC6,0x38,0xD6,0x58,0x53,0x4A,0x11,0xF9,0xBB,0x05,0x2D,0x5A,0x65,0x2C,0xA9,0x29,0x33,0x67,0x35,0x45,0x35,0x8D,0xE5,0xED,0xD5,0x0D,0x5D,0x10,0xE1,0x8F,0xD6,0xD0,0x8D,0x83,0x57,0x3E,0x6A,0x63,0xB3,0x82,0x59,0xF9,0xC8,0x65,0xCD,0x10,0xA5,0x7B,0xCB,0xFF,0x07};
const uint8_t spFREEDOM[] PROGMEM = {0x04,0x18,0xB6,0x82,0x00,0xD3,0x57,0x08,0x60,0xBA,0x74,0x05,0x34,0x5B,0xD6,0xB2,0x54,0xA8,0x29,0x2D,0xFD,0xCA,0x6A,0x62,0x75,0xD7,0xA5,0x2B,0xEF,0xD5,0x48,0xDC,0x37,0xAF,0x7C,0x44,0x43,0x8E,0x58,0xDD,0xCA,0x9E,0x04,0xC5,0xED,0xF1,0x18,0xB6,0x4D,0x53,0x56,0x3B,0x63,0xEA,0xD6,0x85,0x43,0x57,0xAF,0xB1,0x28,0x13,0xAF,0x78,0x3D,0xE6,0x6C,0xD5,0xD2,0x7D,0x73,0x39,0x72,0x70,0x0F,0xD7,0x57,0xE5,0x4A,0x26,0x3D,0x55,0x9B,0x96,0x27,0xEB,0xD0,0x24,0xB1,0x53,0x9E,0xAA,0xCD,0x82,0xCD,0x4E,0x79,0x8A,0x31,0x0F,0x32,0x39,0xE9,0x49,0x26,0x34,0xC5,0xE2,0xA4,0xA7,0x44,0x4F,0x57,0x6B,0x92,0xDE,0x12,0xD4,0x5C,0x3D,0xF2,0xFF,0x03};
const uint8_t spFLIGHT[] PROGMEM = {0x02,0x28,0xC6,0x55,0x00,0xDD,0xA4,0x2B,0x60,0xB8,0x32,0x05,0x0C,0x13,0x5C,0x86,0xA2,0x39,0x3A,0x55,0x6E,0xE8,0xA3,0xD0,0x33,0x96,0xB6,0xAB,0xAF,0x64,0xC6,0x8D,0xD6,0xAC,0x36,0xEB,0x0D,0xF7,0xB8,0xBD,0xEA,0x6A,0x5A,0x22,0x63,0xF6,0xAA,0x5A,0x30,0x2E,0x9F,0xD9,0xA3,0x6C,0x8E,0xB9,0xA3,0x23,0xBB,0x3E,0x08,0xD5,0x8D,0x8A,0x6C,0xEE,0x61,0x93,0xA9,0x62,0x8B,0xBD,0x11,0x38,0x45,0xA9,0x0A,0xD5,0x00,0x30,0xC0,0x53,0x66,0x06,0x78,0xBE,0xE2,0xFF,0x01};
//const uint8_t spDEGREE[] PROGMEM = {0x0C,0x28,0x30,0x2C,0x45,0x43,0x9A,0x72,0xD8,0xEB,0x9D,0xAD,0xBA,0x0B,0x67,0x6E,0x7F,0x3D,0x9A,0xA1,0x1D,0xB9,0xF5,0x0B,0x02,0xA7,0x28,0x55,0xA1,0x1A,0x10,0xD6,0x5C,0x3A,0x35,0x2C,0x66,0x1A,0xA2,0x75,0x73,0x33,0xA7,0xA9,0x0F,0x51,0xD2,0x54,0xDD,0xB6,0x3A,0x27,0x6A,0x4A,0xCB,0xB6,0xCA,0x92,0xC8,0x2C,0x6C,0xED,0x2A,0x7B,0x54,0xD4,0xF2,0xD7,0xA3,0x1A,0xDE,0x50,0x26,0x1E,0xB7,0x7A,0x04,0x05,0x99,0x7C,0xDC,0xEA,0x19,0x0D,0xA8,0xEB,0x76,0xAB,0x66,0x30,0xA0,0xAA,0x59,0xAD,0x1A,0x41,0x40,0xAA,0x67,0xA5,0xAA,0x79,0x14,0xAB,0x9E,0xFD,0xFF};
const uint8_t spAIRPORT[] PROGMEM = {0x63,0xEC,0xC1,0xB0,0x2A,0x1E,0x9D,0xA6,0xA7,0x46,0x29,0x5D,0x7D,0xEA,0xBA,0x02,0x4B,0x75,0xD5,0xA8,0xCB,0x13,0x5A,0xB2,0x55,0xAD,0xCA,0x4B,0x70,0x9D,0x37,0xA5,0x2A,0xB4,0xC0,0x4D,0xEC,0x82,0xC0,0x29,0x4A,0x55,0xA8,0x06,0x00,0x03,0x82,0x77,0xE7,0x00,0x02,0x68,0x19,0x2E,0xBD,0x77,0x17,0x12,0x9C,0xB9,0xCD,0x41,0x5D,0xB3,0x9B,0xDE,0xB6,0x44,0x7D,0x29,0x25,0xFA,0xCA,0x1E,0xC2,0xA8,0x0F,0xFB,0x6B,0x77,0x0A,0x43,0xBE,0xE2,0xA7,0x5C,0xA5,0x0C,0x78,0x8B,0x7E,0x04,0x4E,0x51,0xAA,0x42,0x35,0x00,0x40,0x01,0x53,0xA8,0x2B,0xE0,0xF9,0x8A,0xFF,0x07};
const uint8_t spAIRSPEED[] PROGMEM = {0x2A,0xEB,0x29,0x59,0xD3,0x9A,0xAC,0xBD,0x87,0x24,0x69,0x5F,0xBC,0xC6,0xE1,0x86,0xA1,0x6D,0xF3,0x1A,0xBA,0x3F,0xC1,0xE1,0x3E,0xAB,0x69,0xF6,0x05,0x96,0xFB,0xAC,0xAA,0xBA,0x23,0x3C,0xF1,0x33,0xCA,0xDA,0x02,0x86,0xA2,0x73,0xAB,0x96,0x9E,0x14,0x52,0xB5,0x0E,0xF8,0x49,0xD8,0x01,0xBF,0x5A,0x1A,0xE0,0xAF,0x70,0x01,0x24,0xA0,0x81,0x00,0x8F,0x55,0x08,0x10,0xB9,0xD5,0xC8,0x5A,0x52,0x61,0xD7,0xD7,0xAB,0x9C,0x31,0x18,0xD3,0xB6,0xAE,0x6A,0xC6,0x40,0xE8,0x5C,0x32,0xAA,0x99,0x02,0xA1,0x6B,0x76,0xAB,0x66,0x34,0xA0,0xA9,0x59,0xAD,0x9A,0x49,0x41,0xA6,0x26,0xB5,0x62,0x46,0x01,0xE9,0x9A,0xD5,0x8A,0xAE,0x19,0x3D,0x73,0x31,0x2B,0x99,0xDE,0x4C,0x37,0xCB,0xAE,0x1E,0x46,0x94,0xCC,0xD2,0x94,0xA1,0x6A,0x55,0xB5,0x5C,0xF5,0xFF};
const uint8_t spCLEARANCE[] PROGMEM = {0x0E,0xC8,0x21,0x3D,0x00,0x53,0x99,0xA5,0xEC,0x45,0xB7,0x08,0x89,0x32,0x8A,0x4C,0xA3,0x4D,0xB4,0xED,0x29,0xAA,0x77,0x37,0xB1,0x35,0x27,0x6F,0x31,0x4C,0x5C,0xB6,0x9C,0xBC,0x99,0x56,0x6C,0xED,0xB2,0xCA,0x1C,0x5D,0xAD,0xA4,0x5D,0xAB,0x63,0x91,0x8A,0x74,0xF7,0xAD,0x8B,0x45,0x23,0x32,0xD4,0x8F,0x35,0x65,0xC9,0x88,0xF0,0xB6,0xD6,0xEC,0x43,0x33,0x6C,0x73,0xDB,0x8B,0x4E,0xCD,0xF0,0x5D,0x69,0xAF,0x4A,0x74,0xD4,0x12,0xA9,0xA3,0x58,0x35,0x65,0x5F,0x88,0x80,0x42,0xC2,0x19,0xF0,0x8C,0xAB,0x02,0x7E,0x4A,0x31,0xC0,0x6F,0xA5,0x1E,0x30,0xC0,0x6F,0xA9,0x0A,0xF8,0xA5,0xEC,0xFF,0x01};
const uint8_t spALTITUDE[] PROGMEM = {0xAD,0xAE,0xA6,0xB4,0xD2,0x6F,0x8D,0xA5,0xA9,0x0D,0x2D,0x5D,0xBD,0xBA,0x26,0xB6,0xA4,0x6C,0xF5,0xAA,0x2B,0xBB,0xD1,0xF0,0xCE,0xAB,0x48,0xEA,0xD3,0xCC,0x3B,0xAF,0x22,0xBA,0xCE,0x60,0xEB,0x8C,0xC0,0x29,0x4A,0x55,0xA8,0x06,0x38,0x60,0x72,0x8B,0x92,0x5C,0x16,0x2A,0x6A,0xB9,0x56,0x3E,0x68,0x1A,0x87,0x6F,0x5E,0x55,0xA7,0xA9,0x9C,0xB6,0x1A,0x81,0x53,0x94,0xAA,0x50,0x0D,0x08,0xC0,0x12,0x16,0x09,0xF8,0xBA,0x6B,0x14,0xC7,0x4E,0xA7,0x3B,0xE3,0x52,0x65,0x6D,0xE4,0x95,0xAB,0x46,0x55,0xB9,0x89,0x96,0x6C,0x19,0x4D,0xA5,0xA6,0xD6,0xB4,0xA5,0x34,0x85,0xB8,0x79,0xD3,0xE7,0x52,0x67,0x1C,0x6E,0xCD,0x6F,0x5A,0x9D,0x49,0x98,0x37,0xBF,0x0E,0x75,0x50,0x29,0x5E,0xF6,0x84,0x95,0x4C,0x6F,0xA6,0x9B,0x65,0x57,0x0F,0x23,0x4A,0x66,0x69,0x04,0x50,0x60,0x58,0x19,0xAA,0x56,0x55,0xCB,0x55,0xFF,0x0F};
//const uint8_t spRADIAL[] PROGMEM = {0x6A,0x12,0xC3,0xB4,0x52,0x95,0xAA,0x49,0x74,0xD7,0x0C,0x53,0xE2,0x26,0xD3,0xD4,0xD2,0x4C,0x5D,0xE9,0x62,0xA1,0x56,0x8D,0xDC,0xAB,0x2B,0x21,0x54,0x93,0x57,0xAF,0xA6,0xA5,0x60,0x0D,0x79,0xB3,0x9A,0xDE,0x94,0xD4,0xFD,0xF1,0xAA,0x47,0x56,0xD4,0x8C,0x25,0xAD,0x6E,0x54,0x54,0x26,0x13,0xB2,0x51,0x89,0x8A,0x09,0xB5,0x55,0x96,0x2D,0x13,0x29,0xBC,0x57,0x19,0x7A,0x60,0xB4,0xEA,0xD9,0x6D,0x1C,0x4E,0x50,0xA7,0x16,0x8D,0x79,0x58,0x27,0x9C,0x58,0xBD,0xE6,0x6E,0x9C,0xA4,0x6D,0xF3,0xD8,0xB2,0x2A,0xB1,0xB6,0x2D,0xE3,0xCA,0xA2,0x33,0x92,0x7B,0x97,0x3B,0xCA,0x6D,0x73,0xC9,0x5B,0xEE,0x24,0xB6,0x43,0xB9,0x6B,0x79,0xA2,0xB8,0x71,0xE5,0xB4,0xE9,0x0D,0xE6,0xDA,0x44,0xBA,0xA5,0x37,0xAA,0x9A,0x30,0x4A,0x9B,0xBE,0xA8,0x72,0x22,0x28,0x4D,0xFA,0xA3,0x8C,0x4E,0xA7,0x34,0xFF,0x0F};
const uint8_t spREMARK[] PROGMEM = {0x2C,0xD0,0xA9,0xD8,0xCB,0xAD,0xA9,0x4D,0x76,0xE3,0x74,0x57,0x62,0x56,0x59,0x5D,0x22,0xCC,0x89,0x5B,0x54,0x53,0x2B,0x73,0x67,0x69,0x8C,0x15,0xCB,0xD2,0xBD,0xAD,0xA6,0x26,0x76,0x31,0x6B,0xBB,0xAA,0x9E,0x9C,0x38,0xED,0xCB,0xCA,0x66,0x08,0x84,0x8A,0x35,0x2D,0xEB,0x56,0x40,0xAF,0x16,0xB7,0xA4,0x18,0xD4,0x2A,0x9F,0xEC,0x32,0x6D,0x74,0x8A,0xBC,0x49,0x2A,0x83,0xE4,0x1C,0xF6,0x38,0xA5,0xCA,0x9A,0xDA,0xD9,0x9D,0xAC,0xAA,0x68,0xCD,0x36,0xB1,0xB3,0xAA,0x10,0x2E,0xB5,0xA8,0xED,0xAA,0xA2,0xB9,0xD4,0xA1,0x26,0xAB,0xCE,0xFA,0x42,0x97,0xDB,0xEC,0x7A,0xB5,0x45,0x9D,0xE9,0x51,0x97,0x31,0x14,0x7B,0xAA,0x47,0x9B,0xC7,0x50,0xFD,0xB2,0x2E,0xF5,0x46,0xE0,0x14,0xA5,0x2A,0x54,0x03,0x00,0xC0,0x01,0xBD,0xB9,0x2A,0xA0,0x79,0x11,0x06,0xB4,0x62,0x8C,0x80,0x1A,0x59,0xFE,0x1F};
const uint8_t spREFUELLING[] PROGMEM = {0xAE,0x37,0xD5,0xB4,0x42,0xEC,0xB9,0x5E,0x17,0xD7,0x0C,0x56,0x96,0xFA,0x98,0xB1,0xD5,0xC2,0xDD,0xA8,0x6B,0xC6,0x60,0x8B,0xB5,0xA3,0xEE,0xCA,0x50,0x26,0x57,0xB7,0x6A,0x72,0x23,0x9E,0x9A,0x55,0xEA,0x66,0x04,0x6C,0x6A,0x16,0x02,0x94,0x14,0x31,0x40,0x77,0x65,0x06,0x18,0xAE,0xDD,0x00,0x23,0x4C,0x3A,0x60,0xA4,0xCD,0x11,0x0E,0x6F,0x44,0x69,0x5B,0x56,0x3E,0x7C,0x30,0xA4,0xAE,0x5D,0x79,0x57,0xA6,0x54,0xBC,0xB6,0xE5,0x91,0x67,0x5A,0x73,0x97,0x94,0x27,0x5A,0xA3,0x85,0xD9,0x5A,0x55,0x98,0xB5,0x27,0xA6,0x2F,0x43,0xD4,0xBA,0xC6,0x96,0x2E,0x2D,0x09,0xD7,0x9A,0x71,0x9F,0xB6,0x66,0x56,0xE5,0xA1,0x7D,0xC6,0x5A,0x65,0xBA,0xA4,0x6E,0x1E,0x7B,0xB5,0x29,0x1A,0xFA,0xB9,0x9C,0x3D,0x87,0x70,0xEA,0xED,0x76,0xF7,0x14,0xCC,0x63,0x8F,0xDA,0xDB,0xB3,0x88,0x97,0xD6,0x6E,0x7F,0xF7,0x6C,0xD6,0x56,0xA7,0x7D,0xCD,0x70,0x78,0x5A,0xEC,0xF1,0x35,0xAD,0xEE,0x16,0x75,0xEA,0x53,0x9E,0xAA,0x34,0x4A,0x23,0xCE,0xFF,0x03};
const uint8_t spOUTER[] PROGMEM = {0xA9,0x4B,0x39,0x23,0x6C,0x12,0x8D,0xA9,0xA8,0xB3,0xB4,0x5C,0xB2,0xC6,0x2A,0x3E,0x22,0x62,0xC9,0xEA,0x1A,0xFD,0x88,0xF0,0x35,0xAB,0x29,0xF2,0xBC,0xCC,0x3B,0xAF,0x32,0xFA,0xB5,0x62,0xDF,0xB4,0x8A,0xE4,0xC6,0x8A,0xAD,0x63,0xE8,0xAB,0x55,0x17,0x0B,0x5B,0x01,0xE8,0x3A,0xAC,0x54,0x2D,0x6D,0xB8,0x2A,0x9D,0x52,0xA4,0x24,0x5C,0xE9,0xAD,0x47,0x51,0x4A,0x83,0x2E,0xF6,0x6E,0x55,0x4E,0x83,0xF4,0x94,0xBB,0x54,0x25,0x2C,0xE2,0x51,0x9E,0x54,0xA7,0x18,0x18,0x43,0xB9,0xFF,0x1F};
const uint8_t spMIDDLE[] PROGMEM = {0x69,0x2E,0x92,0xF4,0x9C,0xAB,0x96,0xB9,0x1A,0xB4,0x52,0x4F,0x1A,0xA6,0xA0,0x24,0x8B,0x23,0x4A,0x9A,0xB2,0x22,0x6F,0xB3,0x38,0x6D,0xC8,0x8A,0xAD,0x43,0xEA,0xAC,0xA6,0xCB,0x74,0x76,0xDD,0xB3,0xAA,0xCE,0xDC,0x2C,0xED,0xCB,0x2A,0x86,0x08,0x53,0xE3,0x2D,0xA2,0xE2,0xAA,0x3D,0x22,0x66,0x97,0x76,0xD9,0x08,0x53,0xB3,0xBD,0x8A,0xC2,0x22,0xC2,0x39,0xEB,0x2A,0x0B,0xAB,0x0A,0xA1,0xAE,0xAD,0xCA,0xB8,0x27,0x84,0xBA,0xB6,0x2A,0xB1,0x9A,0x64,0x6A,0x93,0xAA,0x20,0x6A,0x92,0xB8,0x73,0x69,0x33,0x9D,0x2A,0x91,0x36,0xFF,0x0F};
const uint8_t spINNER[] PROGMEM = {0xA5,0x6A,0x52,0xA9,0x37,0x2B,0xAD,0x6A,0xD8,0x40,0xEB,0x98,0xB5,0x8A,0xEE,0x9D,0x3C,0xE2,0xF6,0x2A,0xBB,0x0D,0x0E,0xD7,0xC7,0xAB,0x6A,0x1E,0x3D,0xDD,0xED,0xAE,0xAA,0x37,0x09,0x15,0x49,0xBB,0xEA,0xD2,0x45,0xC3,0xAD,0xCD,0x68,0x4A,0x1B,0x92,0xC1,0xBC,0xAD,0x2E,0xFE,0x04,0x5E,0xFC,0xB5,0xAA,0xDA,0x17,0x38,0xD1,0xD7,0xEA,0x92,0x0E,0xE4,0xD4,0x4F,0x69,0x4B,0x5C,0xD0,0x16,0xDD,0xFF,0x0F};
const uint8_t spINSTRUMENTS[] PROGMEM = {0xA2,0x8F,0xDA,0x63,0xB7,0x23,0xA6,0xA1,0x6A,0xB1,0xCB,0x8E,0x34,0xC6,0xA6,0x9D,0xAA,0xB3,0xD2,0xEA,0xBB,0x37,0xF2,0x88,0x45,0xA3,0x6D,0x46,0x34,0x25,0x6B,0x97,0x36,0x49,0xEA,0x94,0x70,0x12,0xBA,0x28,0x69,0x82,0x2B,0x71,0x08,0x5E,0x12,0x52,0x55,0xA5,0x0E,0x78,0x4E,0xC8,0x01,0x4F,0x93,0x1B,0xE0,0xE5,0x76,0x06,0x34,0xCF,0x2E,0x80,0x5E,0xCB,0x02,0xD0,0x8C,0x53,0x1B,0x52,0xE1,0xB0,0x88,0xAC,0x6D,0x88,0x45,0x22,0x52,0xD7,0xA4,0x39,0x1A,0xE3,0x2A,0x4E,0x9A,0x8E,0xCA,0x83,0xAC,0xB9,0x6E,0x3B,0x8B,0x2E,0x0D,0xE3,0xB6,0xE3,0x2C,0x3E,0xD5,0xC3,0xF6,0xB4,0xAB,0x99,0x34,0x4B,0x59,0x5D,0xAE,0x26,0x53,0xBD,0x64,0x73,0x79,0xAA,0x21,0x6B,0x77,0xAB,0xE9,0x89,0x4A,0xA2,0x25,0x12,0x23,0x70,0x8A,0x52,0x15,0xAA,0x01,0x00,0x0A,0x98,0x42,0x5D,0x00,0xCF,0x57,0x30,0xE0,0x3B,0x41,0x05,0xFC,0x12,0xA6,0x80,0x9F,0xDD,0x14,0xF0,0x8C,0x2B,0x03,0x7E,0x4A,0xF9,0x7F};
//const uint8_t spFLIGHT[] PROGMEM = {0x04,0x68,0x2A,0x42,0x00,0xC5,0xB8,0x0A,0xA0,0x9B,0x74,0x05,0x0C,0x57,0xA6,0x80,0x61,0x82,0xCB,0x50,0x34,0x47,0xA7,0xCA,0x0D,0x7D,0x14,0x7A,0xC6,0xD2,0x76,0xF5,0x95,0xCC,0xB8,0xD1,0x9A,0xD5,0x66,0xBD,0xE1,0x1E,0xB7,0x57,0x5D,0x4D,0x4B,0x64,0xCC,0x5E,0x55,0x0B,0xC6,0xE5,0x33,0x7B,0x94,0xCD,0x31,0x77,0x74,0x64,0xD7,0x07,0xA1,0xBA,0x51,0x91,0x11,0x38,0x45,0xA9,0x0A,0xD5,0x00,0x00,0x03,0x0C,0xE9,0x26,0x80,0xCD,0xD5,0x10,0x38,0x45,0xA9,0x0A,0xD5,0xF8,0x7F};
const uint8_t spAPPROACHES[] PROGMEM = {0x63,0xCD,0x66,0x24,0x32,0x1B,0xAD,0xA5,0x98,0x55,0xF3,0xD8,0x75,0x86,0xCA,0x27,0xDC,0xB5,0xCF,0x19,0x92,0x9C,0x88,0xB0,0x5D,0x65,0x08,0x61,0xCC,0xDC,0x76,0x21,0x70,0x8A,0x52,0x15,0xAA,0x01,0xA0,0x80,0x94,0xCD,0x15,0x90,0xB3,0x47,0xC9,0x42,0x93,0x32,0xF1,0x2C,0x35,0x5B,0x79,0xB2,0x99,0x66,0xD2,0x7C,0x65,0x95,0x44,0x6B,0x51,0xB6,0x91,0x66,0x9E,0xC5,0xCE,0xD9,0x52,0x11,0x0B,0xAB,0x59,0xC4,0x46,0x7E,0xE3,0xCA,0x26,0xEE,0x9A,0x00,0x4D,0x92,0x06,0x60,0xB7,0xB0,0x04,0xEC,0xD4,0xBD,0xAA,0x19,0x9C,0xD9,0x34,0xEF,0x6A,0xAB,0x75,0x16,0x8F,0xCD,0xAB,0xAB,0x2A,0x44,0x33,0x37,0xAF,0xB1,0x89,0x10,0x73,0xDF,0x3C,0xC6,0x2E,0x4D,0xC2,0xB4,0x77,0x9B,0x9B,0x54,0x75,0xD5,0xDE,0x6D,0xEE,0x24,0x9C,0x34,0xFB,0xB6,0x79,0x61,0x75,0x53,0xCF,0x5A,0xFE,0x17,0xD4,0x86,0xC9,0x89,0x02,0x7E,0x2B,0x55,0xC0,0xAF,0xEE,0x02,0xF8,0x29,0xFD,0xFF,0x01};
const uint8_t spGEAR[] PROGMEM = {0x6D,0xDC,0x21,0x39,0x34,0x92,0xB4,0xAE,0x09,0xA6,0x9A,0x8E,0xBD,0x9A,0xEE,0x19,0xA3,0x6B,0xC9,0x6A,0x7A,0x31,0x54,0x8F,0xC7,0xAB,0xED,0xB1,0x40,0x52,0x5F,0xAD,0xB6,0xDB,0x41,0x1A,0xDE,0x3C,0xDA,0xEA,0x06,0x79,0x69,0x77,0x6B,0x4A,0x5E,0x90,0xC5,0x5E,0xAD,0x2E,0x71,0x41,0x8E,0x7A,0xB7,0x2A,0x87,0x01,0x3F,0xEA,0x55,0xAA,0x5C,0x13,0x6A,0xA8,0x67,0x68,0x52,0x71,0x98,0xE2,0x5C,0xAC,0xCC,0xC4,0xDC,0x22,0x14,0xFD,0x3F};
const uint8_t spBOOST[] PROGMEM = {0x0C,0x50,0xD6,0xAC,0x94,0x51,0xAB,0x67,0x60,0x9F,0x5A,0xD6,0xB6,0x0E,0x69,0xB4,0xAA,0x52,0x93,0xBA,0xE4,0xC5,0xAF,0x06,0x78,0xC6,0x55,0x01,0x3F,0xA5,0x28,0xE0,0xB7,0x52,0x0D,0x18,0xE0,0xB7,0x54,0x03,0xFC,0x52,0xA6,0x80,0x9F,0xCB,0x10,0x38,0x45,0xA9,0x0A,0xD5,0x00,0x30,0xC0,0x90,0x6E,0x02,0xD8,0x5C,0xED,0xFF,0x01};
const uint8_t spTELEPHONE[] PROGMEM = {0x0C,0x98,0xD6,0xDC,0x01,0x47,0x9A,0x16,0x7F,0xFA,0x14,0x13,0x4A,0xB5,0xEA,0x6A,0x52,0x53,0x75,0xF5,0xAA,0x1B,0x9B,0xB4,0xE0,0x3E,0xAB,0xEE,0xA0,0x2A,0x93,0xFC,0xAC,0xBA,0xF0,0x8E,0x11,0xCA,0xBD,0x9A,0x62,0xB2,0x52,0xA8,0x75,0xE9,0x92,0xD5,0x74,0x92,0xC6,0x02,0x18,0xB6,0xC2,0x03,0x06,0x98,0xBE,0x42,0x02,0xA3,0x0E,0x7E,0xCC,0x95,0x3B,0xAE,0x29,0x86,0xF6,0x30,0x5A,0xB5,0xD6,0xE8,0x27,0xCC,0xA8,0x4E,0xDB,0xA2,0xAD,0x0A,0xE1,0xAA,0x65,0x8F,0x3E,0x46,0x45,0x9D,0x96,0x23,0xC6,0x68,0x55,0x75,0x92,0xCE,0xE8,0xBC,0x4D,0x4C,0x4E,0x3A,0x93,0xB1,0x51,0x57,0x25,0xE9,0x6C,0x86,0xD3,0xDD,0xE4,0x84,0xAB,0x69,0xAC,0x72,0x55,0x12,0xAE,0xA2,0x28,0xD3,0x42,0x51,0xB8,0x9B,0x66,0x2F,0x75,0x3B,0xF1,0x0E,0x77,0xD3,0x6A,0x69,0x9E,0xE8,0xFF,0x01};

// vocab us male
//const uint8_t spZERO[]          PROGMEM = {0x69,0xFB,0x59,0xDD,0x51,0xD5,0xD7,0xB5,0x6F,0x0A,0x78,0xC0,0x52,0x01,0x0F,0x50,0xAC,0xF6,0xA8,0x16,0x15,0xF2,0x7B,0xEA,0x19,0x47,0xD0,0x64,0xEB,0xAD,0x76,0xB5,0xEB,0xD1,0x96,0x24,0x6E,0x62,0x6D,0x5B,0x1F,0x0A,0xA7,0xB9,0xC5,0xAB,0xFD,0x1A,0x62,0xF0,0xF0,0xE2,0x6C,0x73,0x1C,0x73,0x52,0x1D,0x19,0x94,0x6F,0xCE,0x7D,0xED,0x6B,0xD9,0x82,0xDC,0x48,0xC7,0x2E,0x71,0x8B,0xBB,0xDF,0xFF,0x1F};
//const uint8_t spFOUR[]          PROGMEM = {0x08,0x68,0x21,0x0D,0x03,0x04,0x28,0xCE,0x92,0x03,0x23,0x4A,0xCA,0xA6,0x1C,0xDA,0xAD,0xB4,0x70,0xED,0x19,0x64,0xB7,0xD3,0x91,0x45,0x51,0x35,0x89,0xEA,0x66,0xDE,0xEA,0xE0,0xAB,0xD3,0x29,0x4F,0x1F,0xFA,0x52,0xF6,0x90,0x52,0x3B,0x25,0x7F,0xDD,0xCB,0x9D,0x72,0x72,0x8C,0x79,0xCB,0x6F,0xFA,0xD2,0x10,0x9E,0xB4,0x2C,0xE1,0x4F,0x25,0x70,0x3A,0xDC,0xBA,0x2F,0x6F,0xC1,0x75,0xCB,0xF2,0xFF};
//const uint8_t spEIGHT[]         PROGMEM = {0x65,0x69,0x89,0xC5,0x73,0x66,0xDF,0xE9,0x8C,0x33,0x0E,0x41,0xC6,0xEA,0x5B,0xEF,0x7A,0xF5,0x33,0x25,0x50,0xE5,0xEA,0x39,0xD7,0xC5,0x6E,0x08,0x14,0xC1,0xDD,0x45,0x64,0x03,0x00,0x80,0x00,0xAE,0x70,0x33,0xC0,0x73,0x33,0x1A,0x10,0x40,0x8F,0x2B,0x14,0xF8,0x7F};
//const uint8_t spTWELVE[]        PROGMEM = {0x09,0x98,0xDA,0x22,0x01,0x37,0x78,0x1A,0x20,0x85,0xD1,0x50,0x3A,0x33,0x11,0x81,0x5D,0x5B,0x95,0xD4,0x44,0x04,0x76,0x9D,0xD5,0xA9,0x3A,0xAB,0xF0,0xA1,0x3E,0xB7,0xBA,0xD5,0xA9,0x2B,0xEB,0xCC,0xA0,0x3E,0xB7,0xBD,0xC3,0x5A,0x3B,0xC8,0x69,0x67,0xBD,0xFB,0xE8,0x67,0xBF,0xCA,0x9D,0xE9,0x74,0x08,0xE7,0xCE,0x77,0x78,0x06,0x89,0x32,0x57,0xD6,0xF1,0xF1,0x8F,0x7D,0xFE,0x1F};
//const uint8_t spTWENTY[]        PROGMEM = {0x0A,0xE8,0x4A,0xCD,0x01,0xDB,0xB9,0x33,0xC0,0xA6,0x54,0x0C,0xA4,0x34,0xD9,0xF2,0x0A,0x6C,0xBB,0xB3,0x53,0x0E,0x5D,0xA6,0x25,0x9B,0x6F,0x75,0xCA,0x61,0x52,0xDC,0x74,0x49,0xA9,0x8A,0xC4,0x76,0x4D,0xD7,0xB1,0x76,0xC0,0x55,0xA6,0x65,0xD8,0x26,0x99,0x5C,0x56,0xAD,0xB9,0x25,0x23,0xD5,0x7C,0x32,0x96,0xE9,0x9B,0x20,0x7D,0xCB,0x3C,0xFA,0x55,0xAE,0x99,0x1A,0x30,0xFC,0x4B,0x3C,0xFF,0x1F};
//const uint8_t spONE[]           PROGMEM = {0x66,0x4E,0xA8,0x7A,0x8D,0xED,0xC4,0xB5,0xCD,0x89,0xD4,0xBC,0xA2,0xDB,0xD1,0x27,0xBE,0x33,0x4C,0xD9,0x4F,0x9B,0x4D,0x57,0x8A,0x76,0xBE,0xF5,0xA9,0xAA,0x2E,0x4F,0xD5,0xCD,0xB7,0xD9,0x43,0x5B,0x87,0x13,0x4C,0x0D,0xA7,0x75,0xAB,0x7B,0x3E,0xE3,0x19,0x6F,0x7F,0xA7,0xA7,0xF9,0xD0,0x30,0x5B,0x1D,0x9E,0x9A,0x34,0x44,0xBC,0xB6,0x7D,0xFE,0x1F};
//const uint8_t spFIVE[]          PROGMEM = {0x08,0x68,0x4E,0x9D,0x02,0x1C,0x60,0xC0,0x8C,0x69,0x12,0xB0,0xC0,0x28,0xAB,0x8C,0x9C,0xC0,0x2D,0xBB,0x38,0x79,0x31,0x15,0xA3,0xB6,0xE4,0x16,0xB7,0xDC,0xF5,0x6E,0x57,0xDF,0x54,0x5B,0x85,0xBE,0xD9,0xE3,0x5C,0xC6,0xD6,0x6D,0xB1,0xA5,0xBF,0x99,0x5B,0x3B,0x5A,0x30,0x09,0xAF,0x2F,0xED,0xEC,0x31,0xC4,0x5C,0xBE,0xD6,0x33,0xDD,0xAD,0x88,0x87,0xE2,0xD2,0xF2,0xF4,0xE0,0x16,0x2A,0xB2,0xE3,0x63,0x1F,0xF9,0xF0,0xE7,0xFF,0x01};
//const uint8_t spNINE[]          PROGMEM = {0xE6,0xA8,0x1A,0x35,0x5D,0xD6,0x9A,0x35,0x4B,0x8C,0x4E,0x6B,0x1A,0xD6,0xA6,0x51,0xB2,0xB5,0xEE,0x58,0x9A,0x13,0x4F,0xB5,0x35,0x67,0x68,0x26,0x3D,0x4D,0x97,0x9C,0xBE,0xC9,0x75,0x2F,0x6D,0x7B,0xBB,0x5B,0xDF,0xFA,0x36,0xA7,0xEF,0xBA,0x25,0xDA,0x16,0xDF,0x69,0xAC,0x23,0x05,0x45,0xF9,0xAC,0xB9,0x8F,0xA3,0x97,0x20,0x73,0x9F,0x54,0xCE,0x1E,0x45,0xC2,0xA2,0x4E,0x3E,0xD3,0xD5,0x3D,0xB1,0x79,0x24,0x0D,0xD7,0x48,0x4C,0x6E,0xE1,0x2C,0xDE,0xFF,0x0F};
//const uint8_t spTHIR_[]         PROGMEM = {0x04,0xA8,0xBE,0x5C,0x00,0xDD,0xA5,0x11,0xA0,0xFA,0x72,0x02,0x74,0x97,0xC6,0x01,0x09,0x9C,0xA6,0xAB,0x30,0x0D,0xCE,0x7A,0xEA,0x6A,0x4A,0x39,0x35,0xFB,0xAA,0x8B,0x1B,0xC6,0x76,0xF7,0xAB,0x2E,0x79,0x19,0xCA,0xD5,0xEF,0xCA,0x57,0x08,0x14,0xA1,0xDC,0x45,0x64,0x03,0x00,0xC0,0xFF,0x03};
//const uint8_t spHUNDRED[]       PROGMEM = {0x04,0xC8,0x7E,0x5C,0x02,0x0A,0xA8,0x62,0x43,0x03,0xA7,0xA8,0x62,0x43,0x4B,0x97,0xDC,0xF2,0x14,0xC5,0xA7,0x9B,0x7A,0xD3,0x95,0x37,0xC3,0x1E,0x16,0x4A,0x66,0x36,0xF3,0x5A,0x89,0x6E,0xD4,0x30,0x55,0xB5,0x32,0xB7,0x31,0xB5,0xC1,0x69,0x2C,0xE9,0xF7,0xBC,0x96,0x12,0x39,0xD4,0xB5,0xFD,0xDA,0x9B,0x0F,0xD1,0x90,0xEE,0xF5,0xE4,0x17,0x02,0x45,0x28,0x77,0x11,0xD9,0x40,0x9E,0x45,0xDD,0x2B,0x33,0x71,0x7A,0xBA,0x0B,0x13,0x95,0x2D,0xF9,0xF9,0x7F};
//const uint8_t spTWO[]           PROGMEM = {0x06,0xB8,0x59,0x34,0x00,0x27,0xD6,0x38,0x60,0x58,0xD3,0x91,0x55,0x2D,0xAA,0x65,0x9D,0x4F,0xD1,0xB8,0x39,0x17,0x67,0xBF,0xC5,0xAE,0x5A,0x1D,0xB5,0x7A,0x06,0xF6,0xA9,0x7D,0x9D,0xD2,0x6C,0x55,0xA5,0x26,0x75,0xC9,0x9B,0xDF,0xFC,0x6E,0x0E,0x63,0x3A,0x34,0x70,0xAF,0x3E,0xFF,0x1F};
//const uint8_t spSIX[]           PROGMEM = {0x04,0xF8,0xAD,0x4C,0x02,0x16,0xB0,0x80,0x06,0x56,0x35,0x5D,0xA8,0x2A,0x6D,0xB9,0xCD,0x69,0xBB,0x2B,0x55,0xB5,0x2D,0xB7,0xDB,0xFD,0x9C,0x0D,0xD8,0x32,0x8A,0x7B,0xBC,0x02,0x00,0x03,0x0C,0xB1,0x2E,0x80,0xDF,0xD2,0x35,0x20,0x01,0x0E,0x60,0xE0,0xFF,0x01};
//const uint8_t spTEN[]           PROGMEM = {0x0E,0x38,0x3C,0x2D,0x00,0x5F,0xB6,0x19,0x60,0xA8,0x90,0x93,0x36,0x2B,0xE2,0x99,0xB3,0x4E,0xD9,0x7D,0x89,0x85,0x2F,0xBE,0xD5,0xAD,0x4F,0x3F,0x64,0xAB,0xA4,0x3E,0xBA,0xD3,0x59,0x9A,0x2E,0x75,0xD5,0x39,0x6D,0x6B,0x0A,0x2D,0x3C,0xEC,0xE5,0xDD,0x1F,0xFE,0xB0,0xE7,0xFF,0x03};
const uint8_t spFIF_[]          PROGMEM = {0x08,0x98,0x31,0x93,0x02,0x1C,0xE0,0x80,0x07,0x5A,0xD6,0x1C,0x6B,0x78,0x2E,0xBD,0xE5,0x2D,0x4F,0xDD,0xAD,0xAB,0xAA,0x6D,0xC9,0x23,0x02,0x56,0x4C,0x93,0x00,0x05,0x10,0x90,0x89,0x31,0xFC,0x3F};
//const uint8_t spTHOUSAND[]      PROGMEM = {0x0C,0xE8,0x2E,0xD4,0x02,0x06,0x98,0xD2,0x55,0x03,0x16,0x68,0x7D,0x17,0xE9,0x6E,0xBC,0x65,0x8C,0x45,0x6D,0xA6,0xE9,0x96,0xDD,0xDE,0xF6,0xB6,0xB7,0x5E,0x75,0xD4,0x93,0xA5,0x9C,0x7B,0x57,0xB3,0x6E,0x7D,0x12,0x19,0xAD,0xDC,0x29,0x8D,0x4F,0x93,0xB4,0x87,0xD2,0xB6,0xFC,0xDD,0xAC,0x22,0x56,0x02,0x70,0x18,0xCA,0x18,0x26,0xB5,0x90,0xD4,0xDE,0x6B,0x29,0xDA,0x2D,0x25,0x17,0x8D,0x79,0x88,0xD4,0x48,0x79,0x5D,0xF7,0x74,0x75,0xA1,0x94,0xA9,0xD1,0xF2,0xED,0x9E,0xAA,0x51,0xA6,0xD4,0x9E,0x7F,0xED,0x6F,0xFE,0x2B,0xD1,0xC7,0x3D,0x89,0xFA,0xB7,0x0D,0x57,0xD3,0xB4,0xF5,0x37,0x55,0x37,0x2E,0xE6,0xB2,0xD7,0x57,0xFF,0x0F};
//const uint8_t spTHREE[]         PROGMEM = {0x0C,0xE8,0x2E,0x94,0x01,0x4D,0xBA,0x4A,0x40,0x03,0x16,0x68,0x69,0x36,0x1C,0xE9,0xBA,0xB8,0xE5,0x39,0x70,0x72,0x84,0xDB,0x51,0xA4,0xA8,0x4E,0xA3,0xC9,0x77,0xB1,0xCA,0xD6,0x52,0xA8,0x71,0xED,0x2A,0x7B,0x4B,0xA6,0xE0,0x37,0xB7,0x5A,0xDD,0x48,0x8E,0x94,0xF1,0x64,0xCE,0x6D,0x19,0x55,0x91,0xBC,0x6E,0xD7,0xAD,0x1E,0xF5,0xAA,0x77,0x7A,0xC6,0x70,0x22,0xCD,0xC7,0xF9,0x89,0xCF,0xFF,0x03};
//const uint8_t spSEVEN[]         PROGMEM = {0x0C,0xF8,0x5E,0x4C,0x01,0xBF,0x95,0x7B,0xC0,0x02,0x16,0xB0,0xC0,0xC8,0xBA,0x36,0x4D,0xB7,0x27,0x37,0xBB,0xC5,0x29,0xBA,0x71,0x6D,0xB7,0xB5,0xAB,0xA8,0xCE,0xBD,0xD4,0xDE,0xA6,0xB2,0x5A,0xB1,0x34,0x6A,0x1D,0xA7,0x35,0x37,0xE5,0x5A,0xAE,0x6B,0xEE,0xD2,0xB6,0x26,0x4C,0x37,0xF5,0x4D,0xB9,0x9A,0x34,0x39,0xB7,0xC6,0xE1,0x1E,0x81,0xD8,0xA2,0xEC,0xE6,0xC7,0x7F,0xFE,0xFB,0x7F};
//const uint8_t spELEVEN[]        PROGMEM = {0xA5,0xEF,0xD6,0x50,0x3B,0x67,0x8F,0xB9,0x3B,0x23,0x49,0x7F,0x33,0x87,0x31,0x0C,0xE9,0x22,0x49,0x7D,0x56,0xDF,0x69,0xAA,0x39,0x6D,0x59,0xDD,0x82,0x56,0x92,0xDA,0xE5,0x74,0x9D,0xA7,0xA6,0xD3,0x9A,0x53,0x37,0x99,0x56,0xA6,0x6F,0x4F,0x59,0x9D,0x7B,0x89,0x2F,0xDD,0xC5,0x28,0xAA,0x15,0x4B,0xA3,0xD6,0xAE,0x8C,0x8A,0xAD,0x54,0x3B,0xA7,0xA9,0x3B,0xB3,0x54,0x5D,0x33,0xE6,0xA6,0x5C,0xCB,0x75,0xCD,0x5E,0xC6,0xDA,0xA4,0xCA,0xB9,0x35,0xAE,0x67,0xB8,0x46,0x40,0xB6,0x28,0xBB,0xF1,0xF6,0xB7,0xB9,0x47,0x20,0xB6,0x28,0xBB,0xFF,0x0F};
const uint8_t sp_TEEN[]         PROGMEM = {0x09,0x58,0x2A,0x25,0x00,0xCB,0x9F,0x95,0x6C,0x14,0x21,0x89,0xA9,0x78,0xB3,0x5B,0xEC,0xBA,0xB5,0x23,0x13,0x46,0x97,0x99,0x3E,0xD6,0xB9,0x2E,0x79,0xC9,0x5B,0xD8,0x47,0x41,0x53,0x1F,0xC7,0xE1,0x9C,0x85,0x54,0x22,0xEC,0xFA,0xDB,0xDD,0x23,0x93,0x49,0xB8,0xE6,0x78,0xFF,0x3F};
const uint8_t spA[]             PROGMEM = {0x65,0x2C,0x96,0xAD,0x7B,0x6A,0x9F,0x66,0xE4,0x20,0x8D,0x9C,0x73,0xAB,0x5B,0xDC,0xE2,0x96,0xB7,0xBA,0xF5,0x6A,0x66,0x28,0xA0,0xCE,0xD5,0xBB,0xDB,0xFD,0x1E,0xE6,0x38,0xA7,0x36,0xCF,0x9C,0x80,0x51,0x8B,0xEB,0x52,0xD7,0xBC,0xFF,0x3F};
const uint8_t spB[]             PROGMEM = {0xA6,0x2F,0xAA,0x05,0x5C,0xD6,0x8C,0xBC,0xC7,0x16,0x70,0x59,0x33,0xB2,0x95,0x0B,0xC1,0xFD,0xCD,0xCC,0x66,0x3A,0xF3,0x51,0xAD,0x98,0x00,0x55,0x8B,0x67,0xDB,0xC7,0x3E,0xD5,0xAD,0xEE,0x75,0x2F,0xE7,0x2C,0x4D,0x60,0xBE,0x26,0xDF,0xF1,0x89,0xEF,0xFF,0x03};
const uint8_t spC[]             PROGMEM = {0x04,0xF8,0xA5,0x83,0x03,0x12,0xB0,0x80,0x07,0x22,0xB0,0xC2,0xEE,0x8D,0x45,0x7D,0xC9,0xCA,0x67,0x29,0x42,0xF5,0x35,0x3B,0xDF,0xF9,0x28,0x66,0x0D,0x40,0xCF,0xD7,0xB3,0x1C,0xCD,0xAC,0x06,0x14,0xB5,0x68,0x0E,0x7D,0xEE,0x4B,0xDF,0xD2,0x39,0x5B,0x02,0x44,0xBD,0xCE,0x57,0xBE,0xF2,0x9D,0xEE,0x55,0x0A,0xC1,0x73,0x4D,0x7E,0xF2,0xF3,0xFF};
const uint8_t spD[]             PROGMEM = {0x06,0x98,0x30,0x68,0xE4,0x6B,0x84,0xA0,0xE8,0xD3,0x93,0x8D,0xEC,0x84,0x9E,0x4B,0x6E,0x36,0x8A,0x19,0x0D,0xA8,0xEA,0x71,0xAF,0x7A,0xDF,0xE7,0xB2,0xAD,0xE0,0x00,0xD3,0x8B,0xEB,0x9E,0x8F,0x7C,0xA6,0x73,0xE5,0x40,0xA8,0x5A,0x1C,0xAF,0x78,0xC5,0xDB,0xDF,0xFF,0x0F};
const uint8_t spE[]             PROGMEM = {0xA2,0x59,0x95,0x51,0xBA,0x17,0xF7,0x6A,0x95,0xAB,0x38,0x42,0xE4,0x92,0x5D,0xEE,0x62,0x15,0x33,0x3B,0x50,0xD6,0x92,0x5D,0xAE,0x6A,0xC5,0x04,0xA8,0x5A,0xBC,0xEB,0xDD,0xEC,0x76,0x77,0xBB,0xDF,0xD3,0x9E,0xF6,0x32,0x97,0xBE,0xF5,0xAD,0xED,0xB3,0x34,0x81,0xF9,0x9A,0xFF,0x07};
const uint8_t spF[]             PROGMEM = {0xAB,0x1B,0x61,0x94,0xDD,0xD6,0xDC,0xF1,0x74,0xDD,0x37,0xB9,0xE7,0xEA,0xD3,0x35,0xB3,0x1C,0xE1,0xAF,0x6F,0x77,0xC7,0xB5,0xD4,0xE0,0x56,0x9C,0x77,0xDB,0x5A,0x9D,0xEB,0x98,0x8C,0x61,0xC0,0x30,0xE9,0x1A,0xB0,0x80,0x05,0x14,0x30,0x6D,0xBB,0x06,0x24,0x20,0x01,0x0E,0x10,0xA0,0x06,0xB5,0xFF,0x07};
const uint8_t spG[]             PROGMEM = {0x6E,0x3F,0x29,0x8D,0x98,0x95,0xCD,0x3D,0x00,0xAB,0x38,0x95,0xE2,0xD4,0xEB,0x34,0x81,0x7A,0xF2,0x51,0x53,0x50,0x75,0xEB,0xCE,0x76,0xB6,0xD3,0x95,0x8D,0x92,0x48,0x99,0xAB,0x77,0xBE,0xCB,0xDD,0x8E,0x71,0x96,0x04,0x8C,0x5A,0x3C,0xE7,0x39,0xF7,0xAD,0x6E,0xF5,0x2A,0xD7,0x2A,0x85,0xE0,0xB9,0x26,0x3E,0xF1,0xF9,0x7F};
const uint8_t spH[]             PROGMEM = {0x65,0x18,0x6D,0x90,0x2D,0xD6,0xEC,0xF6,0x56,0xB7,0xBC,0xC5,0xAE,0xC7,0x30,0xA3,0x01,0x6D,0x2D,0xCE,0x8B,0x3D,0xDC,0xD6,0x3C,0x61,0x76,0xC5,0x25,0x9B,0x08,0xE5,0x2E,0x22,0x1B,0x00,0x80,0x01,0x2B,0x87,0x38,0x60,0xE5,0xED,0x08,0x58,0xC0,0x02,0x16,0xB0,0x80,0x06,0x34,0x40,0x80,0x76,0xD3,0xFE,0x1F};
const uint8_t spI[]             PROGMEM = {0xAA,0x8D,0x63,0xA8,0xAA,0x66,0xAD,0xB9,0xA8,0xCB,0x08,0xDD,0x7C,0xFB,0x5B,0xDF,0xFA,0x36,0xB7,0x39,0x6D,0xB5,0xA3,0x15,0xBA,0xF8,0x76,0xBB,0xDF,0xD3,0x9E,0xD7,0xDA,0x5C,0x49,0xA5,0x2D,0xDE,0x7B,0xDB,0x6B,0x76,0x29,0xAF,0xC7,0x6D,0xEF,0x31,0xD8,0x5C,0x1E,0xF7,0xBD,0x1E,0xF5,0x48,0xE7,0x28,0x89,0xE2,0xF2,0x38,0x5F,0xF9,0xFE,0x7F};
const uint8_t spL[]             PROGMEM = {0x6B,0x68,0x2E,0xD8,0x2A,0x37,0xDF,0xFE,0xF6,0xA7,0xAF,0x21,0xBC,0xC4,0x17,0xDF,0xFE,0xF6,0x67,0xC8,0x6A,0xC3,0x4D,0x3A,0xDF,0x61,0x4D,0x95,0x6C,0xA6,0x71,0x9E,0xB1,0x36,0x98,0x53,0x49,0x5E,0xFB,0x5A,0x8E,0x0A,0x7A,0x43,0xD9,0x4F,0x3C,0xC2,0x59,0xE0,0xF4,0x08,0xF9,0x09,0x67,0x03,0x31,0x19,0xA2,0x25,0x9E,0xFF,0x0F};
const uint8_t spJ[]             PROGMEM = {0x6E,0x5A,0xC1,0x99,0x54,0xB2,0x09,0x60,0x49,0x22,0x07,0xEC,0xA8,0x16,0x80,0x5D,0x26,0xC7,0xD0,0xA3,0x92,0x78,0x74,0x3E,0x55,0x2F,0x21,0x6A,0xB1,0xFA,0x56,0xB7,0xBA,0xD5,0xAD,0x6F,0x7D,0xBB,0x3D,0x8E,0x75,0xB4,0x22,0x36,0x7F,0x53,0xCF,0x7E,0xB5,0x67,0x96,0x61,0x34,0xDB,0x52,0x9F,0xF4,0x8E,0xDC,0x88,0xE1,0x5F,0xF2,0x9D,0xEF,0xFF,0x07};
const uint8_t spK[]             PROGMEM = {0x01,0x18,0x91,0xB9,0x00,0x4D,0x91,0x46,0x60,0x65,0x2D,0xB3,0xB8,0x67,0xED,0x53,0xF4,0x14,0x64,0x11,0x4B,0x6E,0x79,0x8B,0x5B,0xDE,0xF2,0x74,0xC3,0x05,0x6A,0xE7,0xEA,0x3D,0xEC,0x71,0x2F,0x6D,0x1F,0xB1,0x00,0x2B,0xDF,0xF4,0xA3,0x1D,0xB3,0x24,0x60,0xD4,0xE2,0x7A,0xE5,0x2B,0xDF,0xE9,0x1E,0x43,0x48,0xA3,0xEB,0xE4,0xFB,0xFF,0x01};
const uint8_t spM[]             PROGMEM = {0xA9,0xE8,0xC5,0xD8,0x73,0x16,0xCF,0xE2,0x0E,0xB7,0xBB,0xCD,0xA9,0xBB,0x6F,0xF1,0xF0,0xD5,0xB7,0xBE,0xCD,0xEE,0xC6,0x50,0x63,0x72,0x98,0x58,0xEE,0x73,0x5F,0xDB,0xD6,0x62,0x72,0x98,0x58,0xAE,0x7B,0xDD,0xD3,0x5E,0x45,0x72,0x93,0xD8,0x8D,0x87,0x3D,0xEC,0x61,0xCF,0x70,0x96,0x58,0xE1,0xA2,0x4D,0xE2,0x15,0xEF,0xFF,0x07};
const uint8_t spN[]             PROGMEM = {0x41,0xEE,0xD1,0xC8,0xB3,0x16,0xEF,0xEE,0xD4,0xC3,0x35,0x59,0xC4,0xE3,0x5B,0xDD,0xEA,0x56,0xBB,0x59,0xED,0x92,0xCD,0x91,0xB4,0x78,0x4F,0x63,0x19,0x9E,0x38,0x2C,0x9C,0xCE,0xA5,0xAF,0xF5,0x08,0xC7,0xB0,0xC2,0x61,0x1E,0x35,0x1E,0xF1,0x8C,0x57,0xBC,0xD3,0xDD,0x4D,0x49,0xB8,0xCE,0x0E,0xF7,0x34,0xAD,0x16,0xBC,0xF9,0xFF,0x01};
const uint8_t spO[]             PROGMEM = {0xA3,0x6D,0xB4,0xBA,0x8D,0xBC,0xAD,0xA6,0x92,0xEC,0x0E,0xF2,0xB6,0xAB,0x5D,0x8C,0xA2,0xE0,0xEE,0x16,0xF6,0x3F,0xCB,0x39,0xCC,0xB1,0xAC,0x91,0xE5,0x0C,0x8B,0xBF,0xB0,0x3B,0xD3,0x1D,0x28,0x59,0xE2,0xE9,0x4F,0x7B,0xF9,0xE7,0xFF,0x01};
const uint8_t spP[]             PROGMEM = {0x02,0x88,0x26,0xD4,0x00,0x6D,0x96,0xB5,0xB8,0x25,0x05,0x89,0x6C,0x3D,0xD2,0xE6,0x51,0xB3,0xA6,0xF4,0x48,0x67,0x09,0xA0,0x8C,0xC7,0x33,0x9B,0x79,0xCB,0x67,0x0E,0x80,0xCA,0xD7,0xBD,0x6A,0xD5,0x72,0x06,0xB4,0xB5,0xBA,0xB7,0xBD,0xAF,0x73,0x5D,0xF3,0x91,0x8F,0x78,0xFE,0x3F};
const uint8_t spQ[]             PROGMEM = {0x0E,0x98,0xD5,0x28,0x02,0x11,0x18,0xE9,0xCC,0x46,0x98,0xF1,0x66,0xA7,0x27,0x1D,0x21,0x99,0x92,0xB6,0xDC,0x7C,0x17,0xAB,0x2C,0xD2,0x2D,0x13,0x3B,0xEF,0xAA,0x75,0xCE,0x94,0x47,0xD0,0xEE,0x3A,0xC4,0x29,0x2F,0x61,0x35,0x31,0xA2,0x50,0xB6,0xF8,0xCD,0x1F,0xFF,0x0F};
const uint8_t spR[]             PROGMEM = {0xAB,0xC8,0x72,0x33,0x93,0xBB,0xDC,0xEE,0xB6,0xB7,0xB9,0xF5,0x68,0x53,0x5C,0xA9,0xA6,0x4D,0xB3,0x6B,0x73,0x0A,0xCB,0x71,0xD8,0xBB,0xAF,0x7D,0x2F,0x47,0xB6,0xC7,0xF4,0x94,0x37,0x9D,0xA9,0x34,0xF8,0x53,0x97,0x78,0xFD,0x3F};
const uint8_t spS[]             PROGMEM = {0x6B,0x6E,0xD9,0x34,0x6C,0xE6,0xDC,0xF6,0x36,0xB7,0xBE,0xF5,0x19,0xAA,0x0F,0x2D,0xDA,0x25,0x7B,0x19,0x5B,0x4D,0x9A,0xA2,0xE7,0xB8,0x1D,0x23,0xA5,0x26,0x71,0x2A,0x03,0xFC,0x94,0xE6,0x01,0x0F,0x68,0x40,0x03,0x12,0xE0,0x00,0x07,0x30,0xF0,0xFF};
const uint8_t spT[]             PROGMEM = {0x01,0xD8,0xB6,0xDD,0x01,0x2F,0xF4,0x38,0x60,0xD5,0xD1,0x91,0x4D,0x97,0x84,0xE6,0x4B,0x4E,0x36,0xB2,0x10,0x67,0xCD,0x19,0xD9,0x2C,0x01,0x94,0xF1,0x78,0x66,0x33,0xEB,0x79,0xAF,0x7B,0x57,0x87,0x36,0xAF,0x52,0x08,0x9E,0x6B,0xEA,0x5A,0xB7,0x7A,0x94,0x73,0x45,0x47,0xAC,0x5A,0x9C,0xAF,0xFF,0x07};
const uint8_t spU[]             PROGMEM = {0xA1,0x9F,0x9C,0x94,0x72,0x26,0x8D,0x76,0x07,0x55,0x90,0x78,0x3C,0xEB,0x59,0x9D,0xA2,0x87,0x60,0x76,0xDA,0x72,0x8B,0x53,0x36,0xA5,0x64,0x2D,0x7B,0x6E,0xB5,0xFA,0x24,0xDC,0x32,0xB1,0x73,0x1F,0xFA,0x1C,0x16,0xAB,0xC6,0xCA,0xE0,0xB5,0xDF,0xCD,0xA1,0xD4,0x78,0x1B,0xB6,0x53,0x97,0x74,0xA7,0x21,0xBC,0xE4,0xFF,0x01};
const uint8_t spV[]             PROGMEM = {0x66,0xF3,0xD2,0x38,0x43,0xB3,0xD8,0x2D,0xAC,0x4D,0xBB,0x70,0xB0,0xDB,0xB0,0x0E,0x17,0x2C,0x26,0xAE,0xD3,0x32,0x6C,0xBB,0x32,0xAB,0x19,0x63,0xF7,0x21,0x6C,0x9C,0xE5,0xD4,0x33,0xB6,0x80,0xCB,0x9A,0x9B,0xAF,0x6C,0xE5,0x42,0x70,0x7F,0xB3,0xB3,0x9D,0xEE,0x7C,0x55,0x2B,0x26,0x40,0xD5,0xE2,0xD9,0xF6,0xB1,0x4F,0x75,0xAB,0x7B,0x3D,0xCA,0x35,0x4B,0x13,0x98,0xAF,0xA9,0x57,0x7E,0xF3,0x97,0xBE,0x19,0x0B,0x31,0xF3,0xCD,0xFF,0x03};
const uint8_t spW[]             PROGMEM = {0xA1,0xDE,0xC2,0x44,0xC2,0xFC,0x9C,0x6A,0x88,0x70,0x09,0x59,0x7B,0x8A,0xCA,0x3B,0x3D,0xA4,0xCF,0xCD,0x56,0x96,0xC4,0xA6,0xBB,0xF4,0x6E,0x59,0xE2,0x9D,0xEA,0xE2,0x4A,0xD5,0x12,0x65,0xBB,0xB3,0xEB,0x51,0x57,0x12,0x99,0xC1,0xD9,0x6E,0xB7,0xC7,0x31,0x35,0x92,0x6A,0xC9,0x9B,0xC7,0x34,0x4C,0x12,0x46,0x6C,0x99,0x73,0x5F,0xDA,0xD2,0x92,0x92,0x64,0x6C,0xEE,0x6B,0xD9,0x6A,0x22,0x71,0x8F,0xCF,0xE5,0x2C,0x41,0xD4,0xDD,0x36,0xA5,0x3B,0x19,0xF5,0x0C,0xEE,0x13,0xEF,0xFC,0x9A,0xD7,0x85,0xC8,0x62,0xEE,0x6D,0xBF,0xFF,0x07};
const uint8_t spX[]             PROGMEM = {0xAD,0x68,0xC9,0xC5,0x32,0x56,0xDF,0xFA,0x54,0x2D,0x35,0x7B,0xF8,0xEA,0x5B,0xDD,0xE6,0x4C,0x6D,0x04,0xA6,0xC5,0xEA,0xB9,0x84,0xB5,0x75,0x23,0x37,0x4F,0x83,0x40,0x11,0xCA,0x5D,0x44,0x36,0x00,0x28,0xA0,0xE6,0x31,0x0F,0x68,0xC0,0x00,0xBF,0x8D,0x79,0xC0,0x03,0x16,0xD0,0x00,0x07,0xFE,0x1F};
const uint8_t spY[]             PROGMEM = {0x6A,0xB1,0xA2,0xA7,0x95,0xD2,0xD8,0x25,0x0F,0xA3,0x2D,0xB2,0x7A,0x1C,0xB3,0xDE,0xE6,0xD4,0x45,0x6D,0x56,0xCA,0x9A,0x5B,0xDF,0xFA,0xB6,0xBB,0xDB,0xFD,0x1A,0x8A,0x6F,0x2B,0xF3,0x37,0x7B,0x19,0x4B,0xD3,0x25,0x39,0xFA,0xB9,0x6F,0x6D,0xEB,0x31,0xC4,0x5C,0x1E,0xF7,0xAD,0x1F,0xE5,0x1C,0xA5,0x48,0x5C,0x1E,0xD7,0x2B,0x5F,0xF9,0xFA,0x7F};
const uint8_t spZ[]             PROGMEM = {0x6D,0xFD,0xC6,0x5C,0x95,0xD5,0xF5,0xD5,0x02,0x7B,0x5D,0xFD,0x51,0x2D,0x2A,0xE4,0x77,0x75,0xA3,0x3A,0xB1,0xFA,0x9B,0x5D,0xEF,0x6A,0x55,0x33,0x27,0x60,0xD4,0xE2,0xD9,0xCC,0x76,0x4E,0x73,0x9D,0x7B,0x3F,0xFB,0x59,0xAE,0x55,0x0A,0xC1,0x73,0x4D,0xBD,0xEA,0x9D,0x9E,0x15,0x12,0xA0,0x6B,0x75,0x7E,0xFE,0x1F};
//const uint8_t spALPHA[]         PROGMEM = {0xAD,0xED,0x6A,0xDC,0x4B,0x57,0xEF,0xF6,0xB4,0x53,0x6C,0x6A,0x4B,0x97,0x53,0x77,0x7E,0x19,0xC9,0x9B,0x57,0x99,0xCC,0x7B,0x9A,0x6E,0x9E,0x45,0x2B,0xA2,0xA9,0x0A,0x91,0xCC,0xB5,0x00,0x02,0x14,0x67,0xA1,0x80,0x16,0x2C,0x3C,0x60,0x80,0xE6,0x2C,0x4A,0x51,0x54,0x47,0x38,0x6F,0xDE,0xC3,0x5D,0xF6,0x36,0xF7,0x7A,0xE5,0xFB,0xFF,0x01};
//const uint8_t spBRAVO[]         PROGMEM = {0x61,0x5A,0xBA,0xC2,0xDD,0x62,0x85,0xD6,0xE8,0x15,0x59,0xB1,0x97,0x9A,0x30,0xD5,0xBC,0x85,0xDF,0xA8,0x63,0x0F,0xE9,0x50,0xE5,0xA7,0xCA,0x6E,0x22,0x5D,0x57,0xEF,0x72,0x97,0xB3,0x2A,0x6D,0x74,0x15,0xE9,0xBA,0x3A,0xF6,0x66,0xE8,0x3E,0xD4,0x5C,0x65,0xD7,0x31,0x2D,0x95,0x54,0xBB,0x8B,0xDF,0xD9,0xAE,0xB1,0xA1,0xAC,0x0E,0x51,0x3F,0xE7,0xB6,0x14,0xD2,0x35,0x4E,0xEE,0xFB,0x5E,0x77,0xB3,0x7B,0xDF,0x19,0x2C,0x7D,0xEC,0xE9,0x2F,0x73,0x05,0xDF,0x19,0x2C,0x7D,0xF8,0xF3,0xFF};
//const uint8_t spCHARLIE[]       PROGMEM = {0x06,0xD8,0x2D,0x2C,0x01,0x33,0xB7,0x67,0x60,0xC4,0x35,0x94,0xAA,0x5A,0xEA,0x93,0x15,0xD7,0xAA,0x23,0xEE,0x56,0x9E,0xD3,0xAA,0x2E,0xE5,0xDB,0xF9,0xC8,0x4B,0x6A,0x8E,0xE3,0x3E,0x33,0x2F,0x45,0x6E,0x62,0x39,0x9A,0x76,0x74,0x4D,0xA5,0xA5,0x73,0xD2,0x3B,0xAC,0xA9,0xD9,0x61,0x0D,0xDF,0x32,0xE6,0xEE,0x0A,0x39,0xE3,0xF3,0x58,0x97,0x2D,0xC2,0x8C,0x2D,0x7D,0x4D,0xE7,0xCC,0x09,0x18,0xB5,0x38,0x5E,0xFE,0xFE,0x7F};
//const uint8_t spDELTA[]         PROGMEM = {0x02,0xE8,0x54,0x6D,0xB5,0x35,0x84,0xB9,0xDA,0x9A,0x5B,0x9F,0xAA,0x98,0x71,0x77,0xDB,0x7C,0x8A,0x64,0x2F,0x5C,0xBD,0xF7,0xCA,0x33,0x9F,0x4A,0x95,0x2C,0x2D,0xCB,0xD2,0xAA,0x95,0xDD,0x9A,0x7C,0x7B,0x15,0xD2,0x48,0x8C,0x40,0x11,0xCA,0x5D,0x44,0x36,0x28,0xE0,0x47,0x73,0x01,0x24,0xEA,0xB2,0xBA,0x6A,0xC2,0xC3,0x7C,0xCB,0x1D,0xCF,0xD6,0x54,0xA5,0x87,0x74,0xDD,0xE7,0xBA,0xAB,0x1A,0xF3,0x94,0xCE,0xFD,0xC9,0xEF,0xFF,0x03};
//const uint8_t spECHO[]          PROGMEM = {0x2B,0x6F,0xB1,0xD9,0xD3,0x36,0xDF,0xF6,0x36,0xB7,0x26,0x85,0x08,0xE5,0x2E,0x22,0x1B,0x20,0x00,0x25,0xAC,0x2A,0x20,0xCF,0xD3,0x52,0x45,0x53,0x6A,0xA9,0x9E,0x4F,0x9B,0x54,0x47,0xB9,0xE4,0xDF,0xC3,0x1C,0xC6,0x98,0x45,0x65,0xBB,0x78,0x9F,0xCB,0x5C,0xD2,0xEA,0x43,0x67,0xB0,0xE5,0xCD,0x7B,0x38,0x9D,0xAD,0x2C,0x15,0x37,0xF1,0xFC,0x7F};
//const uint8_t spFOXTROT[]       PROGMEM = {0x08,0x98,0xB1,0x53,0x02,0x1E,0x88,0xC0,0xCA,0x8B,0xDA,0x4A,0x97,0x2E,0xB7,0xBA,0xD5,0x2A,0x73,0xE8,0x48,0xD3,0xCD,0xAD,0xA8,0x35,0xA2,0xC5,0xAA,0x90,0x42,0x84,0x72,0x17,0x91,0x0D,0x0A,0xA8,0xA1,0xC5,0x01,0xAF,0xF8,0x78,0x40,0x01,0x6F,0xB5,0x23,0xA0,0x47,0x53,0x0C,0x44,0xC0,0x03,0xAD,0x49,0x85,0x53,0x53,0xDD,0x8D,0x26,0x56,0xCB,0x70,0xCD,0xB7,0xA6,0x64,0xC7,0x2B,0x39,0xEF,0x5A,0xAA,0xB8,0xF4,0xE2,0x3E,0xF3,0x1C,0x57,0x0E,0x1D,0x69,0xBA,0xD9,0x5F,0x08,0x14,0xA1,0xDC,0x45,0x64,0x03,0x80,0x00,0x8E,0xE0,0x30,0xC0,0xB2,0x53,0x04,0xA8,0xCA,0xE5,0xFF,0x01};
//const uint8_t spGOLF[]          PROGMEM = {0x0A,0x88,0xA1,0x71,0x15,0x85,0x76,0x45,0x8A,0xFF,0x9B,0xDF,0x6C,0x65,0x99,0x5C,0xB7,0x72,0xDE,0x9D,0xED,0x72,0x77,0x73,0x6C,0x4B,0x54,0x35,0x63,0xE4,0xA6,0xEE,0xF9,0x34,0x57,0x94,0x39,0x63,0xE4,0x86,0x5F,0x04,0x98,0x34,0xDD,0x02,0x0E,0x98,0x32,0x5D,0x03,0x12,0xE0,0xC0,0xFF,0x03};
//const uint8_t spHENRY[]         PROGMEM = {0x08,0xC8,0x4A,0x8C,0x03,0x1A,0x68,0x49,0x0B,0xAC,0xE5,0x11,0xFA,0x14,0xCD,0x35,0x59,0xC4,0xE3,0x5B,0xEC,0xBC,0xA5,0xD5,0x88,0x96,0x99,0xBD,0x9E,0x95,0x3C,0x1B,0xB3,0x64,0x69,0x1A,0xEB,0xD2,0xA7,0xA9,0x1C,0xE6,0xD1,0xDB,0x98,0x07,0xA7,0x5A,0xAA,0x5F,0x53,0x4D,0xAA,0x61,0x9E,0x7D,0xAC,0xDD,0x8E,0x48,0xC8,0x9E,0xB1,0x77,0x5B,0x44,0x95,0xAB,0xEB,0x15,0xAE,0x1E,0x0D,0x2D,0xF3,0x4D,0x7C,0xFC,0xF3,0xFF};
//const uint8_t spINDIA[]         PROGMEM = {0xA3,0x9D,0xD6,0x99,0x32,0x17,0xAF,0x66,0x86,0x16,0x74,0x5F,0x73,0x9A,0xE1,0x4A,0xC4,0xF4,0xCE,0xAD,0x46,0xD1,0x1D,0x5A,0x46,0x3A,0x99,0x45,0x2B,0xAA,0x82,0xAC,0x08,0x27,0xBE,0x5A,0xDD,0x0C,0x25,0x42,0xBC,0xFB,0xF4,0xD3,0x17,0x61,0xF8,0x96,0x3B,0xDC,0xF1,0x4C,0xDD,0x26,0x4B,0xD9,0x9E,0xBB,0xAC,0xB5,0xBB,0x36,0x0D,0xDA,0x7B,0xF6,0xA6,0xD3,0x3A,0xA5,0xF7,0x7E,0xE7,0x3B,0xBF,0xF2,0x55,0x17,0xD6,0xCE,0xAB,0xFD,0xFF,0xFF};
//const uint8_t spJULIET[]        PROGMEM = {0x61,0x5D,0x96,0x49,0x34,0xD2,0x06,0x60,0xC7,0x90,0x0C,0x8C,0x66,0xF6,0x15,0x22,0x4D,0x37,0xAA,0x6A,0xC8,0x2C,0x6D,0xCD,0x28,0xB2,0x15,0x8B,0xE4,0x35,0xB3,0x68,0x79,0x51,0xE6,0xDA,0x9C,0xBE,0x15,0x43,0x89,0xF0,0xA2,0xDB,0x95,0x77,0xA7,0xA6,0x66,0x49,0x77,0xB1,0x9A,0x9E,0x0A,0xD5,0x75,0xEB,0xEE,0xF6,0xB0,0xC6,0xE6,0x83,0xD2,0xE3,0xEB,0x5E,0xD7,0xDA,0x5C,0x48,0x87,0x6D,0x9E,0x7B,0xDF,0xF3,0x89,0x40,0x11,0xCA,0x5D,0x44,0x36,0x00,0x38,0x60,0xEA,0x8C,0x00,0x2C,0xB3,0x6D,0x01,0x01,0x14,0x5F,0x8E,0x81,0xFF,0x07};
//const uint8_t spLIMA[]          PROGMEM = {0x61,0x5A,0x90,0xBA,0xC0,0xD7,0xA6,0x69,0x00,0x19,0x85,0x6A,0xDA,0x9A,0xCD,0x24,0xD9,0xCC,0xCB,0x29,0x46,0x76,0x66,0xF5,0x37,0x3B,0x9B,0xC9,0x48,0x7B,0x50,0xD4,0x8E,0xD9,0xBD,0xA8,0x75,0x6B,0xB3,0x62,0xEE,0xF4,0xB8,0xB5,0xAD,0xFD,0x98,0x8A,0x51,0x0E,0x91,0xB4,0xA3,0x6F,0xBC,0x32,0x8B,0x3A,0xDF,0xE1,0xEE,0xE3,0xCC,0x6A,0x23,0x43,0x57,0xF5,0xA7,0xBE,0xF5,0xFD,0x7F};
//const uint8_t spMIKE[]          PROGMEM = {0x66,0x31,0x3C,0x7C,0x52,0xE3,0xC4,0x69,0xF5,0x85,0x57,0x86,0x51,0xAA,0xD3,0x56,0x75,0xA1,0x69,0x9D,0x6F,0x7D,0xCA,0x6A,0x57,0x23,0x6D,0xF5,0xCD,0x57,0xD1,0x4B,0x50,0x78,0x2C,0xDA,0x75,0x69,0x46,0x77,0xB4,0xCE,0xDB,0xB1,0x45,0xAD,0x08,0xE5,0x2E,0x22,0x1B,0x00,0x18,0xD0,0x3C,0x91,0x03,0x5A,0x09,0xB1,0x80,0x00,0xB2,0x13,0xFE,0x7F};
//const uint8_t spNOVEMBER[]      PROGMEM = {0x6A,0x2B,0x02,0x62,0x4B,0xE3,0xDA,0x75,0x2C,0x5D,0x87,0xB8,0x73,0x9B,0xD5,0x66,0x1D,0x16,0x66,0x7D,0x57,0x9B,0x45,0x59,0x07,0xB7,0x6B,0x55,0xB0,0x99,0xCD,0x9C,0xAD,0x56,0xA1,0x88,0xCE,0x3A,0x99,0x33,0xFB,0xC5,0xCC,0xD5,0xA8,0xA5,0xA9,0x1B,0xDF,0x8E,0xBA,0x05,0xB3,0x34,0xED,0x7C,0xCB,0x9B,0x8F,0xAC,0x38,0xCB,0x0C,0x6D,0x5C,0xB2,0xA2,0x94,0xDA,0xCD,0x4D,0x2C,0x55,0x2B,0x75,0x4A,0xA7,0xBB,0xD5,0x3D,0xA4,0x2D,0x77,0xE5,0x2A,0xEE,0x9C,0xD7,0xB4,0x65,0x77,0xA0,0x9B,0xFA,0xE2,0x9E,0xAE,0x5C,0x0B,0xAA,0xD4,0xB7,0xBF,0xFD,0x6D,0x9E,0xE2,0x1A,0x7C,0x43,0xAF,0x7A,0xCB,0x30,0xCA,0xE6,0x2D,0xFF,0x0F};
//const uint8_t spOSCAR[]         PROGMEM = {0x6B,0xC8,0xE2,0xB2,0x42,0x3A,0xDF,0xFA,0x16,0x27,0x4F,0xAE,0x7D,0xC4,0x17,0xB7,0x2C,0x45,0xAF,0xA4,0xB6,0x6D,0x80,0x03,0xD8,0x0C,0xF0,0xA7,0x9B,0x07,0x3C,0xE0,0x80,0xEB,0xB5,0xC1,0x6C,0x4D,0x5D,0x45,0x69,0xDC,0xD4,0x17,0x37,0x49,0x26,0x4A,0x5B,0x9B,0x53,0x91,0x0D,0xE7,0x9D,0xFD,0x1C,0xDB,0x92,0x9B,0x61,0xB5,0xF4,0x9E,0x5B,0xDD,0xEB,0x99,0xEE,0x12,0x07,0x75,0x52,0x6F,0xFE,0xC2,0x5F,0x5A,0x91,0x0E,0x67,0xF9,0x7F};
//const uint8_t spPAPA[]          PROGMEM = {0x0A,0x70,0x4A,0xB5,0xA5,0x45,0x55,0x84,0x49,0xCC,0x93,0x66,0xD7,0x19,0x26,0x4B,0x4E,0x96,0xDD,0x44,0xBA,0xAE,0xBE,0xD9,0xCC,0x10,0x28,0x42,0xB9,0x8B,0xC8,0x06,0x60,0x80,0xF1,0xE9,0xAB,0xCA,0xA6,0x23,0xD4,0x36,0xDF,0xE1,0x8C,0x55,0x74,0x86,0x6B,0x9F,0xB1,0x67,0xBD,0xE1,0xE6,0xBB,0xDB,0x97,0x53,0x45,0x88,0xCF,0xAE,0xDF,0xFF,0x03};
//const uint8_t spQUEBEC[]        PROGMEM = {0x0C,0x88,0x7E,0x8C,0x02,0xA5,0x0A,0x31,0xDD,0x5C,0xB2,0xAC,0x26,0x5B,0xCF,0x4C,0xEE,0xBB,0xBB,0xDE,0xA7,0xCD,0xA8,0xB4,0x75,0x4D,0x1C,0xB7,0xD1,0xD5,0x28,0xEE,0xE6,0x5B,0x76,0x7B,0x9A,0x1A,0xC4,0x33,0xF3,0xF1,0x6D,0x76,0x3F,0xE7,0xB6,0xB6,0xEC,0x12,0x91,0x9B,0xF2,0x8E,0x40,0x11,0xCA,0x5D,0x44,0x36,0x80,0x00,0x7A,0x2F,0x53,0x40,0x2D,0x24,0x14,0xF8,0x7F};
//const uint8_t spROMEO[]         PROGMEM = {0xA2,0xD5,0x39,0x38,0xCA,0xEC,0xDB,0xA5,0x4C,0xA1,0x98,0x5A,0xB9,0xF2,0xD3,0x47,0x6F,0xE9,0x69,0xCA,0x4E,0xDD,0x89,0x57,0x0E,0x69,0x3F,0x45,0x61,0xD9,0x95,0x98,0x65,0x67,0x25,0x6B,0x86,0x64,0x4C,0xAC,0xF5,0xE2,0x54,0xCD,0x86,0x7A,0xD0,0xE6,0x35,0x4C,0xD7,0x02,0xA5,0x7B,0xF6,0xB0,0xA7,0xBD,0xAC,0xB5,0xAA,0x54,0x1D,0xDB,0xB2,0xF6,0xEC,0xC3,0xD3,0x64,0x73,0xD9,0x63,0xC8,0x2C,0xD5,0xDF,0xE9,0x0C,0xA1,0x33,0xD8,0xF2,0xE6,0x33,0x5E,0xEE,0x09,0xB6,0xB2,0x54,0xDC,0xF8,0xE7,0xFF,0x01};
//const uint8_t spSIERRA[]        PROGMEM = {0x0C,0xF8,0xAD,0xDC,0x02,0x1E,0xB0,0x80,0x06,0x4A,0xDE,0x7D,0x90,0xB8,0xBD,0x1E,0xD5,0xC8,0x45,0xE8,0xF6,0x76,0x56,0xB3,0xDE,0xF5,0xAD,0x4F,0x35,0x72,0xB1,0xB8,0xAE,0x39,0x65,0x0F,0x45,0x56,0xFA,0xE5,0xE4,0x25,0x24,0xE5,0xC8,0xE6,0x91,0xC6,0xC9,0x99,0x6E,0x69,0x7B,0xDA,0xF3,0xD5,0xA4,0xA4,0x95,0x6E,0x5D,0xF6,0xB0,0xB7,0xB5,0x17,0x5B,0xD6,0x2A,0x9B,0xC7,0x9D,0x5D,0x5B,0x9B,0xEF,0xEA,0x77,0x7D,0xCA,0x5F,0x55,0xD9,0x94,0xF4,0xFE,0x7F};
//const uint8_t spTANGO[]         PROGMEM = {0x0E,0x58,0x5A,0xC3,0x02,0x27,0xEB,0xA1,0xC4,0x2B,0x97,0xDC,0xF2,0x16,0x27,0xEF,0x51,0xB9,0x2A,0x2B,0xEF,0xAC,0x64,0x3D,0x60,0x79,0x99,0xE2,0x52,0x74,0x8F,0x9E,0x56,0xAA,0x43,0x99,0x24,0x75,0x5A,0x3A,0x0E,0x4D,0x31,0xC1,0xAC,0x96,0x24,0xCD,0x35,0x96,0x38,0xC9,0xAA,0xD6,0x25,0x17,0x96,0xA6,0xBB,0xE7,0xB0,0xA6,0x2C,0x2A,0xDB,0xC5,0xFB,0x9E,0xE6,0x92,0x76,0x1F,0x3A,0x83,0x2D,0x6F,0x3C,0xC3,0xE5,0x6C,0x65,0xA9,0xB8,0xF1,0xB7,0xBD,0xFF,0x1F};
//const uint8_t spUNIFORM[]       PROGMEM = {0x61,0x3D,0x56,0x98,0xD4,0xB6,0xE6,0xA5,0x8D,0xC7,0xA8,0x01,0xC5,0xDA,0x33,0x2C,0x97,0x06,0x12,0xD9,0x4F,0xD9,0x6D,0x30,0xA6,0x65,0xDF,0x79,0x4B,0x8B,0x11,0xCF,0xE0,0xAE,0x29,0xCD,0x4E,0x5D,0x38,0xEA,0xF5,0xF4,0x64,0x45,0x47,0x84,0xCA,0xE6,0x5D,0xF5,0x96,0x01,0xCD,0x97,0x6A,0x40,0x03,0x1A,0x28,0x5D,0xD0,0xDB,0x61,0xEC,0x7D,0xF7,0x7B,0x3C,0x53,0x16,0xDB,0x9A,0xEA,0xF5,0x2E,0x6B,0x2D,0x6A,0x43,0x46,0xBC,0xCD,0xB3,0x3D,0xD9,0xB5,0xDA,0x70,0xDF,0x72,0xE7,0x94,0xEA,0xCD,0x9D,0xDD,0x9D,0xBC,0x73,0xA9,0x28,0x35,0x4F,0x12,0x41,0xE1,0x96,0xD4,0x3D,0x4D,0x24,0xA7,0x8A,0x94,0xF8,0xFA,0x37,0x7C,0xCD,0x76,0x78,0x50,0xEA,0xF8,0xFD,0x3F};
//const uint8_t spVICTOR[]        PROGMEM = {0x6E,0x2D,0xCA,0xD8,0x43,0xD5,0x99,0xBD,0x58,0xE6,0x70,0xF1,0x9A,0x97,0xD5,0xB6,0x54,0xAA,0x26,0x7D,0x6E,0xB5,0xB2,0xD6,0x8D,0x4D,0x74,0xCB,0x4E,0x4D,0x3C,0xB2,0xAA,0x8B,0x38,0x16,0x40,0xE5,0x8C,0x18,0x40,0xA0,0x08,0xE5,0x2E,0x22,0x1B,0x0C,0xB0,0xED,0xA4,0x02,0xAA,0x15,0x5A,0x43,0xF5,0x21,0x54,0x96,0x6D,0x2C,0xA5,0x26,0x7A,0xB9,0xB7,0xBE,0xA5,0x27,0x57,0x87,0x2E,0xF7,0x1F,0xFE,0xDC,0x49,0xBB,0xBC,0x6F,0xFC,0xFD,0xEF,0xFF,0xFF,0x07};
//const uint8_t spWHISKY[]        PROGMEM = {0x04,0x88,0xAE,0x8C,0x03,0x12,0x08,0x51,0x74,0x65,0xE9,0xEC,0x68,0x24,0x59,0x46,0x78,0x41,0xD7,0x13,0x37,0x6D,0x62,0xC3,0x5B,0x6F,0xDC,0xD2,0xEA,0x54,0xD2,0xE3,0x89,0x01,0x7E,0x2B,0xF7,0x80,0x07,0x14,0xD0,0xE5,0x15,0x38,0x60,0x8C,0x70,0x03,0x04,0x29,0x36,0xBA,0x5E,0x14,0x34,0x72,0xF6,0xE8,0xA7,0x6F,0x82,0xF4,0x2D,0x73,0xEA,0x47,0x3A,0x67,0x6A,0xC0,0xF0,0x2F,0xF1,0x4E,0xCF,0xA8,0x8A,0x1C,0xB9,0xD8,0xFF,0xEE,0x1F,0xBB,0x59,0xD0,0xD6,0xFE,0x3F};
//const uint8_t spXRAY[]          PROGMEM = {0x69,0xAE,0xDE,0x34,0x3A,0x6B,0x9F,0xAC,0xA5,0x66,0x0F,0x5F,0x7D,0x8B,0x5B,0xAD,0xAA,0x8D,0xC0,0xB4,0x58,0xDD,0xDB,0xD0,0xB6,0x6E,0xE4,0xE6,0x69,0x10,0x28,0x42,0xB9,0x8B,0xC8,0x06,0x10,0x40,0xCD,0x63,0x1A,0x60,0xC0,0x6F,0x63,0x1C,0xA0,0x00,0x5B,0xFD,0x54,0xEA,0x54,0xE7,0x66,0x4E,0x8D,0xC3,0xD3,0xF4,0xE6,0xA9,0x4F,0x6B,0xAE,0x2E,0x39,0x42,0xFB,0xEE,0x6D,0x1C,0xCD,0x24,0x45,0xF9,0xE7,0x7E,0xF6,0x33,0x5F,0xF9,0x0A,0xCF,0xB4,0x4B,0x94,0xBE,0x27,0x3E,0xF1,0x75,0xEF,0xCC,0x09,0x18,0xB5,0xF8,0xFF,0x01};
//const uint8_t spYANKEE[]        PROGMEM = {0x6E,0xEF,0x42,0x58,0xB6,0x6B,0xA7,0x7D,0x68,0x25,0xCC,0x59,0xB4,0xF6,0x11,0x82,0xC8,0x6A,0xF1,0x1A,0x46,0x2E,0x12,0x8D,0x37,0xA7,0xEF,0xC9,0xC9,0xA3,0x6E,0x9F,0x76,0xD4,0x22,0x73,0x7F,0xB4,0xEA,0x51,0x0B,0x2D,0x62,0xE2,0xA8,0x47,0x43,0xD7,0x2E,0x29,0xAE,0x4D,0x92,0xAA,0x28,0x5C,0x8B,0xB9,0x6A,0xEB,0x24,0x95,0xE3,0x80,0x1D,0x93,0x35,0x90,0xBA,0x59,0x03,0x45,0xB3,0x75,0x19,0x46,0x27,0x96,0x98,0xC5,0x65,0x1F,0xCD,0x88,0xBC,0x16,0xD7,0x3D,0x3D,0x63,0x10,0x49,0x6E,0xED,0xF8,0xFA,0xEF,0xFF,0x01};
//const uint8_t spZULU[]          PROGMEM = {0x6D,0xFE,0xDE,0xC4,0xC4,0xE8,0x29,0x60,0x00,0x2E,0x0F,0x9C,0x6C,0x29,0x71,0x2A,0x4E,0x77,0x93,0x15,0x77,0x2A,0xAE,0xC3,0xCE,0x76,0x3C,0x92,0xA5,0x44,0x78,0xD1,0x6D,0xCF,0x47,0x3B,0xB8,0xBB,0x07,0xF6,0x5B,0x43,0x91,0x6E,0xA9,0xF2,0x65,0x4C,0xC9,0x98,0x97,0x69,0x9F,0xBA,0xE5,0x33,0x9C,0xC1,0x9A,0x8F,0xCA,0xDE,0x70,0x07,0x9D,0xEE,0xC9,0x79,0xE2,0xED,0xFF,0xFF,0x07};
//const uint8_t spTHE[]           PROGMEM = {0x6E,0xAD,0xCC,0x34,0x9C,0x97,0xE8,0x23,0xED,0x5D,0xA4,0xBB,0xF1,0x96,0xD9,0xEE,0xFA,0xD4,0x45,0x75,0xA6,0xC9,0xE6,0x5B,0xDF,0xE6,0x0E,0x67,0xAE,0x7C,0xD3,0x43,0xFB,0xEC,0x7D,0x9E,0xFD,0xFE,0x7F};
const uint8_t spWATTS[]         PROGMEM = {0xAA,0x15,0x7A,0x23,0x5C,0x12,0xE9,0xD1,0x0D,0x5A,0x76,0x75,0xB2,0xAA,0xD0,0x3B,0xD9,0xED,0x81,0x99,0x4A,0x1B,0xD5,0x8C,0x25,0xFA,0xDD,0xF5,0xA9,0xA3,0x9F,0x2C,0xE3,0x2E,0xB7,0xBE,0xCD,0xEE,0xD6,0x9C,0xDC,0x44,0xAB,0xAD,0x6E,0x67,0x0E,0xE9,0xCD,0x7D,0xBB,0x1E,0x0C,0x1C,0x24,0xCA,0x5C,0x59,0x03,0x00,0x01,0xB6,0x2A,0x15,0xC0,0x2F,0x19,0x1A,0xB0,0x80,0x05,0x2C,0x60,0x80,0xAF,0xA2,0x24,0xF0,0xFF};
const uint8_t spMETER[]         PROGMEM = {0xA1,0x8F,0x5C,0xB5,0x56,0x92,0xE4,0xE1,0xF4,0xDD,0x0B,0x59,0x6B,0xE3,0x53,0x8C,0x14,0x44,0x15,0x8B,0x46,0x3A,0xB3,0x03,0x7B,0xBE,0x99,0x89,0x49,0xB7,0x72,0xC4,0xEA,0x4C,0x01,0xD8,0x2E,0xC8,0x03,0xA3,0xAB,0x91,0x39,0x2C,0x17,0x8D,0xAE,0x36,0xE6,0x34,0x7F,0x3D,0xE6,0xEA,0x13,0x6C,0x79,0x73,0x3B,0xAA,0x1B,0xB0,0xD3,0x3C,0xFD,0x6A,0x4F,0xF1,0x09,0x35,0x9E,0xA5,0xBE,0xFF,0x0F};
//uint8_t spDANGER[]        PROGMEM = {0x2D,0xBF,0x21,0x92,0x59,0xB4,0x9F,0xA2,0x87,0x10,0x8E,0xDC,0x72,0xAB,0x5B,0x9D,0x62,0xA6,0x42,0x9E,0x9C,0xB8,0xB3,0x95,0x0D,0xAF,0x14,0x15,0xA5,0x47,0xDE,0x1D,0x7A,0x78,0x3A,0x49,0x65,0x55,0xD0,0x5E,0xAE,0x3A,0xB5,0x53,0x93,0x88,0x65,0xE2,0x00,0xEC,0x9A,0xEA,0x80,0x65,0x82,0xC7,0xD8,0x63,0x0A,0x9A,0x65,0x5D,0x53,0xC9,0x49,0x5C,0xE1,0x7D,0x2F,0x73,0x2F,0x47,0x59,0xC2,0xDE,0x9A,0x27,0x5F,0xF1,0x8B,0xDF,0xFF,0x03};
//const uint8_t spPRESSURE[]      PROGMEM = {0x06,0x28,0xC1,0x4C,0x03,0x2D,0x49,0x59,0x4A,0x9A,0x3D,0x9F,0xAC,0x04,0x2D,0x2D,0x69,0x73,0xB2,0x56,0x4C,0x43,0x6D,0xF5,0xCD,0x5A,0x3E,0x6A,0x89,0x09,0x65,0x71,0xC0,0xAA,0xDB,0x1E,0x88,0x40,0x04,0x46,0xDF,0x63,0x0A,0x9A,0x65,0x1D,0x43,0xC9,0x49,0x5C,0xE1,0x7D,0xCF,0x7B,0x9F,0x47,0xB9,0xCA,0x12,0xF6,0xD6,0x3C,0xF9,0x8B,0x9F,0xFD,0xFF,0x1F};
const uint8_t spCHANGE[]        PROGMEM = {0x06,0x58,0xD5,0xC3,0x01,0x73,0x6E,0x64,0xC0,0x03,0x2B,0x1B,0xB9,0x95,0xDC,0xFB,0xDE,0xE2,0x14,0xA3,0x06,0x4B,0xE5,0xA2,0x9B,0xEF,0x7C,0x95,0xC3,0x1B,0xCA,0x64,0xA5,0x5D,0xED,0x76,0xCE,0x7D,0x2D,0x6B,0xB3,0x24,0x19,0x11,0x3A,0x1D,0xDD,0x93,0x94,0x7A,0x54,0x7F,0xBA,0xBB,0x4B,0xC5,0x08,0xAD,0x1A,0x9E,0xEE,0x85,0x43,0x2D,0x9E,0x79,0xAA,0x10,0xCA,0xD2,0x2A,0xEA,0xC9,0x82,0xAC,0xC3,0x6B,0xCB,0x87,0x3D,0x51,0xB2,0x75,0x74,0x2D,0xF4,0xCE,0x30,0x2C,0x62,0x76,0x14,0x30,0x94,0x92,0x02,0xC6,0x5C,0xB7,0x00,0x02,0x5A,0x17,0xF9,0x7F};
//const uint8_t spMINUS[]         PROGMEM = {0xE6,0x28,0xC4,0xF8,0x44,0x9A,0xFB,0xCD,0xAD,0x8D,0x2A,0x4E,0x4A,0xBC,0xB8,0x8C,0xB9,0x8A,0xA9,0x48,0xED,0x72,0x87,0xD3,0x74,0x3B,0x1A,0xA9,0x9D,0x6F,0xB3,0xCA,0x5E,0x8C,0xC3,0x7B,0xF2,0xCE,0x5A,0x5E,0x35,0x66,0x5A,0x3A,0xAE,0x55,0xEB,0x9A,0x57,0x75,0xA9,0x29,0x6B,0xEE,0xB6,0xD5,0x4D,0x37,0xEF,0xB5,0x5D,0xC5,0x95,0x84,0xE5,0xA6,0xFC,0x30,0xE0,0x97,0x0C,0x0D,0x58,0x40,0x03,0x1C,0xA0,0xC0,0xFF,0x03};
const uint8_t spNOT[]           PROGMEM = {0x66,0x6B,0x1A,0x25,0x5B,0xEB,0xFA,0x35,0x2D,0xCD,0x89,0xA7,0xDA,0x9A,0x31,0x34,0x93,0x9E,0xA6,0x4B,0x4E,0x57,0xE5,0x86,0x85,0x6C,0xBE,0xED,0x6D,0x57,0x93,0xFC,0xB9,0x96,0x2D,0x1E,0x4D,0xCE,0xAD,0xE9,0x3E,0x7B,0xF7,0x7D,0x66,0xB3,0x08,0xE5,0x2E,0x22,0x1B,0x00,0x40,0x01,0x4B,0xB8,0x2B,0xE0,0x87,0x68,0x05,0x74,0x9D,0x82,0x80,0x62,0x55,0xFE,0x1F};
//const uint8_t spSTART[]         PROGMEM = {0x04,0xF8,0xC5,0x9C,0x03,0x1A,0xD0,0x80,0x04,0x38,0x00,0x06,0x58,0x22,0x7D,0x65,0x9D,0x87,0x8B,0x5B,0xD7,0x53,0x67,0x37,0x96,0x21,0x79,0x6F,0x7D,0xEB,0xD5,0x64,0xB7,0x92,0x43,0x9B,0xC7,0x50,0xDD,0x92,0x1D,0xF7,0x9E,0x53,0xDF,0xDD,0x59,0xCB,0x21,0xAD,0xF6,0x46,0xA0,0x08,0xE5,0x2E,0x22,0x1B,0x40,0x01,0xDD,0xB2,0x2A,0xE0,0xB7,0x0C,0x03,0x4C,0x9D,0x4A,0x80,0xEA,0x54,0xFE,0x1F};
const uint8_t spLINE[]          PROGMEM = {0x61,0xED,0x40,0xC7,0xCD,0xD2,0x96,0x65,0x01,0x9E,0x50,0x73,0x5B,0x96,0x83,0x70,0x87,0x2D,0xD9,0x9A,0x3B,0xA9,0x49,0x97,0x2E,0xB7,0xBF,0xDD,0x6D,0x4F,0x5B,0xD5,0xBA,0x95,0x75,0xD9,0xFD,0x1A,0x86,0x6B,0xD6,0x8A,0xC5,0x7B,0x9A,0xF3,0x3C,0xFA,0x51,0xAE,0x9E,0x59,0x55,0x2A,0x72,0xBE,0xC2,0x35,0x12,0xB9,0x88,0xBB,0x89,0x57,0xB8,0x7A,0x72,0x77,0xB0,0x3A,0xE9,0xEF,0x2E,0xC5,0xDD,0x1F,0x87,0xBF,0x8A,0xD0,0xEA,0x68,0xF8,0xFF};
//const uint8_t spOFF[]           PROGMEM = {0x6B,0x4A,0xE2,0xBA,0x8D,0xBC,0xED,0x66,0xD7,0xBB,0x9E,0xC3,0x98,0x93,0xB9,0x18,0xB2,0xDE,0x7D,0x73,0x67,0x88,0xDD,0xC5,0xF6,0x59,0x15,0x55,0x44,0x56,0x71,0x6B,0x06,0x74,0x53,0xA6,0x01,0x0D,0x68,0x80,0x03,0x1C,0xF8,0x7F};
//const uint8_t spTIME[]          PROGMEM = {0x0E,0xD8,0x5A,0x2D,0x00,0x37,0xA6,0x39,0xA0,0x9B,0xB0,0x95,0x17,0x9B,0x1E,0x21,0x2D,0x4F,0x51,0xF4,0x86,0x25,0x6F,0xB9,0xD5,0xA9,0xBB,0x9E,0xE0,0xD6,0x36,0xB7,0xBE,0xED,0x1E,0xD6,0xDC,0x5D,0x29,0xB7,0xAF,0xDE,0x6B,0xDD,0xCB,0xDE,0xB4,0xB1,0xAB,0xD6,0xC9,0x67,0x3C,0xDD,0x35,0x85,0x73,0x98,0xD8,0xFD,0x7F};
const uint8_t spAUTOMATIC[]     PROGMEM = {0x6B,0xAC,0xA4,0xA7,0x82,0xFD,0xDD,0xF1,0x0E,0x67,0x68,0xB2,0xA2,0x83,0x72,0x1B,0xA0,0x52,0x65,0x03,0xFC,0x24,0x3A,0xEA,0xAD,0xCD,0xD5,0x4C,0xDB,0xA9,0xAB,0x76,0x4B,0x93,0x2D,0x67,0x28,0xA2,0xCC,0xC2,0xF3,0x8C,0x21,0x2B,0xD7,0x70,0xC9,0xD8,0x86,0x4A,0x8D,0xC6,0x35,0x49,0xE9,0x8B,0x54,0x29,0x76,0x37,0x63,0xC8,0xCE,0xDD,0x54,0x6A,0x9D,0xBA,0xC6,0xD2,0xD2,0x58,0x72,0xAB,0x5B,0xDE,0x72,0x35,0x35,0x5B,0x84,0x54,0x6D,0xD3,0xEE,0x90,0x11,0xEA,0x4E,0x5A,0x5B,0x53,0xAA,0xB3,0x2F,0xB9,0xD3,0x59,0xBB,0x6B,0xE5,0x94,0x35,0x7B,0x6F,0xE7,0x34,0xAD,0xD8,0xBA,0x17,0x81,0x22,0x94,0xBB,0x88,0x6C,0x00,0x03,0xB4,0x12,0x22,0x01,0x0E,0xFC,0x3F};
const uint8_t spWEIGHT[]        PROGMEM = {0x62,0x13,0x7E,0x23,0x4C,0x22,0xEB,0x4D,0xAD,0x46,0x7F,0x5A,0xB0,0x95,0xB4,0x38,0xF3,0xA1,0x4E,0x6D,0xD6,0x94,0xCC,0x9A,0x3B,0x6D,0x39,0x7D,0xF3,0xC1,0x99,0xF2,0xE6,0xB4,0x23,0x0E,0x51,0xF8,0x9A,0xDB,0x8E,0x6E,0xE4,0x04,0xC9,0x7C,0xDC,0x17,0x75,0x8C,0x26,0xA8,0x56,0x8B,0x11,0x28,0x42,0xB9,0x8B,0xC8,0x06,0x00,0x00,0x01,0xBC,0xC0,0x66,0x80,0x1F,0x73,0x04,0xB0,0xDD,0x34,0x02,0x46,0xE9,0xF8,0x7F};
//const uint8_t spSMOKE[]         PROGMEM = {0x08,0xF8,0xBB,0x4D,0x02,0x0A,0x78,0x33,0xCC,0x03,0x1E,0x40,0x40,0x53,0x1A,0x22,0xC8,0x92,0x35,0x87,0x92,0xD4,0x74,0x95,0x99,0x55,0x7B,0x52,0xB7,0x5D,0xEE,0x72,0x57,0xAD,0xF7,0x6E,0xA2,0x84,0xFB,0xD6,0xD1,0x6D,0x4E,0x6E,0x84,0xA3,0x37,0x84,0x8B,0x50,0xEE,0x22,0xB2,0x01,0x80,0x01,0x75,0x14,0x7B,0x80,0x01,0x39,0x98,0xFC,0x3F};
//const uint8_t spABORT[]         PROGMEM = {0x63,0xC9,0xA6,0x2A,0x54,0xD7,0x9C,0xA5,0xF0,0xEC,0x0A,0xCA,0xBB,0x67,0xB6,0x1B,0xD9,0xA6,0xAA,0x59,0xE9,0x46,0x8E,0x20,0xC2,0x83,0x25,0x0B,0x39,0x1D,0x4D,0x4D,0x77,0x37,0x76,0x1A,0x55,0x54,0x53,0xA9,0x94,0x65,0x17,0xAB,0xC8,0xAC,0xDA,0x53,0xB9,0xEF,0x72,0x35,0x51,0x5E,0x58,0xAB,0xFE,0xD5,0x66,0xB5,0x12,0x23,0xFA,0xD7,0x94,0x63,0x53,0x95,0xF8,0x69,0x6B,0xEE,0x4E,0x51,0xE2,0x2F,0x6C,0xB9,0x13,0x57,0x59,0x7F,0x04,0x8A,0x50,0xEE,0x22,0xB2,0x01,0x1C,0xB0,0x9D,0xBA,0x03,0x7E,0x0F,0x53,0xC0,0x48,0x53,0x08,0x88,0xD2,0xEC,0xFF,0x01};
//const uint8_t spCALL[]          PROGMEM = {0x02,0x48,0xA5,0xD8,0x02,0x1A,0x18,0x71,0x16,0x15,0x95,0xA4,0x7A,0x65,0x95,0xD5,0x44,0x88,0xFB,0x5B,0xDC,0x62,0x95,0x49,0x4E,0xA7,0x49,0xB6,0x5D,0xED,0x76,0x76,0x73,0x9A,0x4B,0xD9,0x83,0xBD,0x2A,0xB4,0xCE,0xF5,0x0A,0x77,0x50,0xB9,0x25,0x92,0x25,0xDE,0xE1,0x49,0xC2,0x77,0x44,0x5D,0xFB,0xEF,0xFF,0x01};
//const uint8_t spCYCLE[]         PROGMEM = {0x08,0xF8,0xB3,0x5C,0x03,0x16,0xB0,0x80,0x06,0x56,0x55,0x64,0xB9,0xBB,0xB7,0x39,0x4D,0x71,0xA5,0x15,0xBA,0xF8,0x36,0xBB,0x19,0x75,0xCB,0x8A,0xED,0x35,0xB1,0xB7,0xAC,0x15,0xA1,0xDC,0x45,0x64,0x03,0x03,0xE2,0x10,0x2A,0x53,0x54,0xE3,0x69,0xDC,0x79,0xAD,0x1D,0x67,0x57,0xB0,0xB7,0x76,0x6C,0xAC,0xDD,0xC9,0xEC,0xDB,0xD5,0x70,0x4C,0x07,0x69,0xCD,0x8F,0x7B,0x13,0x9B,0x49,0xA1,0xBC,0xFE,0xFB,0x7F};
const uint8_t spDISPLAY[]       PROGMEM = {0x04,0x88,0xD0,0x63,0x2C,0x53,0xB5,0xB1,0x52,0x9F,0x3B,0xDF,0x79,0x4F,0x65,0xF8,0xCE,0x5D,0x4D,0xB9,0x29,0xE0,0xCF,0x52,0x0B,0x78,0x40,0x03,0x08,0xC8,0xDC,0x15,0x40,0x02,0xA9,0x2D,0x4A,0x6A,0x45,0xEC,0xB5,0xB6,0xA0,0xCA,0x71,0x4C,0x73,0xEA,0xCA,0x3B,0xC2,0xA5,0xCB,0xAD,0x6E,0x75,0x9A,0xA6,0x93,0xAD,0x62,0xF3,0xED,0xEE,0xB4,0x96,0x1E,0x13,0x25,0x7D,0xF3,0xDE,0xFB,0xDE,0xCE,0xE6,0x15,0xA3,0x6A,0x55,0x7D,0xCA,0x3B,0x62,0x22,0x67,0x6C,0xCE,0xDF,0xFF,0x03};
const uint8_t spEQUAL[]         PROGMEM = {0x6D,0x18,0x49,0x91,0xBC,0x17,0xEF,0x6E,0x15,0xA3,0x15,0xA2,0xE5,0x93,0x9D,0xB5,0x7C,0x6C,0x07,0xB6,0x7C,0x1C,0xF2,0x11,0x19,0xAC,0xB2,0x0E,0x02,0x45,0x28,0x77,0x11,0xD9,0x00,0x04,0xF0,0xA3,0x88,0x01,0xBE,0x65,0xB4,0x36,0xC8,0x8D,0x08,0xF4,0x33,0xBB,0x39,0xB4,0xB5,0xE2,0xAE,0x0E,0xF2,0xDB,0xD7,0x7A,0xA4,0x33,0xD3,0xEA,0x0E,0xF0,0x9B,0xCE,0xC8,0xAE,0x92,0x24,0x77,0xB8,0x33,0xF8,0x68,0xE6,0xD6,0xF1,0xFE,0x7F};
const uint8_t spFAST[]          PROGMEM = {0x08,0x68,0xD6,0x55,0x02,0x0A,0x18,0x22,0x5D,0x02,0x1A,0x58,0x45,0x75,0xA3,0x5E,0xFA,0xE6,0x96,0xB7,0x39,0x6D,0xD3,0xA3,0xD6,0xBA,0xFA,0xF6,0x6B,0xAE,0xAE,0xA4,0xCA,0xEE,0xAC,0xAD,0x99,0xD1,0x28,0x5B,0x5C,0x8E,0xE2,0x4A,0x2B,0xFD,0x4E,0xBE,0xE2,0x85,0x80,0x25,0x5B,0x39,0xC0,0x80,0xDF,0x32,0x24,0xA0,0x01,0x0B,0x58,0x80,0x02,0xC0,0x80,0x3B,0x4C,0x14,0xF0,0xBC,0x38,0x03,0x96,0xDD,0xF9,0x7F};
const uint8_t spABOUT[]         PROGMEM = {0x63,0xCF,0xA6,0x2A,0x54,0xD7,0xDC,0x6D,0xAD,0x85,0x67,0x57,0x50,0x5E,0x76,0x1A,0xD9,0xA6,0xAA,0x59,0xF9,0x26,0xB6,0x20,0xC2,0x83,0x25,0x0B,0x5B,0x1C,0x4D,0x4D,0x77,0x37,0xA1,0x6F,0xD4,0x45,0xCD,0xB2,0xAC,0xBE,0x98,0xCD,0x34,0xDD,0x72,0xDA,0xAA,0xDA,0x2B,0x79,0xCD,0x6D,0x6F,0x77,0xC7,0xBD,0x94,0x23,0xA4,0xCE,0x22,0xDB,0x15,0x8F,0xF0,0x45,0xEB,0x55,0xC2,0x79,0xC4,0x2F,0x42,0xB9,0x8B,0xC8,0x06,0x00,0x03,0x4C,0xA7,0xEE,0x80,0xD7,0x53,0x09,0x50,0x83,0xCB,0xFF,0x03};
const uint8_t spGO[]            PROGMEM = {0x06,0x08,0xDA,0x75,0xB5,0x8D,0x87,0x4B,0x4B,0xBA,0x5B,0xDD,0xE2,0xE4,0x49,0x4E,0xA6,0x73,0xBE,0x9B,0xEF,0x62,0x37,0xBB,0x9B,0x4B,0xDB,0x82,0x1A,0x5F,0xC1,0x7C,0x79,0xF7,0xA7,0xBF,0xFE,0x1F};
const uint8_t spINCH[]          PROGMEM = {0x23,0x1B,0xD6,0x48,0x2A,0x67,0x9F,0x76,0xC4,0x20,0x89,0xBC,0x7D,0xEB,0x53,0x8F,0x90,0xEC,0x12,0xB7,0x77,0xBB,0xC6,0xEE,0x55,0x92,0x6B,0x72,0x59,0xAA,0x82,0x28,0x4F,0x35,0xE9,0x68,0x0A,0xB9,0xD3,0x6D,0x93,0xA6,0x28,0xC8,0xB1,0xB0,0x85,0x40,0x11,0xCA,0x5D,0x44,0x36,0x00,0x02,0xD6,0xDC,0xD2,0x80,0x05,0x32,0xE0,0x01,0x0F,0x10,0xA0,0x26,0xA1,0xFF,0x07};
//const uint8_t spLOW[]           PROGMEM = {0x65,0xDF,0x98,0xA3,0x4A,0xB4,0xE5,0x65,0x4E,0xAB,0x9F,0xD4,0xA2,0x92,0xBC,0x9E,0xB6,0xF2,0xC8,0x71,0xEA,0x7B,0x9B,0xD5,0x24,0x5E,0x3D,0xCC,0x79,0x77,0x3B,0xFB,0xB9,0xF4,0xBD,0xEE,0xF5,0x0C,0x97,0x37,0x5D,0x0B,0x92,0xC7,0xDF,0xFE,0xFD,0x7F};
uint8_t spMOTOR[]         PROGMEM = {0x66,0xAA,0x8C,0x69,0x53,0x92,0xC4,0x2D,0x2F,0x6B,0x2A,0x74,0xDA,0x9D,0xB2,0xDD,0xF6,0x36,0xAB,0xCE,0x78,0xDA,0x9D,0xB2,0xD5,0x9A,0x01,0xDB,0x77,0x45,0xA0,0x75,0xC5,0xB8,0x71,0x59,0xDA,0x31,0xE5,0x6A,0x22,0x63,0xDE,0xDA,0x9A,0xBB,0xA3,0x75,0x68,0xAF,0x7B,0x3E,0xC3,0x9D,0x97,0x60,0x87,0xE6,0x8B,0x4F,0x78,0x4B,0x76,0xB2,0x09,0xAF,0xFE,0xFD,0x7F};
//const uint8_t spOPEN[]          PROGMEM = {0x61,0xCC,0xB8,0x7B,0x8C,0xB2,0xF5,0x61,0x8F,0xAB,0xA9,0x30,0xA7,0x83,0xBC,0xCD,0xBA,0x95,0x19,0x57,0x97,0xB1,0x6B,0xD2,0x58,0x12,0x31,0x11,0x89,0x01,0x01,0x2E,0x9A,0x48,0x60,0x94,0xC5,0x86,0xBB,0xC9,0xA6,0x35,0x36,0x95,0x1A,0xA6,0x7B,0xF6,0x3E,0x8E,0x26,0x42,0x3D,0x78,0xF1,0x3C,0xCB,0xD5,0x0D,0x71,0x78,0x24,0xAB,0x77,0xBA,0x47,0x12,0x73,0xB1,0xB8,0xF9,0xFE,0x7F};
//const uint8_t spPERCENT[]       PROGMEM = {0x02,0xC8,0xD9,0x5C,0x03,0x2D,0x8A,0xB1,0x30,0x46,0x52,0xAF,0xBA,0x86,0x26,0x1A,0xF6,0x77,0x9B,0xD3,0xD5,0x18,0x68,0x69,0x59,0x63,0xEF,0x80,0x5F,0x5A,0x2D,0x60,0x01,0x0B,0x68,0xC0,0x03,0xAB,0x6E,0xDE,0x25,0x2D,0x17,0xDF,0xFA,0x36,0xBB,0x1D,0x53,0xB1,0x6E,0x23,0x5D,0xA7,0x5D,0x23,0x92,0xB9,0xA7,0x62,0x7F,0x20,0x50,0x84,0x72,0x17,0x91,0x0D,0x00,0xA0,0x80,0xA5,0x33,0x0C,0xF0,0xB3,0x27,0x02,0x5A,0x4A,0xFD,0x7F};
const uint8_t spPROBE[]         PROGMEM = {0x02,0xC8,0x29,0x5D,0x03,0x2E,0x0A,0x83,0xCB,0x5D,0x33,0xF7,0xFC,0x94,0xD1,0x96,0x57,0x71,0xF2,0x53,0x66,0xDE,0xE9,0x8D,0xDE,0x76,0x3D,0xDB,0x3E,0x95,0xDD,0xBB,0x8E,0x54,0xEA,0x13,0x0F,0x73,0x19,0x95,0x91,0x46,0x9E,0xD8,0x23,0x68,0x47,0x47,0x24,0xE1,0x1F,0xFF,0xC3,0xEF,0x4D,0x6A,0x99,0x25,0x49,0x67,0xF4,0x96,0x69,0xBA,0x24,0x5E,0xEE,0xAA,0x91,0x2B,0x59,0xD7,0xFE,0x3F};
//const uint8_t spREADY[]         PROGMEM = {0x6A,0xB4,0xD9,0x25,0x4A,0xE5,0xDB,0xD9,0x8D,0xB1,0xB2,0x45,0x9A,0xF6,0xD8,0x9F,0xAE,0x26,0xD7,0x30,0xED,0x72,0xDA,0x9E,0xCD,0x9C,0x6D,0xC9,0x6D,0x76,0xED,0xFA,0xE1,0x93,0x8D,0xAD,0x51,0x1F,0xC7,0xD8,0x13,0x8B,0x5A,0x3F,0x99,0x4B,0x39,0x7A,0x13,0xE2,0xE8,0x3B,0xF5,0xCA,0x77,0x7E,0xC2,0xDB,0x2B,0x8A,0xC7,0xD6,0xFA,0x7F};
//const uint8_t spSET[]           PROGMEM = {0x08,0xF8,0x35,0x95,0x03,0x02,0xF8,0xC5,0x58,0x03,0x16,0xB0,0xC0,0x2A,0xA6,0x08,0x13,0xD7,0xCE,0xA7,0xEC,0xAE,0xD5,0xCC,0xD6,0xDC,0xEA,0x54,0x35,0xA6,0xA4,0xE5,0x9A,0x3D,0xCC,0x25,0x2E,0x08,0x14,0xA1,0xDC,0x45,0x64,0x03,0x00,0x30,0x60,0x88,0x30,0x05,0xFC,0x1C,0x25,0x80,0x65,0xB6,0x10,0x50,0xA2,0xD0,0xFF,0x03};
//const uint8_t spSPEED[]         PROGMEM = {0x04,0xF8,0xBD,0x5C,0x02,0x1A,0xD0,0x80,0x04,0x30,0x40,0x00,0x6E,0x55,0x59,0xCB,0x75,0x7A,0x7A,0xA5,0x59,0xC5,0xC8,0x41,0x64,0xBA,0x66,0xE5,0x33,0x95,0x82,0xEB,0xD6,0x9B,0xEE,0x6C,0xE5,0x33,0x8D,0x82,0xEB,0xD6,0x5D,0xAD,0x7E,0xC5,0x22,0x48,0xDF,0xB2,0xC7,0xBD,0xCC,0x6D,0x1E,0xF5,0x60,0xA7,0x65,0x1E,0x95,0x91,0x88,0x9F,0xF4,0x2A,0xD7,0xD0,0x4D,0x64,0xBE,0xE5,0xFF,0x01};
const uint8_t spUNDER[]         PROGMEM = {0xA7,0x6B,0xA4,0x3B,0x4A,0xB3,0x9C,0xAE,0xF1,0xF6,0x48,0xE9,0x7C,0xDB,0x55,0x56,0x13,0x56,0x62,0x8D,0x5B,0x56,0x15,0xFA,0x68,0x68,0xA9,0x79,0x28,0xA2,0xE0,0x31,0x4D,0x8D,0xA6,0x36,0x52,0x27,0x39,0x13,0x85,0x7E,0x7A,0x35,0x56,0x4D,0xB2,0xD6,0xE6,0x4D,0x55,0xAD,0xD5,0x58,0x6B,0x0E,0xB2,0x92,0x3C,0x73,0x2F,0x47,0xE9,0x4A,0x99,0xBC,0x25,0x9F,0xE1,0xCA,0x43,0xB0,0x53,0x7A,0x85,0xBB,0x1C,0xE1,0x56,0xCB,0xEC,0xEF,0xFF,0x07};
const uint8_t spOPERATOR[]      PROGMEM = {0xB0,0x9A,0xAC,0xB6,0xC2,0xAD,0xCD,0xA9,0x3B,0x9D,0xCE,0x94,0x2C,0xB7,0x5A,0x65,0xB6,0x9B,0x61,0xBA,0x66,0x15,0xC5,0x65,0x8C,0xF3,0x62,0x94,0x89,0x50,0xEE,0x22,0xB2,0x01,0x5A,0x95,0x7C,0xB9,0xAB,0x25,0x29,0x55,0x5C,0xC2,0xD3,0x94,0xB5,0x37,0xA9,0x0B,0x9B,0x2C,0x4B,0xB9,0xE6,0xA1,0x8E,0x63,0xCE,0x83,0x53,0xD2,0xFC,0xAE,0xA5,0x16,0x97,0x70,0xCD,0x3B,0xD6,0x11,0x4F,0x30,0xB4,0x4F,0xDB,0x46,0x3C,0x62,0xE3,0x3D,0xF9,0x00,0x07,0xCC,0xD4,0x29,0x81,0xB6,0xD5,0x3A,0x28,0x2D,0x7E,0xDB,0x51,0xFD,0x09,0x2C,0xFB,0xCF,0x77,0x7A,0x4A,0x2C,0x94,0x93,0xBC,0xE1,0xA9,0xE1,0x04,0x46,0xFD,0xC5,0x37,0xFC,0x65,0x19,0x56,0x72,0x96,0xFF,0x07};
const uint8_t spAMPS[]          PROGMEM = {0x69,0xEA,0xA5,0x45,0xD2,0x57,0xEF,0xF1,0x0E,0x77,0xB8,0xDD,0x6D,0x4F,0x53,0x43,0x49,0x79,0xCC,0xDE,0x5D,0x19,0x9B,0x08,0x2C,0x31,0xA7,0x6E,0x49,0x3C,0x39,0xC5,0xBC,0xEA,0x07,0x81,0x22,0x94,0xBB,0x88,0x6C,0x00,0x06,0x44,0x16,0xC6,0x80,0x5F,0xD3,0x39,0xC0,0x01,0x0E,0x50,0x00,0x03,0x18,0xF8,0x7F};
const uint8_t spMEGA[]          PROGMEM = {0x66,0x31,0x3C,0x7C,0x52,0xE3,0xF8,0xC5,0xCF,0x6B,0x2A,0x5E,0x3C,0x34,0x96,0x9C,0xBE,0xC7,0x10,0x77,0x7F,0x7D,0x9B,0x51,0xF5,0xA1,0x6C,0xE2,0x8F,0x53,0xDD,0x1A,0x52,0x68,0x4D,0x0E,0x43,0xF5,0x48,0xE3,0x55,0xBA,0xCD,0x7D,0xA4,0x28,0x6B,0x93,0x35,0xB7,0xC2,0x12,0x9A,0x4F,0xCE,0x5A,0x5D,0x68,0xBA,0x6E,0xDE,0xDB,0x3C,0xC7,0x59,0xA2,0x66,0x6A,0xCC,0xE9,0x6F,0x7D,0xFF,0x1F};
const uint8_t spPICO[]          PROGMEM = {0x08,0xC8,0x8E,0x48,0x03,0x2B,0xEA,0xC1,0x48,0xD2,0x57,0x9F,0x6C,0xE6,0x25,0x08,0x5B,0x73,0xB3,0x54,0x8C,0xC1,0xE0,0x56,0xB3,0x75,0x15,0x80,0xE6,0x47,0x3D,0x30,0x86,0xE2,0x82,0x35,0xB4,0xF7,0x1A,0xB2,0x71,0xF3,0xD6,0xBC,0x6B,0xA9,0xA2,0x2C,0x8A,0xBD,0x8F,0x23,0x89,0xF5,0x34,0xC9,0xDF,0xCF,0x76,0x45,0x57,0x51,0x22,0x79,0xD3,0xED,0xFD,0x6A,0xA8,0x75,0x8D,0x8F,0x79,0x6C,0xCD,0x74,0xB6,0xDD,0xEA,0xB5,0x65,0xD4,0xCD,0xFA,0xFC,0x3F};
uint8_t spFIRE[]          PROGMEM = {0x04,0x18,0xCE,0x4D,0x02,0x1A,0xD0,0x80,0x04,0x46,0x91,0x55,0x57,0x07,0x6D,0xD9,0xCD,0xAE,0x4F,0x55,0x5D,0x59,0x87,0xAE,0xB9,0xD5,0x6D,0x5B,0xDB,0x7D,0x93,0xB6,0xED,0xEE,0xE3,0x5A,0x6B,0x6A,0xF4,0x91,0xD5,0x73,0x6B,0x67,0xF5,0x47,0xBC,0xD4,0xA7,0x9C,0xA5,0x34,0xE4,0xD0,0xA6,0xF0,0xE4,0xAA,0xB8,0x2D,0xAB,0xC3,0x9B,0x62,0xC2,0xAC,0x74,0xF6,0x9F,0xFB,0x72,0x0B,0xEC,0x92,0xCD,0xEE,0xCF,0x43,0x69,0x4C,0x5B,0xFF,0x3F};
//const uint8_t spPOWER[]         PROGMEM = {0x0C,0xF0,0xDC,0x4C,0x03,0x2B,0xCD,0x36,0xAB,0x85,0x1B,0x9F,0xBC,0xB1,0xAE,0x6A,0xEA,0x7A,0xB3,0x95,0x15,0xD5,0x39,0x85,0x5D,0x46,0x96,0x7C,0x57,0x3B,0xB6,0x19,0x79,0x30,0x93,0x55,0xA4,0xBB,0xD4,0x2E,0xAD,0x79,0xB1,0xDE,0x3E,0x8D,0x29,0x85,0x61,0x1F,0xF6,0x3B,0xB7,0x7E,0x94,0x33,0x97,0x46,0x5B,0xCE,0x9D,0x9F,0xF0,0x16,0x3F,0x48,0xE7,0x7E,0xC3,0x5B,0xE3,0xA2,0xAC,0xEB,0xF6,0xDF,0xFF,0x03};
const uint8_t spCOMPLETE[]      PROGMEM = {0x0E,0x68,0xA1,0x43,0x03,0xA7,0x2E,0xB2,0x22,0x0B,0xBB,0xDC,0x76,0x75,0x55,0x99,0xB7,0x53,0xB4,0xD1,0x77,0xA6,0x1C,0xA5,0xD6,0x7A,0x9F,0xFA,0x44,0x39,0x5A,0xDC,0x1E,0x9D,0x0C,0x50,0x94,0xB8,0x01,0x46,0x14,0x2F,0x69,0x97,0x9C,0x69,0xA6,0xE4,0x14,0x8D,0x85,0xBB,0x73,0xB3,0x93,0x75,0x6D,0xA2,0x29,0x6F,0x56,0xD6,0xB3,0xB2,0xA8,0x3F,0x59,0xF9,0x18,0x4E,0xA4,0xBE,0x66,0xB6,0x69,0x9F,0xB9,0x08,0xD2,0xDE,0xC4,0x1D,0x81,0x22,0x94,0xBB,0x88,0x6C,0x00,0x00,0x05,0x1C,0xD9,0x6E,0x80,0x65,0x7E,0x18,0xD0,0xEB,0x3A,0x02,0x6A,0x09,0xFC,0x7F};
//const uint8_t spREPAIR[]        PROGMEM = {0x69,0x8E,0x8D,0xCD,0x22,0x95,0xB7,0xA9,0x74,0x09,0xB2,0x54,0x7F,0xC6,0x16,0x83,0xCD,0xB5,0xEF,0x1A,0x7A,0x18,0x22,0x97,0xBE,0x75,0x62,0x93,0x08,0xE5,0x2E,0x22,0x1B,0x00,0x04,0xE0,0x93,0x59,0xCB,0x92,0x53,0xCB,0x8C,0x9A,0xAB,0x68,0xD1,0xC5,0xC2,0x5E,0x9F,0xB2,0xA5,0x22,0x0F,0xD9,0x72,0xAB,0x5B,0xDF,0xE6,0x4E,0x63,0xA9,0x25,0xB0,0x4A,0x3B,0xCF,0xAD,0x1F,0xE9,0xAE,0x7A,0x85,0x4E,0xF2,0xE5,0x27,0xBF,0xF9,0xCD,0x5F,0xFA,0x4A,0x1C,0x92,0xE3,0xDC,0xE9,0x2B,0x35,0xA9,0x5A,0x72,0xFF,0x3F};
//const uint8_t spTEMPERATURE[]   PROGMEM = {0x0E,0xF8,0x2E,0x2C,0x00,0xCB,0x8F,0x8F,0xA8,0x59,0x15,0xF7,0x58,0x79,0xD2,0x9A,0x5D,0x22,0xB5,0xF5,0x4D,0x47,0x96,0xAB,0x5A,0x87,0x69,0x0E,0x85,0xF7,0x46,0x1D,0xA1,0x0C,0x10,0xE0,0x32,0xBB,0x04,0x56,0x5E,0x62,0x91,0xA6,0x79,0xEF,0x7D,0xEC,0xC1,0x00,0x63,0x6C,0x46,0xC0,0x03,0x16,0x18,0x7D,0x8F,0x29,0x68,0x96,0xB5,0x4D,0x25,0x27,0x71,0x85,0xF7,0xBE,0xF6,0xBD,0x9F,0xF5,0x09,0x77,0x59,0xC2,0xDE,0x9A,0x27,0xBE,0xFE,0xFD,0x7F};
//const uint8_t spSTOP[]          PROGMEM = {0x0C,0xF8,0xA5,0x4C,0x02,0x1A,0xD0,0x80,0x04,0x38,0x00,0x1A,0x58,0x59,0x95,0x13,0x51,0xDC,0xE7,0x16,0xB7,0x3A,0x75,0x95,0xE3,0x1D,0xB4,0xF9,0x8E,0x77,0xDD,0x7B,0x7F,0xD8,0x2E,0x42,0xB9,0x8B,0xC8,0x06,0x60,0x80,0x0B,0x16,0x18,0xF8,0x7F};
const uint8_t spMACHINE[]       PROGMEM = {0xC2,0x56,0x3C,0x7D,0xDC,0x12,0xDB,0x3E,0x8C,0x89,0xBA,0x4C,0x4A,0x96,0xD3,0x75,0x95,0x12,0x6E,0xBD,0x6F,0xB7,0xBA,0x16,0x5A,0x58,0x3D,0xB3,0x03,0xA6,0x14,0x76,0xC0,0xCC,0x37,0x11,0xC8,0x40,0x04,0x22,0xB0,0x92,0xD9,0x9A,0xC1,0x7D,0xF5,0xCD,0x6F,0x3E,0x8A,0x39,0x14,0xA5,0x72,0xD4,0x28,0x67,0x56,0xD4,0x89,0xD2,0xB3,0xE9,0x63,0x5D,0xD2,0xDA,0x03,0x49,0xA9,0xDB,0xCD,0x47,0x3C,0xE3,0xEB,0xBF,0xF4,0x75,0x57,0xEC,0xEE,0x9B,0xF2,0x9B,0xBE,0x56,0x34,0xCC,0xA2,0xF2,0xFF,0x03};
//uint8_t spON[]            PROGMEM = {0x65,0x4A,0xEA,0x3A,0x5C,0xB2,0xCE,0x6E,0x57,0xA7,0x48,0xE6,0xD2,0x5D,0xBB,0xEC,0x62,0x17,0xBB,0xDE,0x7D,0x9F,0xDA,0x5C,0x5C,0x7A,0xAA,0xB5,0x6E,0xCB,0xD0,0x0E,0xAD,0x6E,0xAF,0xEE,0xF9,0x88,0x67,0xBC,0xDC,0x3D,0xAC,0x60,0xB8,0x45,0xF3,0xB7,0xBF,0xC3,0xDD,0xA2,0xBB,0xAB,0xCD,0x89,0x8F,0x7F,0xFE,0x1F};
//const uint8_t spCONTROL[]       PROGMEM = {0x06,0x68,0xA5,0xCD,0x02,0x2B,0xA9,0x36,0xD5,0x43,0x5A,0x9F,0xA6,0xA9,0x36,0x4F,0xEE,0x73,0xDA,0xC1,0xDA,0x35,0x79,0x73,0x6B,0x9B,0x62,0xEA,0xB0,0x78,0xB3,0x4B,0x7D,0x91,0x18,0xED,0xE6,0x16,0x81,0x22,0x94,0xBB,0x88,0x6C,0x10,0x40,0x0B,0xE1,0x1E,0x88,0xC0,0x48,0x53,0xE2,0x0A,0x17,0x67,0x3B,0x3B,0x59,0xB2,0x11,0x95,0xA2,0x7C,0x64,0x91,0x4F,0x47,0x92,0xF7,0x99,0xAF,0xA2,0xE0,0xEE,0x76,0x56,0xBF,0x9B,0x39,0xB4,0x29,0xB1,0x9C,0x76,0xF4,0x56,0xD7,0xBA,0xE5,0x3B,0x3F,0xF1,0x29,0x77,0xE6,0x9D,0x63,0x9C,0xE7,0xFF,0x01};
const uint8_t spELECTRICIAN[]   PROGMEM = {0x6B,0x9D,0xA6,0x88,0xD3,0x36,0xDF,0xF1,0x8C,0x5B,0x84,0x93,0x79,0xBB,0x35,0x5C,0x26,0xA9,0xEC,0x6B,0xCF,0x70,0xB8,0x87,0xBA,0x68,0x3F,0x5D,0x4B,0xA1,0x29,0xB6,0xF9,0xB6,0xAD,0x69,0xB1,0x48,0x5B,0x1B,0x23,0x50,0x84,0x72,0x17,0x91,0x0D,0x00,0x06,0x38,0xAE,0xD2,0x03,0xA3,0xAC,0x59,0x4D,0xDD,0x9D,0xAE,0xA2,0x16,0x63,0x37,0xEB,0xBA,0x8B,0x51,0x36,0x63,0x1A,0x9E,0x6B,0x7A,0x65,0x80,0x55,0xB7,0x3D,0x10,0x81,0x0C,0x58,0x60,0x75,0xCD,0x98,0x84,0xF9,0xA6,0xBD,0xF4,0xAD,0x5C,0x43,0x19,0x46,0x58,0xB4,0x7C,0xE7,0x27,0x7D,0x3D,0x0A,0xBB,0x87,0xDD,0xF8,0xC7,0xFF,0xFF,0x01};
//const uint8_t spAT[]            PROGMEM = {0xAD,0xA8,0xC9,0xB5,0xBC,0xA6,0xDC,0xFE,0x36,0xB7,0xB9,0xF5,0x6D,0xC7,0x58,0x9B,0x69,0xF9,0x4C,0x99,0x73,0xDD,0xC8,0x24,0x42,0xB9,0x8B,0xC8,0x06,0x00,0x50,0xC0,0x52,0x2E,0x0E,0xB8,0x66,0x8A,0x01,0xAD,0x95,0x20,0x20,0x3A,0xF2,0xFF,0x07};
//const uint8_t spRED[]           PROGMEM = {0x6A,0xB5,0xD9,0x25,0x4A,0xE5,0xDB,0xC5,0x4F,0x6D,0x88,0x95,0x2D,0xD2,0xB4,0x8F,0x2E,0x37,0x0E,0x33,0xCF,0x7E,0xAA,0x9A,0x5C,0xC3,0xB4,0xCB,0xA9,0x86,0x69,0x76,0xD3,0x37,0xB7,0xBE,0xCD,0xED,0xEF,0xB4,0xB7,0xB0,0x35,0x69,0x94,0x22,0x6D,0x10,0x28,0x42,0xB9,0x8B,0xC8,0x06,0x00,0x50,0xCF,0x0E,0xEE,0x62,0xEA,0xA6,0xBC,0xC3,0x14,0xBB,0x4A,0x9F,0xFA,0xA5,0xAF,0x25,0x13,0x17,0xDF,0x9C,0xBF,0xFF,0x07};
//const uint8_t spALL[]           PROGMEM = {0x65,0x0D,0xFA,0x3B,0x84,0xFB,0x8D,0x2E,0xB1,0x9D,0x34,0xCA,0xBA,0xAB,0x5D,0xEC,0x62,0x15,0x89,0x5F,0xA7,0x49,0xB6,0x5D,0xEF,0x6E,0x0E,0x73,0x99,0xEB,0x3C,0xCA,0x11,0x65,0xCE,0x18,0xB9,0x89,0x67,0xBC,0xDC,0x15,0xF8,0xE5,0xA0,0xE6,0x71,0x77,0x94,0x51,0x8F,0x96,0xE6,0xFF,0x01};
//const uint8_t spCANCEL[]        PROGMEM = {0x01,0x98,0x29,0xC4,0x00,0xDD,0x29,0x9C,0xAC,0x25,0xD7,0xD2,0x9C,0x7C,0x8B,0x5B,0xAE,0xBC,0x26,0xB3,0x94,0x89,0x52,0xF2,0xE6,0x29,0x42,0x52,0x53,0x28,0xAA,0xC1,0xB6,0xB0,0xC4,0x0C,0xF8,0xDE,0xC2,0x02,0x1E,0xF0,0x80,0x05,0x46,0x5C,0x78,0x45,0x25,0xE5,0x19,0x53,0x45,0x93,0xE3,0xA2,0x77,0xAE,0x75,0x4B,0x67,0x92,0xD5,0x6D,0x98,0x25,0x3F,0xF9,0xFD,0x7F};
const uint8_t spPHASE[]         PROGMEM = {0x22,0x5E,0x2E,0xD5,0xC4,0x64,0xA5,0xF6,0x9A,0x52,0x26,0xF1,0xB6,0xDA,0xEA,0x54,0x2C,0x6B,0xCE,0x69,0x7A,0x0A,0x51,0x89,0xB7,0xA7,0x19,0xA9,0x98,0xCD,0xDE,0xDC,0xE6,0x36,0xAB,0x9B,0xA1,0x11,0x23,0x3E,0xCF,0xB1,0xAF,0x7D,0xAB,0x7B,0x3C,0xFC,0x19,0x9E,0xA6,0x55,0x9C,0x6D,0xB7,0x7F,0xEC,0xCB,0x80,0xEF,0xCB,0x39,0x40,0x81,0xFF,0x07};
const uint8_t spNOR[]           PROGMEM = {0xE9,0x38,0x5C,0x84,0x33,0xBD,0x8E,0xB6,0x9A,0x70,0x09,0x6B,0xBB,0x8B,0x93,0x66,0xDE,0x91,0xC9,0xFE,0x6E,0xBA,0xB2,0x24,0xAA,0x26,0x51,0xDD,0xCC,0x47,0x1D,0x7C,0x75,0x3A,0xE5,0x99,0xC3,0x5C,0xCA,0x1E,0x52,0x6A,0xA7,0xE4,0xCF,0x7B,0xB9,0x53,0x4E,0x8E,0x31,0x6F,0xFD,0x4C,0x77,0x1A,0xC2,0x93,0x96,0x25,0xDD,0xA9,0x04,0x4E,0x87,0xDB,0xF0,0xE4,0x2D,0xB4,0x6E,0x59,0xE2,0xE3,0xDF,0xFF,0x07};
const uint8_t spEXIT[]          PROGMEM = {0x6B,0x68,0xC1,0x24,0xAD,0xEE,0xAC,0xA6,0xE7,0x66,0x57,0x7F,0x73,0x9B,0x5B,0xB6,0xA2,0x1F,0x56,0xC5,0x69,0x6A,0xDA,0x96,0x94,0x02,0xB2,0x89,0x02,0x9A,0x1C,0x35,0xC0,0xCF,0x99,0x16,0xB0,0x80,0x04,0xDA,0x5C,0x83,0x4A,0xF0,0xDC,0x5E,0x5B,0x33,0x49,0xA1,0xFE,0xB9,0x9F,0xE1,0x6B,0x41,0x39,0xD8,0x1E,0x23,0x50,0x84,0x72,0x17,0x91,0x0D,0x00,0x02,0x38,0xCC,0xDC,0x02,0x04,0x18,0xF6,0xF3,0xFF,0x01};
const uint8_t spFLOW[]          PROGMEM = {0x04,0xE8,0x3E,0x83,0x02,0x1C,0xE0,0x80,0x04,0x3C,0x10,0xB2,0x24,0x75,0xD9,0xAC,0x4D,0xCD,0x5A,0x9D,0x85,0xAC,0x93,0x79,0x39,0x75,0xA3,0xDE,0x15,0x98,0xED,0x56,0xB7,0x5A,0x55,0xE2,0xD3,0xE9,0xE4,0x6F,0xD6,0xB3,0x9B,0x43,0x5F,0xEB,0x91,0x4F,0x77,0x5B,0xBB,0x15,0xC2,0x7E,0xFC,0x63,0x5E,0x1B,0xD7,0x0B,0xA5,0xB7,0x7E,0xFF,0x1F};
const uint8_t spGAUGE[]         PROGMEM = {0x0E,0x18,0xD5,0xB0,0xB5,0x2B,0x24,0x09,0x7B,0x92,0x55,0xF7,0x4C,0xA2,0xD1,0x8D,0x6F,0x7D,0x9A,0x91,0x83,0x34,0x72,0xCE,0x6D,0x6E,0x73,0xDB,0xD5,0xCD,0x50,0x40,0x9D,0xAB,0xF7,0xB8,0xE7,0xBD,0xB5,0x7D,0xA5,0x46,0x8C,0x58,0x5D,0x0F,0x76,0x15,0x05,0xBE,0x96,0x8D,0xD8,0x59,0x0D,0xE8,0x58,0xD5,0xA2,0x97,0x7A,0xC6,0x72,0x17,0x31,0x5B,0xB2,0x65,0xC0,0x9A,0xCE,0x12,0xB0,0x80,0x02,0xE6,0x50,0xF9,0x7F};
//const uint8_t spGREEN[]         PROGMEM = {0xE1,0x6A,0xEA,0x2A,0x4A,0xE3,0xA6,0xA1,0xB8,0x49,0x32,0x51,0x9A,0xFA,0xE8,0xCC,0xAC,0x2C,0x59,0xED,0x5A,0x5B,0x3A,0x05,0x27,0x77,0x9D,0xF5,0x29,0xDA,0x70,0x91,0x90,0xB6,0xA7,0x18,0x35,0x90,0xD3,0x17,0xED,0x7C,0xE5,0x33,0x06,0xE2,0x54,0xA5,0x5D,0xCC,0xAA,0xF5,0xB3,0x07,0x50,0xD6,0xA8,0x36,0x8E,0xA0,0x68,0x6B,0x61,0xFA,0x52,0xB7,0xB2,0x8F,0x44,0x54,0x15,0x41,0xD2,0x31,0x12,0x86,0xB8,0xBB,0xCE,0x67,0xBA,0xAA,0x66,0x4B,0xF1,0xB8,0xE9,0xEA,0x91,0x43,0xCC,0x5C,0xC7,0x33,0x5E,0xE5,0x6A,0xD6,0x25,0xDC,0x67,0xA5,0xA7,0x55,0x0D,0xD5,0x98,0x9C,0xDF,0xFF,0x07};
const uint8_t spINSPECTOR[]     PROGMEM = {0x29,0xEB,0x5E,0xD9,0x32,0x27,0x9D,0x6E,0xFA,0x66,0x17,0x59,0x7D,0xDB,0xDB,0xB4,0xB6,0x7B,0xD0,0xCC,0x70,0xD2,0xDB,0xD6,0x0D,0xC7,0x38,0xAC,0x4D,0xD2,0xF0,0x0D,0xB3,0xA9,0xBB,0x73,0xC0,0x4F,0xE9,0x11,0xF0,0x80,0x02,0x86,0x52,0x01,0x03,0x44,0xEA,0x7A,0xA2,0x1A,0x43,0xD3,0x6C,0xF3,0x4D,0x6F,0xDA,0xB2,0x56,0x0C,0x82,0xAD,0x31,0x29,0x44,0x28,0x77,0x11,0xD9,0x00,0xE0,0x80,0xED,0x3C,0x46,0x5F,0xEB,0xA0,0xB4,0xF8,0x2D,0x53,0xF5,0x27,0xB0,0xEC,0x3F,0x6F,0x69,0x2F,0xB1,0x50,0x4E,0xF2,0x86,0xB3,0x86,0x13,0x18,0xF5,0x17,0xDF,0xF0,0x96,0x65,0x58,0xC9,0x59,0xFC,0xF7,0xFF};
const uint8_t spMANUAL[]        PROGMEM = {0x6E,0x8A,0x42,0x6C,0xD5,0x9A,0xA4,0xB1,0x72,0xA5,0x2A,0x49,0x5B,0x87,0xD3,0x75,0x5B,0x1A,0x2E,0xAB,0x6F,0x7D,0xAB,0x53,0x76,0xDF,0x12,0xE6,0xAF,0x6F,0x71,0x8A,0x1E,0x43,0x52,0x72,0xF1,0x2A,0x7A,0x24,0x4D,0x4E,0xD7,0xA5,0x6A,0x06,0x32,0x2D,0x34,0x8F,0x7A,0x24,0x12,0x97,0x4E,0xB8,0xFA,0xE1,0x1D,0xD5,0xB3,0xE1,0x1A,0x7A,0x0D,0x12,0xB5,0xD5,0x6B,0xAC,0x51,0x24,0xD4,0x56,0x97,0x25,0x5A,0xB3,0x32,0x59,0x93,0xB6,0xA8,0x27,0x3C,0x31,0x4F,0xDE,0xEB,0x5E,0xCF,0x72,0x26,0x3E,0xD5,0xC6,0xF9,0xCA,0x55,0x71,0x77,0x39,0x7B,0x2B,0xD7,0x40,0xD1,0x1D,0xAC,0xBD,0xDC,0x05,0x57,0x77,0x90,0xB7,0xFC,0xFC,0x3F};
const uint8_t spMOVE[]          PROGMEM = {0x6A,0xD7,0xC2,0xF2,0xD2,0xEC,0xB8,0x39,0x08,0xF6,0x4D,0x4D,0x1A,0xC6,0x24,0x31,0xB2,0xCC,0x69,0x1E,0x56,0x9D,0x85,0x7B,0x15,0xA4,0x3B,0x55,0x23,0x9E,0x3E,0xE0,0x6D,0xE7,0x23,0xAF,0x20,0xC6,0x0A,0xBC,0xCE,0xA2,0x34,0x91,0x6C,0x89,0x43,0xDF,0x3A,0x94,0x31,0x83,0x6E,0x4D,0xE8,0x9A,0x96,0x0C,0x3A,0x63,0x20,0x5B,0xD8,0xAC,0xEC,0xC8,0x20,0x37,0x7E,0xB7,0xA7,0x3D,0xCD,0xD9,0x8A,0x78,0x28,0x2E,0xB5,0x97,0xBD,0xED,0xCD,0x80,0x52,0x32,0x28,0x80,0x81,0xFF,0x07};
//const uint8_t spOVER[]          PROGMEM = {0x63,0x6F,0xC4,0x7A,0x1D,0xB5,0xED,0x61,0x37,0xBB,0x6E,0x75,0x62,0xD9,0x2D,0xEC,0xBF,0x56,0xAD,0x09,0xBA,0x32,0x8C,0x13,0xC7,0xD6,0xED,0x4D,0x85,0x86,0x99,0xE3,0x3E,0xB7,0x29,0x86,0x90,0x2C,0x76,0xDB,0xE6,0x98,0x95,0xBB,0x38,0x4F,0x5B,0x72,0x29,0xB4,0x51,0x6F,0x7D,0xAF,0x47,0xB9,0x73,0x71,0x8C,0x31,0x3F,0xE1,0xC9,0xA9,0x50,0xD6,0xFD,0xBA,0x27,0x57,0xC5,0x6E,0xCD,0xFD,0xFF};
//const uint8_t spPLUS[]          PROGMEM = {0x0A,0x18,0x4D,0x44,0x01,0x23,0x70,0x12,0x40,0x8B,0xD8,0x92,0x7A,0xD3,0x63,0x10,0xAD,0x57,0x91,0xC4,0xB5,0x8A,0xAE,0x39,0x45,0xE1,0x93,0xE9,0xBC,0xE5,0x96,0xB7,0x59,0x43,0x15,0x63,0xE9,0xBA,0x6B,0x6E,0xF5,0x64,0x40,0xF0,0xEE,0x0A,0xF8,0x25,0x43,0x03,0x1E,0xD0,0x80,0x04,0x38,0x40,0x01,0x0C,0xFC,0x3F};
const uint8_t spPULL[]          PROGMEM = {0x06,0xF0,0xB6,0x9C,0x01,0x2C,0xB7,0x8F,0x28,0xCA,0x1E,0x53,0x5A,0xBA,0x93,0x95,0x0C,0x2C,0xD3,0x81,0xDA,0x76,0xBA,0xB3,0x51,0x57,0x14,0xB3,0x8E,0xEE,0x67,0xDF,0x87,0x34,0x17,0xE2,0x3B,0x86,0x5E,0xEB,0x11,0xCE,0x24,0x62,0xD3,0xB0,0x69,0xBE,0xFD,0xE3,0xDE,0x20,0x67,0x54,0xA5,0xCD,0xFF,0x03};
const uint8_t spREPEAT[]        PROGMEM = {0x6E,0xF1,0x49,0x42,0x33,0xD8,0xC5,0xB9,0x8C,0xB9,0x62,0x8A,0x87,0xF6,0xD3,0xB7,0xCC,0xC6,0x1A,0xE9,0x4E,0x33,0x9C,0x23,0x79,0x7C,0xDE,0x4D,0x6B,0x5B,0x62,0xB0,0xF4,0x95,0x64,0x16,0xA1,0xDC,0x45,0x64,0x03,0x04,0xA0,0xB5,0x94,0x96,0xF6,0x14,0x4C,0x62,0xAF,0x4E,0xD6,0x13,0x93,0x66,0xCD,0x3E,0xD9,0x6C,0x89,0x64,0xB1,0xFA,0x66,0xBB,0x18,0xFD,0xAC,0x0A,0x92,0xB5,0xA8,0xAD,0xA3,0x10,0x8B,0x4D,0x6D,0x7B,0x21,0x50,0x84,0x72,0x17,0x91,0x0D,0x00,0x06,0xB8,0xDC,0xCD,0x01,0x33,0x6C,0x62,0x00,0x03,0xFF,0x0F};
const uint8_t spSHUT[]          PROGMEM = {0x04,0x58,0xE3,0x5A,0x03,0x16,0xF0,0x80,0x07,0x22,0x60,0x81,0x55,0xB4,0xE4,0xA2,0x61,0x5D,0x6E,0x71,0xCA,0x12,0x3C,0xCA,0x7C,0xCE,0xAD,0x76,0x31,0xD7,0xBC,0x23,0x50,0x84,0x72,0x17,0x91,0x0D,0x00,0x06,0xE8,0x44,0x5D,0x01,0x3F,0x66,0x11,0xE0,0x98,0x59,0x04,0xF4,0x38,0xFE,0xFF};
const uint8_t spTEST[]          PROGMEM = {0x0E,0x98,0x6A,0xC9,0x00,0x2B,0x37,0xAF,0xA4,0x45,0x91,0xB0,0x5A,0x72,0xEA,0x9A,0x9D,0x23,0xE3,0xCD,0x6D,0x56,0x57,0x93,0x5A,0x78,0x2D,0xD9,0xE3,0x9E,0xEB,0x4E,0x77,0x02,0x6C,0x95,0x4A,0x80,0xDF,0xD2,0x39,0xA0,0x01,0x0D,0x48,0x80,0x01,0x4F,0x2B,0x53,0x00,0x14,0x70,0x45,0x9A,0x06,0x10,0x50,0x73,0xC3,0xFF,0x03};
const uint8_t spVOLTS[]         PROGMEM = {0xA0,0xDA,0xA2,0xB2,0x3A,0x44,0x55,0x9C,0xFA,0xB0,0xBA,0x46,0x72,0xDA,0xD1,0xDB,0xAE,0x47,0x59,0x61,0xED,0x28,0x79,0xED,0x45,0xAF,0x5A,0xDF,0x60,0xF4,0x39,0x69,0xAB,0x63,0xD9,0x3B,0xD2,0xBC,0x24,0xA5,0xF5,0xB6,0x0F,0x80,0x01,0x3E,0x63,0x65,0xC0,0x5F,0x63,0x12,0x90,0x80,0x06,0x24,0x20,0x01,0x0E,0xFC,0x3F};
const uint8_t spGALLONS[]       PROGMEM = {0x0E,0x28,0x8A,0xE5,0xB4,0xAD,0x04,0x9B,0xF9,0x9A,0x5B,0x9F,0xBA,0xE9,0x91,0x4A,0x5D,0x7D,0xAB,0x53,0x15,0x35,0xBE,0xA2,0x8B,0x77,0x35,0xEA,0xCC,0xC6,0x4F,0xA9,0x6E,0x6B,0x07,0xC8,0xEC,0x45,0xCF,0x6B,0x2C,0xA2,0x7C,0x4D,0x36,0xCF,0x65,0xAC,0x8D,0x97,0xB6,0xE9,0xE2,0x7A,0x86,0x7B,0x44,0xD4,0xB0,0x54,0x1A,0xEE,0xA6,0x51,0x32,0xC2,0xA9,0x7F,0xCC,0xD3,0x2D,0xA3,0xA7,0xC4,0xB7,0xAF,0x7E,0xE4,0xE7,0xBE,0xAF,0x4D,0x54,0x53,0x19,0x03,0xBE,0x60,0x62,0xC0,0xAF,0xAE,0x12,0x90,0x00,0x02,0x6A,0x70,0xFE,0x7F};
//const uint8_t spHERTZ[]         PROGMEM = {0x04,0xC8,0xA1,0xD8,0x02,0x1E,0x58,0x71,0x2E,0x81,0x31,0xDC,0x65,0x25,0xD5,0x9E,0xC2,0x9A,0xFE,0x9D,0xED,0x7A,0x8E,0x61,0xAD,0x25,0xC1,0x4A,0xF3,0x01,0x00,0x02,0xB6,0x09,0x65,0xC0,0x6F,0x65,0x1C,0xB0,0x80,0x05,0x34,0xE0,0x01,0x0D,0x10,0xA0,0x09,0x97,0xFF,0x07};
const uint8_t spMICRO[]         PROGMEM = {0x22,0x8B,0x44,0xF5,0x92,0x9B,0xDA,0xC5,0xCF,0x6B,0xA8,0xBC,0x2B,0x8B,0xB3,0xDC,0xEE,0xB6,0xA7,0x6E,0x3E,0xB9,0xC2,0x56,0x9F,0xA2,0x57,0x93,0xD0,0x9C,0x5D,0x8A,0x3E,0x88,0x52,0xA6,0x32,0x2B,0xAA,0x15,0x34,0xCB,0xD4,0xC0,0x80,0x12,0x23,0x22,0x60,0x81,0x30,0xC5,0xAA,0x61,0x25,0xF9,0x7A,0xDF,0x87,0x31,0x17,0xDE,0x1E,0xC5,0xFE,0xDB,0x96,0xD5,0xD8,0x38,0xF4,0xAB,0x47,0x78,0xBC,0xAB,0x18,0xE1,0x3C,0xFE,0xF5,0xDF,0xFF,0x03};
const uint8_t spOHMS[]          PROGMEM = {0xAD,0xC9,0x74,0x37,0x59,0xD2,0xED,0xE6,0xD4,0x95,0xF8,0x56,0xB0,0xD2,0x5D,0x9D,0xAA,0x12,0xAF,0x2D,0xB7,0xBA,0xDB,0xDE,0xB7,0x79,0x68,0x93,0x32,0x96,0xD2,0x97,0xBA,0xE6,0x3D,0x9F,0xEE,0x6A,0x92,0xB9,0x22,0x9C,0x98,0x2B,0x33,0x8E,0x16,0x8F,0xEB,0xEE,0x6E,0xD1,0x5A,0x3C,0x4D,0xB8,0x06,0x09,0x35,0xA5,0xDE,0xE1,0xFA,0xC5,0xD8,0x4D,0xE4,0x2A,0xE0,0x5B,0x15,0x05,0x7C,0x27,0xA4,0x01,0x0E,0x70,0x00,0x01,0xDE,0x6C,0xFE,0x3F};
//const uint8_t spAREA[]          PROGMEM = {0x2D,0xEF,0xA1,0xC8,0x32,0x36,0xDF,0xE5,0x0C,0xDD,0x0D,0xCB,0x68,0xDF,0xDB,0xAC,0xBA,0x0C,0xB1,0x32,0xED,0x3A,0xAA,0xD4,0x39,0x2C,0x4D,0xEF,0xAC,0x67,0xB3,0xFA,0xD2,0x58,0xD3,0x3D,0xEF,0x1A,0xBA,0x2B,0xD0,0xF2,0xDD,0x73,0x1E,0x4B,0xF7,0x89,0xE6,0xF1,0x79,0xAF,0x63,0xED,0x3E,0xD8,0xDD,0x3E,0x8F,0xAD,0x3A,0xF7,0x76,0x5D,0xD3,0xB7,0xBE,0xB7,0xBB,0xE9,0xB4,0x4E,0xE9,0x5D,0x3F,0xF7,0xA7,0x1C,0x9E,0xEA,0x4B,0xFE,0x1F};
const uint8_t spCIRCUIT[]       PROGMEM = {0x02,0x78,0x2D,0x55,0x02,0x12,0xB0,0x80,0x01,0x5E,0x49,0x5D,0x49,0x35,0xAE,0x1A,0xD6,0xF6,0x94,0x25,0x05,0x5B,0x4A,0xD7,0x55,0x94,0x3C,0x28,0x2D,0xFE,0x76,0x11,0xCA,0xEA,0x06,0x25,0x35,0x29,0x02,0x45,0x28,0x77,0x11,0xD9,0x08,0x28,0x4E,0x15,0x1C,0x50,0x1C,0xD3,0xEA,0x6A,0x14,0x49,0xF7,0x4D,0x7B,0x19,0x67,0x53,0x45,0x65,0xB1,0xA7,0x3E,0x08,0x14,0xA1,0xDC,0x45,0x64,0x03,0x80,0x00,0x96,0x56,0x53,0xC0,0x1F,0xAD,0x02,0x78,0xAE,0x06,0x01,0xCB,0xB7,0xFF,0x3F};
const uint8_t spCONNECT[]       PROGMEM = {0x06,0xA8,0xD5,0x29,0x24,0x3D,0xAC,0xB3,0x52,0xE6,0x55,0x97,0xA0,0x56,0x12,0x8D,0x4F,0xDB,0x9C,0x6A,0x4B,0x2C,0x2D,0xDD,0xC8,0xA8,0xEE,0xE9,0xB4,0xF6,0xAB,0x6B,0x4E,0xB5,0x28,0x93,0xAC,0xB6,0xC5,0x66,0x4F,0xDB,0x7C,0xBB,0xDB,0xEF,0x69,0x9E,0xE5,0x69,0xA1,0x39,0x3C,0x96,0x20,0x50,0x84,0x72,0x17,0x91,0x0D,0x00,0x20,0x80,0xA5,0xC3,0x1C,0xB0,0xEC,0x97,0x05,0x18,0xD0,0xCB,0xDA,0xFF,0x03};
const uint8_t spSECONDS[]       PROGMEM = {0x04,0xF8,0xC5,0x51,0x01,0xBF,0xA6,0x6A,0x40,0x03,0x16,0xD0,0xC0,0xCA,0xAB,0x75,0x2D,0xCD,0x25,0x37,0xBB,0xD9,0xCA,0xDA,0x54,0x0F,0xEE,0xD9,0x29,0x6B,0x47,0x30,0xD8,0xE3,0x80,0x00,0x6A,0x26,0x6D,0x55,0xEB,0xCA,0x21,0xB9,0xE4,0xD4,0xDD,0x26,0xA5,0xF9,0xE3,0x3D,0xB6,0x75,0x38,0xA3,0x31,0x5B,0x9A,0xB6,0x11,0x51,0x32,0xD2,0xAA,0x3F,0xFC,0x21,0xCE,0x22,0xD1,0xD7,0x2D,0x9E,0x39,0x0B,0x37,0x4E,0xD7,0x26,0xE1,0xFA,0xC4,0x55,0x42,0xFD,0x85,0xFB,0x7B,0x77,0x13,0xA3,0x27,0x80,0x03,0xD0,0x25,0x20,0x01,0x0A,0x20,0x20,0x69,0xD6,0xFF,0x07};
const uint8_t spUNIT[]          PROGMEM = {0x61,0xB9,0x96,0x84,0xB9,0x56,0xE5,0xB9,0xCE,0x63,0xDE,0xCE,0x0D,0x30,0x36,0x9F,0x6E,0x86,0x36,0x60,0xE9,0x7B,0xCA,0x5E,0x93,0x45,0xA4,0xEB,0xC9,0xBB,0x77,0x72,0xE7,0x2D,0x2B,0xAB,0xD6,0x24,0x94,0x17,0x8F,0xA2,0x79,0x4C,0xD5,0x48,0x5D,0xAA,0xEE,0x21,0x23,0x42,0xF1,0x1A,0x66,0x54,0x15,0x97,0xD6,0x6B,0x19,0xD1,0xC5,0xC5,0x77,0xEF,0xB3,0x9F,0x7E,0x47,0xA0,0x08,0xE5,0x2E,0x22,0x1B,0x00,0x01,0xCB,0xBB,0x3B,0xE0,0xD7,0x0A,0x05,0x9C,0xD0,0x4D,0x80,0xE6,0x92,0xFE,0x1F};
const uint8_t spTIMER[]         PROGMEM = {0x0E,0xB8,0x36,0xC3,0x01,0xCD,0x98,0xB4,0x38,0x87,0x8C,0x0A,0x59,0x72,0x8B,0x5B,0x9D,0xAA,0x15,0x35,0x0B,0x9F,0x7D,0x8B,0x5D,0xB4,0xAA,0x78,0x96,0xB4,0xB0,0x5B,0xFB,0x32,0xE7,0xE8,0x9C,0x85,0x6D,0xDA,0x96,0xC3,0x10,0x9F,0x78,0x49,0x67,0x35,0xA7,0xF0,0xA6,0x2F,0xDD,0x39,0x2D,0xF2,0x89,0x9F,0xFC,0xC4,0xD7,0xFD,0xC5,0x1F,0xC3,0xBA,0x3F,0xF3,0x97,0x6D,0x54,0xC9,0xFD,0xFE,0x1F};
//const uint8_t spUP[]            PROGMEM = {0x2D,0xCD,0x72,0xA2,0x55,0x77,0xDD,0xF6,0x36,0xB7,0xB9,0xD5,0xEA,0xB3,0xC9,0x6C,0xF1,0xD5,0xE9,0x4A,0xB6,0xBD,0x39,0x7F,0x21,0x50,0x84,0x72,0x17,0x91,0x0D,0x00,0x20,0x80,0x48,0xD3,0x08,0x90,0x54,0x28,0x06,0xFE,0x1F};
//uint8_t spIS[]            PROGMEM = {0xAD,0xED,0xD5,0x58,0xA4,0x9E,0xCE,0x76,0xF5,0xDD,0xAB,0x29,0xF5,0xD2,0xDD,0xEF,0x7E,0x0C,0xC3,0xA9,0x06,0xFA,0xD3,0x32,0x0F,0x6E,0x94,0x22,0x8F,0xF3,0x92,0xF6,0x05,0x43,0xCC,0x74,0x77,0x3E,0xC3,0xF5,0x95,0x98,0xA9,0xBA,0x8B,0x8F,0x00,0x7E,0x73,0xE5,0x00,0x05,0x28,0xF0,0xFF};
//const uint8_t spALERT[]         PROGMEM = {0xA5,0xCF,0xC6,0xAB,0x55,0x5B,0xAF,0x39,0xDA,0xC9,0x54,0xDD,0xBC,0xC6,0xC2,0x3C,0x27,0x20,0xCF,0x1C,0xD7,0x30,0xB0,0x45,0x16,0x69,0x1D,0xC3,0x11,0xE4,0x59,0x8A,0x7C,0xB5,0x9B,0x8B,0xD9,0x30,0xB7,0xD3,0x76,0x19,0x9A,0x25,0x59,0x57,0x59,0xEC,0x11,0xAF,0xE8,0xD9,0xF9,0x2A,0x8A,0x1D,0xF0,0x75,0x3F,0x73,0xAC,0x87,0x3B,0xA2,0x0B,0xAA,0x2B,0xCF,0xE4,0x10,0xA1,0xDC,0x45,0x64,0x03,0x00,0x80,0x01,0x66,0x36,0x33,0xC0,0xAB,0xD5,0x0A,0x68,0x25,0x85,0x02,0xFF,0x0F};
const uint8_t spADJUST[]        PROGMEM = {0xAD,0xAD,0xA1,0xD5,0xC4,0x5A,0x9F,0xB1,0xFA,0x14,0xB3,0x78,0xBC,0x87,0x31,0x55,0x9B,0xEC,0xC2,0x6B,0xC4,0xE6,0xB9,0xDB,0xB8,0x97,0x24,0x87,0xA6,0x99,0x59,0x61,0x4B,0x1C,0x05,0x63,0x56,0x79,0x6C,0x05,0x4C,0xC5,0x14,0x81,0x35,0xB4,0x98,0xAC,0xAE,0x7D,0x6E,0x77,0xAA,0xE2,0xD2,0x5A,0x63,0xD5,0xAD,0x6E,0xBD,0xBA,0xE2,0xD3,0x8A,0xAB,0xF2,0x1C,0x15,0x50,0x41,0x8A,0x03,0x7E,0x29,0xF1,0x80,0x05,0x2C,0xA0,0x01,0x01,0xFC,0xD6,0x2A,0x01,0x60,0xC0,0x0B,0xEC,0x16,0x60,0x40,0xB7,0x63,0xFF,0x0F};
const uint8_t spBETWEEN[]       PROGMEM = {0xA2,0xED,0xD9,0x59,0x4C,0xFB,0xEC,0xE2,0x0C,0x33,0x34,0x83,0xD9,0x96,0x3B,0x8E,0x69,0xC6,0x15,0x14,0xDA,0x03,0xE0,0x80,0x6E,0xCD,0x03,0xD0,0xE3,0xB8,0x02,0x72,0x48,0x2B,0x45,0xB0,0xE9,0x69,0x12,0x77,0x55,0x99,0xA7,0x57,0x42,0x93,0x53,0x74,0x19,0xE6,0x89,0x6B,0x4E,0x39,0x82,0xB3,0xA6,0x3E,0x3A,0xE5,0x2C,0x81,0x5C,0x59,0xE9,0xD6,0xAB,0xEB,0x81,0x31,0x27,0xCA,0xCC,0xA5,0x6F,0x65,0x1B,0x09,0x5D,0x3D,0xDC,0xD4,0x23,0x9F,0xE9,0xA9,0x8A,0xB4,0xDD,0x92,0xFC,0x3F};
//const uint8_t spMINUTES[]       PROGMEM = {0x61,0xCA,0xCC,0x38,0x5B,0x9A,0xE6,0xA9,0xB6,0xA7,0xEC,0x2A,0xC5,0xDD,0x17,0xDF,0xE2,0xE6,0x23,0x6B,0x16,0xC3,0x2D,0x92,0xCC,0x72,0xB5,0xD5,0xBA,0x86,0xD5,0xEC,0xB9,0x94,0xAD,0x98,0x90,0xF4,0x79,0x14,0xDE,0x8E,0x53,0x3C,0x63,0x23,0x02,0x45,0x28,0x77,0x11,0xD9,0x00,0x80,0x80,0xCF,0x58,0x05,0xF0,0x7B,0x99,0x04,0x38,0xC0,0x01,0x0A,0x50,0xE0,0xFF,0x01};
const uint8_t spBUTTON[]        PROGMEM = {0x10,0xA6,0x28,0xDD,0xCD,0x2D,0xD5,0x6A,0x8B,0xEE,0x6C,0xB1,0x4D,0xA7,0xAC,0x2E,0xA3,0x44,0x97,0xDC,0xA6,0xF5,0xCD,0x6B,0x34,0x46,0x13,0x32,0x89,0x50,0xEE,0x22,0xB2,0x01,0x20,0xA5,0xDD,0xA1,0x94,0xBB,0xB3,0xB6,0x0C,0x2F,0xA4,0xE6,0xF1,0xFA,0x96,0x8F,0x70,0x8F,0xC2,0x2A,0xE6,0x4A,0xDD,0xD3,0x2D,0x51,0x7A,0xDA,0xF3,0xAF,0x7B,0x47,0x63,0x51,0x73,0x67,0xE1,0x6B,0x46,0xDD,0x49,0xEB,0xFE,0x3F};
const uint8_t spCLOCK[]         PROGMEM = {0x06,0x48,0x65,0x34,0x00,0x93,0xA7,0x5B,0xA0,0xA4,0x95,0xBA,0x5F,0x82,0x9B,0x95,0x07,0x37,0x55,0x24,0x4D,0x4E,0x51,0xE9,0x54,0x25,0x76,0xB9,0xE5,0x2D,0x4F,0x93,0x7D,0xE5,0x98,0xAE,0xDE,0x63,0x3B,0x72,0xC9,0x2C,0x8E,0xD9,0xF1,0x41,0xA0,0x08,0xE5,0x2E,0x22,0x1B,0x00,0x40,0x00,0x35,0x0D,0x69,0x80,0x02,0xFF,0x0F};
const uint8_t spDEVICE[]        PROGMEM = {0x64,0x8E,0x38,0x3C,0x4B,0x62,0x8F,0x7D,0x89,0x14,0xD4,0xCC,0xB5,0x86,0x11,0x9A,0xD1,0xB5,0xCF,0x1C,0xDC,0xDC,0xA5,0x23,0xB5,0x3B,0xCB,0x73,0x9D,0x46,0x99,0x6D,0x59,0x35,0xE5,0xD9,0xF5,0x69,0xAA,0x1E,0xCB,0xE2,0xCD,0xB7,0xB9,0xDD,0x19,0xAA,0x2F,0xE9,0xD0,0xD5,0x7B,0x69,0x57,0xF3,0x49,0x1E,0xF1,0x28,0xDE,0x0C,0xB8,0x36,0x54,0x00,0xBF,0x55,0x6A,0x40,0x03,0x1A,0xE0,0x00,0x07,0x28,0xF0,0xFF};
//const uint8_t spEAST[]          PROGMEM = {0xAD,0x1D,0x59,0x50,0xBC,0x17,0x8F,0x7A,0x96,0x02,0x8C,0x7C,0xB2,0xEB,0x5D,0xCD,0x7A,0x0C,0x63,0x10,0x71,0xCC,0xEC,0x3E,0xA5,0x75,0x0C,0x41,0xF2,0x7A,0x4C,0x80,0x6F,0x67,0x24,0xA0,0x01,0x05,0xFC,0x3C,0xA5,0x01,0x0D,0x58,0x40,0x02,0x04,0xF8,0xDA,0x1C,0x03,0x1A,0x30,0xC0,0x31,0x37,0x02,0xE8,0xF5,0x8D,0x00,0xD5,0x39,0xFC,0x3F};
const uint8_t spFAIL[]          PROGMEM = {0x04,0x98,0x3E,0x8D,0x03,0x1C,0xD0,0x80,0x07,0x4A,0xBF,0x54,0x9B,0x3A,0x79,0x9C,0xCD,0xAA,0x9B,0x0F,0x31,0x8F,0x37,0xB7,0xBE,0xCD,0x6A,0x47,0x2A,0x66,0xB3,0xB7,0xB3,0xDB,0x6B,0x5F,0xC7,0x56,0x44,0x58,0x8E,0x76,0xAA,0x7B,0xD8,0x33,0xB9,0x32,0xD7,0x3C,0xF9,0x0C,0x67,0xD4,0x13,0x9E,0x98,0xC7,0x5F,0xEE,0x49,0x7C,0xAA,0x8D,0xF3,0xF9,0xF7,0xFF,0x01};
const uint8_t spFREQUENCY[]     PROGMEM = {0x04,0xA8,0x4A,0x9D,0x01,0x33,0x8C,0x71,0x40,0x02,0x1A,0x08,0x71,0x4E,0x5C,0x52,0xEA,0x7E,0x67,0x2B,0xEB,0xB5,0x98,0x82,0xB7,0xEE,0x64,0xA4,0x7D,0x18,0xB2,0xDB,0x1B,0x9B,0x22,0x50,0x84,0x72,0x17,0x91,0x0D,0x04,0xF0,0x35,0x2D,0x25,0x59,0xB9,0x57,0xCA,0xE2,0x39,0xB4,0xB1,0x69,0xB4,0xF2,0xB4,0x5B,0x97,0xB0,0x14,0x05,0x15,0x91,0x6A,0xF4,0x2A,0x80,0x5F,0x4A,0x2D,0xE0,0x01,0x0B,0x68,0x40,0x03,0x63,0x69,0x56,0xC5,0x25,0x57,0x8D,0xAD,0x27,0x63,0xB1,0x78,0xDC,0x8F,0x7E,0x95,0x6B,0xE6,0x24,0x32,0x5B,0x93,0xEE,0xD1,0x83,0x58,0xEC,0x4D,0x7E,0xE3,0xF7,0xFF};
const uint8_t spGATE[]          PROGMEM = {0x0C,0x08,0xDA,0x75,0x2C,0xB3,0x27,0x19,0xBB,0xDD,0xD1,0xB7,0x44,0xE4,0x51,0x73,0x4E,0x3D,0x7A,0x90,0x49,0x2C,0xB9,0xE5,0xAD,0x6E,0xB5,0xBA,0x99,0x0A,0x24,0xE3,0xF1,0x1E,0xFA,0x1E,0xEE,0x31,0x13,0x59,0xE3,0x8D,0xFA,0x47,0x21,0x32,0xAF,0xC7,0x08,0x14,0xA1,0xDC,0x45,0x64,0x03,0x00,0x38,0x60,0x89,0x52,0x03,0x6C,0xF3,0xC3,0x80,0xDE,0xD7,0x08,0x50,0x8D,0xE1,0xFF,0x03};
//const uint8_t spHIGH[]          PROGMEM = {0x04,0xC8,0x7E,0x9C,0x02,0x12,0xD0,0x80,0x06,0x56,0x96,0x7D,0x67,0x4B,0x2C,0xB9,0xC5,0x6D,0x6E,0x7D,0xEB,0xDB,0xDC,0xEE,0x8C,0x4D,0x8F,0x65,0xF1,0xE6,0xBD,0xEE,0x6D,0xEC,0xCD,0x97,0x74,0xE8,0xEA,0x79,0xCE,0xAB,0x5C,0x23,0x06,0x69,0xC4,0xA3,0x7C,0xC7,0xC7,0xBF,0xFF,0x0F};
const uint8_t spINTRUDER[]      PROGMEM = {0xAB,0x1D,0xA9,0x88,0xCC,0x37,0x9F,0x66,0xBA,0x16,0x31,0xFE,0xBC,0xEB,0x55,0x0F,0xCF,0x98,0x69,0x55,0x47,0xD3,0x0C,0xF2,0xA4,0x45,0xAB,0x6D,0x6D,0x43,0x57,0x34,0xF8,0x78,0x34,0x45,0xA0,0x08,0xE5,0x2E,0x22,0x1B,0x14,0xD0,0x4A,0x46,0x06,0x34,0xD0,0xD2,0xEC,0x39,0xCC,0xCC,0xDD,0xCC,0x56,0x9E,0x95,0x58,0x14,0xB5,0xDB,0x45,0xAB,0xAB,0x27,0x4B,0xF6,0x74,0xA2,0x62,0xCE,0xB2,0x3C,0x66,0xB7,0x7A,0x2C,0x0B,0x61,0x95,0xBB,0x96,0x96,0x4C,0xD9,0x35,0xDB,0x98,0xAB,0x29,0xA2,0xB3,0x7C,0x73,0xED,0x47,0xBB,0x4A,0x2E,0xD0,0x71,0x3F,0xF9,0x8B,0x5F,0xF8,0x4A,0x0F,0xF4,0xD1,0x3C,0xFF,0x0F};
const uint8_t spMEASURE[]       PROGMEM = {0x66,0x71,0x52,0xED,0xD2,0x92,0x86,0x39,0x2B,0xE6,0x4E,0x8F,0x9B,0xC7,0xD1,0x17,0xA3,0x1C,0x22,0x69,0x4F,0xD7,0x73,0xA8,0x9B,0xAE,0xBE,0xF5,0xAD,0x6E,0x39,0xF2,0xEE,0x45,0xD4,0x7C,0xA5,0x01,0x1A,0x63,0x0E,0xC0,0xA8,0x81,0x11,0x18,0x7D,0x8F,0x29,0x68,0x96,0x75,0x0C,0x25,0x27,0x71,0x85,0xF7,0x39,0xCF,0x7D,0x1E,0xE5,0x2A,0x4B,0xD8,0x5B,0xF3,0xE4,0x27,0x3E,0xFE,0x75,0x7F,0x19,0x46,0xD9,0xBC,0xE5,0xFF,0x01};
//const uint8_t spNORTH[]         PROGMEM = {0x66,0x8E,0x54,0xAC,0x9A,0xE7,0x84,0xA9,0x0A,0xE2,0x1C,0xAE,0x5B,0xC6,0xE6,0x51,0xCD,0x23,0xE9,0xE9,0x8B,0x71,0x77,0xD3,0xAE,0xA7,0x2A,0x22,0x3D,0x8B,0xB2,0x9E,0x32,0x8B,0xCE,0x6C,0xD6,0x76,0x8B,0x55,0x26,0xB7,0xE2,0xCB,0x7A,0x77,0x35,0x87,0xB6,0xE5,0x92,0x54,0xA9,0xF9,0xC6,0x91,0x63,0x88,0xA7,0x77,0xEE,0x67,0xBA,0x4B,0x60,0x2F,0xAB,0xD6,0x04,0x18,0xB2,0x44,0x03,0x06,0xC8,0xB2,0x44,0x03,0x14,0xA0,0xC0,0xFF,0x03};
const uint8_t spPASS[]          PROGMEM = {0x0A,0xC8,0x33,0x83,0x03,0xA3,0xEC,0x55,0x2D,0xD4,0x12,0xAF,0xAA,0x04,0xC9,0xD4,0x0E,0x7D,0xAA,0x16,0x4A,0x33,0x65,0xCE,0xAD,0x6F,0x7D,0x9A,0x9A,0xDC,0xDB,0x62,0xEE,0x6D,0x6E,0x73,0xC6,0x12,0xDD,0x5B,0x6B,0xEE,0x5D,0xF6,0x3A,0xCE,0xAA,0xD2,0x26,0xED,0x75,0xBB,0x9B,0x4D,0x6D,0xF1,0x25,0xFD,0x77,0x7F,0xEF,0xD2,0xCE,0x9D,0x46,0x00,0x4B,0x17,0x2B,0xE0,0x8F,0x52,0x0B,0x68,0x40,0x02,0x1C,0x90,0xC0,0xFF,0x03};
const uint8_t spPOSITION[]      PROGMEM = {0x02,0xC8,0x3C,0x78,0x24,0x5D,0xB8,0xBB,0x53,0xB7,0x5B,0xDC,0x62,0xD5,0x4B,0x38,0x87,0xA1,0x1F,0x05,0x5C,0x40,0x66,0x81,0x95,0x1D,0x19,0xA6,0x4E,0x7E,0x4E,0x3C,0x75,0xA8,0x39,0xF5,0x3D,0x51,0xB7,0xA9,0xA6,0xBA,0xE7,0x44,0x2D,0x99,0x2A,0xC7,0xA6,0x04,0x8C,0x3E,0x95,0x81,0x0C,0x78,0xA0,0xF5,0x2D,0xA8,0x98,0xD9,0x96,0x3D,0x8D,0x69,0xE8,0x64,0x4B,0xE9,0x3B,0x8E,0xA1,0x9D,0xBD,0xA4,0x4B,0x3B,0xBA,0x16,0x2C,0x77,0x7B,0xF9,0xCA,0x4F,0x78,0x7B,0x20,0x35,0x0B,0xA7,0xF1,0xFF,0x7F};
const uint8_t spPUSH[]          PROGMEM = {0x06,0x28,0x22,0x5D,0x03,0xCB,0x4B,0x2A,0x23,0x03,0xDB,0x9E,0xB8,0x88,0x8C,0x18,0xCC,0x7A,0xD3,0x9B,0xAF,0xBA,0x78,0xE7,0x70,0xEB,0xDA,0xC6,0x9E,0x27,0x44,0x44,0xAB,0x01,0x56,0xBE,0x8A,0x40,0x04,0x22,0xE0,0x01,0x0F,0x78,0x40,0x02,0xFF,0x0F};
//const uint8_t spRIGHT[]         PROGMEM = {0x66,0xD7,0xB1,0x24,0xDC,0xE3,0x98,0xCD,0x95,0xA4,0x28,0xB5,0x97,0xD6,0xD0,0x8C,0x3A,0x55,0xFE,0x18,0x43,0xB1,0x4C,0x37,0x6F,0xA7,0x2D,0x72,0x22,0x8A,0xF3,0x9E,0xA6,0xFA,0x94,0x0A,0xDD,0x7C,0x9B,0xDB,0xAD,0xB1,0xD7,0x40,0xF3,0x78,0x3D,0xE7,0x7E,0xE6,0x07,0x81,0x22,0x94,0xBB,0x88,0x6C,0x00,0x50,0xC0,0xB6,0xD7,0x1E,0x10,0x40,0x9B,0xEB,0x0C,0x28,0x56,0xE9,0xFF,0x01};
//const uint8_t spSLOW[]          PROGMEM = {0x04,0xF8,0xCB,0x44,0x01,0xBF,0x86,0x5B,0xC0,0x02,0x1C,0x28,0xD3,0xC6,0x1C,0x55,0xA2,0xAD,0x0F,0xB3,0x3D,0xC5,0xA4,0x16,0x95,0xE4,0xF5,0x64,0x95,0x7B,0x8E,0x53,0xDF,0x9B,0xAD,0x22,0xF1,0xEA,0x61,0xCE,0xBB,0x9B,0xD9,0xCF,0xB9,0x2F,0x7D,0x0D,0x9B,0xD7,0x5D,0x0B,0x92,0x27,0x1E,0xEE,0xD4,0xA5,0x32,0x50,0xDB,0xD8,0xD3,0x5E,0xEE,0xF6,0xB1,0xDD,0x55,0xBB,0xFC,0x3F};
const uint8_t spTOOL[]          PROGMEM = {0x09,0x38,0xD6,0xCC,0x01,0xCB,0x76,0xB5,0x38,0x73,0x0B,0x4F,0xCA,0x3A,0x92,0x42,0xAD,0x25,0x29,0xFD,0x4E,0x47,0x9A,0x78,0x64,0x34,0xA4,0xEB,0xC5,0xA8,0x0A,0xB1,0xCA,0x02,0x77,0xB5,0xAF,0x73,0x5A,0x83,0x88,0x69,0xA3,0x6C,0x69,0xCD,0xCC,0x67,0x94,0xDC,0xE7,0x3D,0x5E,0xF1,0x09,0x7F,0x11,0xDA,0xC3,0xE2,0xF5,0xFF,0x01};
//const uint8_t spWEST[]          PROGMEM = {0x66,0xB7,0x7C,0x53,0x53,0x6B,0xFA,0xC5,0xCF,0x65,0x4C,0x64,0x56,0x5C,0x1C,0xAF,0xA6,0xE0,0xEA,0x68,0x52,0x77,0x8A,0x2A,0xD2,0xB3,0x29,0xDF,0xC9,0x9B,0x4A,0xCD,0xE2,0xCD,0x37,0x5F,0x45,0x8B,0x21,0xAD,0xF1,0x78,0xB7,0xBB,0x1F,0x4B,0x89,0x92,0xC6,0x17,0x5B,0x01,0x8F,0x9B,0x1A,0xE0,0x97,0x48,0x0F,0x78,0xC0,0x03,0x1A,0x10,0xC0,0x9F,0xED,0x1C,0xC0,0x00,0x28,0xE0,0x15,0x56,0x05,0x1C,0x9F,0x43,0x80,0x61,0x26,0xFF,0x1F};
//const uint8_t spKILO[]          PROGMEM = {0x06,0xD8,0x29,0x25,0x01,0x5D,0x22,0x7B,0xA0,0x85,0x33,0x1A,0x52,0xD7,0xDB,0x19,0xCF,0x68,0x44,0xD3,0x29,0x51,0x79,0xBC,0x99,0xAC,0x6C,0x71,0x0B,0x4D,0xCA,0xB6,0xC7,0x35,0x55,0xEE,0x39,0x4E,0x7D,0xEF,0xBA,0xD6,0xC2,0x32,0xAB,0xB8,0xEF,0xDE,0xDB,0x99,0x4C,0x65,0x2B,0xF5,0xED,0x67,0xB9,0x7D,0xAC,0x6C,0xD4,0x35,0xF1,0x8E,0x4F,0x78,0x83,0x9A,0xCA,0x20,0xBF,0xEE,0x4F,0x62,0xBC,0x82,0xF4,0xFD,0x3F};
//const uint8_t spAND[]           PROGMEM = {0xA9,0x6B,0x21,0xB9,0x22,0x66,0x9F,0xAE,0xC7,0xE1,0x70,0x7B,0x72,0xBB,0x5B,0xDF,0xEA,0x56,0xBB,0x5C,0x65,0xCB,0x66,0xC5,0x3D,0x67,0xD7,0xAB,0x6D,0x2E,0x64,0x30,0x93,0xEE,0xB1,0xCD,0x3D,0x92,0xB9,0x9A,0xDA,0xB2,0x8E,0x40,0x12,0x9A,0x6A,0xEB,0x96,0x8F,0x78,0x98,0xB3,0x2A,0xB4,0xD3,0x48,0xAA,0x2F,0x7D,0xA7,0x7B,0xFB,0x0C,0x73,0x71,0x5C,0xCE,0x6E,0x5C,0x52,0x6C,0x73,0x79,0x9A,0x13,0x4B,0x89,0x45,0xE9,0x6E,0x49,0x42,0xA9,0x57,0xFF,0x3F};
const uint8_t spFARAD[]         PROGMEM = {0x04,0x58,0x3E,0x8D,0x03,0x1C,0xD0,0x80,0x05,0x4A,0xB9,0x54,0x9B,0x3A,0x79,0x9C,0xD5,0xA9,0x7B,0x0C,0x71,0xF7,0xD7,0xB7,0xBE,0xCD,0x68,0x4B,0x56,0xF1,0x12,0x3F,0xB5,0x4B,0x6B,0x2C,0x6C,0x91,0x26,0xBF,0x4E,0x63,0x2E,0x91,0x43,0x5D,0xDB,0xAF,0xA5,0xF9,0x10,0x0D,0xE9,0x3E,0xF7,0x7A,0xF2,0x0B,0x81,0x22,0x94,0xBB,0x88,0x6C,0x20,0xCF,0xA2,0xEE,0x95,0x99,0x38,0x3D,0xDD,0x85,0x89,0xCA,0x96,0xFC,0xFC,0x3F};
const uint8_t spMILLI[]         PROGMEM = {0x6E,0xF0,0x8A,0xB3,0x4B,0xEB,0xC6,0xAE,0x36,0xA7,0x1A,0x3A,0x54,0x53,0xD6,0xDC,0xEC,0x66,0x23,0xDF,0x58,0x26,0x43,0xB4,0xCD,0xEA,0x74,0x5D,0x94,0x46,0xF0,0x96,0x3B,0x9D,0x79,0x98,0x26,0x75,0xDB,0xB3,0xD7,0xB6,0xF5,0x90,0xA8,0x91,0x9F,0xEA,0x9E,0xEE,0xE9,0x9B,0x20,0x7D,0xCB,0xFF,0x03};
//const uint8_t spCAUTION[]       PROGMEM = {0x02,0x48,0x69,0x4D,0x03,0x06,0xE8,0x34,0xA2,0x85,0x95,0x4C,0x78,0xA8,0xD2,0x93,0x66,0xB1,0xE9,0x4D,0x79,0x6F,0x7A,0xD3,0x9D,0xF5,0xCC,0x01,0x2B,0x86,0x06,0x60,0xC5,0xAB,0x08,0x44,0x20,0x00,0xCD,0x10,0x8D,0xB6,0x26,0x11,0x8B,0xE8,0x3C,0xE6,0x62,0x5D,0x3D,0x63,0xF7,0x58,0xBB,0x4E,0xF1,0xB0,0x2E,0xED,0x28,0xCA,0x74,0xCC,0x9B,0xB8,0xB7,0x69,0xA6,0x0E,0x8F,0x66,0xBE,0xAC,0x48,0xC6,0xAD,0xAE,0xFB,0x9A,0x16,0x0E,0xF3,0x78,0xFE,0xF3,0xBF,0xFF,0xED,0xFF,0xFF};
//const uint8_t spLIGHT[]         PROGMEM = {0x61,0x69,0xC0,0x2B,0x82,0xB3,0xA5,0x79,0x01,0x9A,0x52,0x71,0x57,0xC7,0x31,0x0C,0x5C,0x5D,0xC1,0x59,0x6F,0x7B,0x9A,0xC6,0x3B,0xCB,0xA5,0xCB,0xA9,0xAA,0x6D,0x6B,0xB3,0xCD,0xA7,0x6C,0x29,0xB4,0x34,0x56,0xAF,0xBA,0x0F,0x23,0x93,0x5C,0x32,0xC7,0xB6,0xF6,0x46,0xA4,0x39,0xB3,0xF3,0x86,0x40,0x11,0xCA,0x5D,0x44,0x36,0x00,0x80,0x02,0x96,0x2A,0x35,0xC0,0xB6,0x97,0x0C,0xE8,0xF9,0x04,0x01,0xC5,0x19,0xFC,0x3F};
//const uint8_t spCHECK[]         PROGMEM = {0x0E,0x58,0x25,0x25,0x00,0xB3,0x8E,0x7B,0x60,0xC5,0x35,0xB3,0x68,0xE4,0xEA,0x53,0xB4,0x1C,0x12,0xEE,0x9B,0x6F,0x79,0xAB,0x5B,0xEF,0x71,0xEF,0xE6,0xAE,0x49,0xA9,0x2A,0x17,0x21,0x50,0x84,0x72,0x17,0x91,0x0D,0x00,0x0A,0x68,0xC5,0x49,0x02,0x12,0xE0,0xC0,0xFF,0x03};
//const uint8_t spDEGREES[]       PROGMEM = {0x65,0x9F,0x5A,0x48,0x42,0x1D,0x8F,0x61,0xB8,0x62,0x56,0xFE,0xB2,0xFA,0x51,0x9C,0x85,0xED,0xCD,0xEA,0x47,0x4B,0x64,0xD5,0x35,0x69,0xE8,0xC7,0x41,0xD4,0x5E,0x8B,0x25,0x6B,0xB4,0x75,0xB7,0x84,0x40,0x11,0xCA,0x5D,0x44,0x36,0x98,0xAD,0xA9,0xAB,0x28,0x8D,0x1B,0xFA,0xE2,0x26,0xC9,0x44,0x69,0x6A,0xA3,0x13,0x8F,0x70,0xAD,0xA5,0xC9,0x99,0x42,0xDC,0x9C,0x8D,0xA6,0x36,0x4E,0x72,0xB3,0xBF,0xEA,0xD6,0x54,0xD9,0x25,0xFD,0xAA,0x46,0x19,0x86,0x90,0xAF,0xB3,0xEE,0x4D,0x19,0x47,0x12,0x90,0xCE,0x5B,0x75,0xC9,0x5B,0xDA,0x47,0x31,0x14,0xF3,0xD7,0xF9,0xCC,0x77,0xFC,0xFC,0xEF,0xFE,0xE6,0x99,0xC2,0x7C,0x93,0xFE,0xC5,0xDF,0x44,0x08,0x5B,0x75,0x36,0xFF,0xD2,0xC6,0xE2,0x91,0xCE,0xFD,0xDF,0x89,0x9A,0x68,0x3A,0x01,0x4C,0x48,0x2A,0x80,0x5F,0x33,0x34,0x40,0x81,0xFF,0x07};
//const uint8_t spSERVICE[]       PROGMEM = {0x04,0xF8,0xAD,0x94,0x03,0x1A,0xB0,0x80,0x07,0x2C,0xB0,0xA2,0xE6,0xCD,0xD4,0xB4,0xEB,0xC9,0xAA,0x4D,0xE1,0xD6,0xEC,0x23,0x2B,0xBE,0x85,0x96,0xFD,0xCD,0xBC,0x15,0xB9,0x16,0xE9,0xB0,0xBF,0x51,0x66,0x5F,0x24,0xA3,0x7A,0x53,0x97,0xBD,0x89,0xBB,0xC4,0x52,0x4B,0xB1,0xAE,0xE6,0x9A,0xB9,0xEE,0x63,0xAD,0xCE,0x35,0xD4,0x7A,0xCF,0xA3,0x9F,0xE9,0x2E,0xD2,0x25,0xDD,0x77,0x13,0xE0,0xB7,0x52,0x09,0x48,0xC0,0x02,0x16,0x90,0x00,0x05,0xFE,0x1F};
const uint8_t spSWITCH[]        PROGMEM = {0x08,0xF8,0x3B,0x93,0x03,0x1A,0xB0,0x80,0x01,0xAE,0xCF,0x54,0x40,0x33,0x99,0x2E,0xF6,0xB2,0x4B,0x9D,0x52,0xA7,0x36,0xF0,0x2E,0x2F,0x70,0xDB,0xCB,0x93,0x75,0xEE,0xA6,0x4B,0x79,0x4F,0x36,0x4C,0x89,0x34,0x77,0xB9,0xF9,0xAA,0x5B,0x08,0x76,0xF5,0xCD,0x73,0xE4,0x13,0x99,0x45,0x28,0x77,0x11,0xD9,0x40,0x80,0x55,0xCB,0x25,0xE0,0x80,0x59,0x2F,0x23,0xE0,0x01,0x0B,0x08,0xA0,0x46,0xB1,0xFF,0x07};
const uint8_t spVALVE[]         PROGMEM = {0x61,0x1F,0x5A,0x58,0x4D,0x9C,0x08,0x60,0x58,0x95,0x32,0x0D,0x2D,0xAC,0x26,0x4E,0x46,0xD7,0x5C,0x58,0x18,0xAF,0x3E,0x6D,0x73,0x6A,0x65,0xF6,0xE4,0x34,0xCD,0xA6,0x97,0xD9,0x93,0x5B,0xDF,0xFA,0x36,0xAB,0xCF,0x6A,0xA3,0x55,0x36,0xEF,0x7E,0xCF,0x63,0x2E,0xF4,0xAA,0x9C,0xFA,0x8C,0xAD,0xC1,0x9E,0x76,0xF2,0xD6,0xF7,0xBA,0xD7,0xA3,0x1C,0x85,0x78,0x76,0xA1,0xFA,0x78,0xC4,0x3B,0xDC,0x91,0x55,0x94,0x70,0x6A,0x7F,0xEB,0x87,0x00,0x55,0xA8,0x70,0x80,0x02,0x14,0xC0,0xC0,0xFF,0x03};
const uint8_t spVAL[]           PROGMEM = {0x24,0x4B,0x38,0x2C,0x43,0x13,0xBB,0xEC,0xB8,0xB6,0xD0,0x76,0xBD,0xDA,0x6D,0x4B,0xC5,0xD8,0xF7,0x69,0x9B,0x55,0x2B,0xB3,0x27,0xA7,0x69,0x36,0xAD,0xCC,0x9E,0xDC,0xFA,0xD6,0xB7,0x59,0x7D,0x56,0x1B,0xAD,0xB2,0x79,0xF7,0x73,0x68,0x73,0x0C,0x5D,0xE1,0xD2,0xA6,0xEE,0xF9,0x0C,0x57,0xB0,0x13,0xC1,0x9E,0x36,0x5E,0xEE,0xCE,0x22,0xAC,0xD5,0xE2,0xF8,0xDB,0xDC,0x4D,0x09,0xA5,0x47,0xDC,0x78,0x9B,0xBB,0x7B,0x62,0xB7,0x70,0xF6,0xFF};
const uint8_t spNUMBER[]        PROGMEM = {0x66,0xA9,0x12,0x72,0x42,0x9B,0x86,0xA5,0x1B,0x90,0x0E,0x6D,0x76,0xA6,0x26,0x2B,0xDC,0xA5,0xCF,0x6D,0x4F,0x95,0x4D,0xA5,0xBB,0x6E,0x5E,0x45,0x31,0x5E,0x65,0x92,0x66,0x14,0x45,0xAA,0xB4,0x98,0x9D,0x5A,0x84,0x2A,0x18,0xF6,0x92,0x74,0x43,0x3A,0xAD,0x5C,0x27,0xDD,0x6D,0x98,0xA3,0x09,0xF5,0x92,0xA4,0x65,0x4C,0x4D,0xA4,0x82,0x56,0x97,0x39,0x77,0xC7,0x68,0xF1,0x5D,0xD6,0xDC,0x1D,0x63,0xD4,0x4F,0xBE,0xC3,0x9D,0x53,0x81,0x4E,0xF3,0x89,0x9F,0xFF,0xDC,0x5F,0x66,0x92,0xB5,0x7A,0xFE,0x7F};
//const uint8_t spOUT[]           PROGMEM = {0xAD,0xCF,0xE6,0xDD,0xD3,0x17,0xED,0xFE,0xF4,0x9D,0x4F,0x56,0x71,0x97,0xDB,0xDD,0xEE,0x76,0xA7,0xCF,0xAE,0x6A,0x54,0x5A,0xEF,0x7E,0x0F,0x7B,0x4C,0x6B,0x88,0x95,0x21,0xBC,0xD9,0x6F,0x08,0x14,0xA1,0xDC,0x45,0x64,0x03,0x00,0x08,0xE0,0xE8,0x2E,0x0F,0x50,0xE0,0xFF,0x01};
//const uint8_t spPOINT[]         PROGMEM = {0x06,0xA8,0xCC,0x4B,0x03,0x2D,0xF3,0x69,0x2B,0x8C,0x1A,0xAF,0x2C,0x98,0xE9,0x28,0x4A,0xB3,0xF3,0x53,0xC6,0x90,0x9E,0xC1,0x6D,0x76,0x77,0xE6,0x9C,0x5D,0xD3,0x75,0xF1,0x58,0x5B,0x75,0x76,0xB7,0x4F,0xE3,0xE8,0xCE,0x31,0x3A,0x17,0xB6,0xB3,0x45,0x96,0xF4,0xAA,0x6D,0x4F,0x75,0x76,0xA3,0x94,0x66,0x6E,0x10,0x28,0x42,0xB9,0x8B,0xC8,0x06,0x50,0xC0,0x32,0x11,0x0A,0x58,0x76,0x87,0x01,0x3D,0xB5,0xFE,0x3F};
const uint8_t spBREAK[]         PROGMEM = {0x90,0xC6,0x62,0x2D,0xDC,0xCC,0x76,0xE9,0x63,0x55,0xD3,0x32,0xF5,0xAD,0x4F,0x5D,0x42,0x53,0xF5,0x9D,0xB6,0x14,0x49,0x0D,0xCD,0x73,0xEA,0x5A,0x4C,0xC3,0x6D,0xF3,0x69,0x7A,0x0B,0x52,0x8D,0x25,0xBB,0x9D,0x8B,0xDB,0xC7,0x13,0x90,0x8A,0xC7,0x08,0x14,0xA1,0xDC,0x45,0x64,0x03,0x00,0x03,0xC6,0xA8,0x14,0x40,0xCD,0x4A,0x16,0xE0,0x00,0x06,0xFE,0x1F};
//const uint8_t spHOURS[]         PROGMEM = {0x63,0xC9,0x66,0xA2,0xCC,0x57,0x9F,0xB1,0xF1,0xCE,0x6E,0xEE,0x72,0xBB,0xD3,0x24,0x3B,0x99,0x49,0x79,0x6E,0x35,0x2A,0x1F,0x27,0xBD,0xC8,0x4B,0x69,0x4D,0xDA,0xB0,0x54,0x2E,0x65,0xB0,0x65,0x34,0x43,0xF8,0x96,0x31,0x75,0xA5,0x6E,0xEA,0x53,0xD7,0x7C,0xA4,0x27,0xD7,0x00,0x6F,0xD7,0x1B,0x1F,0xFF,0xB8,0xB7,0x26,0x16,0x49,0xEB,0xE6,0x5F,0xF7,0x56,0x2B,0x62,0xEA,0xEB,0xDC,0xDB,0x83,0xB2,0x9A,0x74,0x73,0xEF,0x76,0x9E,0xC4,0xAA,0xDE,0x7D,0xBF,0x87,0xA6,0xA0,0x52,0x06,0x7C,0x4B,0x24,0x01,0x09,0x70,0xE0,0xFF,0x01};
const uint8_t spCALIBRATE[]     PROGMEM = {0x0E,0x18,0xC9,0xD9,0x01,0x55,0x29,0x9E,0xA0,0x16,0x97,0x70,0x5F,0x7C,0xB2,0xAA,0xDB,0x2B,0x79,0xCD,0xCD,0x56,0x51,0xC9,0x54,0x0D,0x26,0x1E,0x45,0xC3,0x55,0xDE,0xE2,0xF8,0x54,0xC5,0x94,0xA7,0x73,0x97,0xDB,0x94,0x3E,0xE9,0x52,0x2F,0xF6,0xC2,0x16,0xA9,0x4B,0xB3,0xCC,0x5E,0xD8,0xAA,0x34,0x31,0x73,0x27,0xE5,0x4C,0x8D,0xC3,0xD3,0xF4,0xF6,0xA9,0x2F,0xEB,0xA8,0x2E,0x39,0x42,0xFB,0x8E,0xAB,0x99,0xA4,0x28,0xFF,0x5C,0xEE,0x69,0x97,0x28,0x7D,0x4F,0x7D,0xD2,0xDF,0xAB,0x92,0x98,0x6F,0x41,0x8F,0x08,0xE5,0x2E,0x22,0x1B,0x00,0x18,0xB0,0x42,0xA4,0x02,0x5E,0xA8,0x26,0xC0,0xF0,0xE7,0xFF,0x0F};
const uint8_t spCRANE[]         PROGMEM = {0x0A,0xC8,0xBD,0xD5,0x03,0x16,0x50,0x40,0x5E,0x15,0x23,0x4F,0x5D,0xCC,0x87,0xB3,0xAE,0xA2,0xE4,0x64,0x1D,0x73,0x7F,0x8A,0x9A,0x9B,0xB5,0xA5,0xEB,0x29,0x7A,0x4D,0x36,0xB7,0x45,0xB7,0x58,0xF5,0x28,0x8E,0xDA,0x31,0x69,0x77,0x7B,0x98,0x73,0x5F,0xEA,0x1A,0xF6,0x1E,0x99,0xB3,0x62,0x74,0xB8,0xBA,0x47,0x73,0x4F,0xA7,0xF1,0x0A,0x77,0x4F,0xE4,0x2A,0xEE,0xD5,0x3D,0xCD,0x91,0x86,0x86,0xBB,0xF0,0x8C,0xC8,0x6C,0x9A,0xCE,0xFE,0x1F};
const uint8_t spDIRECTION[]     PROGMEM = {0xA5,0x7E,0xBE,0x3C,0x49,0x14,0xAF,0x6E,0xAA,0x52,0x72,0xCD,0x77,0xBA,0x66,0x4A,0x38,0xAC,0xDB,0xE9,0x8A,0x0F,0xB6,0xB0,0xF4,0xAD,0x4B,0x5D,0xDC,0x35,0xED,0xCF,0xF6,0xD4,0xA5,0x68,0xB8,0x85,0xFB,0x53,0xD6,0x90,0x34,0x1E,0x9D,0x6E,0x31,0xF2,0x36,0x9D,0x4A,0x6C,0x91,0xC9,0x47,0x18,0x63,0xD1,0xD8,0x02,0xE8,0xC1,0xCC,0x01,0x63,0x6C,0x45,0x20,0x02,0x1E,0x68,0x45,0x8D,0xAA,0x6E,0xD1,0x69,0x36,0x63,0x69,0x81,0x2D,0x25,0x9A,0xD4,0x23,0x1D,0x5D,0x0B,0xA5,0x7B,0xB4,0x78,0xF9,0xDB,0x7D,0x23,0x18,0xB9,0x58,0x7C,0xFF,0xBB,0xAF,0x19,0xC1,0x54,0x4B,0xF6,0xFF};
const uint8_t spENTER[]         PROGMEM = {0xAB,0x18,0xB6,0x39,0xDC,0x5E,0xDD,0xFA,0x96,0xAB,0xE8,0x41,0x24,0xC9,0x17,0xE5,0x0A,0x0C,0x70,0x4C,0x65,0xE9,0x4A,0x37,0xCC,0xE4,0xDE,0xB3,0x6F,0x73,0xA9,0x0D,0x36,0x9C,0x37,0xEF,0xE9,0xCA,0x35,0xA0,0x5A,0xFA,0x94,0xB7,0xD4,0xC4,0x48,0xC9,0x93,0xBF,0xFF,0x07};
const uint8_t spFEET[]          PROGMEM = {0x08,0x98,0x31,0x93,0x02,0x1C,0xE0,0x80,0x07,0x5A,0x3E,0x4A,0x28,0x99,0x3F,0x59,0xE9,0xE8,0x4E,0x64,0xFE,0x64,0x67,0xA3,0x98,0x45,0x41,0xB2,0x67,0xF7,0x36,0x4F,0x6A,0x9F,0x9D,0x91,0xB3,0x6E,0xA3,0x7B,0xCA,0x30,0x53,0x95,0x03,0x00,0x00,0x08,0x18,0xD2,0x4D,0x00,0xC7,0x6C,0x6A,0x40,0x00,0x3D,0xAC,0x62,0xE0,0xFF,0x01};
const uint8_t spFROM[]          PROGMEM = {0x04,0x18,0x26,0x8D,0x03,0x12,0xF0,0x80,0xAB,0x42,0x57,0x8B,0x61,0x6F,0xAB,0x4C,0xCE,0x2B,0xD2,0xD4,0xDD,0xE2,0x96,0xA7,0xCC,0x72,0xCA,0x93,0xDB,0xEC,0x6A,0xB7,0x73,0x68,0x4B,0xA7,0x61,0xA1,0x6C,0xB6,0xAF,0xF9,0x88,0x47,0x3C,0xFD,0xF3,0xFF};
const uint8_t spGAP[]           PROGMEM = {0x0C,0x08,0xDA,0x75,0x2C,0xB3,0x27,0x19,0xBB,0xDD,0xD1,0xB7,0x44,0xE4,0x51,0x73,0x4E,0x3B,0x7A,0x90,0x49,0x2C,0x39,0x75,0x77,0xAD,0x66,0xB6,0xE6,0x56,0xA7,0xAA,0x31,0x25,0x2D,0xD7,0xEC,0x61,0x2E,0x71,0x41,0xA0,0x08,0xE5,0x2E,0x22,0x1B,0x00,0x00,0x01,0x5D,0x85,0x29,0xE0,0x88,0x76,0x05,0x4C,0xF7,0xCE,0x80,0xEE,0x9B,0x29,0xF0,0xFF};
//const uint8_t spHOLD[]          PROGMEM = {0x08,0x68,0x34,0x5A,0x03,0x06,0x98,0x42,0xCC,0x02,0x23,0x4F,0x7C,0xD6,0x85,0xDA,0xAC,0xAC,0xE2,0xD8,0x32,0x4C,0xD3,0xF2,0x8C,0xF3,0x9C,0xA9,0x4B,0xCF,0x5A,0x51,0x91,0xEE,0x04,0xBA,0xEB,0x55,0xED,0xCB,0x12,0x85,0x6F,0x0A,0xBB,0xCB,0x6B,0xDC,0xE3,0x61,0x0F,0x73,0x65,0x41,0xAB,0x6A,0x69,0xCC,0x95,0x04,0x75,0x93,0xA7,0x35,0x67,0xD3,0x28,0xE3,0x9A,0x56,0x5D,0x85,0x93,0x65,0x68,0xB6,0x74,0x55,0x63,0xE6,0x62,0x6B,0xDC,0x59,0x2D,0x87,0xBB,0x3F,0xF9,0x7F};
//const uint8_t spLEFT[]          PROGMEM = {0x69,0x1D,0xC0,0xDA,0xCC,0xD3,0xA6,0xB5,0x81,0x68,0xD1,0xF4,0xDA,0xC7,0xD3,0x57,0x6F,0x11,0xDC,0x4B,0x6E,0x73,0x9A,0xE6,0x5D,0x5B,0x72,0xF5,0xED,0xF7,0xD2,0xCE,0x92,0x2C,0x5C,0xEA,0x0D,0x03,0x8A,0x0E,0x25,0xC0,0x74,0xE3,0x12,0xD0,0x80,0x04,0x10,0x90,0x89,0x2B,0x08,0x60,0x8B,0x71,0x0B,0x10,0xA0,0xB5,0xF3,0xFF,0x07};
const uint8_t spMILL[]          PROGMEM = {0x66,0x8E,0x8A,0xA2,0xC2,0x93,0xFA,0x29,0x8E,0xB9,0x1B,0x6D,0x4B,0xA6,0x26,0xF9,0xE4,0xD6,0xB7,0xBA,0xD5,0x6A,0xAB,0x4C,0x6B,0xD5,0xC7,0x6B,0x28,0xA4,0xB3,0x8D,0xFB,0xCC,0xB9,0xEC,0x05,0x75,0x97,0x61,0xDE,0xBA,0xE7,0x33,0x5D,0x0D,0x47,0x4D,0x80,0x97,0x78,0x9B,0xC7,0xEA,0xA9,0x62,0xED,0xFC,0xFF};
const uint8_t spUH[]            PROGMEM = {0x63,0x2A,0xAC,0x2B,0x8D,0xF7,0xEC,0xF1,0xB6,0xB7,0xDD,0xDD,0xEC,0xC7,0x5A,0x58,0x55,0x39,0xF5,0x9E,0x6B,0x3D,0xD3,0x59,0xB8,0x67,0x39,0xEE,0x8A,0x77,0x7A,0xAB,0x54,0x6F,0xC7,0x4C,0xF6,0x91,0xCF,0xFF,0x03};
const uint8_t spPAST[]          PROGMEM = {0x0A,0x88,0x29,0x4C,0x02,0x25,0xAB,0x4E,0xB4,0xCC,0x6B,0x9E,0x22,0x47,0x89,0xF2,0xAA,0x7C,0xEA,0x1A,0xDC,0x3A,0xED,0xCE,0xAD,0x6F,0x77,0x87,0x3B,0xCF,0x7D,0x9C,0xD5,0xBA,0x75,0xEA,0xE2,0x7E,0xB5,0xAB,0x05,0x8D,0x96,0x5C,0xE2,0xCE,0x3E,0x39,0x93,0xCA,0x0D,0x03,0xBE,0x37,0xD5,0x80,0x05,0x3C,0x60,0x01,0x0D,0x00,0x02,0x9E,0xE7,0xB0,0x80,0x00,0xA6,0x5E,0x47,0x40,0x1D,0x4B,0xFF,0x0F};
const uint8_t spPRESS[]         PROGMEM = {0x02,0x28,0x31,0x43,0x03,0x25,0xCB,0xBE,0xDC,0x5D,0xED,0x94,0x22,0x0E,0xCE,0x70,0xC9,0xBD,0xF2,0x9C,0xD5,0xBD,0x24,0xEF,0xC9,0xAB,0x77,0xF5,0x92,0x3E,0x27,0x6B,0xA1,0x25,0xD5,0x56,0xDF,0xEC,0x34,0x5D,0xA7,0x94,0xF9,0xEB,0x3B,0xEC,0x69,0xEE,0x75,0x15,0xC0,0x57,0xC1,0x02,0xF8,0x3D,0x5D,0x02,0x1A,0xD0,0x80,0x04,0x28,0x80,0x81,0xFF,0x07};
const uint8_t spRANGE[]         PROGMEM = {0x6C,0xE7,0xA5,0xD9,0x33,0xAD,0xAA,0x4D,0xF7,0xC0,0x6C,0x93,0xEA,0x66,0x3F,0x95,0x3A,0xD5,0x79,0xEB,0x62,0x17,0x69,0x0B,0xE7,0xAB,0x29,0x45,0x8A,0x4B,0xBD,0x9E,0xBA,0x17,0x63,0xB7,0x58,0x7D,0xAB,0x5B,0xAD,0x7A,0x94,0x00,0xAB,0x9C,0xB5,0xBB,0x39,0xCC,0xB9,0xAF,0x75,0x4F,0x7B,0x8F,0x10,0xEE,0x69,0x27,0x9C,0x3D,0x93,0xA4,0x79,0x5C,0x7F,0x87,0xB7,0x7B,0xE6,0x30,0x8B,0xE7,0x5F,0xF3,0x54,0xCD,0x92,0xA1,0x75,0xFC,0xC3,0x80,0x51,0x9C,0x24,0x60,0x01,0x01,0x8C,0xEC,0xF4,0xFF};
const uint8_t spSAFE[]          PROGMEM = {0x08,0xF8,0x39,0x4C,0x02,0x1A,0xD0,0x80,0x05,0x3C,0x60,0x81,0x95,0x0F,0x15,0xE2,0x6A,0xAB,0x4F,0xD1,0x43,0x8A,0x8A,0xBF,0xB9,0xD5,0xAD,0x57,0x3F,0xAA,0x23,0xBB,0x3F,0x9E,0xCB,0xDC,0xF3,0x99,0x9E,0x5E,0x19,0xCD,0xEB,0x8E,0x79,0x7A,0x43,0x13,0xED,0x39,0x0C,0x18,0x7E,0x5C,0x02,0x12,0x90,0x00,0x07,0x28,0x40,0x81,0xFF,0x07};
//const uint8_t spSOUTH[]         PROGMEM = {0x08,0xF8,0x2E,0x8C,0x03,0x0C,0xF8,0xB5,0xCD,0x02,0x16,0x50,0xC0,0x6F,0xA5,0x1E,0x50,0xC0,0x37,0xEE,0x23,0x69,0xCA,0x35,0x55,0x57,0xAF,0xA2,0xD8,0x8E,0x16,0x5D,0x7D,0xEB,0xDB,0xDC,0x76,0xF5,0xC9,0x4C,0x95,0x71,0xEF,0x3D,0xCD,0xBD,0x9C,0xC1,0x75,0x95,0x72,0x97,0xFC,0x84,0x3F,0xAA,0xAE,0x31,0xF1,0x2D,0x5E,0x5B,0x72,0x9C,0x62,0xB5,0xF9,0x92,0x8E,0x18,0x93,0xC4,0x04,0x18,0xB2,0x45,0x02,0x1C,0xA0,0x00,0x05,0x28,0x40,0x81,0xFF,0x07};
//const uint8_t spTURN[]          PROGMEM = {0x01,0x18,0xA9,0xCC,0x02,0x06,0x28,0x4E,0xA9,0x14,0x39,0x25,0x69,0x4B,0xBA,0x5D,0xAE,0xAA,0x84,0x15,0x5A,0xF5,0xBE,0xAB,0x59,0xCF,0x61,0xCE,0x7D,0x6B,0x5B,0x09,0x49,0x76,0xEE,0xB5,0x1E,0xE5,0x69,0x2E,0x44,0xD3,0x9A,0xE6,0x27,0x7C,0x4D,0x09,0xA5,0x47,0xDC,0xF8,0xB9,0xAF,0x7B,0x62,0xB7,0x70,0xE6,0xBE,0x1A,0x54,0x4C,0xB8,0xDD,0xFF,0x03};
//const uint8_t spYELLOW[]        PROGMEM = {0x69,0xBD,0x56,0x15,0xAC,0x67,0xE5,0xA5,0xCC,0x2B,0x8E,0x82,0xD8,0xD6,0x39,0x9E,0xAE,0x85,0x50,0x37,0x5F,0x7D,0xEB,0x53,0x55,0x1B,0xDE,0xA6,0x6B,0x56,0x5D,0x74,0x47,0x2B,0x77,0x6E,0x75,0x87,0x59,0x95,0xA4,0x76,0x76,0x6B,0xCE,0xA2,0xB3,0x4C,0xF2,0xCF,0xBD,0xED,0xC9,0x54,0xB6,0x52,0x9F,0x7E,0xA5,0xDB,0xC7,0xCA,0x46,0x5D,0x13,0xEF,0xF8,0x84,0x37,0xA8,0xA9,0x0C,0xF2,0xE3,0xBE,0x24,0xC6,0x2B,0x48,0xDF,0xFF,0x03};
